/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.webapp.webxml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.webapp.FacesServlet;
import org.apache.myfaces.shared_tomahawk.config.MyfacesConfig;
import org.apache.myfaces.shared_tomahawk.util.ClassUtils;
import org.apache.myfaces.shared_tomahawk.webapp.webxml.DelegatedFacesServlet;
import org.apache.myfaces.shared_tomahawk.webapp.webxml.FilterMapping;
import org.apache.myfaces.shared_tomahawk.webapp.webxml.ServletMapping;
import org.apache.myfaces.shared_tomahawk.webapp.webxml.WebXmlParser;

public class WebXml {
    private static final Logger log = Logger.getLogger(WebXml.class.getName());
    private static long refreshPeriod;
    private long parsingTime;
    private Map _servlets = new HashMap();
    private Map _servletMappings = new HashMap();
    private Map _filters = new HashMap();
    private Map _filterMappings = new HashMap();
    private volatile List _facesServletMappings = null;
    private volatile List _facesExtensionsFilterMappings = null;
    private String _delegateFacesServlet = null;
    private boolean errorPagePresent = false;
    private static final String WEB_XML_ATTR;

    void addServlet(String servletName, String servletClass) {
        if (this._servlets.get(servletName) != null) {
            log.warning("Servlet " + servletName + " defined more than once, first definition will be used.");
        } else {
            this._servlets.put(servletName, servletClass);
        }
    }

    void addFilter(String filterName, String filterClass) {
        if (this._filters.get(filterName) != null) {
            log.warning("Filter " + filterName + " defined more than once, first definition will be used.");
        } else {
            this._filters.put(filterName, filterClass);
        }
    }

    boolean containsServlet(String servletName) {
        return this._servlets.containsKey(servletName);
    }

    boolean containsFilter(String filterName) {
        return this._filters.containsKey(filterName);
    }

    void addServletMapping(String servletName, String urlPattern) {
        ArrayList<String> mappings = (ArrayList<String>)this._servletMappings.get(servletName);
        if (mappings == null) {
            mappings = new ArrayList<String>();
            this._servletMappings.put(servletName, mappings);
        }
        mappings.add(urlPattern);
    }

    void addFilterMapping(String filterName, String urlPattern) {
        ArrayList<String> mappings = (ArrayList<String>)this._filterMappings.get(filterName);
        if (mappings == null) {
            mappings = new ArrayList<String>();
            this._filterMappings.put(filterName, mappings);
        }
        mappings.add(urlPattern);
    }

    public List getFacesServletMappings() {
        if (this._facesServletMappings != null) {
            return this._facesServletMappings;
        }
        ArrayList<ServletMapping> tempFacesServletMappings = new ArrayList<ServletMapping>();
        for (Map.Entry entry : this._servlets.entrySet()) {
            String servletName = (String)entry.getKey();
            if (null == entry.getValue()) continue;
            Class servletClass = ClassUtils.simpleClassForName((String)entry.getValue());
            if (FacesServlet.class.isAssignableFrom(servletClass) || DelegatedFacesServlet.class.isAssignableFrom(servletClass) || servletClass.getName().equals(this._delegateFacesServlet)) {
                List urlPatterns = (List)this._servletMappings.get(servletName);
                if (urlPatterns == null) continue;
                for (String urlpattern : urlPatterns) {
                    tempFacesServletMappings.add(new ServletMapping(servletName, servletClass, urlpattern));
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.finest("adding mapping for servlet + " + servletName + " urlpattern = " + urlpattern);
                }
                continue;
            }
            if (!log.isLoggable(Level.FINEST)) continue;
            log.finest("ignoring servlet + " + servletName + " " + servletClass + " (no FacesServlet)");
        }
        this._facesServletMappings = tempFacesServletMappings;
        return this._facesServletMappings;
    }

    public List getFacesExtensionsFilterMappings() {
        if (this._facesExtensionsFilterMappings != null) {
            return this._facesExtensionsFilterMappings;
        }
        ArrayList<FilterMapping> tempExtensionsFilterMappings = new ArrayList<FilterMapping>();
        for (Map.Entry entry : this._filters.entrySet()) {
            String filterName = (String)entry.getKey();
            String filterClassName = (String)entry.getValue();
            if (!"org.apache.myfaces.component.html.util.ExtensionsFilter".equals(filterClassName) && !"org.apache.myfaces.webapp.filter.ExtensionsFilter".equals(filterClassName)) continue;
            Class filterClass = ClassUtils.simpleClassForName(filterClassName);
            List urlPatterns = (List)this._filterMappings.get(filterName);
            if (urlPatterns == null) continue;
            for (String urlpattern : urlPatterns) {
                tempExtensionsFilterMappings.add(new FilterMapping(filterName, filterClass, urlpattern));
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("adding mapping for filter + " + filterName + " urlpattern = " + urlpattern);
            }
        }
        this._facesExtensionsFilterMappings = tempExtensionsFilterMappings;
        return this._facesExtensionsFilterMappings;
    }

    protected void setParsingTime(long parsingTime) {
        this.parsingTime = parsingTime;
    }

    private void setDelegateFacesServlet(String delegateFacesServlet) {
        this._delegateFacesServlet = delegateFacesServlet;
    }

    public void setErrorPagePresent(boolean errorPagePresent) {
        this.errorPagePresent = errorPagePresent;
    }

    public boolean isErrorPagePresent() {
        return this.errorPagePresent;
    }

    protected boolean isOld(ExternalContext context) {
        if (refreshPeriod > 0L) {
            long ttl = this.parsingTime + refreshPeriod;
            if (System.currentTimeMillis() > ttl) {
                long lastModified = WebXmlParser.getWebXmlLastModified(context);
                return lastModified == 0L || lastModified > ttl;
            }
        }
        return false;
    }

    public static WebXml getWebXml(ExternalContext context) {
        WebXml webXml = (WebXml)context.getApplicationMap().get(WEB_XML_ATTR);
        if (webXml == null) {
            WebXml.init(context);
            webXml = (WebXml)context.getApplicationMap().get(WEB_XML_ATTR);
        }
        return webXml;
    }

    public static void init(ExternalContext context) {
        WebXmlParser parser = new WebXmlParser(context);
        WebXml webXml = parser.parse();
        context.getApplicationMap().put(WEB_XML_ATTR, webXml);
        MyfacesConfig mfconfig = MyfacesConfig.getCurrentInstance(context);
        long configRefreshPeriod = mfconfig.getConfigRefreshPeriod();
        webXml.setParsingTime(System.currentTimeMillis());
        webXml.setDelegateFacesServlet(mfconfig.getDelegateFacesServlet());
        refreshPeriod = configRefreshPeriod * 1000L;
    }

    public static void update(ExternalContext context) {
        if (WebXml.getWebXml(context).isOld(context)) {
            WebXml.init(context);
        }
    }

    static {
        WEB_XML_ATTR = WebXml.class.getName();
    }
}

