/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.context.flash;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SubKeyMap<V>
extends AbstractMap<String, V> {
    private final Map<String, Object> _base;
    private final String _prefix;
    private Set<Map.Entry<String, V>> _entrySet;
    private StringBuilder _keyBuffer;

    public SubKeyMap(Map<String, Object> base, String prefix) {
        if (base == null) {
            throw new NullPointerException();
        }
        if (prefix == null) {
            throw new NullPointerException();
        }
        if (base instanceof SubKeyMap) {
            this._base = ((SubKeyMap)base)._base;
            this._prefix = ((SubKeyMap)base)._prefix + prefix;
        } else {
            this._base = base;
            this._prefix = prefix;
        }
        this._keyBuffer = new StringBuilder(32);
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public V get(Object key) {
        key = this._getBaseKey(key);
        return (V)this._base.get(key);
    }

    @Override
    public V put(String key, V value) {
        key = this._getBaseKey(key);
        return (V)this._base.put(key, value);
    }

    @Override
    public V remove(Object key) {
        key = this._getBaseKey(key);
        return (V)this._base.remove(key);
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        return this._base.containsKey(this._getBaseKey(key));
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        if (this._entrySet == null) {
            this._entrySet = new Entries();
        }
        return this._entrySet;
    }

    private String _getBaseKey(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this._keyBuffer.setLength(0);
        this._keyBuffer.append(this._prefix);
        this._keyBuffer.append((String)key);
        return this._keyBuffer.toString();
    }

    private List<String> _gatherKeys() {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : this._base.keySet()) {
            if (key == null || !key.startsWith(this._prefix)) continue;
            list.add(key);
        }
        return list;
    }

    private static boolean _equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry<V>
    implements Map.Entry<String, V> {
        private String _baseKey;
        private String _key;

        public Entry(String baseKey) {
            this._baseKey = baseKey;
        }

        @Override
        public String getKey() {
            if (this._key == null) {
                this._key = this._baseKey.substring(SubKeyMap.this._prefix.length());
            }
            return this._key;
        }

        @Override
        public V getValue() {
            return SubKeyMap.this._base.get(this._baseKey);
        }

        @Override
        public V setValue(V value) {
            return SubKeyMap.this._base.put(this._baseKey, value);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return SubKeyMap._equals(this.getKey(), e.getKey()) && SubKeyMap._equals(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            String key = this.getKey();
            V value = this.getValue();
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator<V>
    implements Iterator<Map.Entry<String, V>> {
        private Iterator<String> _iterator;
        private String _currentKey;

        public EntryIterator(Iterator<String> iterator) {
            this._iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public Map.Entry<String, V> next() {
            String baseKey;
            this._currentKey = baseKey = this._iterator.next();
            return new Entry(baseKey);
        }

        @Override
        public void remove() {
            if (this._currentKey == null) {
                throw new IllegalStateException();
            }
            SubKeyMap.this._base.remove(this._currentKey);
            this._currentKey = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entries<V>
    extends AbstractSet<Map.Entry<String, V>> {
        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            List keyList = SubKeyMap.this._gatherKeys();
            return new EntryIterator(keyList.iterator());
        }

        @Override
        public int size() {
            int size = 0;
            for (String key : SubKeyMap.this._base.keySet()) {
                if (key == null || !key.startsWith(SubKeyMap.this._prefix)) continue;
                ++size;
            }
            return size;
        }

        @Override
        public boolean isEmpty() {
            for (String key : SubKeyMap.this._base.keySet()) {
                if (key == null || !key.startsWith(SubKeyMap.this._prefix)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void clear() {
            Iterator keys = SubKeyMap.this._base.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (key == null || !key.startsWith(SubKeyMap.this._prefix)) continue;
                keys.remove();
            }
        }
    }
}

