/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.change.BaseChangeManager;
import org.apache.myfaces.trinidad.change.ComponentChange;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ComponentUtils;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionChangeManager
extends BaseChangeManager {
    private static final String _COMPONENT_CHANGES_MAP_FOR_SESSION_KEY = "org.apache.myfaces.trinidadinternal.ComponentChangesMapForSession";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SessionChangeManager.class);

    @Override
    public void applyComponentChangesForCurrentView(FacesContext facesContext) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        List<QualifiedComponentChange> componentChangesForView = this._getComponentChangesForView(facesContext, viewRoot.getViewId(), false);
        for (QualifiedComponentChange qualifiedChange : componentChangesForView) {
            UIComponent targetComponent = viewRoot.findComponent(qualifiedChange.getTargetComponentScopedId());
            if (targetComponent != null) {
                ComponentChange componentChange = qualifiedChange.getComponentChange();
                componentChange.changeComponent(targetComponent);
                continue;
            }
            _LOG.info(this.getClass().getName(), "applyComponentChangesForCurrentView", "TARGET_COMPONENT_MISSING_CHANGE_FAILED", qualifiedChange.getTargetComponentScopedId());
        }
    }

    @Override
    protected void addComponentChangeImpl(FacesContext facesContext, UIComponent targetComponent, ComponentChange componentChange) {
        String viewId = facesContext.getViewRoot().getViewId();
        List<QualifiedComponentChange> componentChangesForView = this._getComponentChangesForView(facesContext, viewId, true);
        String scopedIdForTargetComponent = ComponentUtils.getScopedIdForComponent(targetComponent, null);
        componentChangesForView.add(new QualifiedComponentChange(scopedIdForTargetComponent, componentChange));
    }

    @Override
    protected Document getDocument(FacesContext context) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QualifiedComponentChange> _getComponentChangesForView(FacesContext facesContext, String viewId, boolean createIfNecessary) {
        ConcurrentHashMap componentChangesMapForSession;
        Object session;
        Object object = session = facesContext.getExternalContext().getSession(true);
        synchronized (object) {
            Map sessMap = facesContext.getExternalContext().getSessionMap();
            componentChangesMapForSession = (ConcurrentHashMap)sessMap.get(_COMPONENT_CHANGES_MAP_FOR_SESSION_KEY);
            if (componentChangesMapForSession == null) {
                if (!createIfNecessary) {
                    return Collections.emptyList();
                }
                componentChangesMapForSession = new ConcurrentHashMap();
                sessMap.put(_COMPONENT_CHANGES_MAP_FOR_SESSION_KEY, componentChangesMapForSession);
            }
        }
        if (!componentChangesMapForSession.containsKey(viewId)) {
            if (!createIfNecessary) {
                return Collections.emptyList();
            }
            componentChangesMapForSession.putIfAbsent(viewId, new CopyOnWriteArrayList());
        }
        return (List)componentChangesMapForSession.get(viewId);
    }

    private static final class QualifiedComponentChange
    implements Serializable {
        private final String _targetComponentScopedId;
        private final ComponentChange _componentChange;
        private static final long serialVersionUID = 1L;

        public QualifiedComponentChange(String targetComponentScopedId, ComponentChange componentChange) {
            if (targetComponentScopedId == null || componentChange == null) {
                throw new IllegalArgumentException("Target component scoped id and component change is required");
            }
            this._targetComponentScopedId = targetComponentScopedId;
            this._componentChange = componentChange;
        }

        public String getTargetComponentScopedId() {
            return this._targetComponentScopedId;
        }

        public ComponentChange getComponentChange() {
            return this._componentChange;
        }
    }
}

