/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.myfaces.trinidad.component.ChildLoop;
import org.apache.myfaces.trinidad.component.CollectionComponent;
import org.apache.myfaces.trinidad.component.UIXCollection;
import org.apache.myfaces.trinidad.component.UIXColumn;
import org.apache.myfaces.trinidad.component.UIXTree;
import org.apache.myfaces.trinidad.event.DisclosureEvent;
import org.apache.myfaces.trinidad.event.FocusEvent;
import org.apache.myfaces.trinidad.event.RangeChangeEvent;
import org.apache.myfaces.trinidad.event.RowDisclosureEvent;
import org.apache.myfaces.trinidad.event.SelectionEvent;
import org.apache.myfaces.trinidad.event.SortEvent;
import org.apache.myfaces.trinidad.model.ModelUtils;
import org.apache.myfaces.trinidad.model.RowKeySet;
import org.apache.myfaces.trinidad.model.TreeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TableUtils {
    public static int getLast(CollectionComponent table) {
        return TableUtils.getLast(table, table.getFirst());
    }

    public static int getLast(CollectionComponent table, int rangeStart) {
        int blockSize = table.getRows();
        int rangeEnd = blockSize <= 0 ? Integer.MAX_VALUE : rangeStart + blockSize;
        return ModelUtils.findLastIndex(table, rangeStart, rangeEnd) - 1;
    }

    public static Object setupELVariable(FacesContext context, String name, Object value) {
        Map requestMap = context.getExternalContext().getRequestMap();
        if (value == null) {
            return requestMap.remove(name);
        }
        return requestMap.put(name, value);
    }

    static void __doSafeExpandAll(TreeModel model, RowKeySet state, int maxSize) {
        int size = TableUtils._getSizeOfTree(model, maxSize);
        if (size < 0 || size > maxSize) {
            state.add();
            model.enterContainer();
            int i = 0;
            while (true) {
                model.setRowIndex(i++);
                if (!model.isRowAvailable()) break;
                state.add();
            }
            model.exitContainer();
        } else {
            state.addAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int _getSizeOfTree(TreeModel model, int maxSize) {
        if (model.isRowAvailable() && model.isContainer()) {
            model.enterContainer();
            try {
                int size = model.getRowCount();
                int sz = size;
                for (int i = 0; i < sz; ++i) {
                    if (size > maxSize) {
                        int n = size;
                        return n;
                    }
                    model.setRowIndex(i);
                    int kidSize = TableUtils._getSizeOfTree(model, maxSize - size);
                    if (kidSize < 0) {
                        int n = -1;
                        return n;
                    }
                    size += kidSize;
                }
                int n = size;
                return n;
            }
            finally {
                model.exitContainer();
            }
        }
        return 0;
    }

    static void __handleQueueEvent(UIComponent comp, FacesEvent event) {
        if (TableUtils._isImmediateEvent(comp, event)) {
            String immediateAttr = UIXTree.IMMEDIATE_KEY.getName();
            Object isImmediate = comp.getAttributes().get(immediateAttr);
            if (Boolean.TRUE.equals(isImmediate)) {
                event.setPhaseId(PhaseId.ANY_PHASE);
                FacesContext context = FacesContext.getCurrentInstance();
                context.renderResponse();
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
    }

    static void __processFacets(FacesContext context, final UIXCollection table, UIComponent component, final PhaseId phaseId, String skipFacet) {
        Map facets = component.getFacets();
        final UIComponent skip = skipFacet != null ? (UIComponent)facets.get(skipFacet) : null;
        new ChildLoop(){

            protected void process(FacesContext context, UIComponent facet) {
                if (facet != skip) {
                    table.processComponent(context, facet, phaseId);
                }
            }
        }.runAlways(context, facets.values());
    }

    static void __processColumnFacets(FacesContext context, final UIXCollection table, UIComponent column, final PhaseId phaseId) {
        new ChildLoop(){

            protected void process(FacesContext context, UIComponent child) {
                if (child instanceof UIXColumn) {
                    TableUtils.__processFacets(context, table, child, phaseId, null);
                    TableUtils.__processColumnFacets(context, table, child, phaseId);
                }
            }
        }.runAlways(context, column);
    }

    static void __processStampedChildren(FacesContext context, final UIXCollection table, final PhaseId phaseId) {
        new ChildLoop(){

            protected void process(FacesContext context, UIComponent child) {
                table.processComponent(context, child, phaseId);
            }
        }.runAlways(context, table);
    }

    static void __processChildren(FacesContext context, UIXCollection comp, PhaseId phaseId) {
        int childCount = comp.getChildCount();
        if (childCount != 0) {
            List<UIComponent> children = comp.getChildren();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = children.get(i);
                comp.processComponent(context, child, phaseId);
            }
        }
    }

    static void cacheHeaderFooterFacets(UIComponent parent, Map<UIComponent, Boolean> cache) {
        UIComponent footerFacet;
        UIComponent headerFacet = (UIComponent)parent.getFacets().get("header");
        if (headerFacet != null) {
            TableUtils._cacheDescendants(headerFacet, cache, true);
        }
        if ((footerFacet = (UIComponent)parent.getFacets().get("footer")) != null) {
            TableUtils._cacheDescendants(footerFacet, cache, true);
        }
    }

    static void cacheColumnHeaderFooterFacets(UIComponent parent, Map<UIComponent, Boolean> cache) {
        List children = parent.getChildren();
        for (UIComponent child : children) {
            if (!(child instanceof UIXColumn)) continue;
            TableUtils.cacheHeaderFooterFacets(child, cache);
            TableUtils.cacheColumnHeaderFooterFacets(child, cache);
        }
    }

    private static void _cacheDescendants(UIComponent parent, Map<UIComponent, Boolean> cache, boolean inclusive) {
        if (inclusive) {
            cache.put(parent, Boolean.TRUE);
        }
        List children = parent.getChildren();
        for (UIComponent child : children) {
            TableUtils._cacheDescendants(child, cache, true);
        }
    }

    private static boolean _isImmediateEvent(UIComponent comp, FacesEvent event) {
        if (event.getComponent() == comp) {
            return event instanceof RangeChangeEvent || event instanceof DisclosureEvent || event instanceof RowDisclosureEvent || event instanceof SelectionEvent || event instanceof SortEvent || event instanceof FocusEvent;
        }
        return false;
    }

    private TableUtils() {
    }
}

