/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.component.UIXComponentBase;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

class TreeState
implements Externalizable {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(TreeState.class);
    private Object[] _facets;
    private Object[] _children;
    private Object _state;
    private boolean _empty = true;

    public boolean isEmpty() {
        return this._empty;
    }

    public void restoreState(FacesContext context, UIXComponentBase component) {
        int i;
        List<UIComponent> children;
        component.restoreState(context, this._state);
        int childCount = component.getChildCount();
        int arrayCount = this._children == null ? 0 : this._children.length;
        int transientCount = 0;
        if (childCount != arrayCount) {
            children = component.getChildren();
            for (i = 0; i < childCount; ++i) {
                UIComponent child = children.get(i);
                if (!child.isTransient()) continue;
                ++transientCount;
            }
        }
        if (arrayCount + transientCount != childCount) {
            if (_LOG.isWarning()) {
                _LOG.warning("SAVED_CHILD_COUNT_NOT_MATCH", new Object[]{arrayCount, childCount});
            }
        } else {
            children = component.getChildren();
            int arrayIndex = 0;
            for (int i2 = 0; i2 < childCount; ++i2) {
                UIComponent child = children.get(i2);
                if (child.isTransient()) continue;
                child.processRestoreState(context, this._children[arrayIndex]);
                ++arrayIndex;
            }
        }
        if (this._facets != null) {
            assert (this._facets.length % 2 == 0);
            int facetCount = this._facets.length / 2;
            if (facetCount < component.getFacetCount() && _LOG.isWarning()) {
                _LOG.warning("FACETS_STATE_MISSING_WILLNOT_RESTORE", (Object)component);
            }
            for (i = 0; i < facetCount; ++i) {
                assert (this._facets[i * 2] == null || this._facets[i * 2] instanceof String);
                String facetName = (String)this._facets[i * 2];
                if (facetName == null) continue;
                Object facetState = this._facets[i * 2 + 1];
                UIComponent facet = component.getFacet(facetName);
                if (facet == null) {
                    if (!_LOG.isWarning()) continue;
                    _LOG.warning("DISCARDING_SAVED_STATE", facetName);
                    continue;
                }
                if (facet.isTransient()) {
                    if (facetState == null || !_LOG.isWarning()) continue;
                    _LOG.warning("SAVED_STATE_INCLUDE_TRANSIENT_COMPONENT_STATE", facet);
                    continue;
                }
                facet.processRestoreState(context, facetState);
            }
        }
    }

    public void saveState(FacesContext context, UIXComponentBase component) {
        int childCount;
        this._state = component.saveState(context);
        if (this._state != null) {
            this._empty = false;
        }
        if ((childCount = component.getChildCount()) == 0) {
            this._children = null;
        } else {
            this._children = new Object[childCount];
            List<UIComponent> children = component.getChildren();
            int j = 0;
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = children.get(i);
                if (child.isTransient()) continue;
                Object childState = child.processSaveState(context);
                if (childState != null) {
                    this._empty = false;
                    this._children[j] = childState;
                }
                ++j;
            }
            if (j < childCount) {
                Object[] newChildren = new Object[j];
                System.arraycopy(this._children, 0, newChildren, 0, j);
                this._children = newChildren;
            }
        }
        int facetCount = component.getFacetCount();
        if (facetCount == 0) {
            this._facets = null;
        } else {
            this._facets = new Object[facetCount * 2];
            int i = 0;
            Set<Map.Entry<String, UIComponent>> entries = component.getFacets().entrySet();
            for (Map.Entry<String, UIComponent> entry : entries) {
                UIComponent facet = entry.getValue();
                if (facet.isTransient()) continue;
                Object facetState = facet.processSaveState(context);
                if (facetState != null) {
                    this._empty = false;
                    this._facets[2 * i] = entry.getKey();
                    this._facets[2 * i + 1] = facetState;
                }
                ++i;
            }
            if (i == 0) {
                this._facets = null;
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._state);
        out.writeObject(this._facets);
        out.writeObject(this._children);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._state = in.readObject();
        this._facets = (Object[])in.readObject();
        this._children = (Object[])in.readObject();
    }
}

