/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import javax.el.MethodExpression;
import javax.faces.component.ActionSource;
import javax.faces.component.ActionSource2;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.DialogSource;
import org.apache.myfaces.trinidad.component.MethodBindingMethodExpression;
import org.apache.myfaces.trinidad.component.MethodExpressionMethodBinding;
import org.apache.myfaces.trinidad.component.UIXComponentBase;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.LaunchEvent;
import org.apache.myfaces.trinidad.event.LaunchListener;
import org.apache.myfaces.trinidad.event.ReturnEvent;
import org.apache.myfaces.trinidad.event.ReturnListener;
import org.apache.myfaces.trinidad.util.ComponentUtils;

public class UIXCommand
extends UIXComponentBase
implements ActionSource2,
ActionSource,
DialogSource {
    public static final FacesBean.Type TYPE = new FacesBean.Type(UIXComponentBase.TYPE);
    public static final PropertyKey ACTION_EXPRESSION_KEY = TYPE.registerKey("actionExpression", MethodExpression.class, 8);
    public static final PropertyKey ACTION_LISTENER_KEY = TYPE.registerKey("actionListener", MethodBinding.class, 9);
    public static final PropertyKey RETURN_LISTENER_KEY = TYPE.registerKey("returnListener", MethodExpression.class);
    public static final PropertyKey LAUNCH_LISTENER_KEY = TYPE.registerKey("launchListener", MethodExpression.class);
    public static final PropertyKey IMMEDIATE_KEY = TYPE.registerKey("immediate", Boolean.class, Boolean.FALSE);
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.trinidad.Command";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.trinidad.Command";

    public UIXCommand() {
        super("org.apache.myfaces.trinidad.Button");
    }

    @Deprecated
    public void setLaunchListener(MethodBinding binding) {
        this.setLaunchListener(UIXCommand.adaptMethodBinding(binding));
    }

    @Deprecated
    public void setReturnListener(MethodBinding binding) {
        this.setReturnListener(UIXCommand.adaptMethodBinding(binding));
    }

    public MethodBinding getAction() {
        MethodExpression me = this.getActionExpression();
        if (me == null) {
            return null;
        }
        if (me instanceof MethodBindingMethodExpression) {
            return ((MethodBindingMethodExpression)me).getMethodBinding();
        }
        return new MethodExpressionMethodBinding(me);
    }

    public void setAction(MethodBinding binding) {
        if (binding instanceof MethodExpressionMethodBinding) {
            this.setActionExpression(((MethodExpressionMethodBinding)binding).getMethodExpression());
        } else {
            this.setActionExpression(new MethodBindingMethodExpression(binding));
        }
    }

    public void queueEvent(FacesEvent e) {
        if (this == e.getComponent() && (e instanceof ActionEvent || e instanceof ReturnEvent)) {
            if (this.isImmediate()) {
                e.setPhaseId(PhaseId.ANY_PHASE);
            } else {
                e.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof ActionEvent) {
            RequestContext afContext = RequestContext.getCurrentInstance();
            afContext.getDialogService().setCurrentLaunchSource(this);
            try {
                super.broadcast(event);
                this.broadcastToMethodBinding(event, this.getActionListener());
                FacesContext context = this.getFacesContext();
                ActionListener defaultActionListener = context.getApplication().getActionListener();
                if (defaultActionListener == null) return;
                defaultActionListener.processAction((ActionEvent)event);
                return;
            }
            finally {
                afContext.getDialogService().setCurrentLaunchSource(null);
            }
        } else {
            super.broadcast(event);
            if (event instanceof LaunchEvent) {
                this.broadcastToMethodExpression(event, this.getLaunchListener());
                boolean useWindow = Boolean.TRUE.equals(this.getAttributes().get("useWindow"));
                ((LaunchEvent)event).launchDialog(useWindow);
                return;
            } else {
                if (!(event instanceof ReturnEvent)) return;
                this.broadcastToMethodExpression(event, this.getReturnListener());
                this.getFacesContext().renderResponse();
            }
        }
    }

    public final MethodExpression getActionExpression() {
        return (MethodExpression)this.getProperty(ACTION_EXPRESSION_KEY);
    }

    public final void setActionExpression(MethodExpression actionExpression) {
        this.setProperty(ACTION_EXPRESSION_KEY, actionExpression);
    }

    public final MethodBinding getActionListener() {
        return (MethodBinding)this.getProperty(ACTION_LISTENER_KEY);
    }

    public final void setActionListener(MethodBinding actionListener) {
        this.setProperty(ACTION_LISTENER_KEY, actionListener);
    }

    public final MethodExpression getReturnListener() {
        return (MethodExpression)this.getProperty(RETURN_LISTENER_KEY);
    }

    public final void setReturnListener(MethodExpression returnListener) {
        this.setProperty(RETURN_LISTENER_KEY, returnListener);
    }

    public final MethodExpression getLaunchListener() {
        return (MethodExpression)this.getProperty(LAUNCH_LISTENER_KEY);
    }

    public final void setLaunchListener(MethodExpression launchListener) {
        this.setProperty(LAUNCH_LISTENER_KEY, launchListener);
    }

    public final boolean isImmediate() {
        return ComponentUtils.resolveBoolean(this.getProperty(IMMEDIATE_KEY), false);
    }

    public final void setImmediate(boolean immediate) {
        this.setProperty(IMMEDIATE_KEY, immediate ? Boolean.TRUE : Boolean.FALSE);
    }

    public final void addActionListener(ActionListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public final void removeActionListener(ActionListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public final ActionListener[] getActionListeners() {
        return (ActionListener[])this.getFacesListeners(ActionListener.class);
    }

    public final void addReturnListener(ReturnListener listener) {
        this.addFacesListener(listener);
    }

    public final void removeReturnListener(ReturnListener listener) {
        this.removeFacesListener(listener);
    }

    public final ReturnListener[] getReturnListeners() {
        return (ReturnListener[])this.getFacesListeners(ReturnListener.class);
    }

    public final void addLaunchListener(LaunchListener listener) {
        this.addFacesListener(listener);
    }

    public final void removeLaunchListener(LaunchListener listener) {
        this.removeFacesListener(listener);
    }

    public final LaunchListener[] getLaunchListeners() {
        return (LaunchListener[])this.getFacesListeners(LaunchListener.class);
    }

    public String getFamily() {
        return "org.apache.myfaces.trinidad.Command";
    }

    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    protected UIXCommand(String rendererType) {
        super(rendererType);
    }

    static {
        TYPE.lockAndRegister("org.apache.myfaces.trinidad.Command", "org.apache.myfaces.trinidad.Button");
    }
}

