/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import javax.faces.FacesException;
import javax.faces.component.ContextCallback;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXComponentBase;
import org.apache.myfaces.trinidad.util.ComponentUtils;

public class UIXSubform
extends UIXComponentBase
implements NamingContainer {
    public static final FacesBean.Type TYPE = new FacesBean.Type(UIXComponentBase.TYPE);
    public static final PropertyKey SUBMITTED_KEY = TYPE.registerKey("submitted", Boolean.class, Boolean.FALSE, 3);
    public static final PropertyKey DEFAULT_KEY = TYPE.registerKey("default", Boolean.class, Boolean.FALSE, 1);
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.trinidad.Subform";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.trinidad.Subform";
    private static final String _SOMETHING_SUBMITTED = "org.apache.myfaces.trinidad.component.UIXSubformSubmitted";

    public UIXSubform() {
        super("org.apache.myfaces.trinidad.Subform");
    }

    public void queueEvent(FacesEvent event) {
        if (PhaseId.APPLY_REQUEST_VALUES.compareTo((Object)event.getPhaseId()) < 0) {
            UIXSubform._storeSomethingSubmitted(FacesContext.getCurrentInstance());
            this.setSubmitted(true);
        }
        super.queueEvent(event);
    }

    public void processDecodes(FacesContext context) {
        this.setSubmitted(false);
        super.processDecodes(context);
    }

    public void processValidators(FacesContext context) {
        if (!this.isSubmitted() && this.isDefault() && !UIXSubform._isSomethingSubmitted(context)) {
            this.setSubmitted(true);
        }
        if (this.isSubmitted()) {
            super.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (this.isSubmitted()) {
            super.processUpdates(context);
        }
    }

    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        String thisClientId = this.getClientId(context);
        if (clientId.equals(thisClientId)) {
            callback.invokeContextCallback(context, (UIComponent)this);
            return true;
        }
        if (clientId.startsWith(thisClientId) && clientId.charAt(thisClientId.length()) == ':') {
            return super.invokeOnComponent(context, clientId, callback);
        }
        return false;
    }

    private static void _storeSomethingSubmitted(FacesContext context) {
        context.getExternalContext().getRequestMap().put(_SOMETHING_SUBMITTED, Boolean.TRUE);
    }

    private static boolean _isSomethingSubmitted(FacesContext context) {
        return Boolean.TRUE.equals(context.getExternalContext().getRequestMap().get(_SOMETHING_SUBMITTED));
    }

    public final boolean isSubmitted() {
        return ComponentUtils.resolveBoolean(this.getProperty(SUBMITTED_KEY), false);
    }

    public final void setSubmitted(boolean submitted) {
        this.setProperty(SUBMITTED_KEY, submitted ? Boolean.TRUE : Boolean.FALSE);
    }

    public final boolean isDefault() {
        return ComponentUtils.resolveBoolean(this.getProperty(DEFAULT_KEY), false);
    }

    public final void setDefault(boolean defaultParam) {
        this.setProperty(DEFAULT_KEY, defaultParam ? Boolean.TRUE : Boolean.FALSE);
    }

    public String getFamily() {
        return "org.apache.myfaces.trinidad.Subform";
    }

    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    protected UIXSubform(String rendererType) {
        super(rendererType);
    }

    static {
        TYPE.lockAndRegister("org.apache.myfaces.trinidad.Subform", "org.apache.myfaces.trinidad.Subform");
    }
}

