/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.util;

import java.io.IOException;
import java.io.InputStream;
import javax.faces.context.ExternalContext;
import javax.portlet.ActionRequest;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;

public final class ExternalContextUtils {
    private static final TrinidadLogger _LOG;
    private static final Class<?> _PORTLET_ACTION_REQUEST_CLASS;
    private static final Class<?> _PORTLET_CONTEXT_CLASS;

    public static String getRequestedSessionId(ExternalContext externalContext) {
        if (ExternalContextUtils.isPortlet(externalContext)) {
            return ((PortletRequest)externalContext.getRequest()).getRequestedSessionId();
        }
        return ((HttpServletRequest)externalContext.getRequest()).getRequestedSessionId();
    }

    public static boolean isRequestedSessionIdValid(ExternalContext externalContext) {
        if (ExternalContextUtils.isPortlet(externalContext)) {
            return ((PortletRequest)externalContext.getRequest()).isRequestedSessionIdValid();
        }
        return ((HttpServletRequest)externalContext.getRequest()).isRequestedSessionIdValid();
    }

    public static String getServletContextPath(ExternalContext externalContext) {
        if (!ExternalContextUtils.isPortlet(externalContext)) {
            return ((ServletContext)externalContext.getContext()).getContextPath();
        }
        return null;
    }

    public static String getRequestContextPath(ExternalContext externalContext) {
        if (!ExternalContextUtils.isPortlet(externalContext)) {
            return ((HttpServletRequest)externalContext.getRequest()).getContextPath();
        }
        return null;
    }

    public static String getRequestURI(ExternalContext externalContext) {
        if (!ExternalContextUtils.isPortlet(externalContext)) {
            return ((HttpServletRequest)externalContext.getRequest()).getRequestURI();
        }
        return null;
    }

    public static String getCharacterEncoding(ExternalContext externalContext) {
        if (ExternalContextUtils.isAction(externalContext)) {
            try {
                if (ExternalContextUtils.isPortlet(externalContext)) {
                    return ExternalContextUtils._getPortletCharacterEncoding(externalContext.getRequest());
                }
                return ((ServletRequest)externalContext.getRequest()).getCharacterEncoding();
            }
            catch (ClassCastException e) {
                _LOG.severe(e);
            }
        }
        return null;
    }

    public static String getContextName(ExternalContext externalContext) {
        try {
            if (ExternalContextUtils.isPortlet(externalContext)) {
                return ((PortletContext)externalContext.getContext()).getPortletContextName();
            }
            return ((ServletContext)externalContext.getContext()).getServletContextName();
        }
        catch (ClassCastException e) {
            _LOG.severe(e);
            return null;
        }
    }

    public static int getContentLength(ExternalContext externalContext) {
        if (ExternalContextUtils.isAction(externalContext)) {
            try {
                if (!ExternalContextUtils.isPortlet(externalContext)) {
                    return ((ServletRequest)externalContext.getRequest()).getContentLength();
                }
                ExternalContextUtils._getPortletContentLength(externalContext.getRequest());
            }
            catch (ClassCastException e) {
                _LOG.severe(e);
            }
        }
        return -1;
    }

    public static String getContentType(ExternalContext externalContext) {
        if (ExternalContextUtils.isAction(externalContext)) {
            try {
                if (ExternalContextUtils.isPortlet(externalContext)) {
                    return ExternalContextUtils._getPortletContentType(externalContext.getRequest());
                }
                return ((ServletRequest)externalContext.getRequest()).getContentType();
            }
            catch (ClassCastException e) {
                _LOG.severe(e);
            }
        }
        return null;
    }

    public static InputStream getRequestInputStream(ExternalContext externalContext) throws IOException {
        if (ExternalContextUtils.isAction(externalContext)) {
            try {
                if (ExternalContextUtils.isPortlet(externalContext)) {
                    return ExternalContextUtils._getPortletInputStream(externalContext.getRequest());
                }
                return ((ServletRequest)externalContext.getRequest()).getInputStream();
            }
            catch (ClassCastException e) {
                _LOG.severe(e);
            }
        }
        return null;
    }

    public static boolean isAction(ExternalContext externalContext) {
        Object request = externalContext.getRequest();
        if (_PORTLET_ACTION_REQUEST_CLASS == null) {
            _LOG.fine("Portlet API's are not on the classpath so isAction will only check for servlet request.");
            return request instanceof ServletRequest;
        }
        return request instanceof ServletRequest || _PORTLET_ACTION_REQUEST_CLASS.isInstance(request);
    }

    public static boolean isPortlet(ExternalContext externalContext) {
        if (_PORTLET_CONTEXT_CLASS == null) {
            _LOG.fine("Portlet API's are not on the classpath therefore isPortlet is false.");
            return false;
        }
        return _PORTLET_CONTEXT_CLASS.isInstance(externalContext.getContext());
    }

    public static boolean isHttpServletRequest(ExternalContext externalContext) {
        return !ExternalContextUtils.isPortlet(externalContext) && externalContext.getRequest() instanceof HttpServletRequest;
    }

    private static final String _getPortletCharacterEncoding(Object request) {
        if (!(request instanceof ActionRequest)) {
            return null;
        }
        return ((ActionRequest)request).getCharacterEncoding();
    }

    private static final int _getPortletContentLength(Object request) {
        if (!(request instanceof ActionRequest)) {
            return -1;
        }
        return ((ActionRequest)request).getContentLength();
    }

    private static final String _getPortletContentType(Object request) {
        if (!(request instanceof ActionRequest)) {
            return null;
        }
        return ((ActionRequest)request).getContentType();
    }

    private static final InputStream _getPortletInputStream(Object request) throws IOException {
        return ((ActionRequest)request).getPortletInputStream();
    }

    private ExternalContextUtils() {
    }

    static {
        Class<?> actionRequest;
        Class<?> context;
        _LOG = TrinidadLogger.createTrinidadLogger(ExternalContextUtils.class);
        try {
            context = ClassLoaderUtils.loadClass("javax.portlet.PortletContext");
            actionRequest = ClassLoaderUtils.loadClass("javax.portlet.ActionRequest");
        }
        catch (ClassNotFoundException e) {
            _LOG.fine("Portlet API is not available on the classpath.  Portlet configurations are disabled.");
            context = null;
            actionRequest = null;
        }
        _PORTLET_CONTEXT_CLASS = context;
        _PORTLET_ACTION_REQUEST_CLASS = actionRequest;
    }
}

