/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.util;

import org.apache.myfaces.trinidad.logging.TrinidadLogger;

public class FastMessageFormat {
    private final char[] _formatText;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(FastMessageFormat.class);

    public FastMessageFormat(String formatString) {
        if (formatString == null) {
            throw new NullPointerException();
        }
        this._formatText = formatString.toCharArray();
    }

    public String format(Object[] source) {
        int formatLength = this._formatText.length;
        int length = 0;
        int sourceCount = source.length;
        for (int i = 0; i < sourceCount; ++i) {
            Object sourceString = source[i];
            if (sourceString == null) continue;
            length += sourceString.toString().length();
        }
        StringBuffer buffer = new StringBuffer(length + formatLength);
        int lastStart = 0;
        boolean inQuote = false;
        for (int i = 0; i < formatLength; ++i) {
            Object sourceString;
            char patternChar;
            int j;
            char ch = this._formatText[i];
            if (inQuote) {
                if (ch != '\'') continue;
                buffer.append(this._formatText, lastStart, i - lastStart);
                lastStart = ++i;
                inQuote = false;
                continue;
            }
            if (ch == '\'') {
                buffer.append(this._formatText, lastStart, i - lastStart);
                lastStart = ++i;
                if (i < formatLength && this._formatText[i] == '\'') continue;
                inQuote = true;
                continue;
            }
            if (ch != '{') continue;
            buffer.append(this._formatText, lastStart, i - lastStart);
            int sourceIndex = 0;
            for (j = i + 1; j < formatLength && (patternChar = this._formatText[j]) != '}'; ++j) {
                if (patternChar < '0' || patternChar > '9') {
                    throw new IllegalArgumentException(_LOG.getLogger().getResourceBundle().getString("FASTMESSAGEFORMAT_ONLY_SUPPORT_NUMERIC_ARGUMENTS"));
                }
                sourceIndex = sourceIndex * 10 + (patternChar - 48);
            }
            if (j == formatLength) {
                throw new IllegalArgumentException(_LOG.getLogger().getResourceBundle().getString("END_OF_PATTERN_NOT_FOUND"));
            }
            if (j == i + 1) {
                throw new IllegalArgumentException(_LOG.getLogger().getResourceBundle().getString("FASTMESSAGEFORMAT_FIND_EMPTY_ARGUMENT"));
            }
            if (sourceIndex < sourceCount && (sourceString = source[sourceIndex]) != null) {
                buffer.append(sourceString.toString());
            }
            i = j;
            lastStart = i + 1;
        }
        buffer.append(this._formatText, lastStart, formatLength - lastStart);
        return new String(buffer);
    }
}

