/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.util;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThreadLocalUtils {
    private static final String _REQUEST_SERVICE = ThreadLocalUtils.class.getName() + ".ThreadLocalLifecycle.REQUEST";
    private static final ConcurrentMap<String, ResettableThreadLocalManager> _threadLocalManagers = new ConcurrentHashMap<String, ResettableThreadLocalManager>();

    private ThreadLocalUtils() {
    }

    public static <T> ThreadLocal<T> newRequestThreadLocal() {
        return ThreadLocalUtils.registerRequestThreadLocal(new ThreadLocal());
    }

    public static <T> ThreadLocal<T> registerRequestThreadLocal(ThreadLocal<T> threadLocal) {
        return ThreadLocalUtils._getThreadLocalManager(_REQUEST_SERVICE).registerThreadLocal(threadLocal);
    }

    private static ResettableThreadLocalManager _getThreadLocalManager(String threadLocalGroup) {
        ResettableThreadLocalManager threadLocalManager = (ResettableThreadLocalManager)_threadLocalManagers.get(threadLocalGroup);
        if (threadLocalManager == null) {
            threadLocalManager = new ResettableThreadLocalManager();
            ResettableThreadLocalManager oldThreadLocalManager = _threadLocalManagers.putIfAbsent(threadLocalGroup, threadLocalManager);
            if (oldThreadLocalManager != null) {
                threadLocalManager = oldThreadLocalManager;
            } else {
                List lifecycles = ClassLoaderUtils.getServices(threadLocalGroup);
                if (!lifecycles.isEmpty()) {
                    ((ThreadLocalLifecycle)lifecycles.get(0)).init(threadLocalManager);
                }
            }
        }
        return threadLocalManager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResettableThreadLocalManager
    extends ThreadLocalManager {
        private final Collection<WeakReference<ThreadLocal<?>>> _threadLocals = new CopyOnWriteArrayList();

        public <T> ThreadLocal<T> registerThreadLocal(ThreadLocal<T> threadLocal) {
            if (threadLocal == null) {
                throw new NullPointerException();
            }
            this._threadLocals.add(new WeakReference<ThreadLocal<T>>(threadLocal));
            return threadLocal;
        }

        @Override
        public void removeThreadLocals() {
            Iterator<WeakReference<ThreadLocal<?>>> iterator = this._threadLocals.iterator();
            while (iterator.hasNext()) {
                ThreadLocal threadLocal = (ThreadLocal)iterator.next().get();
                if (threadLocal == null) continue;
                threadLocal.remove();
            }
        }
    }

    public static abstract class ThreadLocalLifecycle {
        public abstract void init(ThreadLocalManager var1);
    }

    public static abstract class ThreadLocalManager {
        public abstract void removeThreadLocals();
    }
}

