/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.change.AttributeComponentChange;
import org.apache.myfaces.trinidad.change.BaseChangeManager;
import org.apache.myfaces.trinidad.change.ComponentChange;
import org.apache.myfaces.trinidad.change.MoveChildComponentChange;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.CollectionUtils;
import org.apache.myfaces.trinidad.util.ComponentUtils;
import org.w3c.dom.Document;

public class SessionChangeManager
extends BaseChangeManager {
    private static final ChangesForView _EMPTY_CHANGES = new ChangesForView(false);
    private static final String _COMPONENT_CHANGES_MAP_FOR_SESSION_KEY = "org.apache.myfaces.trinidadinternal.ComponentChangesMapForSession";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SessionChangeManager.class);

    public void applyComponentChangesForCurrentView(FacesContext facesContext) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        ChangesForView changesForView = this._getChangesForView(facesContext, viewRoot.getViewId(), false);
        for (QualifiedComponentChange qualifiedChange : changesForView.getComponentChangesForView()) {
            UIComponent targetComponent = viewRoot.findComponent(qualifiedChange.getTargetComponentScopedId());
            if (targetComponent != null) {
                ComponentChange componentChange = qualifiedChange.getComponentChange();
                componentChange.changeComponent(targetComponent);
                continue;
            }
            _LOG.info(this.getClass().getName(), "applyComponentChangesForCurrentView", "TARGET_COMPONENT_MISSING_CHANGE_FAILED", qualifiedChange.getTargetComponentScopedId());
        }
    }

    protected void addComponentChangeImpl(FacesContext facesContext, UIComponent targetComponent, ComponentChange componentChange) {
        String viewId = facesContext.getViewRoot().getViewId();
        ChangesForView changesForView = this._getChangesForView(facesContext, viewId, true);
        String scopedIdForTargetComponent = ComponentUtils.getScopedIdForComponent(targetComponent, null);
        if (componentChange instanceof AttributeComponentChange) {
            String currTargetScopedId;
            MoveChildComponentChange nextRenameChange;
            AttributeComponentChange attributeChange = (AttributeComponentChange)componentChange;
            String attributeName = attributeChange.getAttributeName();
            Iterator<QualifiedComponentChange> changes = changesForView.getComponentChangesForView().iterator();
            Iterator<MoveChildComponentChange> renameChanges = changesForView.getRenameChanges(scopedIdForTargetComponent);
            if (renameChanges.hasNext()) {
                nextRenameChange = renameChanges.next();
                currTargetScopedId = nextRenameChange.getSourceScopedId();
            } else {
                nextRenameChange = null;
                currTargetScopedId = scopedIdForTargetComponent;
            }
            while (changes.hasNext()) {
                AttributeComponentChange currAttributeChange;
                ComponentChange currChange;
                QualifiedComponentChange currQualifiedChange = changes.next();
                if (currQualifiedChange.getComponentChange() == nextRenameChange) {
                    currTargetScopedId = nextRenameChange.getDestinationScopedId();
                    nextRenameChange = renameChanges.hasNext() ? renameChanges.next() : null;
                    continue;
                }
                if (!currQualifiedChange.getTargetComponentScopedId().equals(currTargetScopedId) || !((currChange = currQualifiedChange.getComponentChange()) instanceof AttributeComponentChange) || !attributeName.equals((currAttributeChange = (AttributeComponentChange)currChange).getAttributeName())) continue;
                changes.remove();
                break;
            }
        }
        QualifiedComponentChange newQualifiedChange = new QualifiedComponentChange(scopedIdForTargetComponent, componentChange);
        changesForView.addChange(newQualifiedChange);
    }

    protected Document getDocument(FacesContext context) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChangesForView _getChangesForView(FacesContext facesContext, String viewId, boolean createIfNecessary) {
        ConcurrentHashMap<String, ChangesForView> componentChangesMapForSession;
        Object session;
        Object object = session = facesContext.getExternalContext().getSession(true);
        synchronized (object) {
            Map sessMap = facesContext.getExternalContext().getSessionMap();
            componentChangesMapForSession = (ConcurrentHashMap<String, ChangesForView>)sessMap.get(_COMPONENT_CHANGES_MAP_FOR_SESSION_KEY);
            if (componentChangesMapForSession == null) {
                if (!createIfNecessary) {
                    return _EMPTY_CHANGES;
                }
                componentChangesMapForSession = new ConcurrentHashMap<String, ChangesForView>();
                sessMap.put(_COMPONENT_CHANGES_MAP_FOR_SESSION_KEY, componentChangesMapForSession);
            }
        }
        if (!componentChangesMapForSession.containsKey(viewId)) {
            if (!createIfNecessary) {
                return _EMPTY_CHANGES;
            }
            componentChangesMapForSession.putIfAbsent(viewId, new ChangesForView(true));
        }
        return (ChangesForView)componentChangesMapForSession.get(viewId);
    }

    private static class QualifiedComponentChange
    implements Serializable {
        private final String _targetComponentScopedId;
        private final ComponentChange _componentChange;
        private static final long serialVersionUID = 1L;

        public QualifiedComponentChange(String targetComponentScopedId, ComponentChange componentChange) {
            if (targetComponentScopedId == null || componentChange == null) {
                throw new IllegalArgumentException("Target component scoped id and component change is required");
            }
            this._targetComponentScopedId = targetComponentScopedId;
            this._componentChange = componentChange;
        }

        public String getTargetComponentScopedId() {
            return this._targetComponentScopedId;
        }

        public ComponentChange getComponentChange() {
            return this._componentChange;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ChangesForView
    implements Serializable {
        private final Queue<QualifiedComponentChange> _componentChangesForView;
        private final List<MoveChildComponentChange> _renameChanges;
        private static final long serialVersionUID = 1L;

        protected ChangesForView(boolean rw) {
            if (rw) {
                this._componentChangesForView = new ConcurrentLinkedQueue<QualifiedComponentChange>();
                this._renameChanges = new CopyOnWriteArrayList<MoveChildComponentChange>();
            } else {
                this._componentChangesForView = CollectionUtils.emptyQueue();
                this._renameChanges = null;
            }
        }

        protected Iterable<QualifiedComponentChange> getComponentChangesForView() {
            return this._componentChangesForView;
        }

        protected void addChange(QualifiedComponentChange qualifiedChange) {
            MoveChildComponentChange moveComponentChange;
            this._componentChangesForView.add(qualifiedChange);
            ComponentChange componentChange = qualifiedChange.getComponentChange();
            if (componentChange instanceof MoveChildComponentChange && !(moveComponentChange = (MoveChildComponentChange)componentChange).getSourceScopedId().equals(moveComponentChange.getDestinationScopedId())) {
                this._renameChanges.add(moveComponentChange);
            }
        }

        protected Iterator<MoveChildComponentChange> getRenameChanges(String targetScopedId) {
            if (this._renameChanges != null) {
                String currTargetScopedId = targetScopedId;
                ArrayList<MoveChildComponentChange> renameChanges = null;
                ListIterator<MoveChildComponentChange> moveChanges = this._renameChanges.listIterator(this._renameChanges.size());
                while (moveChanges.hasPrevious()) {
                    MoveChildComponentChange currMoveChange = moveChanges.previous();
                    if (!currTargetScopedId.equals(currMoveChange.getDestinationScopedId())) continue;
                    if (renameChanges == null) {
                        renameChanges = new ArrayList<MoveChildComponentChange>();
                    }
                    renameChanges.add(currMoveChange);
                    currTargetScopedId = currMoveChange.getSourceScopedId();
                }
                if (renameChanges != null) {
                    if (renameChanges.size() > 1) {
                        Collections.reverse(renameChanges);
                    }
                    return renameChanges.iterator();
                }
            }
            return CollectionUtils.emptyIterator();
        }
    }
}

