/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.render.Renderer;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.ComponentProcessingContext;
import org.apache.myfaces.trinidad.component.ComponentProcessor;
import org.apache.myfaces.trinidad.component.FlattenedComponent;
import org.apache.myfaces.trinidad.component.UIXCollection;
import org.apache.myfaces.trinidad.component.UIXComponent;
import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.ModelUtils;
import org.apache.myfaces.trinidad.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIXIterator
extends UIXCollection
implements FlattenedComponent {
    public static final FacesBean.Type TYPE = new FacesBean.Type(UIXCollection.TYPE);
    public static final PropertyKey VAR_STATUS_KEY = TYPE.registerKey("varStatus", String.class, 1);
    public static final PropertyKey VALUE_KEY = TYPE.registerKey("value");
    public static final PropertyKey ROWS_KEY = TYPE.registerKey("rows", Integer.class, (Object)25);
    public static final PropertyKey FIRST_KEY = TYPE.registerKey("first", Integer.class, (Object)0);
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.trinidad.Iterator";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.trinidad.Iterator";

    public UIXIterator() {
        super(null);
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public <S> boolean processFlattenedChildren(final FacesContext context, ComponentProcessingContext cpContext, final ComponentProcessor<S> childProcessor, final S callbackContext) throws IOException {
        this.__processFlattenedChildrenBegin();
        Runner runner = new Runner(cpContext){

            protected void process(UIComponent kid, ComponentProcessingContext cpContext) throws IOException {
                childProcessor.processComponent(context, cpContext, kid, callbackContext);
            }
        };
        boolean processedChildren = runner.run();
        Exception exp = runner.exception;
        if (exp != null) {
            if (exp instanceof RuntimeException) {
                throw (RuntimeException)exp;
            }
            if (exp instanceof IOException) {
                throw (IOException)exp;
            }
            throw new IllegalStateException(exp);
        }
        return processedChildren;
    }

    @Override
    public boolean isFlatteningChildren(FacesContext context) {
        return this.getRendererType() == null;
    }

    @Override
    public void encodeChildren(final FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        if (this.getRendererType() != null) {
            Renderer renderer = this.getRenderer(context);
            if (renderer != null) {
                renderer.encodeChildren(context, (UIComponent)this);
            }
        } else {
            Runner runner = new Runner(){

                protected void process(UIComponent kid, ComponentProcessingContext cpContext) throws IOException {
                    UIXIterator.this.__encodeRecursive(context, kid);
                }
            };
            runner.run();
            Exception exp = runner.exception;
            if (exp != null) {
                if (exp instanceof RuntimeException) {
                    throw (RuntimeException)exp;
                }
                if (exp instanceof IOException) {
                    throw (IOException)exp;
                }
                throw new IllegalStateException(exp);
            }
        }
    }

    @Override
    protected Map<String, Object> createVarStatusMap() {
        final Map<String, Object> map = super.createVarStatusMap();
        return new AbstractMap<String, Object>(){

            @Override
            public Object get(Object key) {
                if ("begin".equals(key)) {
                    return UIXIterator.this.getFirst();
                }
                if ("first".equals(key)) {
                    boolean isFirst = UIXIterator.this.getFirst() == UIXIterator.this.getRowIndex();
                    return isFirst;
                }
                if ("count".equals(key)) {
                    int count = UIXIterator.this.getRowIndex() - UIXIterator.this.getFirst() + 1;
                    return count;
                }
                if ("step".equals(key)) {
                    return 1;
                }
                return map.get(key);
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return map.entrySet();
            }
        };
    }

    @Override
    protected CollectionModel createCollectionModel(CollectionModel current, Object value) {
        CollectionModel model = ModelUtils.toCollectionModel(value);
        model.setRowIndex(-1);
        assert (model.getRowIndex() == -1) : "RowIndex did not reset to -1";
        return model;
    }

    @Override
    protected void processFacetsAndChildren(final FacesContext context, final PhaseId phaseId) {
        Runner runner = new Runner(){

            protected void process(UIComponent kid, ComponentProcessingContext cpContext) {
                UIXIterator.this.processComponent(context, kid, phaseId);
            }
        };
        runner.run();
    }

    @Override
    void __encodeBegin(FacesContext context) throws IOException {
        this._fixupFirst();
        super.__encodeBegin(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _fixupFirst() {
        int first = this.getFirst();
        if (first == 0) {
            return;
        }
        if (first < 0) {
            this.setFirst(0);
            return;
        }
        CollectionModel model = this.getCollectionModel();
        int oldIndex = model.getRowIndex();
        try {
            model.setRowIndex(first);
            if (!model.isRowAvailable()) {
                int size = model.getRowCount();
                int rows = this.getRows();
                if (size <= 0 || rows <= 0 || size <= rows) {
                    first = 0;
                } else {
                    first = size - rows;
                    model.setRowIndex(first);
                    if (!model.isRowAvailable()) {
                        first = 0;
                    }
                }
                this.setFirst(first);
            }
        }
        finally {
            model.setRowIndex(oldIndex);
        }
    }

    @Override
    public final String getVarStatus() {
        return ComponentUtils.resolveString(this.getProperty(VAR_STATUS_KEY));
    }

    public final void setVarStatus(String varStatus) {
        this.setProperty(VAR_STATUS_KEY, varStatus);
    }

    @Override
    public final Object getValue() {
        return this.getProperty(VALUE_KEY);
    }

    public final void setValue(Object value) {
        this.setProperty(VALUE_KEY, value);
    }

    public final int getRows() {
        return ComponentUtils.resolveInteger(this.getProperty(ROWS_KEY), 25);
    }

    public final void setRows(int rows) {
        this.setProperty(ROWS_KEY, rows);
    }

    public final int getFirst() {
        return ComponentUtils.resolveInteger(this.getProperty(FIRST_KEY), 0);
    }

    public final void setFirst(int first) {
        this.setProperty(FIRST_KEY, first);
    }

    @Override
    public String getFamily() {
        return "org.apache.myfaces.trinidad.Iterator";
    }

    @Override
    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    protected UIXIterator(String rendererType) {
        super(rendererType);
    }

    static {
        TYPE.lock();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class Runner
    implements ComponentProcessor<Object> {
        public Exception exception = null;
        private final ComponentProcessingContext _cpContext;

        public Runner() {
            this(null);
        }

        public Runner(ComponentProcessingContext cpContext) {
            this._cpContext = cpContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean run() {
            FacesContext context = FacesContext.getCurrentInstance();
            List<UIComponent> stamps = UIXIterator.this.getStamps();
            int oldIndex = UIXIterator.this.getRowIndex();
            int first = UIXIterator.this.getFirst();
            int rows = UIXIterator.this.getRows();
            int end = rows <= 0 ? Integer.MAX_VALUE : first + rows;
            boolean processedChild = false;
            try {
                for (int i = first; i < end; ++i) {
                    UIXIterator.this.setRowIndex(i);
                    if (UIXIterator.this.isRowAvailable()) {
                        processedChild |= this._cpContext != null ? UIXComponent.processFlattenedChildren(context, this._cpContext, this, stamps, null) : UIXComponent.processFlattenedChildren(context, this, stamps, null);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                this.exception = e;
            }
            finally {
                UIXIterator.this.setRowIndex(oldIndex);
            }
            return processedChild;
        }

        @Override
        public void processComponent(FacesContext context, ComponentProcessingContext cpContext, UIComponent component, Object callbackContext) throws IOException {
            try {
                this.process(component, cpContext);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        protected abstract void process(UIComponent var1, ComponentProcessingContext var2) throws Exception;
    }
}

