/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.RandomAccess;
import java.util.Set;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionUtils {
    private static final Class<? extends List> _CHECKED_LIST;
    private static final Class<? extends List> _UNMODIFIABLE_LIST;
    private static final Class<? extends List> _SYNCHRONIZED_LIST;
    private static final Queue _EMPTY_QUEUE;
    private static final Iterator _EMPTY_ITERATOR;
    private static final Iterator _EMPTY_LIST_ITERATOR;
    private static final TrinidadLogger _LOG;

    private CollectionUtils() {
    }

    public static <T> ArrayList<T> arrayList(Iterator<T> iterator) {
        ArrayList<T> arrayList = new ArrayList<T>();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public static <T> Queue<T> emptyQueue() {
        return _EMPTY_QUEUE;
    }

    public static <T> Iterator<T> emptyIterator() {
        return _EMPTY_ITERATOR;
    }

    public static <T> ListIterator<T> emptyListIterator() {
        return (ListIterator)_EMPTY_LIST_ITERATOR;
    }

    public static <T> Collection<T> getSerializableCollection(Collection<T> c) {
        if (c instanceof Serializable) {
            return c;
        }
        return new SerializableCollection<T>(c);
    }

    public static <T> List<T> newSerializableList(List<T> l) {
        if (l instanceof RandomAccess) {
            return new SerializableRandomAccessList<T>(l);
        }
        return new SerializableList<T>(l);
    }

    public static <T> List<T> getSerializableList(List<T> l) {
        if (l instanceof Serializable && !_CHECKED_LIST.isInstance(l) && !_UNMODIFIABLE_LIST.isInstance(l) && !_SYNCHRONIZED_LIST.isInstance(l)) {
            return l;
        }
        return CollectionUtils.newSerializableList(l);
    }

    public static <K, V> Map<K, V> getCheckedSerializationMap(Map<K, V> map) {
        if (map instanceof CheckedSerializationMap) {
            return map;
        }
        return new CheckedSerializationMap<K, V>(map);
    }

    protected static <T> T[] copyOf(T[] original, int newLength) {
        return CollectionUtils.copyOf(original, newLength, original.getClass());
    }

    protected static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    static {
        _EMPTY_QUEUE = new EmptyQueue();
        _EMPTY_ITERATOR = new EmptyIterator();
        _EMPTY_LIST_ITERATOR = new EmptyListIterator();
        LinkedList dummyList = new LinkedList();
        _CHECKED_LIST = Collections.checkedList(dummyList, Object.class).getClass();
        _UNMODIFIABLE_LIST = Collections.unmodifiableList(dummyList).getClass();
        _SYNCHRONIZED_LIST = Collections.synchronizedList(dummyList).getClass();
        _LOG = TrinidadLogger.createTrinidadLogger(CollectionUtils.class);
    }

    private static final class EmptyQueue
    extends AbstractQueue
    implements Serializable {
        private static final long serialVersionUID = 0L;

        private EmptyQueue() {
        }

        public Iterator iterator() {
            return _EMPTY_ITERATOR;
        }

        public int size() {
            return 0;
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean contains(Object o) {
            return false;
        }

        public boolean offer(Object e) {
            throw new UnsupportedOperationException();
        }

        public Object poll() {
            return null;
        }

        public Object peek() {
            return null;
        }

        private Object readResolve() {
            return _EMPTY_QUEUE;
        }
    }

    private static final class EmptyListIterator
    extends EmptyIterator
    implements ListIterator {
        private EmptyListIterator() {
        }

        public boolean hasPrevious() {
            return false;
        }

        public Object previous() {
            throw new NoSuchElementException();
        }

        public int nextIndex() {
            return 0;
        }

        public int previousIndex() {
            return -1;
        }

        public void set(Object e) {
            throw new UnsupportedOperationException();
        }

        public void add(Object e) {
            throw new UnsupportedOperationException();
        }
    }

    private static class EmptyIterator
    implements Iterator {
        private EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CheckedSerializationMap<K, V>
    extends DelegatingMap<K, V>
    implements Serializable {
        private final Map<K, V> _delegate;

        public CheckedSerializationMap(Map<K, V> delegate) {
            if (delegate == null) {
                throw new NullPointerException();
            }
            if (delegate instanceof Serializable) {
                throw new IllegalArgumentException("Unserializable delegate");
            }
            this._delegate = delegate;
        }

        @Override
        protected Map<K, V> getDelegate() {
            return this._delegate;
        }

        @Override
        public V put(K key, V value) {
            this._checkSerialization(key, value);
            return super.put(key, value);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            Object[] values;
            Object[] keys = m.keySet().toArray();
            int keyCount = keys.length;
            if (keyCount != (values = m.values().toArray()).length) {
                throw new ConcurrentModificationException();
            }
            for (int k = 0; k < keyCount; ++k) {
                this._checkSerialization(keys[k], values[k]);
            }
            Map<Object, Object> delegate = this.getDelegate();
            for (int k = 0; k < keyCount; ++k) {
                delegate.put(keys[k], values[k]);
            }
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new CheckedSerializationEntrySet(this.getDelegate().entrySet());
        }

        private void _checkSerialization(Object key, Object value) {
            if (!(key instanceof Serializable)) {
                throw new ClassCastException(_LOG.getMessage("UNSERIALIZABLE_PROPERTY_KEY", new Object[]{key, this}));
            }
            if (!(value instanceof Serializable)) {
                throw new ClassCastException(_LOG.getMessage("UNSERIALIZABLE_PROPERTY_VALUE", new Object[]{value, key, this}));
            }
            if (!(key instanceof String)) {
                try {
                    new ObjectOutputStream(new ByteArrayOutputStream()).writeObject(key);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(_LOG.getMessage("FAILED_SERIALIZATION_PROPERTY_KEY", new Object[]{key, this}), e);
                }
            }
            try {
                new ObjectOutputStream(new ByteArrayOutputStream()).writeObject(value);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(_LOG.getMessage("FAILED_SERIALIZATION_PROPERTY_VALUE", new Object[]{value, key, this}), e);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class CheckedSerializationEntrySet
        extends DelegatingCollection<Map.Entry<K, V>>
        implements Set<Map.Entry<K, V>> {
            private final Set<Map.Entry<K, V>> _delegate;

            private CheckedSerializationEntrySet(Set<Map.Entry<K, V>> delegate) {
                if (delegate == null) {
                    throw new NullPointerException();
                }
                this._delegate = delegate;
            }

            @Override
            protected Set<Map.Entry<K, V>> getDelegate() {
                return this._delegate;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new CheckedSerializationEntrySetIterator(super.iterator());
            }

            @Override
            public Object[] toArray() {
                Object[] delegateEntries = super.toArray();
                int entryCount = delegateEntries.length;
                Object[] entries = delegateEntries.getClass().getComponentType().isAssignableFrom(Map.Entry.class) ? delegateEntries : new Map.Entry[entryCount];
                for (int i = 0; i < entryCount; ++i) {
                    entries[i] = new CheckedSerializationEntry((Map.Entry)delegateEntries[i]);
                }
                return entries;
            }

            @Override
            public <T> T[] toArray(T[] a) {
                int inputSize = a.length;
                T[] outTypeArray = inputSize == 0 ? a : CollectionUtils.copyOf(a, 0);
                T[] delegateEntries = super.toArray(outTypeArray);
                int entryCount = delegateEntries.length;
                for (int i = 0; i < entryCount; ++i) {
                    delegateEntries[i] = new CheckedSerializationEntry((Map.Entry)delegateEntries[i]);
                }
                if (entryCount > inputSize) {
                    return delegateEntries;
                }
                System.arraycopy(delegateEntries, 0, a, 0, entryCount);
                if (inputSize > entryCount) {
                    a[entryCount] = null;
                }
                return a;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            private class CheckedSerializationEntry<K, V>
            extends DelegatingEntry<K, V> {
                private final Map.Entry<K, V> _delegate;

                private CheckedSerializationEntry(Map.Entry<K, V> delegate) {
                    if (delegate == null) {
                        throw new NullPointerException();
                    }
                    this._delegate = delegate;
                }

                @Override
                protected Map.Entry<K, V> getDelegate() {
                    return this._delegate;
                }

                @Override
                public V setValue(V value) {
                    CheckedSerializationMap.this._checkSerialization(this.getKey(), value);
                    return super.setValue(value);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            private class CheckedSerializationEntrySetIterator
            implements Iterator<Map.Entry<K, V>> {
                private final Iterator<Map.Entry<K, V>> _delegate;

                private CheckedSerializationEntrySetIterator(Iterator<Map.Entry<K, V>> delegate) {
                    this._delegate = delegate;
                }

                @Override
                public boolean hasNext() {
                    return this._delegate.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    return new CheckedSerializationEntry(this._delegate.next());
                }

                @Override
                public void remove() {
                    this._delegate.remove();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class DelegatingEntry<K, V>
    implements Map.Entry<K, V> {
        protected DelegatingEntry() {
        }

        protected abstract Map.Entry<K, V> getDelegate();

        @Override
        public K getKey() {
            return this.getDelegate().getKey();
        }

        @Override
        public V getValue() {
            return this.getDelegate().getValue();
        }

        @Override
        public V setValue(V value) {
            return this.getDelegate().setValue(value);
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this.getDelegate()).equals(o);
        }

        @Override
        public int hashCode() {
            return ((Object)this.getDelegate()).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class DelegatingMap<K, V>
    implements Map<K, V> {
        protected DelegatingMap() {
        }

        protected abstract Map<K, V> getDelegate();

        @Override
        public int size() {
            return this.getDelegate().size();
        }

        @Override
        public boolean isEmpty() {
            return this.getDelegate().isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.getDelegate().containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.getDelegate().containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this.getDelegate().get(key);
        }

        @Override
        public V put(K key, V value) {
            return this.getDelegate().put(key, value);
        }

        @Override
        public V remove(Object key) {
            return this.getDelegate().remove(key);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            this.getDelegate().putAll(m);
        }

        @Override
        public void clear() {
            this.getDelegate().clear();
        }

        @Override
        public Set<K> keySet() {
            return this.getDelegate().keySet();
        }

        @Override
        public Collection<V> values() {
            return this.getDelegate().values();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.getDelegate().entrySet();
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this.getDelegate()).equals(o);
        }

        @Override
        public int hashCode() {
            return ((Object)this.getDelegate()).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializableRandomAccessList<E>
    extends SerializableList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 0L;

        SerializableRandomAccessList(List<E> delegate) {
            super(delegate);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializableList<E>
    extends SerializableCollection<E>
    implements List<E> {
        private static final long serialVersionUID = 0L;
        private final transient List<E> _delegate;

        SerializableList(List<E> delegate) {
            super(delegate);
            this._delegate = delegate;
        }

        @Override
        public void add(int index, E element) {
            this._delegate.add(index, element);
        }

        @Override
        public E remove(int index) {
            return this._delegate.remove(index);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            return this._delegate.addAll(index, c);
        }

        @Override
        public E get(int index) {
            return this._delegate.get(index);
        }

        @Override
        public E set(int index, E element) {
            return this._delegate.set(index, element);
        }

        @Override
        public int indexOf(Object o) {
            return this._delegate.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this._delegate.lastIndexOf(o);
        }

        @Override
        public ListIterator<E> listIterator() {
            return this._delegate.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return this._delegate.listIterator(index);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return CollectionUtils.getSerializableList(this._delegate.subList(fromIndex, toIndex));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializableCollection<E>
    extends DelegatingCollection<E>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final transient Collection<E> _delegate;

        SerializableCollection(Collection<E> delegate) {
            if (delegate == null) {
                throw new NullPointerException();
            }
            this._delegate = delegate;
        }

        @Override
        protected Collection<E> getDelegate() {
            return this._delegate;
        }

        protected Object writeReplace() throws ObjectStreamException {
            return new ArrayList<E>(this._delegate);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class DelegatingCollection<E>
    implements Collection<E> {
        protected DelegatingCollection() {
        }

        protected abstract Collection<E> getDelegate();

        @Override
        public int size() {
            return this.getDelegate().size();
        }

        @Override
        public boolean isEmpty() {
            return this.getDelegate().isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.getDelegate().contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            return this.getDelegate().iterator();
        }

        @Override
        public Object[] toArray() {
            return this.getDelegate().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.getDelegate().toArray(a);
        }

        @Override
        public boolean add(E e) {
            return this.getDelegate().add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.getDelegate().remove(0);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.getDelegate().containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return this.getDelegate().addAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.getDelegate().removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.getDelegate().retainAll(c);
        }

        @Override
        public void clear() {
            this.getDelegate().clear();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || ((Object)this.getDelegate()).equals(o);
        }

        @Override
        public int hashCode() {
            return ((Object)this.getDelegate()).hashCode();
        }

        public String toString() {
            return this.getDelegate().toString();
        }
    }
}

