/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.util;

import org.apache.myfaces.trinidad.logging.TrinidadLogger;

public class FastMessageFormat {
    private final char[] _formatText;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(FastMessageFormat.class);

    public FastMessageFormat(String formatString) {
        if (formatString == null) {
            throw new NullPointerException();
        }
        this._formatText = formatString.toCharArray();
    }

    public String format(Object[] source) {
        int formatLength = this._formatText.length;
        int length = 0;
        int tokenCount = source.length;
        for (int i = 0; i < tokenCount; ++i) {
            Object sourceString = source[i];
            if (sourceString == null) continue;
            length += sourceString.toString().length();
        }
        StringBuilder buffer = new StringBuilder(length + formatLength);
        int lastStart = 0;
        for (int i = 0; i < formatLength; ++i) {
            int tokenIndex;
            char ch = this._formatText[i];
            if (ch != '{' || i + 2 >= formatLength || this._formatText[i + 2] != '}' || (tokenIndex = this._formatText[i + 1] - 48) < 0 || tokenIndex >= tokenCount) continue;
            buffer.append(this._formatText, lastStart, i - lastStart);
            Object sourceString = source[tokenIndex];
            if (sourceString != null) {
                buffer.append(sourceString.toString());
            }
            lastStart = (i += 2) + 1;
        }
        buffer.append(this._formatText, lastStart, formatLength - lastStart);
        return new String(buffer);
    }
}

