/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.el.MethodExpression;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.ProjectStage;
import javax.faces.component.NamingContainer;
import javax.faces.component.StateHelper;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIPanel;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.render.Renderer;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.ComponentProcessingContext;
import org.apache.myfaces.trinidad.component.ComponentProcessor;
import org.apache.myfaces.trinidad.component.FlattenedComponent;
import org.apache.myfaces.trinidad.context.ComponentContextChange;
import org.apache.myfaces.trinidad.context.ComponentContextManager;
import org.apache.myfaces.trinidad.context.PartialPageContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.AttributeChangeListener;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.render.CoreRenderer;

public abstract class UIXComponent
extends UIComponent {
    private static final boolean _treatContextualIssuesAsErrors;
    private static final boolean _inTestingPhase;
    private static final TrinidadLogger _LOG;
    private String _setupVisitingCaller;
    private String _tearDownVisitingCaller;
    private String _setupEncodingCaller;
    private String _tearDownEncodingCaller;
    private String _setupChildrenEncodingCaller;
    private String _tearDownChildrenEncodingCaller;
    private String _setupChildrenVisitingCaller;
    private String _tearDownChildrenVisitingCaller;
    private boolean _inVisitingContext;
    private boolean _inChildrenVisitingContext;
    private boolean _inEncodingContext;
    private boolean _inChildrenEncodingContext;

    public static <S> boolean processFlattenedChildren(FacesContext context, ComponentProcessor<S> childProcessor, UIComponent child, S callbackContext) throws IOException {
        return UIXComponent.processFlattenedChildren(context, new ComponentProcessingContext(), childProcessor, child, callbackContext);
    }

    public static <S> boolean encodeFlattenedChild(FacesContext context, ComponentProcessor<S> childProcessor, UIComponent child, S callbackContext) throws IOException {
        ComponentProcessingContext processingContext = new ComponentProcessingContext();
        processingContext.__setIsRendering();
        return UIXComponent.processFlattenedChildren(context, processingContext, childProcessor, child, callbackContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S> boolean processFlattenedChildren(FacesContext context, ComponentProcessingContext cpContext, ComponentProcessor<S> childProcessor, UIComponent child, S callbackContext) throws IOException {
        if (child.isRendered()) {
            boolean processed;
            block9: {
                if (child instanceof FlattenedComponent && ((FlattenedComponent)child).isFlatteningChildren(context)) {
                    return ((FlattenedComponent)child).processFlattenedChildren(context, cpContext, childProcessor, callbackContext);
                }
                processed = true;
                RequestContext requestContext = cpContext.getRequestContext();
                requestContext.pushCurrentComponent(context, child);
                child.pushComponentToEL(context, null);
                try {
                    if (UIXComponent.isFlattenableCoreComponent(child)) {
                        processed = UIXComponent.processFlattenedChildren(context, cpContext, childProcessor, child.getChildren(), callbackContext);
                        break block9;
                    }
                    try {
                        childProcessor.processComponent(context, cpContext, child, callbackContext);
                    }
                    finally {
                        cpContext.resetStartDepth();
                    }
                }
                finally {
                    child.popComponentFromEL(context);
                    requestContext.popCurrentComponent(context, child);
                }
            }
            return processed;
        }
        return false;
    }

    public static <S> boolean processFlattenedChildren(FacesContext context, ComponentProcessor<S> childProcessor, Iterable<UIComponent> children, S callbackContext) throws IOException {
        return UIXComponent.processFlattenedChildren(context, new ComponentProcessingContext(), childProcessor, children, callbackContext);
    }

    public static <S> boolean encodeFlattenedChildren(FacesContext context, ComponentProcessor<S> childProcessor, Iterable<UIComponent> children, S callbackContext) throws IOException {
        ComponentProcessingContext processingContext = new ComponentProcessingContext();
        processingContext.__setIsRendering();
        return UIXComponent.processFlattenedChildren(context, processingContext, childProcessor, children, callbackContext);
    }

    public static <S> boolean processFlattenedChildren(FacesContext context, ComponentProcessingContext cpContext, ComponentProcessor<S> childProcessor, Iterable<UIComponent> children, S callbackContext) throws IOException {
        boolean processedChild = false;
        for (UIComponent currChild : children) {
            processedChild |= UIXComponent.processFlattenedChildren(context, cpContext, childProcessor, currChild, callbackContext);
        }
        return processedChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void broadcastInContext(FacesContext context, FacesEvent event) {
        UIComponent component = event.getComponent();
        UIComponent compositeParent = null;
        RequestContext requestContext = RequestContext.getCurrentInstance();
        if (!UIComponent.isCompositeComponent((UIComponent)component) && (compositeParent = UIComponent.getCompositeComponentParent((UIComponent)component)) != null) {
            requestContext.pushCurrentComponent(context, compositeParent);
            compositeParent.pushComponentToEL(context, null);
        }
        requestContext.pushCurrentComponent(context, component);
        component.pushComponentToEL(context, null);
        try {
            component.broadcast(event);
        }
        finally {
            component.popComponentFromEL(context);
            requestContext.popCurrentComponent(context, component);
            if (compositeParent != null) {
                compositeParent.popComponentFromEL(context);
                requestContext.popCurrentComponent(context, compositeParent);
            }
        }
    }

    public boolean visitTree(VisitContext visitContext, VisitCallback callback) {
        return UIXComponent.visitTree(visitContext, this, callback);
    }

    protected Iterator<UIComponent> getRenderedFacetsAndChildren(FacesContext facesContext) {
        return this.defaultGetRenderedFacetsAndChildren(facesContext);
    }

    protected final Iterator<UIComponent> defaultGetRenderedFacetsAndChildren(FacesContext facesContext) {
        Renderer renderer = this.getRenderer(facesContext);
        if (renderer instanceof CoreRenderer) {
            return ((CoreRenderer)renderer).getRenderedFacetsAndChildren(facesContext, this);
        }
        return this.getFacetsAndChildren();
    }

    protected boolean visitChildren(VisitContext visitContext, VisitCallback callback) {
        Renderer renderer;
        if (UIXComponent._isEncodingVisit(visitContext) && (renderer = this.getRenderer(visitContext.getFacesContext())) instanceof CoreRenderer) {
            CoreRenderer coreRenderer = (CoreRenderer)renderer;
            return coreRenderer.visitChildrenForEncoding(this, visitContext, callback);
        }
        return this.visitAllChildren(visitContext, callback);
    }

    protected final boolean visitAllChildren(VisitContext visitContext, VisitCallback callback) {
        Iterator<UIComponent> kids;
        Iterator<UIComponent> iterator = kids = visitContext.getHints().contains(VisitHint.SKIP_UNRENDERED) ? this.getRenderedFacetsAndChildren(visitContext.getFacesContext()) : this.getFacetsAndChildren();
        while (kids.hasNext()) {
            if (!kids.next().visitTree(visitContext, callback)) continue;
            return true;
        }
        return false;
    }

    private static boolean _isEncodingVisit(VisitContext visitContext) {
        return visitContext.getHints().contains(VisitHint.EXECUTE_LIFECYCLE) && FacesContext.getCurrentInstance().getCurrentPhaseId() == PhaseId.RENDER_RESPONSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean visitTree(VisitContext visitContext, UIComponent component, VisitCallback callback) {
        RequestContext requestContext = RequestContext.getCurrentInstance();
        requestContext.pushCurrentComponent(visitContext.getFacesContext(), component);
        try {
            boolean doneVisiting;
            block33: {
                if (!(component instanceof UIXComponent)) {
                    boolean bl = component.visitTree(visitContext, callback);
                    return bl;
                }
                UIXComponent uixComponent = (UIXComponent)component;
                FacesContext context = visitContext.getFacesContext();
                if (!uixComponent.isVisitable(visitContext)) {
                    boolean bl = false;
                    return bl;
                }
                component.pushComponentToEL(context, null);
                doneVisiting = false;
                RuntimeException re = null;
                try {
                    RenderingContext rc;
                    RenderingContext renderingContext = rc = UIXComponent._isEncodingVisit(visitContext) ? RenderingContext.getCurrentInstance() : null;
                    if (rc == null) {
                        uixComponent.setupVisitingContext(context);
                    }
                    VisitResult visitResult = VisitResult.REJECT;
                    try {
                        visitResult = visitContext.invokeVisitCallback(component, callback);
                        if (visitResult == VisitResult.COMPLETE) {
                            doneVisiting = true;
                            break block33;
                        }
                        if (visitResult == VisitResult.ACCEPT) {
                            boolean skipChildren;
                            boolean bl = skipChildren = uixComponent instanceof NamingContainer && visitContext.getSubtreeIdsToVisit((UIComponent)uixComponent).isEmpty();
                            if (skipChildren) break block33;
                            if (rc != null) {
                                uixComponent.setupEncodingContext(context, rc);
                            }
                            try {
                                doneVisiting = UIXComponent.visitChildren(visitContext, uixComponent, callback);
                                break block33;
                            }
                            finally {
                                if (rc != null) {
                                    uixComponent.tearDownEncodingContext(context, rc);
                                }
                            }
                        }
                        assert (visitResult == VisitResult.REJECT);
                    }
                    catch (RuntimeException ex) {
                        re = ex;
                    }
                    finally {
                        try {
                            if (rc == null) {
                                uixComponent.tearDownVisitingContext(context);
                            }
                        }
                        catch (RuntimeException ex) {
                            if (re == null) {
                                throw ex;
                            }
                            _LOG.warning(ex);
                        }
                    }
                }
                finally {
                    component.popComponentFromEL(context);
                    if (re != null) {
                        throw re;
                    }
                }
            }
            boolean bl = doneVisiting;
            return bl;
        }
        finally {
            requestContext.popCurrentComponent(visitContext.getFacesContext(), component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean visitChildren(VisitContext visitContext, UIComponent parentComponent, VisitCallback callback) {
        boolean doneVisiting;
        block19: {
            if (!(parentComponent instanceof UIXComponent)) {
                Iterator iter = parentComponent.getFacetsAndChildren();
                while (iter.hasNext()) {
                    UIComponent child = (UIComponent)iter.next();
                    if (!child.visitTree(visitContext, callback)) continue;
                    return true;
                }
                return false;
            }
            UIXComponent uixParentComponent = (UIXComponent)parentComponent;
            FacesContext context = visitContext.getFacesContext();
            RenderingContext rc = UIXComponent._isEncodingVisit(visitContext) ? RenderingContext.getCurrentInstance() : null;
            doneVisiting = false;
            RuntimeException re = null;
            if (parentComponent instanceof UIXComponent) {
                if (rc != null) {
                    uixParentComponent.setupChildrenEncodingContext(context, rc);
                } else {
                    uixParentComponent.setupChildrenVisitingContext(context);
                }
            }
            try {
                doneVisiting = uixParentComponent.visitChildren(visitContext, callback);
            }
            catch (RuntimeException ex) {
                re = ex;
                return (boolean)re;
            }
            finally {
                try {
                    if (rc != null) {
                        uixParentComponent.tearDownChildrenEncodingContext(context, rc);
                    } else {
                        uixParentComponent.tearDownChildrenVisitingContext(context);
                    }
                }
                catch (RuntimeException ex) {
                    if (re == null) {
                        throw ex;
                    }
                    _LOG.warning(ex);
                }
                if (re == null) break block19;
                throw re;
            }
        }
        return doneVisiting;
    }

    public static void addPartialTarget(FacesContext facesContext, PartialPageContext partialContext, UIComponent component) {
        if (component == null) {
            throw new NullPointerException("UIComponent is null");
        }
        if (component instanceof UIXComponent) {
            ((UIXComponent)component).setPartialTarget(facesContext, partialContext);
        } else {
            UIXComponent._addPartialTargetImpl(facesContext, partialContext, component);
        }
    }

    public void clearCachedClientIds() {
        UIXComponent.clearCachedClientIds(this);
    }

    public static void clearCachedClientIds(UIComponent component) {
        if (component instanceof UIXComponent) {
            ((UIXComponent)component).clearCachedClientIds();
        } else {
            UIXComponent._clearCachedClientIds(component);
        }
    }

    private static void _clearCachedClientIds(UIComponent component) {
        String id = component.getId();
        component.setId(id);
        Iterator allChildren = component.getFacetsAndChildren();
        while (allChildren.hasNext()) {
            UIXComponent.clearCachedClientIds((UIComponent)allChildren.next());
        }
    }

    protected void setPartialTarget(FacesContext facesContext, PartialPageContext partialContext) {
        UIXComponent._addPartialTargetImpl(facesContext, partialContext, this);
    }

    protected boolean isVisitable(VisitContext visitContext) {
        return UIXComponent._isVisitable(visitContext, this);
    }

    private static void _addPartialTargetImpl(FacesContext facesContext, PartialPageContext partialContext, UIComponent component) {
        if (component.getRendererType() == null) {
            if (component.getParent() != null) {
                UIXComponent.addPartialTarget(facesContext, partialContext, component.getParent());
            }
        } else {
            partialContext.addPartialTarget(component.getClientId(facesContext));
        }
    }

    private static boolean _isVisitable(VisitContext visitContext, UIComponent component) {
        Set hints = visitContext.getHints();
        if (hints.contains(VisitHint.SKIP_TRANSIENT) && component.isTransient()) {
            return false;
        }
        return !hints.contains(VisitHint.SKIP_UNRENDERED) || component.isRendered();
    }

    public VisitResult partialEncodeVisit(VisitContext visitContext, PartialPageContext partialContext, VisitCallback callback) {
        FacesContext context = visitContext.getFacesContext();
        Renderer renderer = this.getRenderer(context);
        if (renderer instanceof CoreRenderer) {
            return ((CoreRenderer)renderer).partialEncodeVisit(visitContext, partialContext, this, callback);
        }
        if (partialContext.isPossiblePartialTarget(this.getId()) && partialContext.isPartialTarget(this.getClientId(context))) {
            return callback.visit(visitContext, (UIComponent)this);
        }
        return VisitResult.ACCEPT;
    }

    protected void setupVisitingContext(FacesContext context) {
        if (_inTestingPhase) {
            if (this._inVisitingContext) {
                this._handleInvalidContextUsage("COMPONENT_ALREADY_IN_VISITING_CONTEXT", this._setupVisitingCaller);
            }
            ComponentContextManager componentContextManager = RequestContext.getCurrentInstance().getComponentContextManager();
            componentContextManager.pushChange(new VisitDebugContextChange(this));
            this._inVisitingContext = true;
            this._setupVisitingCaller = this._getStackTraceElementForCaller();
        }
    }

    protected void setupChildrenVisitingContext(FacesContext context) {
        if (_inTestingPhase) {
            if (this._inChildrenVisitingContext) {
                this._handleInvalidContextUsage("COMPONENT_ALREADY_IN_CHILDREN_VISITING_CONTEXT", this._setupChildrenVisitingCaller);
            }
            ComponentContextManager componentContextManager = RequestContext.getCurrentInstance().getComponentContextManager();
            componentContextManager.pushChange(new VisitChildrenDebugContextChange(this));
            this._inChildrenVisitingContext = true;
            this._setupChildrenVisitingCaller = this._getStackTraceElementForCaller();
        }
    }

    protected void tearDownVisitingContext(FacesContext context) {
        if (_inTestingPhase) {
            ComponentContextManager componentContextManager;
            ComponentContextChange contextChange;
            if (!this._inVisitingContext) {
                this._handleInvalidContextUsage("COMPONENT_NOT_IN_VISITING_CONTEXT", this._tearDownVisitingCaller);
            }
            if (!((contextChange = (componentContextManager = RequestContext.getCurrentInstance().getComponentContextManager()).popChange()) instanceof VisitDebugContextChange) || ((VisitDebugContextChange)contextChange)._component != this) {
                throw new IllegalStateException(this._getInvalidContextChangeMessage(VisitDebugContextChange.class, contextChange));
            }
            this._inVisitingContext = false;
            this._tearDownVisitingCaller = this._getStackTraceElementForCaller();
        }
    }

    protected void tearDownChildrenVisitingContext(FacesContext context) {
        if (_inTestingPhase) {
            ComponentContextManager componentContextManager;
            ComponentContextChange contextChange;
            if (!this._inChildrenVisitingContext) {
                this._handleInvalidContextUsage("COMPONENT_NOT_IN_CHILDREN_VISITING_CONTEXT", this._tearDownChildrenVisitingCaller);
            }
            if (!((contextChange = (componentContextManager = RequestContext.getCurrentInstance().getComponentContextManager()).popChange()) instanceof VisitChildrenDebugContextChange) || ((VisitChildrenDebugContextChange)contextChange)._component != this) {
                throw new IllegalStateException(this._getInvalidContextChangeMessage(VisitChildrenDebugContextChange.class, contextChange));
            }
            this._inChildrenVisitingContext = false;
            this._tearDownChildrenVisitingCaller = this._getStackTraceElementForCaller();
        }
    }

    @Deprecated
    protected final void setUpEncodingContext(FacesContext context, RenderingContext rc) {
        this.setupEncodingContext(context, rc);
    }

    protected void setupEncodingContext(FacesContext context, RenderingContext rc) {
        Renderer renderer;
        this.setupVisitingContext(context);
        if (_inTestingPhase) {
            if (this._inEncodingContext) {
                this._handleInvalidContextUsage("COMPONENT_ALREADY_IN_ENCODING_CONTEXT", this._setupEncodingCaller);
            }
            this._inEncodingContext = true;
            this._setupEncodingCaller = this._getStackTraceElementForCaller();
        }
        if ((renderer = this.getRenderer(context)) instanceof CoreRenderer) {
            CoreRenderer coreRenderer = (CoreRenderer)renderer;
            coreRenderer.setupEncodingContext(context, rc, (UIComponent)this);
        }
        this._inEncodingContext = true;
    }

    public void setupChildrenEncodingContext(FacesContext context, RenderingContext rc) {
        Renderer renderer;
        this.setupChildrenVisitingContext(context);
        if (_inTestingPhase) {
            if (this._inChildrenEncodingContext) {
                this._handleInvalidContextUsage("COMPONENT_ALREADY_IN_CHILDREN_ENCODING_CONTEXT", this._setupChildrenEncodingCaller);
            }
            this._inChildrenEncodingContext = true;
            this._setupChildrenEncodingCaller = this._getStackTraceElementForCaller();
        }
        if ((renderer = this.getRenderer(context)) instanceof CoreRenderer) {
            CoreRenderer coreRenderer = (CoreRenderer)renderer;
            coreRenderer.setupChildrenEncodingContext(context, rc, this);
        }
        this._inChildrenEncodingContext = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDownEncodingContext(FacesContext context, RenderingContext rc) {
        if (_inTestingPhase) {
            if (!this._inEncodingContext) {
                this._handleInvalidContextUsage("COMPONENT_NOT_IN_ENCODING_CONTEXT", this._tearDownEncodingCaller);
            }
            this._inEncodingContext = false;
            this._tearDownEncodingCaller = this._getStackTraceElementForCaller();
        }
        Renderer renderer = this.getRenderer(context);
        try {
            if (renderer instanceof CoreRenderer) {
                CoreRenderer coreRenderer = (CoreRenderer)renderer;
                coreRenderer.tearDownEncodingContext(context, rc, (UIComponent)this);
            }
        }
        finally {
            this.tearDownVisitingContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDownChildrenEncodingContext(FacesContext context, RenderingContext rc) {
        if (_inTestingPhase) {
            if (!this._inChildrenEncodingContext) {
                this._handleInvalidContextUsage("COMPONENT_NOT_IN_CHILDREN_ENCODING_CONTEXT", this._tearDownChildrenEncodingCaller);
            }
            this._inChildrenEncodingContext = false;
            this._tearDownChildrenEncodingCaller = this._getStackTraceElementForCaller();
        }
        Renderer renderer = this.getRenderer(context);
        try {
            if (renderer instanceof CoreRenderer) {
                CoreRenderer coreRenderer = (CoreRenderer)renderer;
                coreRenderer.tearDownChildrenEncodingContext(context, rc, this);
            }
        }
        finally {
            this.tearDownChildrenVisitingContext(context);
            this._inChildrenEncodingContext = false;
        }
    }

    public abstract FacesBean getFacesBean();

    public abstract void addAttributeChangeListener(AttributeChangeListener var1);

    public abstract void removeAttributeChangeListener(AttributeChangeListener var1);

    public abstract AttributeChangeListener[] getAttributeChangeListeners();

    public abstract void setAttributeChangeListener(MethodExpression var1);

    public abstract MethodExpression getAttributeChangeListener();

    public abstract void markInitialState();

    public abstract String getContainerClientId(FacesContext var1, UIComponent var2);

    public UIComponent getLogicalParent() {
        return this.getParent();
    }

    public static UIComponent getLogicalParent(UIComponent component) {
        if (component instanceof UIXComponent) {
            return ((UIXComponent)component).getLogicalParent();
        }
        return component.getParent();
    }

    protected StateHelper getStateHelper() {
        throw new UnsupportedOperationException();
    }

    protected StateHelper getStateHelper(boolean create) {
        throw new UnsupportedOperationException();
    }

    private String _getStackTraceElementForCaller() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        String lineSep = System.getProperty("line.separator");
        StringBuilder stack = new StringBuilder();
        int size = elements.length;
        for (int i = 3; i < size && i < 10; ++i) {
            stack.append(elements[i].toString());
            stack.append(lineSep);
        }
        return stack.toString();
    }

    private static boolean isFlattenableCoreComponent(UIComponent component) {
        Class<?> componentClass = component.getClass();
        if (UINamingContainer.class == componentClass) {
            return component.getFacet("javax.faces.component.COMPOSITE_FACET_NAME") == null;
        }
        return UIPanel.class == componentClass;
    }

    private void _handleInvalidContextUsage(String bundleKey, String originalStackTrace) throws IllegalStateException {
        String errorMessage = _LOG.getMessage(bundleKey, new Object[]{this.getClientId(), originalStackTrace});
        if (_treatContextualIssuesAsErrors) {
            throw new IllegalStateException(errorMessage);
        }
        _LOG.warning(errorMessage);
    }

    private String _getInvalidContextChangeMessage(Class<? extends ComponentContextChange> expectedClass, ComponentContextChange foundChange) {
        String type = expectedClass.getName();
        String id = this.getParent() == null ? this.getId() : this.getClientId();
        return _LOG.getMessage("INVALID_CONTEXT_CHANGE_FOUND", new Object[]{type, id, foundChange});
    }

    static {
        _LOG = TrinidadLogger.createTrinidadLogger(UIXComponent.class);
        Application app = null;
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Application application = app = facesContext == null ? null : facesContext.getApplication();
            if (app == null) {
                ApplicationFactory appFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
                app = appFactory.getApplication();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean bl = app == null ? false : (_inTestingPhase = app.getProjectStage() == ProjectStage.UnitTest);
        if (_inTestingPhase) {
            _LOG.info("Application is running in testing phase, UIXComponent will perform extra validation steps to ensure proper component usage");
        }
        _treatContextualIssuesAsErrors = "true".equals(System.getProperty("uixcomponent.contextual.issue.throw"));
    }

    private static class VisitChildrenDebugContextChange
    extends ComponentContextChange {
        private final UIXComponent _component;
        private boolean _inChildrenVisitingContext;
        private boolean _inChildrenEncodingContext;
        private String _setupChildrenEncodingCaller;
        private String _tearDownChildrenEncodingCaller;
        private String _setupChildrenVisitingCaller;
        private String _tearDownChildrenVisitingCaller;

        private VisitChildrenDebugContextChange(UIXComponent component) {
            this._component = component;
        }

        @Override
        public void resume(FacesContext facesContext) {
            this._component._inChildrenVisitingContext = this._inChildrenVisitingContext;
            this._component._inChildrenEncodingContext = this._inChildrenEncodingContext;
            this._component._setupChildrenEncodingCaller = this._setupChildrenEncodingCaller;
            this._component._tearDownChildrenEncodingCaller = this._tearDownChildrenEncodingCaller;
            this._component._setupChildrenVisitingCaller = this._setupChildrenVisitingCaller;
            this._component._tearDownChildrenVisitingCaller = this._tearDownChildrenVisitingCaller;
        }

        @Override
        public void suspend(FacesContext facesContext) {
            this._inChildrenVisitingContext = this._component._inChildrenVisitingContext;
            this._inChildrenEncodingContext = this._component._inChildrenEncodingContext;
            this._setupChildrenEncodingCaller = this._component._setupChildrenEncodingCaller;
            this._tearDownChildrenEncodingCaller = this._component._tearDownChildrenEncodingCaller;
            this._setupChildrenVisitingCaller = this._component._setupChildrenVisitingCaller;
            this._tearDownChildrenVisitingCaller = this._component._tearDownChildrenVisitingCaller;
            this._component._inChildrenVisitingContext = false;
            this._component._inChildrenEncodingContext = false;
            this._component._setupChildrenEncodingCaller = null;
            this._component._tearDownChildrenEncodingCaller = null;
            this._component._setupChildrenVisitingCaller = null;
            this._component._tearDownChildrenVisitingCaller = null;
        }

        public String toString() {
            return String.format("VisitChildrenDebugContextChange(component: %s, id: %s)", new Object[]{this._component, this._component == null ? null : (this._component.getParent() == null ? this._component.getId() : this._component.getClientId())});
        }
    }

    private static class VisitDebugContextChange
    extends ComponentContextChange {
        private final UIXComponent _component;
        private boolean _inVisitingContext;
        private boolean _inEncodingContext;
        private String _setupVisitingCaller;
        private String _tearDownVisitingCaller;
        private String _setupEncodingCaller;
        private String _tearDownEncodingCaller;

        private VisitDebugContextChange(UIXComponent component) {
            this._component = component;
        }

        @Override
        public void resume(FacesContext facesContext) {
            this._component._inVisitingContext = this._inVisitingContext;
            this._component._inEncodingContext = this._inEncodingContext;
            this._component._setupVisitingCaller = this._setupVisitingCaller;
            this._component._tearDownVisitingCaller = this._tearDownVisitingCaller;
            this._component._setupEncodingCaller = this._setupEncodingCaller;
            this._component._tearDownEncodingCaller = this._tearDownEncodingCaller;
        }

        @Override
        public void suspend(FacesContext facesContext) {
            this._inVisitingContext = this._component._inVisitingContext;
            this._inEncodingContext = this._component._inEncodingContext;
            this._setupVisitingCaller = this._component._setupVisitingCaller;
            this._tearDownVisitingCaller = this._component._tearDownVisitingCaller;
            this._setupEncodingCaller = this._component._setupEncodingCaller;
            this._tearDownEncodingCaller = this._component._tearDownEncodingCaller;
            this._component._inVisitingContext = false;
            this._component._inEncodingContext = false;
            this._component._setupVisitingCaller = null;
            this._component._tearDownVisitingCaller = null;
            this._component._setupEncodingCaller = null;
            this._component._tearDownEncodingCaller = null;
        }

        public String toString() {
            return String.format("VisitDebugContextChange(component: %s, id: %s)", new Object[]{this._component, this._component == null ? null : (this._component.getParent() == null ? this._component.getId() : this._component.getClientId())});
        }
    }
}

