/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.event;

import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.FacesBeanImpl;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

public class SetActionListener
implements ActionListener,
StateHolder {
    private Bean _bean = new Bean();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SetActionListener.class);

    public void processAction(ActionEvent event) {
        ValueExpression to = this._bean.getValueExpression(Bean.TO_KEY);
        if (to != null) {
            Object from = this.getFrom();
            try {
                to.setValue(FacesContext.getCurrentInstance().getELContext(), from);
            }
            catch (RuntimeException e) {
                if (_LOG.isWarning()) {
                    ValueExpression fromExpression = this._bean.getValueExpression(Bean.FROM_KEY);
                    String mes = "Error setting:'" + to.getExpressionString() + "' to value:" + from;
                    if (fromExpression != null) {
                        mes = mes + " from:'" + fromExpression.getExpressionString() + "'";
                    }
                    _LOG.warning(mes, e);
                }
                throw e;
            }
        }
    }

    public ValueExpression getValueExpression(String name) {
        PropertyKey key = Bean.TYPE.findKey(name);
        if (key == null) {
            return null;
        }
        return this._bean.getValueExpression(key);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        PropertyKey key = Bean.TYPE.findKey(name);
        if (key == null) {
            throw new IllegalArgumentException();
        }
        this._bean.setValueExpression(key, binding);
    }

    public Object getFrom() {
        return this._bean.getProperty(Bean.FROM_KEY);
    }

    public void setFrom(Object from) {
        this._bean.setProperty(Bean.FROM_KEY, from);
    }

    public Object saveState(FacesContext context) {
        return this._bean.saveState(context);
    }

    public void restoreState(FacesContext context, Object state) {
        this._bean.restoreState(context, state);
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean newTransientValue) {
        throw new UnsupportedOperationException();
    }

    private static class Bean
    extends FacesBeanImpl {
        public static final FacesBean.Type TYPE = new FacesBean.Type();
        public static final PropertyKey FROM_KEY = TYPE.registerKey("from");
        public static final PropertyKey TO_KEY = TYPE.registerKey("to");

        private Bean() {
        }

        @Override
        public FacesBean.Type getType() {
            return TYPE;
        }

        static {
            TYPE.lock();
        }
    }
}

