/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.faces.context.ExternalContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import org.apache.myfaces.trinidad.config.Configurator;
import org.apache.myfaces.trinidad.context.ExternalContextDecorator;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.context.RequestContextFactory;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.SkinFactory;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidad.util.ExternalContextUtils;
import org.apache.myfaces.trinidadinternal.config.ThreadLocalResetter;
import org.apache.myfaces.trinidadinternal.context.RequestContextFactoryImpl;
import org.apache.myfaces.trinidadinternal.context.external.ServletCookieMap;
import org.apache.myfaces.trinidadinternal.context.external.ServletRequestHeaderMap;
import org.apache.myfaces.trinidadinternal.context.external.ServletRequestHeaderValuesMap;
import org.apache.myfaces.trinidadinternal.context.external.ServletRequestMap;
import org.apache.myfaces.trinidadinternal.context.external.ServletRequestParameterMap;
import org.apache.myfaces.trinidadinternal.context.external.ServletRequestParameterValuesMap;
import org.apache.myfaces.trinidadinternal.skin.SkinFactoryImpl;
import org.apache.myfaces.trinidadinternal.skin.SkinUtils;

public final class GlobalConfiguratorImpl
extends Configurator {
    private static volatile boolean _sSetRequestBugTested = false;
    private static boolean _sHasSetRequestBug = false;
    private boolean _initialized;
    private List<Configurator> _services;
    private static final Map<ClassLoader, GlobalConfiguratorImpl> _CONFIGURATORS = new HashMap<ClassLoader, GlobalConfiguratorImpl>();
    private static final String _IN_REQUEST = GlobalConfiguratorImpl.class.getName() + ".IN_REQUEST";
    private static final String _REQUEST_CONTEXT = GlobalConfiguratorImpl.class.getName() + ".REQUEST_CONTEXT";
    private AtomicReference<ThreadLocalResetter> _threadResetter = new AtomicReference();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(GlobalConfiguratorImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final GlobalConfiguratorImpl getInstance() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            Map<ClassLoader, GlobalConfiguratorImpl> map = _CONFIGURATORS;
            synchronized (map) {
                GlobalConfiguratorImpl config = _CONFIGURATORS.get(loader);
                if (config == null) {
                    try {
                        config = new GlobalConfiguratorImpl();
                        _CONFIGURATORS.put(loader, config);
                    }
                    catch (RuntimeException e) {
                        _LOG.severe((Throwable)e);
                        throw e;
                    }
                    _LOG.fine("GlobalConfigurator has been created.");
                }
                return config;
            }
        }
        _LOG.severe("CANNOT_FIND_CONTEXT_CLASS_LOADER");
        return null;
    }

    public static boolean isRequestStarted(ExternalContext ec) {
        return RequestType.getType(ec) != null;
    }

    private static final boolean _isDisabled(ExternalContext ec) {
        Boolean inRequest = (Boolean)ec.getRequestMap().get(_IN_REQUEST);
        if (inRequest == null) {
            return GlobalConfiguratorImpl.isConfiguratorServiceDisabled((ExternalContext)ec);
        }
        boolean disabled = inRequest;
        if (disabled != GlobalConfiguratorImpl.isConfiguratorServiceDisabled((ExternalContext)ec)) {
            _LOG.warning("Configurator services were disabled after beginRequest was executed.  Cannot disable configurator services");
        }
        return disabled;
    }

    private GlobalConfiguratorImpl() {
    }

    public void beginRequest(ExternalContext externalContext) {
        assert (externalContext != null);
        if (RequestType.getType(externalContext) == null) {
            RequestType.setType(externalContext);
            if (!GlobalConfiguratorImpl._isDisabled(externalContext)) {
                if (!this._initialized) {
                    this.init(externalContext);
                }
                this._attachRequestContext(externalContext);
                if (externalContext.getRequestMap().get(_IN_REQUEST) == null) {
                    this._startConfiguratorServiceRequest(externalContext);
                }
            } else {
                _LOG.fine("GlobalConfigurator: Configurators have been disabled for this request.");
            }
        } else {
            if (!RequestType.isCorrectType(externalContext)) {
                throw new IllegalStateException("The previous action request was not ended.");
            }
            _LOG.fine("BeginRequest called multiple times for this request");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this._initialized) {
            try {
                for (Configurator config : this._services) {
                    try {
                        config.destroy();
                    }
                    catch (Throwable t) {
                        _LOG.severe(t);
                    }
                }
                this._services = null;
                this._initialized = false;
            }
            finally {
                this._releaseManagedThreadLocals();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endRequest(ExternalContext externalContext) {
        if (RequestType.getType(externalContext) != null) {
            if (!GlobalConfiguratorImpl._isDisabled(externalContext)) {
                try {
                    RequestType type = RequestType.getType(externalContext);
                    if (type != RequestType.PORTAL_ACTION) {
                        this._endConfiguratorServiceRequest(externalContext);
                    }
                }
                finally {
                    this._releaseRequestContext(externalContext);
                    this._releaseManagedThreadLocals();
                }
            }
            RequestType.clearType(externalContext);
        }
    }

    public ExternalContext getExternalContext(ExternalContext externalContext) {
        if (RequestType.getType(externalContext) == null) {
            this.beginRequest((ExternalContext)externalContext);
        }
        if (!GlobalConfiguratorImpl._isDisabled(externalContext)) {
            if (!ExternalContextUtils.isPortlet((ExternalContext)externalContext) && GlobalConfiguratorImpl._isSetRequestBugPresent(externalContext)) {
                externalContext = new ClearRequestExternalContext((ExternalContext)externalContext);
            }
            for (Configurator config : this._services) {
                externalContext = config.getExternalContext(externalContext);
            }
        }
        return externalContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ExternalContext externalContext) {
        assert (externalContext != null);
        if (!this._initialized) {
            try {
                this._services = ClassLoaderUtils.getServices((String)Configurator.class.getName());
                if (RequestContextFactory.getFactory() == null) {
                    RequestContextFactory.setFactory((RequestContextFactory)new RequestContextFactoryImpl());
                }
                if (SkinFactory.getFactory() == null) {
                    SkinFactory.setFactory((SkinFactory)new SkinFactoryImpl());
                }
                SkinUtils.registerBaseSkins();
                for (Configurator config : this._services) {
                    config.init(externalContext);
                }
                SkinUtils.registerSkinExtensions(externalContext);
                this._initialized = true;
            }
            finally {
                this._releaseManagedThreadLocals();
            }
        } else {
            _LOG.warning("CONFIGURATOR_SERVICES_INITIALIZED");
        }
    }

    void __setThreadLocalResetter(ThreadLocalResetter resetter) {
        if (resetter == null) {
            throw new NullPointerException();
        }
        this._threadResetter.set(resetter);
    }

    private void _attachRequestContext(ExternalContext externalContext) {
        Object cachedRequestContext;
        RequestContext context = RequestContext.getCurrentInstance();
        if (context != null) {
            if (_LOG.isWarning()) {
                _LOG.warning("REQUESTCONTEXT_NOT_PROPERLY_RELEASED");
            }
            context.release();
            this._releaseManagedThreadLocals();
        }
        if ((cachedRequestContext = externalContext.getRequestMap().get(_REQUEST_CONTEXT)) instanceof RequestContext) {
            context = (RequestContext)cachedRequestContext;
            context.attach();
        } else {
            RequestContextFactory factory = RequestContextFactory.getFactory();
            assert (factory != null);
            context = factory.createContext(externalContext);
            externalContext.getRequestMap().put(_REQUEST_CONTEXT, context);
        }
        assert (RequestContext.getCurrentInstance() == context);
    }

    private void _releaseRequestContext(ExternalContext ec) {
        RequestContext context;
        if (RequestType.getType(ec) != RequestType.PORTAL_ACTION) {
            ec.getRequestMap().remove(_REQUEST_CONTEXT);
        }
        if ((context = RequestContext.getCurrentInstance()) != null) {
            context.release();
            assert (RequestContext.getCurrentInstance() == null);
        }
    }

    private void _releaseManagedThreadLocals() {
        ThreadLocalResetter resetter = this._threadResetter.get();
        if (resetter != null) {
            resetter.__removeThreadLocals();
        }
    }

    private void _endConfiguratorServiceRequest(ExternalContext ec) {
        ec.getRequestMap().remove(_IN_REQUEST);
        if (this._services != null) {
            for (Configurator config : this._services) {
                config.endRequest(ec);
            }
        }
    }

    private void _startConfiguratorServiceRequest(ExternalContext ec) {
        boolean disabled = GlobalConfiguratorImpl.isConfiguratorServiceDisabled((ExternalContext)ec);
        ec.getRequestMap().put(_IN_REQUEST, disabled);
        for (Configurator config : this._services) {
            config.beginRequest(ec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean _isSetRequestBugPresent(ExternalContext ec) {
        if (_sSetRequestBugTested) return _sHasSetRequestBug;
        Class<GlobalConfiguratorImpl> clazz = GlobalConfiguratorImpl.class;
        synchronized (GlobalConfiguratorImpl.class) {
            if (_sSetRequestBugTested) return _sHasSetRequestBug;
            ServletRequest orig = (ServletRequest)ec.getRequest();
            ec.getInitParameterMap();
            ec.setRequest((Object)new TestRequest(orig));
            _sHasSetRequestBug = !TestRequest.isTestParamPresent(ec);
            _sSetRequestBugTested = true;
            ec.setRequest((Object)orig);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _sHasSetRequestBug;
        }
    }

    private static class TestRequest
    extends ServletRequestWrapper {
        private static String _TEST_PARAM = TestRequest.class.getName() + ".TEST_PARAM";

        public TestRequest(ServletRequest request) {
            super(request);
        }

        public String getParameter(String string) {
            if (_TEST_PARAM.equals(string)) {
                return "passed";
            }
            return super.getParameter(string);
        }

        public static final boolean isTestParamPresent(ExternalContext ec) {
            return ec.getRequestParameterMap().get(_TEST_PARAM) != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RequestType {
        PORTAL_ACTION,
        PORTAL_RENDER,
        SERVLET;

        private static final String _REQUEST_TYPE;

        public static void clearType(ExternalContext ec) {
            ec.getRequestMap().remove(_REQUEST_TYPE);
        }

        public static RequestType getType(ExternalContext ec) {
            return (RequestType)((Object)ec.getRequestMap().get(_REQUEST_TYPE));
        }

        public static boolean isCorrectType(ExternalContext ec) {
            return RequestType._findType(ec) == RequestType.getType(ec);
        }

        public static void setType(ExternalContext ec) {
            ec.getRequestMap().put(_REQUEST_TYPE, RequestType._findType(ec));
        }

        private static final RequestType _findType(ExternalContext ec) {
            if (ExternalContextUtils.isPortlet((ExternalContext)ec)) {
                if (ExternalContextUtils.isAction((ExternalContext)ec)) {
                    return PORTAL_ACTION;
                }
                return PORTAL_RENDER;
            }
            return SERVLET;
        }

        static {
            _REQUEST_TYPE = GlobalConfiguratorImpl.class.getName() + ".REQUEST_TYPE";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClearRequestExternalContext
    extends ExternalContextDecorator {
        private ExternalContext _ec;
        private Map<String, Object> _requestCookieMap;
        private Map<String, String> _requestHeaderMap;
        private Map<String, String[]> _requestHeaderValuesMap;
        private Map<String, Object> _requestMap;
        private Map<String, String> _requestParameterMap;
        private Map<String, String[]> _requestParameterValuesMap;

        public ClearRequestExternalContext(ExternalContext ec) {
            this._ec = ec;
        }

        protected ExternalContext getExternalContext() {
            return this._ec;
        }

        public void setRequest(Object request) {
            super.setRequest(request);
            this._requestCookieMap = null;
            this._requestHeaderMap = null;
            this._requestHeaderValuesMap = null;
            this._requestMap = null;
            this._requestParameterMap = null;
            this._requestParameterValuesMap = null;
        }

        public Map<String, Object> getRequestCookieMap() {
            this._checkRequest();
            if (this._requestCookieMap == null) {
                this._requestCookieMap = new ServletCookieMap(this._getHttpServletRequest());
            }
            return this._requestCookieMap;
        }

        public Map<String, String> getRequestHeaderMap() {
            if (this._requestHeaderMap == null) {
                this._requestHeaderMap = new ServletRequestHeaderMap(this._getHttpServletRequest());
            }
            return this._requestHeaderMap;
        }

        public Map<String, String[]> getRequestHeaderValuesMap() {
            if (this._requestHeaderValuesMap == null) {
                this._requestHeaderValuesMap = new ServletRequestHeaderValuesMap(this._getHttpServletRequest());
            }
            return this._requestHeaderValuesMap;
        }

        public Map<String, Object> getRequestMap() {
            this._checkRequest();
            if (this._requestMap == null) {
                this._requestMap = new ServletRequestMap((ServletRequest)this.getRequest());
            }
            return this._requestMap;
        }

        public Map<String, String> getRequestParameterMap() {
            this._checkRequest();
            if (this._requestParameterMap == null) {
                this._requestParameterMap = new ServletRequestParameterMap((ServletRequest)this.getRequest());
            }
            return this._requestParameterMap;
        }

        public Map<String, String[]> getRequestParameterValuesMap() {
            this._checkRequest();
            if (this._requestParameterValuesMap == null) {
                this._requestParameterValuesMap = new ServletRequestParameterValuesMap((ServletRequest)this.getRequest());
            }
            return this._requestParameterValuesMap;
        }

        private void _checkRequest() {
            if (super.getRequest() == null) {
                throw new UnsupportedOperationException("Request is null on this context.");
            }
        }

        private HttpServletRequest _getHttpServletRequest() {
            this._checkRequest();
            if (!(this.getRequest() instanceof HttpServletRequest)) {
                throw new IllegalArgumentException("Only HttpServletRequest supported");
            }
            return (HttpServletRequest)this.getRequest();
        }
    }
}

