/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config.upload;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.portlet.faces.annotation.ExcludeFromManagedRequestScope;
import javax.servlet.http.HttpServletRequest;
import org.apache.myfaces.trinidad.config.Configurator;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.UploadedFile;
import org.apache.myfaces.trinidad.util.ExternalContextUtils;
import org.apache.myfaces.trinidadinternal.config.upload.ActionUploadRequestWrapper;
import org.apache.myfaces.trinidadinternal.config.upload.UploadRequestWrapper;
import org.apache.myfaces.trinidadinternal.config.upload.UploadedFiles;
import org.apache.myfaces.trinidadinternal.share.util.MultipartFormHandler;
import org.apache.myfaces.trinidadinternal.share.util.MultipartFormItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUploadConfiguratorImpl
extends Configurator {
    private static final String _APPLIED = FileUploadConfiguratorImpl.class.getName() + ".APPLIED";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(FileUploadConfiguratorImpl.class);
    private static final String _PARAMS = FileUploadConfiguratorImpl.class.getName() + ".PARAMS";
    private long _maxAllowedBytes = 0x8000000L;

    public static Map<String, String[]> getAddedParameters(ExternalContext externalContext) {
        Map map = (Map)externalContext.getRequestMap().get(_PARAMS);
        return map;
    }

    public static boolean isApplied(ExternalContext context) {
        return context.getRequestMap().get(_APPLIED) != null;
    }

    public static void apply(ExternalContext context) {
        context.getRequestMap().put(_APPLIED, AppliedClass.APPLIED);
    }

    public void beginRequest(ExternalContext externalContext) {
        block6: {
            if (MultipartFormHandler.isMultipartRequest(externalContext) && (externalContext.getRequest() instanceof HttpServletRequest || ExternalContextUtils.isPortlet((ExternalContext)externalContext))) {
                try {
                    MultipartFormItem item;
                    MultipartFormHandler mfh = new MultipartFormHandler(externalContext);
                    mfh.setMaximumAllowedBytes(this._maxAllowedBytes);
                    mfh.setCharacterEncoding(ExternalContextUtils.getCharacterEncoding((ExternalContext)externalContext));
                    HashMap<String, String[]> parameters = new HashMap<String, String[]>();
                    UploadedFiles files = new UploadedFiles(externalContext);
                    while ((item = mfh.getNextPart()) != null) {
                        String name = item.getName();
                        String value = null;
                        if (item.getFilename() == null) {
                            value = item.getValue();
                            Object oldValue = parameters.get(name);
                            if (oldValue == null) {
                                parameters.put(name, new String[]{value});
                                continue;
                            }
                            String[] oldArray = (String[])oldValue;
                            String[] newArray = new String[oldArray.length + 1];
                            System.arraycopy(oldArray, 0, newArray, 1, oldArray.length);
                            newArray[0] = value;
                            parameters.put(name, newArray);
                            continue;
                        }
                        if (item.getFilename().length() <= 0) continue;
                        this._doUploadFile(RequestContext.getCurrentInstance(), externalContext, files, item);
                    }
                    externalContext.getRequestMap().put(_PARAMS, parameters);
                }
                catch (Throwable t) {
                    if (!_LOG.isSevere()) break block6;
                    _LOG.severe(t);
                }
            }
        }
    }

    public ExternalContext getExternalContext(ExternalContext externalContext) {
        Map<String, String[]> addedParams = FileUploadConfiguratorImpl.getAddedParameters(externalContext);
        if (addedParams != null) {
            return FileUploadConfiguratorImpl._getExternalContextWrapper(externalContext, addedParams);
        }
        return externalContext;
    }

    public void endRequest(ExternalContext externalContext) {
        UploadedFiles files;
        if (!ExternalContextUtils.isPortlet((ExternalContext)externalContext) && (files = UploadedFiles.getUploadedFiles(externalContext)) != null) {
            files.dispose();
        }
    }

    public void init(ExternalContext externalContext) {
        super.init(externalContext);
    }

    private void _doUploadFile(RequestContext context, ExternalContext externalContext, UploadedFiles files, MultipartFormItem item) throws IOException {
        TempUploadedFile temp = new TempUploadedFile(item);
        UploadedFile file = context.getUploadedFileProcessor().processFile(externalContext.getRequest(), (UploadedFile)temp);
        if (file != null) {
            files.__put(item.getName(), file);
            if (_LOG.isFine()) {
                _LOG.fine("Uploaded file " + file.getFilename() + "(" + file.getLength() + " bytes) for ID " + item.getName());
            }
        }
    }

    private static ExternalContext _getExternalContextWrapper(ExternalContext externalContext, Map<String, String[]> addedParams) {
        if (!FileUploadConfiguratorImpl.isApplied(externalContext)) {
            if (!ExternalContextUtils.isPortlet((ExternalContext)externalContext)) {
                externalContext.setRequest((Object)new UploadRequestWrapper((HttpServletRequest)externalContext.getRequest(), addedParams));
            } else if (ExternalContextUtils.isAction((ExternalContext)externalContext)) {
                externalContext.setRequest((Object)new ActionUploadRequestWrapper(externalContext, addedParams));
            }
            FileUploadConfiguratorImpl.apply(externalContext);
        }
        return externalContext;
    }

    private static class TempUploadedFile
    implements UploadedFile {
        private MultipartFormItem _item;

        public TempUploadedFile(MultipartFormItem item) {
            this._item = item;
            assert (item.getValue() == null);
        }

        public String getFilename() {
            return this._item.getFilename();
        }

        public String getContentType() {
            return this._item.getContentType();
        }

        public long getLength() {
            return -1L;
        }

        public Object getOpaqueData() {
            return null;
        }

        public InputStream getInputStream() throws IOException {
            return this._item.getInputStream();
        }

        public void dispose() {
            throw new UnsupportedOperationException();
        }
    }

    @ExcludeFromManagedRequestScope
    private static class AppliedClass {
        public static final AppliedClass APPLIED = new AppliedClass();

        private AppliedClass() {
        }
    }
}

