/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.menu;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.faces.context.FacesContext;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.ChildPropertyTreeModel;
import org.apache.myfaces.trinidad.model.TreeModel;
import org.apache.myfaces.trinidad.model.XMLMenuModel;
import org.apache.myfaces.trinidadinternal.menu.GroupNode;
import org.apache.myfaces.trinidadinternal.menu.ItemNode;
import org.apache.myfaces.trinidadinternal.menu.MenuNode;
import org.apache.myfaces.trinidadinternal.menu.MenuUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuContentHandlerImpl
extends DefaultHandler
implements XMLMenuModel.MenuContentHandler {
    private List<List<MenuNode>> _menuNodes;
    private List<MenuNode> _menuList;
    private String _currentTreeModelMapKey;
    private int _nodeDepth;
    private int _skipDepth = -1;
    private String _currentNodeStyle;
    private String _handlerId;
    private String _resBundleKey;
    private String _resBundleName;
    private Map<String, String> _attrMap;
    private Map<String, TreeModel> _treeModelMap = new HashMap<String, TreeModel>();
    private Map<Object, Map<String, List<Object>>> _viewIdFocusPathMapMap = new HashMap<Object, Map<String, List<Object>>>();
    private Map<Object, Map<String, Object>> _idNodeMapMap;
    private Map<Object, Map<Object, List<Object>>> _nodeFocusPathMapMap = new HashMap<Object, Map<Object, List<Object>>>();
    private Stack<Object> _saveDataStack;
    private Map<String, List<Object>> _viewIdFocusPathMap;
    private Map<Object, List<Object>> _nodeFocusPathMap;
    private Map<String, Object> _idNodeMap;
    private String _localModelId = null;
    private String _rootModelKey = null;
    private static final String _GROUP_NODE = "groupNode";
    private static final String _ITEM_NODE = "itemNode";
    private static final String _SHARED_NODE = "sharedNode";
    private static final String _ROOT_NODE = "menu";
    private static final String _LABEL_ATTR = "label";
    private static final String _RENDERED_ATTR = "rendered";
    private static final String _ID_ATTR = "id";
    private static final String _IDREF_ATTR = "idref";
    private static final String _ICON_ATTR = "icon";
    private static final String _DISABLED_ATTR = "disabled";
    private static final String _DESTINATION_ATTR = "destination";
    private static final String _ACTION_ATTR = "action";
    private static final String _REF_ATTR = "ref";
    private static final String _READONLY_ATTR = "readOnly";
    private static final String _VAR_ATTR = "var";
    private static final String _RES_BUNDLE_ATTR = "resourceBundle";
    private static final String _FOCUS_VIEWID_ATTR = "focusViewId";
    private static final String _ACCESSKEY_ATTR = "accessKey";
    private static final String _LABEL_AND_ACCESSKEY_ATTR = "labelAndAccessKey";
    private static final String _TARGETFRAME_ATTR = "targetframe";
    private static final String _ACTIONLISTENER_ATTR = "actionListener";
    private static final String _LAUNCHLISTENER_ATTR = "launchListener";
    private static final String _RETURNLISTENER_ATTR = "returnListener";
    private static final String _IMMEDIATE_ATTR = "immediate";
    private static final String _USEWINDOW_ATTR = "useWindow";
    private static final String _WINDOWHEIGHT_ATTR = "windowHeight";
    private static final String _WINDOWWIDTH_ATTR = "windowWidth";
    private static final String _DEFAULT_FOCUS_PATH_ATTR = "defaultFocusPath";
    private static final String _VISIBLE_ATTR = "visible";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(MenuContentHandlerImpl.class);

    public MenuContentHandlerImpl() {
        this._idNodeMapMap = new HashMap<Object, Map<String, Object>>();
    }

    @Override
    public void startDocument() {
        this._nodeDepth = 0;
        this._menuNodes = new ArrayList<List<MenuNode>>();
        this._menuList = null;
        this._handlerId = Integer.toString(System.identityHashCode(this._menuNodes));
    }

    @Override
    public void startElement(String nameSpaceUri, String localElemName, String qualifiedElemName, Attributes attrList) throws SAXException {
        super.startElement(nameSpaceUri, localElemName, qualifiedElemName, attrList);
        if (_ROOT_NODE.equals(qualifiedElemName)) {
            String resBundle = attrList.getValue(_RES_BUNDLE_ATTR);
            String resBundleKey = attrList.getValue(_VAR_ATTR);
            if (resBundle != null && !"".equals(resBundle) && resBundleKey != null && !"".equals(resBundleKey)) {
                MenuUtils.loadBundle(resBundle, resBundleKey + this.getHandlerId());
                this._resBundleKey = resBundleKey;
                this._resBundleName = resBundle;
            }
        } else {
            boolean isNonSharedNode;
            boolean bl = isNonSharedNode = _ITEM_NODE.equals(qualifiedElemName) || _GROUP_NODE.equals(qualifiedElemName);
            if (isNonSharedNode) {
                this._currentNodeStyle = _ITEM_NODE.equals(qualifiedElemName) ? "item" : "group";
                ++this._nodeDepth;
                if (this._skipDepth >= 0 && this._nodeDepth > this._skipDepth) {
                    return;
                }
                if (this._menuNodes.size() < this._nodeDepth) {
                    this._menuNodes.add(new ArrayList());
                }
                this._attrMap = this._getMapFromList(attrList);
                MenuNode menuNode = this._createMenuNode();
                if (menuNode == null) {
                    this._skipDepth = this._nodeDepth;
                } else {
                    if (this._resBundleName != null && !"".equals(this._resBundleName) && this._resBundleKey != null && !"".equals(this._resBundleKey)) {
                        menuNode.setResBundleKey(this._resBundleKey);
                        menuNode.setResBundleName(this._resBundleName);
                    }
                    menuNode.setHandlerId(this.getHandlerId());
                    menuNode.setRootModelKey(this.getRootModelKey());
                    menuNode.setModelId(this.getModelId());
                    List<MenuNode> list = this._menuNodes.get(this._nodeDepth - 1);
                    list.add(menuNode);
                }
            } else if (_SHARED_NODE.equals(qualifiedElemName)) {
                ++this._nodeDepth;
                String expr = attrList.getValue(_REF_ATTR);
                this._saveModelData();
                XMLMenuModel menuModel = (XMLMenuModel)MenuUtils.getBoundValue(expr, Object.class);
                this._restoreModelData();
                String modelStr = expr.substring(expr.indexOf(123) + 1, expr.indexOf(125));
                if (menuModel != null) {
                    Object subMenuObj = menuModel.getWrappedData();
                    List subMenuList = null;
                    if (subMenuObj instanceof ChildPropertyTreeModel) {
                        subMenuList = (List)((ChildPropertyTreeModel)subMenuObj).getWrappedData();
                    }
                    if (subMenuList != null) {
                        if (this._menuNodes.size() < this._nodeDepth) {
                            this._menuNodes.add(new ArrayList());
                        }
                        List<MenuNode> list = this._menuNodes.get(this._nodeDepth - 1);
                        list.addAll(subMenuList);
                    } else {
                        SAXException npe = new SAXException("Shared Node Model not created for " + modelStr);
                    }
                } else {
                    NullPointerException npe = new NullPointerException("Shared Node Model not created for " + modelStr + ". Check for the existence of the corresponding " + "managed bean in your config files.");
                    _LOG.severe(npe.getMessage(), (Throwable)npe);
                }
            } else {
                throw new SAXException("Invalid Node type: " + localElemName);
            }
        }
    }

    @Override
    public void endElement(String nameSpaceUri, String localElemName, String qualifiedElemName) {
        if (_ITEM_NODE.equals(qualifiedElemName) || _GROUP_NODE.equals(qualifiedElemName)) {
            --this._nodeDepth;
            if (this._skipDepth >= 0) {
                if (this._nodeDepth < this._skipDepth) {
                    this._skipDepth = -1;
                }
            } else {
                if (this._nodeDepth > 0) {
                    List<MenuNode> parentList = this._menuNodes.get(this._nodeDepth - 1);
                    MenuNode parentNode = parentList.get(parentList.size() - 1);
                    parentNode.setChildren(this._menuNodes.get(this._nodeDepth));
                }
                if (this._nodeDepth == this._menuNodes.size() - 2) {
                    this._menuNodes.remove(this._nodeDepth + 1);
                }
            }
        } else if (_SHARED_NODE.equals(qualifiedElemName)) {
            --this._nodeDepth;
            if (this._nodeDepth > 0 && this._menuNodes.size() > this._nodeDepth) {
                List<MenuNode> parentList = this._menuNodes.get(this._nodeDepth - 1);
                MenuNode parentNode = parentList.get(parentList.size() - 1);
                parentNode.setChildren(this._menuNodes.get(this._nodeDepth));
            }
        }
    }

    @Override
    public void endDocument() {
        if (this._menuNodes.isEmpty()) {
            _LOG.warning("CREATE_TREE_WARNING: Empty Tree!");
            ChildPropertyTreeModel treeModel = new ChildPropertyTreeModel();
            this._treeModelMap.put(this._currentTreeModelMapKey, (TreeModel)treeModel);
        } else {
            this._menuList = this._menuNodes.get(0);
            ChildPropertyTreeModel treeModel = new ChildPropertyTreeModel(this._menuList, "children");
            this._treeModelMap.put(this._currentTreeModelMapKey, (TreeModel)treeModel);
            XMLMenuModel rootModel = this.getRootModel();
            if (rootModel == this.getModel()) {
                this._viewIdFocusPathMap = new HashMap<String, List<Object>>();
                this._nodeFocusPathMap = new HashMap<Object, List<Object>>();
                this._idNodeMap = new HashMap<String, Object>();
                Object oldPath = treeModel.getRowKey();
                treeModel.setRowKey(null);
                this._addToMaps((TreeModel)treeModel, this._viewIdFocusPathMap, this._nodeFocusPathMap, this._idNodeMap);
                this._viewIdFocusPathMapMap.put(this._currentTreeModelMapKey, this._viewIdFocusPathMap);
                this._nodeFocusPathMapMap.put(this._currentTreeModelMapKey, this._nodeFocusPathMap);
                this._idNodeMapMap.put(this._currentTreeModelMapKey, this._idNodeMap);
                treeModel.setRowKey(oldPath);
            }
        }
    }

    public Map<String, List<Object>> getViewIdFocusPathMap(Object modelKey) {
        return this._viewIdFocusPathMapMap.get(modelKey);
    }

    public Map<Object, List<Object>> getNodeFocusPathMap(Object modelKey) {
        return this._nodeFocusPathMapMap.get(modelKey);
    }

    public Map<String, Object> getIdNodeMap(Object modelKey) {
        return this._idNodeMapMap.get(modelKey);
    }

    public TreeModel getTreeModel(String uri) {
        TreeModel model = this._treeModelMap.get(uri);
        if (model != null) {
            return model;
        }
        this._currentTreeModelMapKey = uri;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            InputStream inStream = this.getModel().getStream(uri);
            parser.parse(inStream, (DefaultHandler)this);
            inStream.close();
        }
        catch (SAXException saxex) {
            _LOG.severe("SAX Parse Exception parsing " + uri + ": " + saxex.getMessage(), (Throwable)saxex);
        }
        catch (IOException ioe) {
            _LOG.severe("Unable to open an InputStream to " + uri, (Throwable)ioe);
        }
        catch (IllegalArgumentException iae) {
            _LOG.severe("InputStream to " + iae + " is null", (Throwable)iae);
        }
        catch (ParserConfigurationException pce) {
            _LOG.severe("Unable to create SAX parser for " + uri, (Throwable)pce);
        }
        return this._treeModelMap.get(uri);
    }

    public XMLMenuModel getRootModel() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        XMLMenuModel model = (XMLMenuModel)requestMap.get(this.getRootModelKey());
        return model;
    }

    public String getRootModelKey() {
        return this._rootModelKey;
    }

    public void setRootModelKey(String rootModelKey) {
        this._rootModelKey = rootModelKey;
    }

    public XMLMenuModel getModel() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        return (XMLMenuModel)requestMap.get(this.getModelId());
    }

    public String getModelId() {
        return this._localModelId;
    }

    public void setModelId(String localModelId) {
        this._localModelId = localModelId;
    }

    public void setTreeModelKey(String uri) {
        this._currentTreeModelMapKey = uri;
    }

    String getHandlerId() {
        return this._handlerId;
    }

    String getBundleKey() {
        return this._resBundleKey;
    }

    private Map<String, String> _getMapFromList(Attributes attrList) {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        for (int i = 0; i < attrList.getLength(); ++i) {
            attrMap.put(attrList.getQName(i), attrList.getValue(i));
        }
        return attrMap;
    }

    private MenuNode _createMenuNode() {
        String renderedStr = this._getAndRemoveAttrValue(_RENDERED_ATTR);
        if (!(!"false".equals(renderedStr) || this.getRootModel().getCreateHiddenNodes() && this.getModel().getCreateHiddenNodes())) {
            return null;
        }
        String label = this._getAndRemoveAttrValue(_LABEL_ATTR);
        String icon = this._getAndRemoveAttrValue(_ICON_ATTR);
        String disabledStr = this._getAndRemoveAttrValue(_DISABLED_ATTR);
        String readOnlyStr = this._getAndRemoveAttrValue(_READONLY_ATTR);
        String accessKey = this._getAndRemoveAttrValue(_ACCESSKEY_ATTR);
        String labelAndAccessKey = this._getAndRemoveAttrValue(_LABEL_AND_ACCESSKEY_ATTR);
        String id = this._getAndRemoveAttrValue(_ID_ATTR);
        String visibleStr = this._getAndRemoveAttrValue(_VISIBLE_ATTR);
        MenuNode menuNode = this._currentNodeStyle == "item" ? this._createItemNode() : this._createGroupNode();
        menuNode.setLabel(label);
        menuNode.setIcon(icon);
        menuNode.setDisabled(disabledStr);
        menuNode.setRendered(renderedStr);
        menuNode.setReadOnly(readOnlyStr);
        menuNode.setAccessKey(accessKey);
        menuNode.setId(id);
        menuNode.setVisible(visibleStr);
        if (labelAndAccessKey != null) {
            menuNode.setLabelAndAccessKey(labelAndAccessKey);
        }
        return menuNode;
    }

    private ItemNode _createItemNode() {
        ItemNode itemNode = new ItemNode();
        String action = this._getAndRemoveAttrValue(_ACTION_ATTR);
        String actionListener = this._getAndRemoveAttrValue(_ACTIONLISTENER_ATTR);
        String launchListener = this._getAndRemoveAttrValue(_LAUNCHLISTENER_ATTR);
        String returnListener = this._getAndRemoveAttrValue(_RETURNLISTENER_ATTR);
        String immediate = this._getAndRemoveAttrValue(_IMMEDIATE_ATTR);
        String useWindow = this._getAndRemoveAttrValue(_USEWINDOW_ATTR);
        String windowHeight = this._getAndRemoveAttrValue(_WINDOWHEIGHT_ATTR);
        String windowWidth = this._getAndRemoveAttrValue(_WINDOWWIDTH_ATTR);
        String defaultFocusPathStr = this._getAndRemoveAttrValue(_DEFAULT_FOCUS_PATH_ATTR);
        String focusViewId = this._getAndRemoveAttrValue(_FOCUS_VIEWID_ATTR);
        String destination = this._getAndRemoveAttrValue(_DESTINATION_ATTR);
        String targetFrame = this._getAndRemoveAttrValue(_TARGETFRAME_ATTR);
        itemNode.setAction(action);
        itemNode.setActionListener(actionListener);
        itemNode.setLaunchListener(launchListener);
        itemNode.setReturnListener(returnListener);
        itemNode.setImmediate(immediate);
        itemNode.setUseWindow(useWindow);
        itemNode.setWindowHeight(windowHeight);
        itemNode.setWindowWidth(windowWidth);
        itemNode.setFocusViewId(focusViewId);
        itemNode.setDefaultFocusPath(defaultFocusPathStr);
        itemNode.setDestination(destination);
        itemNode.setTargetFrame(targetFrame);
        if (this._attrMap.size() > 0) {
            itemNode.setCustomPropList(this._attrMap);
        }
        return itemNode;
    }

    private GroupNode _createGroupNode() {
        GroupNode groupNode = new GroupNode();
        String idRef = this._getAndRemoveAttrValue(_IDREF_ATTR);
        groupNode.setIdRef(idRef);
        return groupNode;
    }

    private void _saveModelData() {
        if (this._saveDataStack == null) {
            this._saveDataStack = new Stack();
        }
        int nodeDepthSave = this._nodeDepth;
        ArrayList<List<MenuNode>> menuNodesSave = new ArrayList<List<MenuNode>>(this._menuNodes);
        ArrayList<MenuNode> menuListSave = this._menuList != null ? new ArrayList<MenuNode>(this._menuList) : null;
        String mapTreeKeySave = this._currentTreeModelMapKey;
        String localModelIdSave = this._localModelId;
        String handlerId = this._handlerId;
        String resBundleName = this._resBundleName;
        String resBundleKey = this._resBundleKey;
        this._saveDataStack.push(nodeDepthSave);
        this._saveDataStack.push(menuNodesSave);
        this._saveDataStack.push(menuListSave);
        this._saveDataStack.push(mapTreeKeySave);
        this._saveDataStack.push(localModelIdSave);
        this._saveDataStack.push(handlerId);
        this._saveDataStack.push(resBundleName);
        this._saveDataStack.push(resBundleKey);
    }

    private void _restoreModelData() {
        this._resBundleKey = (String)this._saveDataStack.pop();
        this._resBundleName = (String)this._saveDataStack.pop();
        this._handlerId = (String)this._saveDataStack.pop();
        this._localModelId = (String)this._saveDataStack.pop();
        this._currentTreeModelMapKey = (String)this._saveDataStack.pop();
        this._menuList = (ArrayList)this._saveDataStack.pop();
        this._menuNodes = (ArrayList)this._saveDataStack.pop();
        this._nodeDepth = (Integer)this._saveDataStack.pop();
    }

    private String _getAndRemoveAttrValue(String attrName) {
        String attrValue = this._attrMap.get(attrName);
        if (attrValue != null) {
            this._attrMap.remove(attrName);
        }
        return attrValue;
    }

    private void _addToMaps(TreeModel tree, Map viewIdFocusPathMap, Map nodeFocusPathMap, Map idNodeMap) {
        for (int i = 0; i < tree.getRowCount(); ++i) {
            String idProp;
            tree.setRowIndex(i);
            MenuNode node = (MenuNode)tree.getRowData();
            List focusPath = (List)tree.getRowKey();
            String viewIdObject = node.getFocusViewId();
            if (viewIdObject != null) {
                nodeFocusPathMap.put(node, focusPath);
                List<Object> existingFpArrayList = this._viewIdFocusPathMap.get(viewIdObject);
                if (existingFpArrayList == null) {
                    ArrayList<List> fpArrayList = new ArrayList<List>();
                    fpArrayList.add(focusPath);
                    viewIdFocusPathMap.put(viewIdObject, fpArrayList);
                } else {
                    boolean defFocusPath = node.getDefaultFocusPath();
                    if (defFocusPath) {
                        existingFpArrayList.add(0, focusPath);
                    } else {
                        existingFpArrayList.add(focusPath);
                    }
                }
            }
            if ((idProp = node.getUniqueId()) != null) {
                idNodeMap.put(idProp, node);
            }
            if (!tree.isContainer() || tree.isContainerEmpty()) continue;
            tree.enterContainer();
            this._addToMaps(tree, viewIdFocusPathMap, nodeFocusPathMap, idNodeMap);
            tree.exitContainer();
        }
    }
}

