/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.menu;

import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.model.XMLMenuModel;
import org.apache.myfaces.trinidad.util.ContainerUtils;
import org.apache.myfaces.trinidadinternal.menu.MenuUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuNode {
    private String _label = null;
    private String _icon = null;
    private List<MenuNode> _children = null;
    private String _focusViewId = null;
    private String _renderedStr = null;
    private String _disabledStr = null;
    private String _visibleStr = null;
    private String _readOnlyStr = null;
    private String _handlerId = null;
    private String _bundleKey = null;
    private String _bundleName = null;
    private String _accessKey = null;
    private String _id = null;
    private String _modelId = null;
    private boolean _labelAndAccessKeyEL = false;
    private String _labelAndAccessKey = null;
    private String _defaultFocusPathStr = null;
    private String _rootModelKey = null;

    public void setLabel(String label) {
        this._label = label;
    }

    public String getLabel() {
        if (this._bundleKey != null && this._bundleName != null) {
            MenuUtils.loadBundle(this._bundleName, this._bundleKey + this.getHandlerId());
        }
        if (this._label != null && ContainerUtils.isValueReference((String)this._label)) {
            return this._evalElStr(this._label);
        }
        return this._label;
    }

    public void setIcon(String icon) {
        this._icon = icon;
    }

    public String getIcon() {
        return MenuUtils.evalString(this._icon);
    }

    public void setRendered(boolean rendered) {
        this._renderedStr = rendered ? "true" : "false";
    }

    public boolean getRendered() {
        boolean rendered = MenuUtils.evalBoolean(this._renderedStr, true);
        return rendered;
    }

    public void setDisabled(boolean disabled) {
        this._disabledStr = disabled ? "true" : "false";
    }

    public boolean getDisabled() {
        boolean disabled = MenuUtils.evalBoolean(this._disabledStr, false);
        return disabled;
    }

    public void setVisible(boolean visible) {
        this._visibleStr = visible ? "true" : "false";
    }

    public boolean getVisible() {
        boolean visible = MenuUtils.evalBoolean(this._visibleStr, true);
        return visible;
    }

    public void setDefaultFocusPath(boolean defaultFocusPath) {
        this._defaultFocusPathStr = defaultFocusPath ? "true" : "false";
    }

    public boolean getDefaultFocusPath() {
        boolean defaultFocusPath = MenuUtils.evalBoolean(this._defaultFocusPathStr, false);
        return defaultFocusPath;
    }

    public List<MenuNode> getChildren() {
        return this._children;
    }

    public void setChildren(List<MenuNode> children) {
        this._children = children;
    }

    public boolean getReadOnly() {
        boolean readOnly = MenuUtils.evalBoolean(this._readOnlyStr, false);
        return readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this._readOnlyStr = readOnly ? "true" : "false";
    }

    public void setFocusViewId(String focusViewId) {
        this._focusViewId = focusViewId;
    }

    public String getFocusViewId() {
        return this._focusViewId;
    }

    public void setRendered(String renderedStr) {
        this._renderedStr = renderedStr;
    }

    public void setDisabled(String disabledStr) {
        this._disabledStr = disabledStr;
    }

    public void setReadOnly(String readOnlyStr) {
        this._readOnlyStr = readOnlyStr;
    }

    public void setVisible(String visibleStr) {
        this._visibleStr = visibleStr;
    }

    public void setDefaultFocusPath(String defaultFocusPathStr) {
        this._defaultFocusPathStr = defaultFocusPathStr;
    }

    public void setAccessKey(String accessKey) {
        if (accessKey != null && ContainerUtils.isValueReference((String)accessKey)) {
            this._accessKey = accessKey;
        } else {
            if (accessKey != null && accessKey.length() > 1) {
                return;
            }
            this._accessKey = accessKey;
        }
    }

    public void setAccessKey(char accessKey) {
        char[] charArray = new char[]{'\u0000'};
        charArray[0] = accessKey;
        this._accessKey = String.copyValueOf(charArray);
    }

    public char getAccessKey() {
        String accessKeyStr = MenuUtils.evalString(this._accessKey);
        if (accessKeyStr == null || accessKeyStr.length() > 1) {
            return '\u0000';
        }
        return accessKeyStr.charAt(0);
    }

    public void setLabelAndAccessKey(String labelAndAccessKey) {
        int ampIdx = 0;
        this._labelAndAccessKeyEL = false;
        if (labelAndAccessKey != null && ContainerUtils.isValueReference((String)labelAndAccessKey)) {
            this._labelAndAccessKey = labelAndAccessKey;
            this._labelAndAccessKeyEL = true;
            this._accessKey = null;
        } else if (labelAndAccessKey == null || (ampIdx = labelAndAccessKey.indexOf(38)) == -1) {
            this._label = labelAndAccessKey;
            this._accessKey = null;
        } else if (ampIdx == labelAndAccessKey.length() - 1) {
            this._label = labelAndAccessKey.substring(0, ampIdx);
            this._accessKey = null;
        } else {
            this._splitLabelAndAccessKey(labelAndAccessKey);
        }
    }

    public String getLabelAndAccessKey() {
        if (this._labelAndAccessKeyEL) {
            this._labelAndAccessKey = this._evalElStr(this._labelAndAccessKey);
            this.setLabelAndAccessKey(this._labelAndAccessKey);
            this._labelAndAccessKey = null;
            this._labelAndAccessKeyEL = false;
        }
        String label = this.getLabel();
        if (this._accessKey == null) {
            return label;
        }
        return this._joinLabelAndAccessKey(label, this._accessKey);
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public MenuNode getRefNode() {
        return this;
    }

    public String doAction() {
        return this.getRefNode().doAction();
    }

    public String getDestination() {
        return this.getRefNode().getDestination();
    }

    public String getRootModelKey() {
        return this._rootModelKey;
    }

    public void setRootModelKey(String rootModelKey) {
        this._rootModelKey = rootModelKey;
    }

    public String getModelId() {
        return this._modelId;
    }

    public void setModelId(String modelId) {
        this._modelId = modelId;
    }

    protected void setResBundleKey(String bundleKey) {
        this._bundleKey = bundleKey;
    }

    protected void setResBundleName(String bundleName) {
        this._bundleName = bundleName;
    }

    protected void setHandlerId(String handlerId) {
        this._handlerId = handlerId;
    }

    protected void postSelectedNode(MenuNode selectedNode) {
        this.getRootModel().setCurrentlyPostedNode((Object)selectedNode);
    }

    protected String getUniqueId() {
        return this._id + this._modelId;
    }

    protected String getHandlerId() {
        return this._handlerId;
    }

    protected XMLMenuModel getRootModel() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        XMLMenuModel model = (XMLMenuModel)requestMap.get(this.getRootModelKey());
        return model;
    }

    private String _joinLabelAndAccessKey(String label, String accessKey) {
        char[] keyArray = label.toCharArray();
        int len = label.length();
        int lentimes2 = len * 2;
        char[] keyArray2 = new char[lentimes2];
        int j = 0;
        boolean accessKeyFound = false;
        int i = 0;
        j = 0;
        while (i < len) {
            if (keyArray[i] == accessKey.charAt(0) && !accessKeyFound) {
                keyArray2[j] = 38;
                ++j;
                accessKeyFound = true;
            }
            keyArray2[j] = keyArray[i];
            if (keyArray[i] == '&') {
                keyArray2[++j] = keyArray[i];
            }
            ++i;
            ++j;
        }
        String combinedLabel = new String(keyArray2, 0, j);
        return combinedLabel;
    }

    private void _splitLabelAndAccessKey(String labelAndAccessKey) {
        String label;
        char[] keyArray = labelAndAccessKey.toCharArray();
        int len = labelAndAccessKey.length();
        char[] keyArray2 = new char[len];
        int j = 0;
        boolean accessKeyFound = false;
        int i = 0;
        j = 0;
        while (i < len) {
            if (keyArray[i] == '&' && !accessKeyFound && keyArray[++i] != '&') {
                this._accessKey = labelAndAccessKey.substring(i, i + 1);
                accessKeyFound = true;
            }
            keyArray2[j] = keyArray[i];
            ++i;
            ++j;
        }
        this._label = label = new String(keyArray2, 0, j);
    }

    private String _evalElStr(String str) {
        if (str == null) {
            return null;
        }
        String keystr = MenuUtils.stringReplaceFirst(str.trim(), this._bundleKey, this._bundleKey + this.getHandlerId());
        String elVal = MenuUtils.getBoundValue(keystr, String.class);
        return elVal;
    }
}

