/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.desktop;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.CollectionComponent;
import org.apache.myfaces.trinidad.component.UIXCollection;
import org.apache.myfaces.trinidad.component.UIXColumn;
import org.apache.myfaces.trinidad.component.UIXTable;
import org.apache.myfaces.trinidad.component.core.data.CoreColumn;
import org.apache.myfaces.trinidad.component.core.data.CoreTable;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.render.CoreRenderer;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.io.RepeatIdResponseWriter;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.ShowDetailRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.TableRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.CellUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.ColumnData;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.RenderStage;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.RowData;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableSelectManyRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TreeUtils;

public class DesktopTableRenderer
extends TableRenderer {
    private CoreRenderer _allDisclosed;
    private CoreRenderer _allUndisclosed;
    private static final String _SHOW_ALL_DETAILS_TEXT_KEY = "af_table.SHOW_ALL_DETAILS";
    private static final String _HIDE_ALL_DETAILS_TEXT_KEY = "af_table.HIDE_ALL_DETAILS";
    private static final String _SELECT_ALL_TEXT_KEY = "af_tableSelectMany.SELECT_ALL";
    private static final String _SELECT_NONE_TEXT_KEY = "af_tableSelectMany.SELECT_NONE";
    public static final String LINKS_DIVIDER_TEXT = "\u00a0|\u00a0";
    private static final Object _IE_SCROLL_KEY = new Object();
    private PropertyKey _autoSubmitKey;
    private PropertyKey _summaryKey;
    private PropertyKey _heightKey;
    private PropertyKey _allDetailsEnabledKey;

    protected DesktopTableRenderer(FacesBean.Type type) {
        super(type);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._summaryKey = type.findKey("summary");
        this._heightKey = type.findKey("height");
        if (this._heightKey == null) {
            this._heightKey = PropertyKey.createPropertyKey((String)"height");
        }
        this._allDetailsEnabledKey = type.findKey("allDetailsEnabled");
        this._allDisclosed = new AllDetail(type, true);
        this._allUndisclosed = new AllDetail(type, false);
        this._autoSubmitKey = type.findKey("autoSubmit");
    }

    public DesktopTableRenderer() {
        this(CoreTable.TYPE);
    }

    protected final void renderSingleRow(FacesContext context, RenderingContext arc, TableRenderingContext tContext, UIComponent component) throws IOException {
        RenderStage renderStage = tContext.getRenderStage();
        int stage = renderStage.getStage();
        if (stage == 20) {
            this.renderColumnHeader(context, arc, tContext, component);
            return;
        }
        int physicalColumn = this.renderSpecialColumns(context, arc, tContext, component, 0);
        this._renderRegularColumns(context, tContext, component, physicalColumn);
    }

    protected void renderSelectionLinks(FacesContext context, RenderingContext arc, TableRenderingContext tContext, UIComponent component) throws IOException {
        if (tContext.getRowData().isEmptyTable()) {
            return;
        }
        if (this.hasControlBarLinks(context, arc, tContext, component)) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("tr", null);
            writer.startElement("td", null);
            writer.startElement("table", null);
            OutputUtils.renderLayoutTableAttributes(context, arc, "0", "100%");
            DesktopTableRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|table::sub-control-bar");
            writer.startElement("tr", null);
            writer.startElement("td", null);
            writer.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
            writer.writeAttribute("valign", (Object)"middle", null);
            this.renderControlBarLinks(context, arc, tContext, component, false);
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("table");
            writer.endElement("td");
            writer.endElement("tr");
        }
    }

    protected boolean hasControlBarLinks(FacesContext context, RenderingContext arc, TableRenderingContext tContext, UIComponent component) throws IOException {
        return tContext.hasSelectAll() || tContext.getDetail() != null && this.getAllDetailsEnabled(this.getFacesBean(component));
    }

    protected void renderControlBarLinks(FacesContext context, RenderingContext arc, TableRenderingContext trc, UIComponent component, boolean useDivider) throws IOException {
        FacesBean bean = this.getFacesBean(component);
        boolean hasAllDetails = trc.getDetail() != null && this.getAllDetailsEnabled(bean);
        boolean needsDivider = false;
        if (trc.hasSelectAll()) {
            String jsVarName = trc.getJSVarName();
            this.renderControlBarLink(context, arc, TreeUtils.callJSSelectAll(jsVarName, true), _SELECT_ALL_TEXT_KEY, null, true);
            this.renderControlBarLink(context, arc, TreeUtils.callJSSelectAll(jsVarName, false), _SELECT_NONE_TEXT_KEY, null, hasAllDetails);
            needsDivider = true;
            TableSelectManyRenderer.renderScripts(context, arc, trc, this.isAutoSubmit(bean));
        }
        ResponseWriter writer = context.getResponseWriter();
        if (hasAllDetails) {
            this.delegateRenderer(context, arc, component, bean, this._allUndisclosed);
            writer.writeText((Object)LINKS_DIVIDER_TEXT, null);
            this.delegateRenderer(context, arc, component, bean, this._allDisclosed);
            needsDivider = true;
        }
        if (useDivider && needsDivider) {
            writer.writeText((Object)LINKS_DIVIDER_TEXT, null);
        }
    }

    protected final void renderControlBarLink(FacesContext context, RenderingContext arc, String onclick, String translationKey, String id, boolean hasDivider) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        writer.writeAttribute("id", (Object)id, null);
        DesktopTableRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"OraNavBarActiveLink");
        writer.writeAttribute("onclick", (Object)onclick, null);
        writer.writeURIAttribute("href", (Object)"#", null);
        writer.writeText((Object)arc.getTranslatedString(translationKey), null);
        writer.endElement("a");
        if (hasDivider) {
            writer.writeText((Object)LINKS_DIVIDER_TEXT, null);
        }
    }

    protected void renderSubControlBar(FacesContext context, RenderingContext arc, TableRenderingContext tContext, UIComponent component, boolean isUpper) throws IOException {
        if (!isUpper) {
            return;
        }
        RenderStage rs = tContext.getRenderStage();
        rs.setStage(12);
        this.renderSelectionLinks(context, arc, tContext, component);
    }

    protected void renderTableContent(FacesContext context, RenderingContext arc, TableRenderingContext tContext, UIComponent component) throws IOException {
        String scrollID;
        boolean useScrollIE;
        boolean wideMode;
        if (DesktopTableRenderer.getFacet((UIComponent)component, (String)"footer") != null) {
            tContext.setExplicitHeaderIDMode(true);
        }
        ResponseWriter writer = context.getResponseWriter();
        UIComponent table = tContext.getTable();
        RenderStage renderStage = tContext.getRenderStage();
        Object assertKey = null;
        if ($assertionsDisabled || (assertKey = ((UIXCollection)table).getRowKey()) == null) {
            // empty if block
        }
        if (wideMode = "100%".equals(tContext.getTableWidth())) {
            writer.endElement("table");
        } else {
            writer.startElement("tr", null);
            writer.startElement("td", null);
        }
        String height = this.getHeight(this.getFacesBean(component));
        if (height != null && DesktopTableRenderer.isIE((RenderingContext)arc)) {
            useScrollIE = true;
            String tableId = tContext.getTableId();
            scrollID = tableId + "_scroll";
            writer.startElement("script", null);
            DesktopTableRenderer.renderScriptDeferAttribute(context, arc);
            DesktopTableRenderer.renderScriptTypeAttribute(context, arc);
            this._writeIEscrollScript(context, arc, tableId, scrollID);
            writer.endElement("script");
            writer.startElement("div", null);
            writer.writeAttribute("style", (Object)("overflow:auto;overflow-x:hidden;width:100%;height:" + height), null);
            writer.writeAttribute("onscroll", (Object)("return _uixIEmaskFrame.tickle('" + scrollID + "');"), null);
            writer.startElement("div", null);
            writer.writeAttribute("style", (Object)"padding-right:16px", null);
        } else {
            useScrollIE = false;
            scrollID = null;
        }
        writer.startElement("table", null);
        DesktopTableRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|table::content");
        if (height != null && DesktopTableRenderer.isGecko((RenderingContext)arc)) {
            writer.writeAttribute("style", (Object)"border-width:0px", null);
        }
        FacesBean bean = this.getFacesBean(table);
        String summary = this.getSummary(bean);
        Object cellPadding = this.getTablePadding(table);
        OutputUtils.renderLayoutTableAttributes(context, arc, cellPadding, "0", "0", "100%", summary);
        this._renderTableHeader(context, arc, tContext, table);
        if (tContext.hasColumnHeaders()) {
            renderStage.setStage(20);
            writer.startElement("tr", null);
            if (useScrollIE) {
                writer.endElement("tr");
                writer.startElement("tr", null);
                writer.writeAttribute("style", (Object)"position:relative;top:-2px;left:0px;z-index:2", null);
                writer.writeAttribute("id", (Object)scrollID, null);
            }
            this.renderColumnHeader(context, arc, tContext, component);
            writer.endElement("tr");
        }
        assert (this._assertCurrencyKeyPreserved(assertKey, table));
        renderStage.setStage(30);
        this.renderTableRows(context, arc, tContext, component, bean);
        assert (this._assertCurrencyKeyPreserved(assertKey, table));
        writer.endElement("table");
        if (useScrollIE) {
            writer.endElement("div");
            writer.endElement("div");
        }
        if (wideMode) {
            writer.startElement("table", null);
            OutputUtils.renderLayoutTableAttributes(context, arc, "0", "0", "100%");
        } else {
            writer.endElement("td");
            writer.endElement("tr");
        }
    }

    private void _writeIEscrollScript(FacesContext context, RenderingContext arc, String tableId, String scrollID) throws IOException {
        boolean previouslyNotRendered;
        ResponseWriter writer = context.getResponseWriter();
        boolean bl = previouslyNotRendered = arc.getProperties().put(_IE_SCROLL_KEY, Boolean.TRUE) == null;
        if (previouslyNotRendered) {
            writer.write("function _uixIEmaskFrame(){};_uixIEmaskFrame.addElement = function(elementId,tableId){if (_uixIEmaskFrame.elements == null){_uixIEmaskFrame.elements = new Array();}_uixIEmaskFrame.elements.push(elementId);_uixIEmaskFrame.elements.push(tableId);};_uixIEmaskFrame.createFrames = function(){if (_uixIEmaskFrame.frames == null){_uixIEmaskFrame.frames = new Object();}var elements = _uixIEmaskFrame.elements;for(var i=0; i<elements.length; i+=2){var elementId  = elements[i];var tableId  = elements[i+1];var element  = document.getElementById(elementId);var maskFrame = element.ownerDocument.createElement('iframe');maskFrame.frameBorder = 'none';maskFrame.scrolling = 'no';maskFrame.title = '';var maskFrameStyle = maskFrame.style;maskFrameStyle.borderStyle = 'none';maskFrameStyle.top = element.offsetTop;maskFrameStyle.posLeft = element.offsetLeft;maskFrameStyle.width = element.offsetWidth;maskFrameStyle.height = element.offsetHeight + 'px';maskFrameStyle.position = 'absolute';maskFrameStyle.zIndex = '1';var tableDiv = document.getElementById(tableId);tableDiv.appendChild(maskFrame);_uixIEmaskFrame.frames[elementId] = maskFrame;var subtr = element.parentNode.childNodes[0];var subtrStyle = subtr.style;subtrStyle.width = element.offsetWidth + 16;subtrStyle.height = element.offsetHeight;var elementStyle = element.style;elementStyle.position = 'absolute';elementStyle.top = maskFrame.offsetTop;elementStyle.posLeft = maskFrame.offsetLeft;}_uixIEmaskFrame.elements = null;};_uixIEmaskFrame.tickle = function(elementId){var maskFrame = _uixIEmaskFrame.frames[elementId];var maskFrameStyle = maskFrame.style;maskFrameStyle.visibility = 'hidden';maskFrameStyle.visibility = 'visible';return false;};");
        }
        writer.write("_uixIEmaskFrame.addElement('" + scrollID + "','" + tableId + "');");
        writer.write("if (document.readyState == 'complete'){_uixIEmaskFrame.createFrames();}");
        if (previouslyNotRendered) {
            writer.write("if (_uixIEmaskFrame.attached == null){_uixIEmaskFrame.attached = true;window.attachEvent('onload', _uixIEmaskFrame.createFrames);}");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void renderControlBar(FacesContext context, RenderingContext arc, TableRenderingContext tContext, UIComponent component) throws IOException {
        boolean hasNav;
        UIComponent action = DesktopTableRenderer.getFacet((UIComponent)component, (String)"actions");
        boolean tableNotEmpty = !tContext.getRowData().isEmptyTable();
        boolean bl = hasNav = tContext.hasNavigation() && tableNotEmpty;
        if (hasNav || action != null) {
            boolean isUpper = tContext.getRenderStage().getStage() == 10;
            ResponseWriter oldRW = null;
            try {
                if (!isUpper) {
                    oldRW = RepeatIdResponseWriter.install(context);
                }
                ResponseWriter writer = context.getResponseWriter();
                writer.startElement("tr", null);
                writer.startElement("td", null);
                String style = "af|table::control-bar-top";
                if (!isUpper) {
                    style = "af|table::control-bar-bottom";
                }
                writer.startElement("table", null);
                OutputUtils.renderLayoutTableAttributes(context, arc, "0", "0", "0", "100%");
                DesktopTableRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)style);
                writer.startElement("tr", null);
                if (action != null) {
                    writer.startElement("td", null);
                    this.encodeChild(context, action);
                    writer.endElement("td");
                }
                writer.startElement("td", null);
                writer.writeAttribute("width", (Object)"100%", null);
                writer.endElement("td");
                if (hasNav) {
                    writer.startElement("td", null);
                    if (arc.isRightToLeft()) {
                        writer.writeAttribute("align", (Object)"left", null);
                    } else {
                        writer.writeAttribute("align", (Object)"right", null);
                    }
                    writer.writeAttribute("valign", (Object)"middle", null);
                    this.renderRangePagingControl(context, arc, tContext, component);
                    writer.endElement("td");
                }
                writer.endElement("tr");
                writer.endElement("table");
                writer.endElement("td");
                writer.endElement("tr");
            }
            finally {
                if (!isUpper) {
                    assert (oldRW != null);
                    RepeatIdResponseWriter.remove(context, oldRW);
                }
            }
        }
    }

    protected void renderRangePagingControl(FacesContext context, RenderingContext arc, TableRenderingContext tContext, UIComponent component) throws IOException {
        this.delegateRenderer(context, arc, component, this.getFacesBean(component), this.getSharedNavBarRenderer());
    }

    private boolean _assertCurrencyKeyPreserved(Object oldKey, UIComponent table) {
        UIXCollection base = (UIXCollection)table;
        Object newKey = base.getRowKey();
        return oldKey != null ? oldKey.equals(newKey) : newKey == null;
    }

    protected Object getTablePadding(UIComponent component) {
        return "1";
    }

    protected void renderTableRows(FacesContext context, RenderingContext arc, TableRenderingContext trc, UIComponent component, FacesBean bean) throws IOException {
        if (trc.getRowData().isEmptyTable()) {
            this._renderEmptyTable(context, arc, trc);
        } else {
            this._renderTableRows(context, arc, trc, component);
        }
        this.renderFooter(context, arc, trc, component);
    }

    protected void renderTableAttributes(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, Object cellPadding, Object border) throws IOException {
        super.renderTableAttributes(context, arc, component, bean, cellPadding, border);
    }

    protected void renderCellFormatAttributes(FacesContext context, RenderingContext arc, TableRenderingContext tContext) throws IOException {
        boolean noSelect;
        String cellClass = "af|column::cell-text";
        String borderStyleClass = CellUtils.getDataBorderStyle(arc, tContext);
        DesktopTableRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)arc, (String[])new String[]{cellClass, borderStyleClass});
        ResponseWriter writer = context.getResponseWriter();
        int row = tContext.getRowData().getRangeIndex();
        int physicalColumn = tContext.getColumnData().getPhysicalColumnIndex();
        boolean bl = noSelect = !tContext.hasSelection();
        if (row == 0 && noSelect && !tContext.hasColumnHeaders()) {
            Object width = tContext.getColumnWidth(physicalColumn);
            writer.writeAttribute("width", width, null);
        }
        if (tContext.getColumnData().getNoWrap(physicalColumn)) {
            writer.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
        }
    }

    private void _renderTableHeader(FacesContext context, RenderingContext arc, TableRenderingContext tContext, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent header = DesktopTableRenderer.getFacet((UIComponent)component, (String)"header");
        if (header != null) {
            writer.startElement("thead", null);
            writer.startElement("tr", null);
            writer.startElement("td", null);
            writer.writeAttribute("colspan", (Object)tContext.getActualColumnCount(), null);
            DesktopTableRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|column::sortable-header-icon-format");
            this.encodeChild(context, header);
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("thead");
        }
    }

    private void _renderEmptyTable(FacesContext context, RenderingContext arc, TableRenderingContext tContext) throws IOException {
        int specialCols;
        int n = specialCols = tContext.hasSelection() ? 1 : 0;
        if (tContext.getDetail() != null) {
            ++specialCols;
        }
        this.renderEmptyTableRow(context, arc, tContext, specialCols);
    }

    protected final void renderEmptyTableRow(FacesContext context, RenderingContext arc, TableRenderingContext tContext, int specialColumnCount) throws IOException {
        this.renderEmptyTableRow(context, arc, tContext, specialColumnCount, null);
    }

    protected final void renderEmptyTableRow(FacesContext context, RenderingContext arc, TableRenderingContext tContext, int specialColumnCount, CoreRenderer emptyTextRenderer) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tr", null);
        ColumnData colData = tContext.getColumnData();
        int physicalColumn = 0;
        int objectNameColumnIndex = colData.getObjectNameColumnIndex();
        int sz = Math.max(specialColumnCount, objectNameColumnIndex);
        for (int i = 0; i < sz; ++i) {
            this._renderEmptyCell(context, arc, tContext, physicalColumn++, null, 1);
        }
        int totalCols = tContext.getActualColumnCount();
        UIComponent table = tContext.getTable();
        FacesBean bean = this.getFacesBean(table);
        if (emptyTextRenderer == null) {
            this._renderEmptyCell(context, arc, tContext, physicalColumn, this.getEmptyText(bean), totalCols - physicalColumn);
            ++physicalColumn;
        } else {
            this.delegateRenderer(context, arc, table, bean, emptyTextRenderer);
            while (physicalColumn < totalCols) {
                this._renderEmptyCell(context, arc, tContext, physicalColumn++, null, 1);
            }
        }
        colData.setCurrentHeaderID(null);
        writer.endElement("tr");
    }

    private void _renderEmptyCell(FacesContext context, RenderingContext arc, TableRenderingContext tContext, int physicalColumn, String text, int colspan) throws IOException {
        ColumnData colData = tContext.getColumnData();
        ResponseWriter writer = context.getResponseWriter();
        String colID = colData.getHeaderID(physicalColumn);
        colData.setCurrentHeaderID(colID);
        colData.setColumnIndex(physicalColumn, -1);
        writer.startElement("td", null);
        this.renderCellFormatAttributes(context, arc, tContext);
        if (colspan > 1) {
            writer.writeAttribute("colspan", (Object)colspan, null);
        }
        if (text != null) {
            writer.writeText((Object)text, null);
        }
        writer.endElement("td");
    }

    private void _renderTableRows(FacesContext context, final RenderingContext arc, final TableRenderingContext tContext, UIComponent component) throws IOException {
        boolean useScroll;
        final RowData rowData = tContext.getRowData();
        final UIComponent detail = tContext.getDetail();
        final RenderStage renderStage = tContext.getRenderStage();
        TableUtils.RowLoop loop = new TableUtils.RowLoop(){

            protected void processRowImpl(FacesContext fc, CollectionComponent tableBase) throws IOException {
                ResponseWriter writer = fc.getResponseWriter();
                rowData.setCurrentRowSpan(-1);
                renderStage.setStage(35);
                DesktopTableRenderer.this.renderSingleRow(fc, arc, tContext, (UIComponent)tableBase);
                renderStage.setStage(30);
                int sz = rowData.getCurrentRowSpan();
                for (int i = 0; i < sz; ++i) {
                    writer.startElement("tr", null);
                    DesktopTableRenderer.this.renderSingleRow(fc, arc, tContext, (UIComponent)tableBase);
                    rowData.incCurrentSubRow();
                    writer.endElement("tr");
                }
                if (detail != null && ((UIXTable)tableBase).getDisclosedRowKeys().isContained()) {
                    renderStage.setStage(45);
                    ColumnData colData = tContext.getColumnData();
                    writer.startElement("tr", null);
                    writer.startElement("td", null);
                    writer.writeAttribute("headers", (Object)colData.getHeaderID(tContext.getDetailColumnIndex()), null);
                    writer.writeAttribute("colspan", (Object)IntegerUtils.getString((int)tContext.getActualColumnCount()), null);
                    String styleClass = "af|table::detail";
                    String borderStyleClass = CellUtils.getBorderClass(true, true, true, true);
                    CoreRenderer.renderStyleClasses((FacesContext)fc, (RenderingContext)arc, (String[])new String[]{styleClass, borderStyleClass});
                    DesktopTableRenderer.this.encodeChild(fc, detail);
                    writer.endElement("td");
                    writer.endElement("tr");
                    renderStage.setStage(30);
                }
            }
        };
        ResponseWriter writer = context.getResponseWriter();
        String height = this.getHeight(this.getFacesBean(component));
        if (height != null && DesktopTableRenderer.isGecko((RenderingContext)arc)) {
            useScroll = true;
            writer.startElement("tbody", null);
            writer.writeAttribute("style", (Object)("overflow:auto;max-height:" + height), null);
        } else {
            useScroll = false;
        }
        loop.run(context, tContext.getCollectionComponent());
        if (useScroll) {
            writer.endElement("tbody");
        }
    }

    protected final void renderColumnHeader(FacesContext context, RenderingContext arc, TableRenderingContext tContext, UIComponent component) throws IOException {
        ColumnData colData = tContext.getColumnData();
        colData.setRowIndex(0);
        int physicalCol = this.renderSpecialColumns(context, arc, tContext, component, 0);
        this.renderRegularHeaders(context, arc, tContext, component, physicalCol);
        colData.setRowIndex(-1);
    }

    protected final void renderRegularHeaders(FacesContext context, RenderingContext arc, TableRenderingContext tContext, UIComponent component, int physicalCol) throws IOException {
        ColumnData colData = tContext.getColumnData();
        this._renderRegularColumns(context, tContext, component, physicalCol);
        int rowSpan = colData.getHeaderRowSpan();
        if (rowSpan > 1) {
            ResponseWriter writer = context.getResponseWriter();
            for (int i = 1; i < rowSpan; ++i) {
                colData.setRowIndex(i);
                writer.endElement("tr");
                writer.startElement("tr", null);
                this._renderRegularColumns(context, tContext, component, physicalCol);
            }
        }
    }

    private void _renderRegularColumns(FacesContext context, TableRenderingContext tContext, UIComponent component, int physicalCol) throws IOException {
        List children = component.getChildren();
        int colCount = children.size();
        int[] hidden = tContext.getHiddenColumns();
        ColumnData colData = tContext.getColumnData();
        for (int i = 0; i < colCount; ++i) {
            UIXColumn column;
            boolean isRowHeader;
            UIComponent child;
            if (hidden[i] != 0 || !((child = (UIComponent)children.get(i)) instanceof UIXColumn) || (isRowHeader = Boolean.TRUE.equals((column = (UIXColumn)child).getAttributes().get(CoreColumn.ROW_HEADER_KEY.getName())))) continue;
            colData.setColumnIndex(physicalCol, i);
            this.encodeChild(context, (UIComponent)column);
            physicalCol = colData.getPhysicalColumnIndex();
        }
    }

    protected final void renderFooter(FacesContext context, RenderingContext arc, TableRenderingContext tContext, UIComponent component) throws IOException {
        boolean hasColumnFooters;
        tContext.getRenderStage().setStage(60);
        ColumnData colData = tContext.getColumnData();
        UIComponent footer = DesktopTableRenderer.getFacet((UIComponent)component, (String)"footer");
        boolean bl = hasColumnFooters = colData.getPhysicalIndexOfFirstFooter() >= 0;
        if (footer != null || hasColumnFooters) {
            int firstFooterPhysicalIndex;
            boolean useScroll;
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("tr", null);
            boolean bl2 = useScroll = this.getHeight(this.getFacesBean(component)) != null && DesktopTableRenderer.isIE((RenderingContext)arc);
            if (useScroll) {
                writer.writeAttribute("style", (Object)"position:relative;bottom:expression(this.offsetParent.scrollHeight-this.offsetParent.scrollTop-this.offsetParent.clientHeight+1);left:-1px", null);
            }
            if ((firstFooterPhysicalIndex = colData.getPhysicalIndexOfFirstFooter()) != 0) {
                writer.startElement("th", null);
                int colSpan = firstFooterPhysicalIndex > 0 ? firstFooterPhysicalIndex : tContext.getActualColumnCount();
                writer.writeAttribute("colspan", (Object)IntegerUtils.getString((int)colSpan), null);
                DesktopTableRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|table::column-footer");
                if (footer != null) {
                    this.encodeChild(context, footer);
                }
                writer.endElement("th");
            }
            if (firstFooterPhysicalIndex >= 0) {
                colData.setColumnIndex(tContext.getSpecialColumnCount(), 0);
                for (UIComponent child : component.getChildren()) {
                    if (!child.isRendered()) continue;
                    this.encodeChild(context, child);
                }
            }
            writer.endElement("tr");
            if (firstFooterPhysicalIndex == 0 && footer != null) {
                writer.startElement("tr", null);
                writer.startElement("th", null);
                writer.writeAttribute("colspan", (Object)tContext.getActualColumnCount(), null);
                DesktopTableRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|table::column-footer");
                this.encodeChild(context, footer);
                writer.endElement("th");
                writer.endElement("tr");
            }
        }
    }

    protected String getSummary(FacesBean bean) {
        return DesktopTableRenderer.toString((Object)bean.getProperty(this._summaryKey));
    }

    protected String getHeight(FacesBean bean) {
        return DesktopTableRenderer.toString((Object)bean.getProperty(this._heightKey));
    }

    protected boolean isAutoSubmit(FacesBean bean) {
        if (this._autoSubmitKey == null) {
            return false;
        }
        return Boolean.TRUE.equals(bean.getProperty(this._autoSubmitKey));
    }

    protected boolean getAllDetailsEnabled(FacesBean bean) {
        Object o = bean.getProperty(this._allDetailsEnabledKey);
        if (o == null) {
            o = this._allDetailsEnabledKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    private static class AllDetail
    extends ShowDetailRenderer {
        private boolean _disclosed;

        public AllDetail(FacesBean.Type type, boolean disclosed) {
            super(type);
            this._disclosed = disclosed;
        }

        protected void renderAllAttributes(FacesContext context, RenderingContext arc, FacesBean bean) {
        }

        protected boolean isTableAllDisclosure() {
            return true;
        }

        protected boolean renderAsInline() {
            return true;
        }

        protected String getValueParameter(UIComponent component) {
            return "all";
        }

        protected boolean getDisclosed(FacesBean bean) {
            return this._disclosed;
        }

        protected String getDisclosedText(FacesBean bean) {
            RenderingContext arc = RenderingContext.getCurrentInstance();
            return arc.getTranslatedString(DesktopTableRenderer._HIDE_ALL_DETAILS_TEXT_KEY);
        }

        protected String getUndisclosedText(FacesBean bean) {
            RenderingContext arc = RenderingContext.getCurrentInstance();
            return arc.getTranslatedString(DesktopTableRenderer._SHOW_ALL_DETAILS_TEXT_KEY);
        }

        protected String getLinkId(String rootId, boolean disclosed) {
            String suffix = disclosed ? "ha" : "sa";
            return XhtmlUtils.getCompositeId(rootId, suffix);
        }

        protected String getClientId(FacesContext context, UIComponent component) {
            TableRenderingContext tContext = TableRenderingContext.getCurrentInstance();
            return tContext.getTableId();
        }
    }
}

