/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.pages;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.component.core.CoreImportScript;
import org.apache.myfaces.trinidad.component.core.output.CoreOutputText;
import org.apache.myfaces.trinidad.component.html.HtmlFrame;
import org.apache.myfaces.trinidad.component.html.HtmlFrameBorderLayout;
import org.apache.myfaces.trinidad.component.html.HtmlHtml;
import org.apache.myfaces.trinidad.component.html.HtmlScript;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderKit;
import org.apache.myfaces.trinidadinternal.renderkit.core.pages.GenericEntry;
import org.apache.myfaces.trinidadinternal.share.url.EncoderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FredJSP {
    private static final String _VIEW_ID_REDIRECT_PARAM = "_vir";
    private static final String _MIN_WIDTH_PARAM = "_minWidth";
    private static final String _MIN_HEIGHT_PARAM = "_minHeight";
    private static final String _RETURN_ID_PARAM = "_rtrnId";
    private static final String _BLOCK_RELOAD_TEXT = "document.onkeydown=_noReload;var _blockReload=1;";
    private static final String _FIX_DIALOG_TITLE = "function _fixDialogTitle(){window.document.title=window.frames[0].document.title};";
    private static final String _FRAMESET_ONLOAD_TEXT = "_fixDialogTitle(); _sizeWin(window.frames[0],0,30";
    private static final String _FRAMESET_ONUNLOAD_TEXT = "_checkUnload(event)";
    private static final Collection<String> _SKIP_PARAMS = Arrays.asList("_t", "redirect", "_minWidth", "_minHeight", "_red", "_vir", "_rtrnId", "_afPfm");
    private static final String _FRAME_CONTENT = "FRAME_CONTENT";
    private static final String _DEFAULT_CONTENT_STRING = "Content";

    public static String getRedirectURL(FacesContext context, UIViewRoot viewRoot, String minWidth, String minHeight) {
        String baseURL = GenericEntry.getGenericEntryURL(context, "fred");
        String[] args = new String[]{_VIEW_ID_REDIRECT_PARAM, viewRoot.getViewId(), "loc", viewRoot.getLocale().toString().replace('_', '-'), _MIN_WIDTH_PARAM, minWidth, _MIN_HEIGHT_PARAM, minHeight};
        return EncoderUtils.appendURLArguments(baseURL, args);
    }

    static void service(FacesContext context) throws IOException {
        RenderingContext arc = RenderingContext.getCurrentInstance();
        HtmlHtml root = new HtmlHtml();
        context.getViewRoot().getChildren().add(root);
        Map requestParameters = context.getExternalContext().getRequestParameterMap();
        String returnId = (String)requestParameters.get(_RETURN_ID_PARAM);
        if (returnId != null) {
            CoreRenderKit.saveDialogPostbackValues(returnId);
        }
        CoreOutputText headStart = new CoreOutputText();
        root.getChildren().add(headStart);
        headStart.setEscape(false);
        headStart.setValue((Object)"<head>");
        CoreImportScript cis = new CoreImportScript();
        cis.setNames(new String[]{"Core"});
        root.getChildren().add(cis);
        HtmlScript script = new HtmlScript();
        script.setText("document.onkeydown=_noReload;var _blockReload=1;function _fixDialogTitle(){window.document.title=window.frames[0].document.title};");
        root.getChildren().add(script);
        CoreOutputText headEnd = new CoreOutputText();
        root.getChildren().add(headEnd);
        headStart.setEscape(false);
        headStart.setValue((Object)"</head>");
        HtmlFrame contentFrame = new HtmlFrame();
        String contentStr = arc.getTranslatedString(_FRAME_CONTENT);
        if (contentStr == null) {
            contentStr = _DEFAULT_CONTENT_STRING;
        }
        contentFrame.setShortDesc(contentStr);
        contentFrame.setLongDescURL("#");
        contentFrame.setHeight("100%");
        contentFrame.setWidth("100%");
        String queryString = FredJSP._getQueryString(context.getExternalContext().getRequestParameterValuesMap());
        String widthParam = (String)requestParameters.get(_MIN_WIDTH_PARAM);
        boolean gotWidth = widthParam != null;
        String heightParam = (String)requestParameters.get(_MIN_HEIGHT_PARAM);
        boolean gotHeight = heightParam != null;
        String viewIdRedirect = (String)requestParameters.get(_VIEW_ID_REDIRECT_PARAM);
        if (viewIdRedirect != null) {
            ViewHandler vh = context.getApplication().getViewHandler();
            String redirectString = "/" + vh.getActionURL(context, viewIdRedirect);
            char sep = redirectString.indexOf(63) != -1 ? (char)'&' : '?';
            contentFrame.setSource(redirectString + sep + queryString);
        } else {
            String internalRedirect = (String)requestParameters.get("_red");
            if (internalRedirect != null) {
                String path = GenericEntry.getGenericEntryURL(context, internalRedirect);
                contentFrame.setSource("/" + path + "&" + queryString);
            }
        }
        HtmlFrameBorderLayout frameSet = new HtmlFrameBorderLayout();
        frameSet.setShortDesc(contentStr);
        frameSet.setCenter((UIComponent)contentFrame);
        frameSet.getAttributes().put("border", Boolean.FALSE);
        CoreOutputText alternateContent = new CoreOutputText();
        alternateContent.setValue((Object)arc.getTranslatedString("NO_FRAMES_MESSAGE"));
        frameSet.setAlternateContent((UIComponent)alternateContent);
        StringBuilder onload = new StringBuilder(_FRAMESET_ONLOAD_TEXT.length() + (gotWidth ? widthParam.length() + 2 : 0) + (gotHeight ? heightParam.length() + 2 : 0) + 5);
        onload.append(_FRAMESET_ONLOAD_TEXT);
        if (gotWidth || gotHeight) {
            onload.append(",{");
            if (gotWidth) {
                onload.append("W:");
                onload.append(widthParam);
            }
            if (gotHeight) {
                if (gotWidth) {
                    onload.append(",");
                }
                onload.append("H:");
                onload.append(heightParam);
            }
            onload.append("}");
        }
        onload.append(")");
        frameSet.setOnload(onload.toString());
        if (returnId != null) {
            StringBuilder onunload = new StringBuilder(53 + returnId.length());
            onunload.append(_FRAMESET_ONUNLOAD_TEXT);
            onunload.append(";window.opener.setTimeout(");
            onunload.append("'ADFDialogReturn[").append(returnId).append("]();'");
            onunload.append(",1)");
            frameSet.setOnunload(onunload.toString());
        } else {
            frameSet.setOnunload(_FRAMESET_ONUNLOAD_TEXT);
        }
        root.getChildren().add(frameSet);
    }

    private static String _getQueryString(Map<String, String[]> parameters) throws IOException {
        StringBuffer buf = new StringBuffer();
        Iterator<String> paramNames = parameters.keySet().iterator();
        boolean isFirst = true;
        while (paramNames.hasNext()) {
            String paramName = paramNames.next();
            if (_SKIP_PARAMS.contains(paramName)) continue;
            String[] paramValues = parameters.get(paramName);
            for (int i = 0; i < paramValues.length; ++i) {
                if (!isFirst) {
                    buf.append("&");
                }
                String paramValue = paramValues[i];
                EncoderUtils.appendUIXQueryParameter(buf, paramName);
                buf.append("=");
                EncoderUtils.appendUIXQueryParameter(buf, paramValue);
                isFirst = false;
            }
        }
        return buf.toString();
    }
}

