/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.input.CoreSelectOneRadio;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AutoSubmitUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.HiddenLabelUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.LabelAndMessageRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SimpleSelectOneRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSelectOneRadioRenderer
extends SimpleSelectOneRenderer {
    private PropertyKey _accessKeyKey;
    private PropertyKey _layoutKey;
    private PropertyKey _unselectedLabelKey;

    public SimpleSelectOneRadioRenderer() {
        this(CoreSelectOneRadio.TYPE);
    }

    public SimpleSelectOneRadioRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._accessKeyKey = type.findKey("accessKey");
        this._layoutKey = type.findKey("layout");
        this._unselectedLabelKey = type.findKey("unselectedLabel");
    }

    @Override
    protected void encodeElementContent(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, List<SelectItem> selectItems, int selectedIndex, Converter converter, boolean valuePassThru) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", component);
        this.renderId(context, component);
        this.renderAllAttributes(context, arc, bean, false);
        boolean applyFieldSet = SimpleSelectOneRadioRenderer._applyFieldSetWrapper(arc);
        if (applyFieldSet) {
            String shortDesc = this.getShortDesc(bean);
            if (shortDesc == null) {
                applyFieldSet = false;
            } else {
                writer.startElement("fieldset", null);
                writer.writeAttribute("style", (Object)"border:none;margin:0px;padding:0px;", null);
                writer.startElement("legend", null);
                SimpleSelectOneRadioRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"p_OraHiddenLabel");
                writer.writeText((Object)shortDesc, "shortDesc");
                writer.endElement("legend");
            }
        }
        this.encodeSelectItems(context, arc, component, bean, selectItems, selectedIndex, converter, valuePassThru);
        if (applyFieldSet) {
            writer.endElement("fieldset");
        }
        writer.endElement("span");
    }

    protected void encodeSelectItems(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, List<SelectItem> selectItems, int selectedIndex, Converter converter, boolean valuePassThru) throws IOException {
        int size = selectItems == null ? 0 : selectItems.size();
        boolean disabled = this.getDisabled(bean);
        boolean isVertical = !"horizontal".equals(this.getLayout(bean));
        Object accessKey = SimpleSelectOneRadioRenderer.supportsAccessKeys(arc) ? this.getAccessKey(bean) : null;
        String itemOnclick = this.getItemOnclick(arc, bean);
        boolean renderedOne = false;
        String unselectedLabel = this.getUnselectedLabel(bean);
        if (unselectedLabel != null) {
            SelectItem item = new SelectItem((Object)"", unselectedLabel, "", false);
            this.encodeSelectItem(context, arc, component, item, null, true, accessKey, -1, selectedIndex < 0, disabled, false, itemOnclick);
            renderedOne = true;
        }
        for (int i = 0; i < size; ++i) {
            SelectItem item = selectItems.get(i);
            if (!this.encodeSelectItem(context, arc, component, item, converter, valuePassThru, accessKey, i, selectedIndex == i, disabled, renderedOne && isVertical, itemOnclick)) continue;
            renderedOne = true;
        }
    }

    protected boolean encodeSelectItem(FacesContext context, RenderingContext arc, UIComponent component, SelectItem item, Converter converter, boolean valuePassThru, Object accessKey, int index, boolean isSelected, boolean isDisabled, boolean renderBreak, String itemOnclick) throws IOException {
        if (item == null) {
            return false;
        }
        String id = arc.getCurrentClientId();
        if (id == null) {
            return false;
        }
        StringBuffer subidBuffer = new StringBuffer(id.length() + 4);
        subidBuffer.append(id);
        subidBuffer.append(":_");
        subidBuffer.append(IntegerUtils.getString((int)index));
        String subid = subidBuffer.toString();
        Object itemValue = SimpleSelectOneRadioRenderer.getItemValue(context, component, item, converter, valuePassThru, index);
        FacesBean bean = this.getFacesBean(component);
        ResponseWriter rw = context.getResponseWriter();
        if (renderBreak) {
            rw.startElement("br", null);
            rw.endElement("br");
        }
        rw.startElement("input", null);
        rw.writeAttribute("type", (Object)"radio", null);
        rw.writeAttribute("name", (Object)id, null);
        rw.writeAttribute("id", (Object)subid, null);
        rw.writeAttribute("value", itemValue, null);
        rw.writeAttribute("accesskey", accessKey, null);
        if (isSelected) {
            rw.writeAttribute("checked", (Object)Boolean.TRUE, null);
        }
        if (isDisabled || item.isDisabled()) {
            rw.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        rw.writeAttribute("onclick", (Object)itemOnclick, null);
        this.renderItemFormEventHandlers(context, bean);
        rw.endElement("input");
        rw.startElement("label", null);
        rw.writeAttribute("for", (Object)subid, null);
        String description = item.getDescription();
        if (description != null && !"".equals(description)) {
            rw.writeAttribute("title", (Object)description, null);
        }
        rw.writeText((Object)item.getLabel(), null);
        rw.endElement("label");
        return true;
    }

    @Override
    protected void renderId(FacesContext context, UIComponent component) throws IOException {
        if (this.shouldRenderId(context, component)) {
            String clientId = this.getClientId(context, component);
            context.getResponseWriter().writeAttribute("id", (Object)clientId, "id");
        }
    }

    @Override
    protected void renderFormEventHandlers(FacesContext context, FacesBean bean) throws IOException {
    }

    @Override
    protected String getOnclick(FacesBean bean) {
        return null;
    }

    protected void renderItemFormEventHandlers(FacesContext context, FacesBean bean) throws IOException {
        super.renderFormEventHandlers(context, bean);
    }

    protected String getItemOnclick(RenderingContext arc, FacesBean bean) {
        String onclick = super.getOnclick(bean);
        if (this.isAutoSubmit(bean)) {
            String source = LabelAndMessageRenderer.__getCachedClientId(arc);
            boolean immediate = this.isImmediate(bean);
            String auto = AutoSubmitUtils.getSubmitScript(arc, source, "autosub", immediate);
            onclick = XhtmlUtils.getChainedJS(onclick, auto, true);
        }
        return onclick;
    }

    protected Object getAccessKey(FacesBean bean) {
        return bean.getProperty(this._accessKeyKey);
    }

    protected String getLayout(FacesBean bean) {
        return SimpleSelectOneRadioRenderer.toString((Object)bean.getProperty(this._layoutKey));
    }

    @Override
    protected String getUnselectedLabel(FacesBean bean) {
        return SimpleSelectOneRadioRenderer.toString((Object)bean.getProperty(this._unselectedLabelKey));
    }

    @Override
    protected boolean isHiddenLabelRequired(RenderingContext arc) {
        return false;
    }

    @Override
    protected String getContentStyleClass(FacesBean bean) {
        return "af|selectOneRadio::content";
    }

    @Override
    protected String getRootStyleClass(FacesBean bean) {
        return "af|selectOneRadio";
    }

    private static boolean _applyFieldSetWrapper(RenderingContext arc) {
        if (SimpleSelectOneRadioRenderer.isInaccessibleMode((RenderingContext)arc)) {
            return false;
        }
        if (!HiddenLabelUtils.supportsHiddenLabels(arc)) {
            return true;
        }
        return Boolean.TRUE.equals(arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_FIELDSET));
    }
}

