/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs;

import java.util.HashMap;
import java.util.Locale;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs.LocaleInfoScriptlet;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.LocaleList;

class NamedLocaleInfoScriptlet
extends LocaleInfoScriptlet {
    private Locale _locale;

    public static void registerNamedLocales() {
        HashMap<Locale, Locale> supportedMap = LocaleList.getSupportedLocales();
        for (Locale l : supportedMap.keySet()) {
            NamedLocaleInfoScriptlet ns = new NamedLocaleInfoScriptlet(l);
            ns.registerSelf();
        }
    }

    public NamedLocaleInfoScriptlet(Locale namedlocale) {
        String var = this.getSupportedLocaleVariant(RenderingContext.getCurrentInstance());
        if (var != null) {
            namedlocale = new Locale(namedlocale.getLanguage(), namedlocale.getCountry(), var);
        }
        this._locale = namedlocale;
    }

    protected String getLibraryURL(FacesContext context, RenderingContext arc) {
        StringBuffer sb = new StringBuffer(super.getLibraryURL(context, arc));
        if (!this._locale.equals(arc.getLocaleContext().getFormattingLocale())) {
            sb.append("?skipTranslations=true");
        }
        return sb.toString();
    }

    public Object getScriptletKey() {
        String lib = (String)super.getScriptletKey();
        String sLoc = this._locale.toString();
        StringBuffer sb = new StringBuffer(lib.length() + 1 + sLoc.length());
        sb.append(lib);
        sb.append("_");
        sb.append(sLoc);
        return sb.toString();
    }

    protected Locale getFormattingLocale(RenderingContext arc) {
        return this._locale;
    }
}

