/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style.cache;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.context.AccessibilityProfile;
import org.apache.myfaces.trinidad.context.LocaleContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.share.io.CachingNameResolver;
import org.apache.myfaces.trinidadinternal.share.io.DefaultNameResolver;
import org.apache.myfaces.trinidadinternal.share.io.InputStreamProvider;
import org.apache.myfaces.trinidadinternal.share.io.NameResolver;
import org.apache.myfaces.trinidadinternal.share.xml.JaxpXMLProvider;
import org.apache.myfaces.trinidadinternal.style.CSSStyle;
import org.apache.myfaces.trinidadinternal.style.Style;
import org.apache.myfaces.trinidadinternal.style.StyleContext;
import org.apache.myfaces.trinidadinternal.style.StyleMap;
import org.apache.myfaces.trinidadinternal.style.StyleProvider;
import org.apache.myfaces.trinidadinternal.style.util.CSSGenerationUtils;
import org.apache.myfaces.trinidadinternal.style.util.NameUtils;
import org.apache.myfaces.trinidadinternal.style.util.StyleWriterFactory;
import org.apache.myfaces.trinidadinternal.style.xml.StyleSheetDocumentUtils;
import org.apache.myfaces.trinidadinternal.style.xml.parse.IconNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.PropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.SkinPropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetDocument;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetNode;
import org.apache.myfaces.trinidadinternal.util.nls.LocaleUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemStyleCache
implements StyleProvider {
    private File _sourceFile;
    private String _targetPath;
    private String _baseName;
    private NameResolver _resolver;
    private StyleSheetDocument _document;
    private Hashtable<Key, Entry> _cache;
    private Hashtable<Object, Entry> _entryCache;
    private Map<String, String> _shortStyleClassMap;
    private String[] _namespacePrefixes;
    private static final char _NAME_SEPARATOR = '-';
    private static final String _COMPRESSED = "cmp";
    private static final String _PORTLET = "prtl";
    private static final String _CSS_EXTENSION = ".css";
    private static String _UTF8_ENCODING = "UTF8";
    private static final StyleSheetDocument _EMPTY_DOCUMENT = new StyleSheetDocument(null, null, -1L);
    static final Style _MISS = new CSSStyle();
    private static final String _SHORT_CLASS_PREFIX = "x";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(FileSystemStyleCache.class);
    private static final Map<String, String> _STYLE_KEY_MAP = new HashMap<String, String>();
    private static final String[] _EMPTY_STRING_ARRAY;

    @Override
    public String getContentStyleType(StyleContext context) {
        return "text/css";
    }

    protected FileSystemStyleCache(String source, String target) {
        File targetDirectory;
        if (source != null) {
            File sourceFile = new File(source);
            if (!sourceFile.exists()) {
                throw new IllegalArgumentException("\nRequired XSS file " + source + " does not exist.");
            }
            this._sourceFile = sourceFile;
            String baseName = sourceFile.getName();
            int dotIndex = baseName.indexOf(46);
            if (dotIndex != -1) {
                baseName = baseName.substring(0, dotIndex);
            }
            this._baseName = baseName;
        }
        if (!(targetDirectory = new File(target)).exists()) {
            targetDirectory.mkdirs();
        }
        this._targetPath = target;
    }

    @Override
    public List<String> getStyleSheetURIs(StyleContext context) {
        Entry entry = this._getEntry(context);
        if (entry == null) {
            return null;
        }
        return entry.uris;
    }

    @Override
    public StyleMap getStyleMap(StyleContext context) {
        Entry entry = this._getEntry(context);
        if (entry == null) {
            return null;
        }
        return entry.map;
    }

    @Override
    public ConcurrentMap<Object, Object> getSkinProperties(StyleContext context) {
        Entry entry = this._getEntry(context);
        if (entry == null) {
            return null;
        }
        return entry.skinProperties;
    }

    @Override
    public ConcurrentMap<String, Icon> getIcons(StyleContext context) {
        Entry entry = this._getEntry(context);
        if (entry == null) {
            return null;
        }
        return entry.icons;
    }

    @Override
    public Map<String, String> getShortStyleClasses(StyleContext context) {
        return this._shortStyleClassMap;
    }

    protected StyleSheetDocument createStyleSheetDocument(StyleContext context) {
        if (this._sourceFile == null) {
            return null;
        }
        StyleSheetDocument document = null;
        JaxpXMLProvider provider = new JaxpXMLProvider();
        try {
            document = StyleSheetDocumentUtils.createStyleSheetDocument(provider, this._resolver, this._sourceFile.getPath());
        }
        catch (SAXException e) {
        }
        catch (IOException e) {
            if (_LOG.isWarning()) {
                _LOG.warning("IOEXCEPTION_IN_PHASE", (Object)this._sourceFile);
            }
            _LOG.warning((Throwable)e);
        }
        return document;
    }

    protected boolean hasSourceDocumentChanged(StyleContext context) {
        if (this._document == null) {
            return true;
        }
        InputStreamProvider provider = this._getInputStreamProvider();
        if (provider != null) {
            return provider.hasSourceChanged();
        }
        return false;
    }

    protected String getTargetStyleSheetName(StyleContext context, StyleSheetDocument document) {
        boolean compressedStyles;
        String contextName;
        StringBuilder buffer = new StringBuilder();
        String baseName = this._baseName;
        if (baseName != null) {
            buffer.append(baseName);
        }
        if ((contextName = NameUtils.getContextName(context, document)) != null && contextName.length() > 0) {
            if (baseName != null) {
                buffer.append('-');
            }
            buffer.append(contextName);
        }
        if (compressedStyles = this._isCompressStyles(null)) {
            if (baseName != null || contextName != null) {
                buffer.append('-');
            }
            buffer.append(_COMPRESSED);
        }
        if (context.isPortletMode()) {
            if (baseName != null || contextName != null || compressedStyles) {
                buffer.append('-');
            }
            buffer.append(_PORTLET);
        }
        buffer.append(_CSS_EXTENSION);
        return buffer.toString();
    }

    StyleSheetDocument __getStyleSheetDocument() {
        return this._document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry _getEntry(StyleContext context) {
        Hashtable<Key, Entry> cache = null;
        Hashtable<Object, Entry> entryCache = null;
        StyleSheetDocument document = null;
        Map<String, String> shortStyleClassMap = null;
        String[] namespacePrefixes = null;
        boolean checkModified = context.checkStylesModified();
        FileSystemStyleCache fileSystemStyleCache = this;
        synchronized (fileSystemStyleCache) {
            this._initResolver();
            if (checkModified && this.hasSourceDocumentChanged(context)) {
                this._cache = null;
                this._entryCache = null;
                this._document = null;
                this._shortStyleClassMap = null;
                this._namespacePrefixes = null;
            }
            if (this._cache == null) {
                this._cache = new Hashtable();
            }
            if (this._entryCache == null) {
                this._entryCache = new Hashtable(19);
            }
            cache = this._cache;
            entryCache = this._entryCache;
            document = this._getStyleSheetDocument(context);
            if (document == null) {
                return null;
            }
            shortStyleClassMap = this._shortStyleClassMap;
            namespacePrefixes = this._namespacePrefixes;
        }
        Key key = new Key(context);
        Entry entry = this._getEntry(cache, key, checkModified);
        if (entry != null) {
            return entry;
        }
        entry = this._getCompatibleEntry(context, document, cache, key, entryCache, checkModified);
        if (entry != null) {
            return entry;
        }
        return this._createEntry(context, document, cache, key, entryCache, shortStyleClassMap, namespacePrefixes, checkModified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry _getEntry(Map<?, Entry> cache, Object key, boolean checkModified) {
        Entry entry = cache.get(key);
        if (entry == null) {
            return null;
        }
        if (checkModified) {
            List<String> uris = entry.uris;
            assert (uris != null && !uris.isEmpty());
            boolean valid = true;
            LinkedList<File> existing = new LinkedList<File>();
            for (String name : uris) {
                File file = new File(this._targetPath, name);
                if (file.exists()) {
                    existing.add(file);
                    continue;
                }
                valid = false;
            }
            if (!valid) {
                this._deleteAll(existing);
                Map<?, Entry> map = cache;
                synchronized (map) {
                    if (cache.get(key) == entry) {
                        cache.remove(key);
                    }
                }
                return null;
            }
        }
        return entry;
    }

    private Entry _createEntry(StyleContext context, StyleSheetDocument document, Hashtable<Key, Entry> cache, Key key, Hashtable<Object, Entry> entryCache, Map<String, String> shortStyleClassMap, String[] namespacePrefixes, boolean checkModified) {
        StyleNode[] styles = this._getStyleContextResolvedStyles(context, document);
        if (styles == null) {
            return null;
        }
        List<String> uris = this._createStyleSheetFiles(context, document, styles, shortStyleClassMap, namespacePrefixes, checkModified);
        _LOG.fine("Finished processing stylesheet {0}", uris);
        ConcurrentMap<String, Icon> icons = this._getStyleContextResolvedIcons(context, document);
        ConcurrentMap<Object, Object> skinProperties = this._getStyleContextResolvedSkinProperties(context, document);
        Entry entry = new Entry(uris, new StyleMapImpl(), icons, skinProperties);
        cache.put(key, entry);
        DerivationKey derivationKey = this._getDerivationKey(context, document);
        entryCache.put(derivationKey, entry);
        return entry;
    }

    private Entry _getCompatibleEntry(StyleContext context, StyleSheetDocument document, Map<Key, Entry> cache, Key key, Map<Object, Entry> entryCache, boolean checkModified) {
        DerivationKey derivationKey = this._getDerivationKey(context, document);
        Entry entry = this._getEntry(entryCache, derivationKey, checkModified);
        if (entry != null) {
            cache.put(key, entry);
        }
        return entry;
    }

    private DerivationKey _getDerivationKey(StyleContext context, StyleSheetDocument document) {
        Object[] styleSheets;
        Iterator<StyleSheetNode> e = document.getStyleSheets(context);
        Vector<StyleSheetNode> v = this._copyIterator(e);
        if (v == null) {
            styleSheets = new StyleSheetNode[]{};
        } else {
            styleSheets = new StyleSheetNode[v.size()];
            v.copyInto(styleSheets);
        }
        return new DerivationKey(context, (StyleSheetNode[])styleSheets);
    }

    private StyleSheetDocument _getStyleSheetDocument(StyleContext context) {
        StyleSheetDocument document = this._document;
        if (document != null) {
            return document;
        }
        document = this.createStyleSheetDocument(context);
        if (document == null) {
            document = _EMPTY_DOCUMENT;
        }
        if (this._document == null) {
            this._document = document;
        }
        this._namespacePrefixes = FileSystemStyleCache._getNamespacePrefixes(context, this._document);
        this._shortStyleClassMap = FileSystemStyleCache._getShortStyleClassMap(context, this._document, this._namespacePrefixes);
        return document;
    }

    private StyleNode[] _getStyleContextResolvedStyles(StyleContext context, StyleSheetDocument document) {
        Iterator<StyleNode> e = document.getStyles(context);
        if (e == null || !e.hasNext()) {
            if (_LOG.isWarning()) {
                _LOG.warning("NO_STYLES_FOUND_CONTEXT", (Object)context);
            }
            return null;
        }
        ArrayList<StyleNode> v = new ArrayList<StyleNode>();
        while (e.hasNext()) {
            v.add(e.next());
        }
        return v.toArray(new StyleNode[v.size()]);
    }

    private ConcurrentMap<Object, Object> _getStyleContextResolvedSkinProperties(StyleContext context, StyleSheetDocument document) {
        Iterator<StyleSheetNode> styleSheetNodes = document.getStyleSheets(context);
        ConcurrentHashMap<Object, Object> skinProperties = new ConcurrentHashMap<Object, Object>();
        while (styleSheetNodes.hasNext()) {
            StyleSheetNode styleSheetNode = styleSheetNodes.next();
            Collection<SkinPropertyNode> skinPropertyNodes = styleSheetNode.getSkinProperties();
            if (skinPropertyNodes == null) continue;
            for (SkinPropertyNode skinPropertyNode : skinPropertyNodes) {
                skinProperties.put(skinPropertyNode.getKey(), skinPropertyNode.getValue());
            }
        }
        return skinProperties;
    }

    private ConcurrentMap<String, Icon> _getStyleContextResolvedIcons(StyleContext context, StyleSheetDocument document) {
        Iterator<StyleSheetNode> styleSheetNodes = document.getStyleSheets(context);
        ConcurrentHashMap<String, Icon> icons = new ConcurrentHashMap<String, Icon>();
        while (styleSheetNodes.hasNext()) {
            StyleSheetNode styleSheetNode = styleSheetNodes.next();
            Collection<IconNode> iconNodes = styleSheetNode.getIcons();
            if (iconNodes == null) continue;
            for (IconNode iconNode : iconNodes) {
                icons.put(iconNode.getIconName(), iconNode.getIcon());
            }
        }
        return icons;
    }

    private List<String> _createStyleSheetFiles(StyleContext context, StyleSheetDocument document, StyleNode[] styles, Map<String, String> shortStyleClassMap, String[] namespacePrefixes, boolean checkModified) {
        File outputDir;
        List<File> outputFiles = this._getOutputFiles(context, document);
        if (!outputFiles.isEmpty()) {
            if (checkModified) {
                if (!this._checkSourceModified(document, outputFiles.get(0))) {
                    return this._getFileNames(outputFiles);
                }
                this._deleteAll(outputFiles);
            } else {
                return this._getFileNames(outputFiles);
            }
        }
        if (!(outputDir = new File(this._targetPath)).exists()) {
            outputDir.mkdirs();
        }
        Skin skin = RenderingContext.getCurrentInstance().getSkin();
        boolean compressStyles = this._isCompressStyles(skin);
        StyleWriterFactoryImpl writerFactory = new StyleWriterFactoryImpl(this._targetPath, this.getTargetStyleSheetName(context, document));
        CSSGenerationUtils.writeCSS(context, skin.getStyleSheetName(), styles, writerFactory, compressStyles, shortStyleClassMap, namespacePrefixes, _STYLE_KEY_MAP);
        writerFactory.close();
        return this._getFileNames(writerFactory.getFiles());
    }

    private File _getOutputFile(String name, int number) {
        assert (number >= 1);
        if (number == 1) {
            return new File(this._targetPath, name);
        }
        int index = name.lastIndexOf(".");
        if (index < 0) {
            return new File(this._targetPath, name + number);
        }
        return new File(this._targetPath, new StringBuilder(name.length() + 2).append(name.substring(0, index)).append(number).append(name.substring(index)).toString());
    }

    private void _deleteAll(Iterable<File> files) {
        for (File file : files) {
            if (!file.exists()) continue;
            file.delete();
        }
    }

    private boolean _isCompressStyles(Skin skin) {
        if (skin == null) {
            skin = RenderingContext.getCurrentInstance().getSkin();
        }
        String disableContentCompression = FacesContext.getCurrentInstance().getExternalContext().getInitParameter("org.apache.myfaces.trinidad.DISABLE_CONTENT_COMPRESSION");
        boolean isPortletSkin = "portlet".equals(skin.getRenderKitId());
        return !"true".equals(disableContentCompression) && !isPortletSkin;
    }

    private List<String> _getFileNames(List<File> files) {
        ArrayList<String> names = new ArrayList<String>(files.size());
        for (File file : files) {
            names.add(file.getName());
        }
        return Collections.unmodifiableList(names);
    }

    private List<File> _getOutputFiles(StyleContext context, StyleSheetDocument document) {
        File f;
        LinkedList<File> files = new LinkedList<File>();
        String name = this.getTargetStyleSheetName(context, document);
        int i = 1;
        while ((f = this._getOutputFile(name, i)).exists()) {
            files.add(f);
            ++i;
        }
        return files;
    }

    private PrintWriter _getWriter(File file) {
        PrintWriter out = null;
        try {
            File parentFile = file.getParentFile();
            if (parentFile != null) {
                parentFile.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter writer = null;
            try {
                writer = new OutputStreamWriter((OutputStream)fos, _UTF8_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                assert (false);
                writer = new OutputStreamWriter(fos);
            }
            out = new PrintWriter(new BufferedWriter(writer));
        }
        catch (IOException e) {
            if (_LOG.isWarning()) {
                _LOG.warning("IOEXCEPTION_OPENNING_FILE", (Object)file);
            }
            _LOG.warning((Throwable)e);
        }
        return out;
    }

    private boolean _checkSourceModified(StyleSheetDocument document, File outputFile) {
        assert (outputFile != null);
        return document.getDocumentTimestamp() > outputFile.lastModified();
    }

    private InputStreamProvider _getInputStreamProvider() {
        File sourceFile = this._sourceFile;
        if (sourceFile == null) {
            return null;
        }
        assert (this._resolver != null);
        try {
            return this._resolver.getProvider(sourceFile.getPath());
        }
        catch (IOException e) {
            if (_LOG.isWarning()) {
                _LOG.warning((Throwable)e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initResolver() {
        FileSystemStyleCache fileSystemStyleCache = this;
        synchronized (fileSystemStyleCache) {
            if (this._resolver == null) {
                NameResolver resolver = new DefaultNameResolver(this._sourceFile, null);
                resolver = new CachingNameResolver(resolver, new Hashtable<Object, InputStreamProvider>(17), true);
                this._resolver = resolver;
            }
        }
    }

    private <T> Vector<T> _copyIterator(Iterator<T> e) {
        if (e == null) {
            return null;
        }
        Vector<T> v = new Vector<T>();
        while (e.hasNext()) {
            v.addElement(e.next());
        }
        return v;
    }

    private static String[] _getNamespacePrefixes(StyleContext context, StyleSheetDocument document) {
        assert (document != null);
        Iterator<StyleSheetNode> styleSheets = document.getStyleSheets(context);
        assert (styleSheets != null);
        HashSet<String> namespacePrefixesSet = new HashSet<String>();
        while (styleSheets.hasNext()) {
            StyleSheetNode styleSheet = styleSheets.next();
            Collection<StyleNode> styles = styleSheet.getStyles();
            assert (styles != null);
            for (StyleNode style : styles) {
                String selector = style.getSelector();
                if (selector == null) continue;
                CSSGenerationUtils.getNamespacePrefixes(namespacePrefixesSet, selector);
            }
        }
        return namespacePrefixesSet.toArray(_EMPTY_STRING_ARRAY);
    }

    private static Map<String, String> _getShortStyleClassMap(StyleContext context, StyleSheetDocument document, String[] namespacePrefixes) {
        HashMap<String, String> map = new HashMap<String, String>();
        assert (document != null);
        Iterator<StyleSheetNode> styleSheets = document.getStyleSheets(context);
        assert (styleSheets != null);
        HashSet<String> emptySelectors = new HashSet<String>();
        HashSet<String> nonEmptySelectors = new HashSet<String>(512);
        while (styleSheets.hasNext()) {
            StyleSheetNode styleSheet = styleSheets.next();
            Collection<StyleNode> styles = styleSheet.getStyles();
            assert (styles != null);
            for (StyleNode style : styles) {
                String selector = style.getSelector();
                if (selector == null) continue;
                if (CSSGenerationUtils.isSingleStyleClassSelector(selector)) {
                    String styleClass = selector.substring(1);
                    FileSystemStyleCache._putStyleClassInShortMap(styleClass, map);
                    if (styleClass != null && !styleClass.startsWith("p_AF") && !map.containsKey(styleClass)) {
                        map.put(styleClass, FileSystemStyleCache._getShortStyleClass(map.size()));
                    }
                    if (style.isEmpty()) {
                        emptySelectors.add(styleClass);
                        continue;
                    }
                    nonEmptySelectors.add(styleClass);
                    continue;
                }
                Iterator<String> styleClasses = CSSGenerationUtils.getStyleClasses(selector);
                if (styleClasses != null) {
                    while (styleClasses.hasNext()) {
                        String styleClass = styleClasses.next();
                        FileSystemStyleCache._putStyleClassInShortMap(styleClass, map);
                        nonEmptySelectors.add(styleClass);
                    }
                }
                for (String nsPrefix : namespacePrefixes) {
                    Iterator<String> afSelectors = CSSGenerationUtils.getNamespacedSelectors(selector, nsPrefix, _STYLE_KEY_MAP);
                    if (afSelectors == null) continue;
                    boolean isFirst = true;
                    while (afSelectors.hasNext()) {
                        String styleClass = afSelectors.next();
                        FileSystemStyleCache._putStyleClassInShortMap(styleClass, map);
                        if (isFirst && !afSelectors.hasNext() && style.isEmpty()) {
                            emptySelectors.add(styleClass);
                        } else {
                            nonEmptySelectors.add(styleClass);
                        }
                        isFirst = false;
                    }
                }
            }
        }
        emptySelectors.removeAll(nonEmptySelectors);
        for (String emptyKey : emptySelectors) {
            map.put(emptyKey, "");
        }
        return Collections.unmodifiableMap(map);
    }

    private static void _putStyleClassInShortMap(String styleClass, Map map) {
        if (styleClass != null && !styleClass.startsWith("p_AF") && !map.containsKey(styleClass)) {
            map.put(styleClass, FileSystemStyleCache._getShortStyleClass(map.size()));
        }
    }

    private static String _getShortStyleClass(int count) {
        return _SHORT_CLASS_PREFIX + Integer.toString(count, 36);
    }

    static {
        _STYLE_KEY_MAP.put("af|body", "BODY");
        _STYLE_KEY_MAP.put("af|panelHeader::level-one", "H1.af|panelHeader");
        _STYLE_KEY_MAP.put("af|panelHeader::level-two", "H2.af|panelHeader");
        _STYLE_KEY_MAP.put("af|panelHeader::level-three", "H3.af|panelHeader");
        _STYLE_KEY_MAP.put("af|panelHeader::level-four", "H4.af|panelHeader");
        _STYLE_KEY_MAP.put("af|panelHeader::level-five", "H5.af|panelHeader");
        _STYLE_KEY_MAP.put("af|panelHeader::level-six", "H6.af|panelHeader");
        _STYLE_KEY_MAP.put("af|showDetailHeader::level-one", "H1.af|showDetailHeader");
        _STYLE_KEY_MAP.put("af|showDetailHeader::level-two", "H2.af|showDetailHeader");
        _STYLE_KEY_MAP.put("af|showDetailHeader::level-three", "H3.af|showDetailHeader");
        _STYLE_KEY_MAP.put("af|showDetailHeader::level-four", "H4.af|showDetailHeader");
        _STYLE_KEY_MAP.put("af|showDetailHeader::level-five", "H5.af|showDetailHeader");
        _STYLE_KEY_MAP.put("af|showDetailHeader::level-six", "H6.af|showDetailHeader");
        _STYLE_KEY_MAP.put("af|menuTabs::selected-link", "af|menuTabs::selected A");
        _STYLE_KEY_MAP.put("af|menuTabs::enabled-link", "af|menuTabs::enabled A");
        _STYLE_KEY_MAP.put("af|menuBar::enabled-link", "af|menuBar::enabled A");
        _STYLE_KEY_MAP.put("af|menuBar::selected-link", "af|menuBar::selected A");
        _STYLE_KEY_MAP.put("OraLinkEnabledLink", "OraLinkEnabled A:link");
        _STYLE_KEY_MAP.put("OraLinkSelectedLink", "OraLinkSelected A:link");
        _STYLE_KEY_MAP.put("OraLinkEnabledActive", "OraLinkEnabled A:active");
        _STYLE_KEY_MAP.put("OraLinkSelectedActive", "OraLinkSelected A:active");
        _STYLE_KEY_MAP.put("OraLinkEnabledVisited", "OraLinkEnabled A:visited");
        _STYLE_KEY_MAP.put("OraLinkSelectedVisited", "OraLinkSelected A:visited");
        _STYLE_KEY_MAP.put("af|panelPage::about-link", "af|panelPage::about A");
        _STYLE_KEY_MAP.put("af|panelPage::copyright-link", "af|panelPage::copyright A");
        _STYLE_KEY_MAP.put("af|panelPage::privacy-link", "af|panelPage::privacy A");
        _STYLE_KEY_MAP.put("af|panelList::link", "af|panelList A");
        _STYLE_KEY_MAP.put("af|panelList::unordered-list", "af|panelList UL");
        _STYLE_KEY_MAP.put("af|inputDate::nav-link", "af|inputDate::nav A");
        _STYLE_KEY_MAP.put("af|inputDate::content-link", "af|inputDate::content A");
        _STYLE_KEY_MAP.put("af|inputDate::disabled-link", "af|inputDate::disabled A");
        _STYLE_KEY_MAP.put("af|chooseDate::nav-link", "af|chooseDate::nav A");
        _STYLE_KEY_MAP.put("af|chooseDate::content-link", "af|chooseDate::content A");
        _STYLE_KEY_MAP.put("af|showManyAccordion::title-link", "A.af|showManyAccordion::title-link");
        _STYLE_KEY_MAP.put("af|showManyAccordion::title-disabled-link", "A.af|showManyAccordion::title-disabled-link");
        _STYLE_KEY_MAP.put("af|showOneAccordion::title-link", "A.af|showOneAccordion::title-link");
        _STYLE_KEY_MAP.put("af|showOneAccordion::title-disabled-link", "A.af|showOneAccordion::title-disabled-link");
        _STYLE_KEY_MAP.put("af|panelAccordion::title-link", "A.af|panelAccordion::title-link");
        _STYLE_KEY_MAP.put("af|panelAccordion::title-disabled-link", "A.af|panelAccordion::title-disabled-link");
        _STYLE_KEY_MAP.put("af|panelTabbed::tab-link", "af|panelTabbed::tab A");
        _STYLE_KEY_MAP.put("af|panelTabbed::tab-selected-link", "af|panelTabbed::tab-selected A");
        _EMPTY_STRING_ARRAY = new String[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StyleWriterFactoryImpl
    implements StyleWriterFactory {
        private String _outputDirectory;
        private String _baseFilename;
        private PrintWriter _out;
        private List<File> _files = new LinkedList<File>();

        StyleWriterFactoryImpl(String outputDirectory, String baseName) {
            this._outputDirectory = outputDirectory;
            this._baseFilename = baseName;
        }

        List<File> getFiles() {
            return this._files;
        }

        @Override
        public PrintWriter createWriter() {
            if (this._out != null) {
                this._out.close();
            }
            File outputFile = FileSystemStyleCache.this._getOutputFile(this._baseFilename, this._files.size() + 1);
            outputFile.setReadOnly();
            this._files.add(outputFile);
            this._out = FileSystemStyleCache.this._getWriter(outputFile);
            return this._out;
        }

        void close() {
            if (this._out != null) {
                this._out.close();
                this._out = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StyleMapImpl
    implements StyleMap {
        private Hashtable<String, Style> _selectorMap;
        private Hashtable<String, Style> _classMap;
        private Hashtable<String, Style> _nameMap;

        private StyleMapImpl() {
        }

        @Override
        public Style getStyleBySelector(StyleContext context, String selector) {
            if (this._selectorMap == null) {
                this._selectorMap = this._createMap();
            }
            return this._getStyle(context, this._selectorMap, selector, "", false);
        }

        @Override
        public Style getStyleByClass(StyleContext context, String styleClass) {
            if (this._classMap == null) {
                this._classMap = this._createMap();
            }
            String prefix = styleClass.indexOf(124) > -1 ? "" : ".";
            return this._getStyle(context, this._classMap, styleClass, prefix, false);
        }

        @Override
        public Style getStyleByName(StyleContext context, String name) {
            if (this._nameMap == null) {
                this._nameMap = this._createMap();
            }
            return this._getStyle(context, this._nameMap, name, "", true);
        }

        private Style _getStyle(StyleContext context, Map<String, Style> map, String id, String prefix, boolean isName) {
            CSSStyle style = (CSSStyle)map.get(id);
            if (style == _MISS) {
                return null;
            }
            if (style != null) {
                return style;
            }
            StyleSheetDocument document = FileSystemStyleCache.this.__getStyleSheetDocument();
            if (document == null) {
                return null;
            }
            StyleNode styleNode = null;
            styleNode = isName ? document.getStyleByName(context, id) : document.getStyleBySelector(context, prefix + id);
            if (styleNode == null) {
                map.put(id, _MISS);
                return null;
            }
            style = new CSSStyle();
            Collection<PropertyNode> propertyNodeList = styleNode.getProperties();
            for (PropertyNode property : propertyNodeList) {
                String name = property.getName();
                String value = property.getValue();
                style.setProperty(name, value);
            }
            map.put(id, style);
            return style;
        }

        private Hashtable<String, Style> _createMap() {
            return new Hashtable<String, Style>(19);
        }
    }

    private static class DerivationKey {
        private boolean _noHash = false;
        private int _hashCode;
        private StyleSheetNode[] _styleSheets;
        private boolean _portlet;
        private boolean _short;

        public DerivationKey(StyleContext context, StyleSheetNode[] styleSheets) {
            this._styleSheets = new StyleSheetNode[styleSheets.length];
            System.arraycopy(styleSheets, 0, this._styleSheets, 0, styleSheets.length);
            this._short = true;
            this._portlet = context.isPortletMode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o.hashCode() == this.hashCode() && o instanceof DerivationKey) {
                DerivationKey key = (DerivationKey)o;
                if (this._short != key._short || this._portlet != key._portlet || this._styleSheets.length != key._styleSheets.length) {
                    return false;
                }
                for (int i = this._styleSheets.length - 1; i >= 0; --i) {
                    if (this._styleSheets[i].equals(key._styleSheets[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            if (this._noHash) {
                this._hashCode = Arrays.hashCode(this._styleSheets) ^ (this._short ? 1 : 0) ^ (this._portlet ? 1 : 0);
                this._noHash = false;
            }
            return this._hashCode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry {
        public final List<String> uris;
        public final StyleMap map;
        public final ConcurrentMap<String, Icon> icons;
        public final ConcurrentMap<Object, Object> skinProperties;

        public Entry(List<String> uris, StyleMap map, ConcurrentMap<String, Icon> icons, ConcurrentMap<Object, Object> skinProperties) {
            this.uris = uris;
            this.map = map;
            this.icons = icons;
            this.skinProperties = skinProperties;
        }
    }

    private static class Key {
        private boolean _noHash = true;
        private int _hashCode;
        private Locale _locale;
        private int _direction;
        private int _browser;
        private String _version;
        private int _platform;
        private boolean _short;
        private AccessibilityProfile _accProfile;
        private boolean _portlet;

        public Key(StyleContext context) {
            TrinidadAgent agent = context.getAgent();
            LocaleContext localeContext = context.getLocaleContext();
            AccessibilityProfile accProfile = context.getAccessibilityProfile();
            this._init(localeContext.getTranslationLocale(), LocaleUtils.getReadingDirection(localeContext), agent.getAgentApplication(), agent.getAgentVersion(), agent.getAgentOS(), true, accProfile, context.isPortletMode());
        }

        public int hashCode() {
            if (this._noHash) {
                this._hashCode = this._locale.hashCode() ^ this._direction ^ this._browser << 2 ^ this._version.hashCode() ^ this._platform << 8 ^ (this._short ? 1 : 0) ^ this._accProfile.hashCode() ^ (this._portlet ? 1 : 0);
                this._noHash = false;
            }
            return this._hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o.hashCode() == this.hashCode() && o instanceof Key) {
                Key key = (Key)o;
                return this._short == key._short && this._portlet == key._portlet && this._direction == key._direction && this._browser == key._browser && this._platform == key._platform && this._version.equals(key._version) && this._locale.equals(key._locale) && this._accProfile.equals(key._accProfile);
            }
            return false;
        }

        private void _init(Locale locale, int direction, int browser, String version, int platform, boolean useShort, AccessibilityProfile accessibilityProfile, boolean portlet) {
            this._locale = locale == null ? Locale.getDefault() : locale;
            this._direction = direction == 0 ? LocaleUtils.getReadingDirectionForLocale(this._locale) : direction;
            this._browser = browser;
            this._version = version;
            this._platform = platform;
            this._short = useShort;
            this._accProfile = accessibilityProfile;
            this._portlet = portlet;
        }
    }
}

