/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.util.nls;

import java.util.Locale;
import org.apache.myfaces.trinidad.context.LocaleContext;

public final class LocaleUtils {
    public static final int DIRECTION_DEFAULT = 0;
    public static final int DIRECTION_LEFTTORIGHT = 1;
    public static final int DIRECTION_RIGHTTOLEFT = 2;

    public static int getReadingDirection(LocaleContext localeContext) {
        return localeContext.isRightToLeft() ? 2 : 1;
    }

    public static int getReadingDirectionForLocale(Locale loc) {
        String language;
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if ((language = loc.getLanguage()).equals("ar") || language.equals("he") || language.equals("iw")) {
            return 2;
        }
        return 1;
    }

    public static Locale getLocaleForIANAString(String ianaString) {
        String language;
        if (ianaString == null || "".equals(ianaString)) {
            return null;
        }
        String country = "";
        String variant = "";
        int dashIndex = ianaString.indexOf(45);
        if (dashIndex < 0) {
            language = ianaString;
        } else {
            language = ianaString.substring(0, dashIndex);
            int start = dashIndex + 1;
            if ((dashIndex = ianaString.indexOf(45, start)) < 0) {
                country = ianaString.substring(start);
            } else {
                country = ianaString.substring(start, dashIndex);
                variant = ianaString.substring(dashIndex + 1);
            }
        }
        return new Locale(language, country, variant);
    }
}

