/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.webapp;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidadinternal.config.GlobalConfiguratorImpl;
import org.apache.myfaces.trinidadinternal.config.dispatch.DispatchResponseConfiguratorImpl;
import org.apache.myfaces.trinidadinternal.config.dispatch.DispatchServletResponse;
import org.apache.myfaces.trinidadinternal.config.upload.FileUploadConfiguratorImpl;
import org.apache.myfaces.trinidadinternal.config.upload.UploadRequestWrapper;
import org.apache.myfaces.trinidadinternal.config.xmlHttp.XmlHttpConfigurator;
import org.apache.myfaces.trinidadinternal.context.external.ServletExternalContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderKit;
import org.apache.myfaces.trinidadinternal.webapp.PseudoFacesContext;
import org.apache.myfaces.trinidadinternal.webapp.ReplaceParametersRequestWrapper;

public class TrinidadFilterImpl
implements Filter {
    private ServletContext _servletContext;
    private List<Filter> _filters = null;
    private static final String _IS_RETURNING_KEY = "org.apache.myfaces.trinidadinternal.webapp.AdfacesFilterImpl.IS_RETURNING";
    private static final String _FILTER_EXECUTED_KEY = "org.apache.myfaces.trinidadinternal.webapp.AdfacesFilterImpl.EXECUTED";
    private static ThreadLocal<PseudoFacesContext> _PSEUDO_FACES_CONTEXT = new ThreadLocal();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(TrinidadFilterImpl.class);

    public static void verifyFilterIsInstalled(FacesContext context) {
        Object isInstalled = context.getExternalContext().getRequestMap().get(_FILTER_EXECUTED_KEY);
        if (!Boolean.TRUE.equals(isInstalled)) {
            _LOG.warning("REQUIRED_TRINIDADFILTER_NOT_INSTALLED");
        }
    }

    public static FacesContext getPseudoFacesContext() {
        return _PSEUDO_FACES_CONTEXT.get();
    }

    public static boolean isExecutingDialogReturn(FacesContext context) {
        return Boolean.TRUE.equals(context.getExternalContext().getRequestMap().get(_IS_RETURNING_KEY));
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this._servletContext = filterConfig.getServletContext();
        this._filters = ClassLoaderUtils.getServices((String)TrinidadFilterImpl.class.getName());
        for (Filter f : this._filters) {
            f.init(filterConfig);
        }
    }

    public void destroy() {
        for (Filter f : this._filters) {
            f.destroy();
        }
        this._filters = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this._filters.isEmpty()) {
            chain = new FilterListChain(this._filters, chain);
        }
        request.setAttribute(_FILTER_EXECUTED_KEY, (Object)Boolean.TRUE);
        ServletExternalContext externalContext = new ServletExternalContext(this._servletContext, (ServletRequest)request, response);
        GlobalConfiguratorImpl config = GlobalConfiguratorImpl.getInstance();
        config.beginRequest(externalContext);
        Map<String, String[]> addedParams = FileUploadConfiguratorImpl.getAddedParameters(externalContext);
        if (addedParams != null) {
            FileUploadConfiguratorImpl.apply(externalContext);
            request = new UploadRequestWrapper((HttpServletRequest)request, addedParams);
        }
        try {
            this._doFilterImpl((ServletRequest)request, response, chain);
        }
        catch (Throwable t) {
            boolean isPartialRequest = addedParams != null ? CoreRenderKit.isPartialRequest(addedParams) : CoreRenderKit.isPartialRequest(externalContext);
            if (isPartialRequest) {
                XmlHttpConfigurator.handleError(externalContext, t);
            } else {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof ServletException) {
                    throw (ServletException)t;
                }
                _LOG.severe(t);
            }
        }
        finally {
            config.endRequest(externalContext);
        }
    }

    private void _doFilterImpl(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ServletExternalContext ec = new ServletExternalContext(this._servletContext, (ServletRequest)request, response);
        DispatchServletResponse dispatch = new DispatchServletResponse(ec);
        DispatchResponseConfiguratorImpl.apply(ec);
        this._invokeDoFilter((ServletRequest)request, (ServletResponse)dispatch, chain);
        Map launchParameters = (Map)request.getAttribute("org.apache.myfaces.trinidad.PageFlowSourceParameters");
        if (launchParameters != null) {
            request.removeAttribute("org.apache.myfaces.trinidad.PageFlowSourceParameters");
            request.setAttribute(_IS_RETURNING_KEY, (Object)Boolean.TRUE);
            request = new ReplaceParametersRequestWrapper((HttpServletRequest)request, launchParameters);
            this._invokeDoFilter((ServletRequest)request, (ServletResponse)dispatch, chain);
            request.removeAttribute(_IS_RETURNING_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _invokeDoFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        PseudoFacesContext pfc = new PseudoFacesContext(new ServletExternalContext(this._servletContext, request, response));
        _PSEUDO_FACES_CONTEXT.set(pfc);
        try {
            chain.doFilter(request, response);
        }
        finally {
            _PSEUDO_FACES_CONTEXT.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FilterListChain
    implements FilterChain {
        private final List<Filter> _filters;
        private final FilterChain _last;
        private final int _index;

        public FilterListChain(List<Filter> filters, FilterChain last) {
            this(filters, last, 0);
        }

        private FilterListChain(List<Filter> filters, FilterChain last, int index) {
            assert (index < filters.size());
            this._filters = filters;
            this._last = last;
            this._index = index;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            int nextIndex = this._index + 1;
            FilterChain next = nextIndex < this._filters.size() ? new FilterListChain(this._filters, this._last, nextIndex) : this._last;
            this._filters.get(this._index).doFilter(request, response, next);
        }
    }
}

