function TrNumberFormat(a0)
{
if(!a0)
alert("type for TrNumberFormat not defined!");
this._type=a0;
this._pPre=getLocaleSymbols().getPositivePrefix();
this._pSuf=getLocaleSymbols().getPositiveSuffix();
this._nPre=getLocaleSymbols().getNegativePrefix();
this._nSuf=getLocaleSymbols().getNegativeSuffix();
this._maxFractionDigits=3;
this._maxIntegerDigits=40;
this._minFractionDigits=0;
this._minIntegerDigits=1;
this._groupingUsed=true;
}
TrNumberFormat.getNumberInstance=function()
{
return new TrNumberFormat("number");
}
TrNumberFormat.getCurrencyInstance=function()
{
return new TrNumberFormat("currency");
}
TrNumberFormat.getPercentInstance=function()
{
return new TrNumberFormat("percent");
}
TrNumberFormat.prototype.setGroupingUsed=function(a1)
{
this._groupingUsed=a1;
}
TrNumberFormat.prototype.isGroupingUsed=function()
{
return this._groupingUsed;
}
TrNumberFormat.prototype.setMaximumIntegerDigits=function(a2)
{
if(a2)
{
this._maxIntegerDigits=a2<0?0:a2;
if(this._minIntegerDigits>this._maxIntegerDigits)
{
this._minIntegerDigits=this._maxIntegerDigits;
}
}
}
TrNumberFormat.prototype.getMaximumIntegerDigits=function()
{
return this._maxIntegerDigits;
}
TrNumberFormat.prototype.setMaximumFractionDigits=function(a3)
{
if(a3)
{
this._maxFractionDigits=a3<0?0:a3;
if(this._maxFractionDigits<this._minFractionDigits)
{
this._minFractionDigits=this._maxFractionDigits;
}
}
}
TrNumberFormat.prototype.getMaximumFractionDigits=function()
{
return this._maxFractionDigits;
}
TrNumberFormat.prototype.setMinimumIntegerDigits=function(a4)
{
if(a4)
{
this._minIntegerDigits=a4<0?0:a4;
if(this._minIntegerDigits>this._maxIntegerDigits)
{
this._maxIntegerDigits=this._minIntegerDigits;
}
}
}
TrNumberFormat.prototype.getMinimumIntegerDigits=function()
{
return this._minIntegerDigits;
}
TrNumberFormat.prototype.setMinimumFractionDigits=function(a5)
{
if(a5)
{
this._minFractionDigits=a5<0?0:a5;
if(this._maxFractionDigits<this._minFractionDigits)
{
this._maxFractionDigits=this._minFractionDigits;
}
}
}
TrNumberFormat.prototype.getMinimumFractionDigits=function()
{
return this._minFractionDigits;
}
TrNumberFormat.prototype.format=function(a6)
{
if(this._type=="percent")
return this.percentageToString(a6);
else if(this._type=="currency")
return this.currencyToString(a6);
else if(this._type=="number")
return this.numberToString(a6);
}
TrNumberFormat.prototype.parse=function(a7)
{
if(this._type=="percent")
return this.stringToPercentage(a7);
else if(this._type=="currency")
return this.stringToCurrency(a7);
}
TrNumberFormat.prototype.stringToCurrency=function(a8)
{
var a9=a8.indexOf(this._nPre);
if(a9!=-1)
{
a8=a8.substr(this._nPre.length,a8.length);
var a10=a8.indexOf(this._nSuf);
if(a10!=-1)
{
a8=a8.substr(0,a8.length-this._nSuf.length);
return(parseFloat(a8)*-1);
}
else
{
throw new TrParseException("not able to parse number");
}
}
else
{
var a11=a8.indexOf(this._pPre);
if(a11!=-1)
{
a8=a8.substr(this._pPre.length,a8.length);
var a12=a8.indexOf(this._pSuf);
if(a12!=-1)
{
a8=a8.substr(0,a8.length-this._pSuf.length);
a8=parseFloat(a8);
}
else
{
throw new TrParseException("not able to parse number");
}
return a8;
}
else
{
throw new TrParseException("not able to parse number");
}
}
}
TrNumberFormat.prototype.stringToPercentage=function(a13)
{
var a14=(a13.indexOf('%')!=-1);
var a15=a13.replace(/\%/g,'');
a15=parseFloat(a15);
if(!a14||isNaN(a15))
{
throw new TrParseException("not able to parse number");
}
return a15;
}
TrNumberFormat.prototype.numberToString=function(a16)
{
var a17=a16<0;
if(a17)
a16=(a16*-1);
var a18=a16+"";
var a19=a18.indexOf(".");
var a20=a18.length;
var a21;
var a22;
if(a19!=-1)
{
a21=a18.substring(0,a19);
a22=a18.substring(a19+1,a20);
}
else
{
a21=a18;
a22="";
}
a21=this._formatIntegers(a21);
a22=this._formatFractions(a22)
var a23=getLocaleSymbols().getDecimalSeparator();
if(a22!="")
a18=(a21+a23+a22);
else
a18=(a21);
if(a17)
a18="-"+a18;
return a18;
}
TrNumberFormat.prototype.currencyToString=function(a24)
{
if(a24<0)
{
a24=(a24*-1)+"";
a24=this.numberToString(a24);
return this._nPre+a24+this._nSuf;
}
else
{
a24=this.numberToString(a24);
return this._pPre+a24+this._pSuf;
}
}
TrNumberFormat.prototype.percentageToString=function(a25)
{
a25=a25*100;
a25=this.getRounded(a25);
if(isNaN(a25))
{
throw new TrParseException("not able to parse number");
}
a25=this.numberToString(a25);
return a25+'%';
}
TrNumberFormat.prototype.getRounded=function(a26)
{
a26=this.moveDecimalRight(a26);
a26=Math.round(a26);
a26=this.moveDecimalLeft(a26);
return a26;
}
TrNumberFormat.prototype.moveDecimalRight=function(a27)
{
var a28='';
a28=this.moveDecimal(a27,false);
return a28;
}
TrNumberFormat.prototype.moveDecimalLeft=function(a29)
{
var a30='';
a30=this.moveDecimal(a29,true);
return a30;
}
TrNumberFormat.prototype.moveDecimal=function(a31,a32)
{
var a33='';
a33=this.moveDecimalAsString(a31,a32);
return parseFloat(a33);
}
TrNumberFormat.prototype.moveDecimalAsString=function(a34,a35)
{
var a36=2;
if(a36<=0)
return a34;
var a37=a34+'';
var a38=this.getZeros(a36);
var a39=new RegExp('([0-9.]+)');
if(a35)
{
a37=a37.replace(a39,a38+'$1');
var a40=new RegExp('(-?)([0-9]*)([0-9]{'+a36+'})(\\.?)');
a37=a37.replace(a40,'$1$2.$3');
}
else
{
var a41=a39.exec(a37);
if(a41!=null)
{
a37=a37.substring(0,a41.index)+a41[1]+a38+a37.substring(a41.index+a41[0].length);
}
var a40=new RegExp('(-?)([0-9]*)(\\.?)([0-9]{'+a36+'})');
a37=a37.replace(a40,'$1$2$4.');
}
a37=a37.replace(/\.$/,'');
return a37;
}
TrNumberFormat.prototype.getZeros=function(a42)
{
var a43='';
var a44;
for(a44=0;a44<a42;a44++){
a43+='0';
}
return a43;
}
TrNumberFormat.prototype._formatIntegers=function(a45)
{
var a46=a45.length;
var a47=this.getMaximumIntegerDigits();
var a48=this.getMinimumIntegerDigits();
var a49;
if(a46>a47)
{
a49=a46-a47;
a45=a45.substring(a49,a46);
}
else if(a46<a48)
{
a49=a48-a46;
var a50="";
while(a49>0)
{
a50="0"+a50;
--a49;
}
a45=a50+a45;
}
if(this.isGroupingUsed())
{
a45=this._addGroupingSeparators(a45);
}
return a45;
}
TrNumberFormat.prototype._formatFractions=function(a51)
{
var a52=a51.length;
var a53=this.getMaximumFractionDigits();
var a54=this.getMinimumFractionDigits();
if(a52>a53&&a53>a54)
{
a51=a51.substring(0,a53);
}
if(a52<a54)
{
var a55=a54-a52;
while(a55>0)
{
a51=a51+"0";
--a55;
}
}
return a51;
}
TrNumberFormat.prototype._addGroupingSeparators=function(a56)
{
var a57=a56.length;
var a58=a57%3;
var a59;
var a60;
var a61="";
if(a58>0)
{
a59=a56.substring(0,a58);
a60=a56.substring(a58,a57);
}
else
{
a59="";
a60=a56;
}
var a62=getLocaleSymbols().getGroupingSeparator();
for(i=0;i<a60.length;i++)
{
if(i%3==0&&i!=0)
{
a61+=a62;
}
a61+=a60.charAt(i);
}
a56=a59+a61;
return a56;
}
function TrParseException(
a0
)
{
this._message=a0;
}
TrParseException.prototype.getMessage=function()
{
return this._message;
}
