/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.agent;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.myfaces.trinidadinternal.agent.CapabilityKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapabilityMap
extends AbstractMap<Object, Object>
implements Cloneable {
    private Object[] _indexedValues;
    private Set<Map.Entry<Object, Object>> _entrySet;

    private CapabilityMap() {
    }

    CapabilityMap(Object[][] keyValuesArr) {
        int i;
        int keyCount;
        CapabilityKey[] keys;
        Object[] keyValues;
        int arrayIndex;
        int arrayCount = keyValuesArr.length;
        CapabilityKey[][] keyArrays = new CapabilityKey[arrayCount][];
        for (int arrayIndex2 = 0; arrayIndex2 < arrayCount; ++arrayIndex2) {
            keyArrays[arrayIndex2] = new CapabilityKey[keyValuesArr[arrayIndex2] == null ? 0 : keyValuesArr[arrayIndex2].length >> 1];
        }
        int maxKeyIndex = 0;
        for (arrayIndex = 0; arrayIndex < arrayCount; ++arrayIndex) {
            keyValues = keyValuesArr[arrayIndex];
            keys = keyArrays[arrayIndex];
            keyCount = keys.length;
            for (i = 0; i < keyCount; ++i) {
                keys[i] = (CapabilityKey)keyValues[i << 1];
                maxKeyIndex = this._max(keys[i].getIndex(), maxKeyIndex);
            }
        }
        this._indexedValues = new Object[maxKeyIndex + 1];
        for (arrayIndex = 0; arrayIndex < arrayCount; ++arrayIndex) {
            keyValues = keyValuesArr[arrayIndex];
            keys = keyArrays[arrayIndex];
            keyCount = keys.length;
            for (i = 0; i < keyCount; ++i) {
                this._indexedValues[keys[i].getIndex()] = keyValues[(i << 1) + 1];
            }
        }
    }

    public Object getCapability(CapabilityKey capKey) {
        int keyIndex = capKey.getIndex();
        if (keyIndex < this._indexedValues.length) {
            return this._indexedValues[keyIndex];
        }
        return null;
    }

    public CapabilityMap merge(Map<Object, Object> capabilities) {
        if (capabilities == null || capabilities.isEmpty()) {
            return this;
        }
        return this.merge(this._getMapAsArray(capabilities));
    }

    public CapabilityMap merge(Object[] capabilities) {
        CapabilityKey capKey;
        if (capabilities == null || capabilities.length <= 0) {
            return this;
        }
        int maxKeyIndex = this._indexedValues.length;
        Object[] capKeys = new Object[capabilities.length >> 1];
        Object[] capValues = new Object[capabilities.length >> 1];
        int j = 0;
        for (int i = 0; i < capabilities.length - 1; ++i) {
            capKey = (CapabilityKey)capabilities[i++];
            capKeys[j] = capKey;
            capValues[j++] = capabilities[i];
            maxKeyIndex = this._max(capKey.getIndex(), maxKeyIndex);
        }
        Object[] indexedValues = new Object[maxKeyIndex + 1];
        System.arraycopy(this._indexedValues, 0, indexedValues, 0, this._indexedValues.length);
        for (int i = 0; i < capKeys.length; ++i) {
            capKey = (CapabilityKey)capKeys[i];
            int keyIndex = capKey.getIndex();
            indexedValues[keyIndex] = capValues[i];
        }
        CapabilityMap newImpl = new CapabilityMap();
        newImpl._indexedValues = indexedValues;
        return newImpl;
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        if (key instanceof CapabilityKey) {
            return this.getCapability((CapabilityKey)key);
        }
        return this._get(key.toString());
    }

    @Override
    public Object put(Object key, Object value) {
        return new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        if (this._entrySet == null) {
            this._createEntrySet();
        }
        return this._entrySet;
    }

    @Override
    public Object clone() {
        try {
            CapabilityMap that = (CapabilityMap)super.clone();
            that._indexedValues = (Object[])this._indexedValues.clone();
            that._entrySet = null;
            return that;
        }
        catch (CloneNotSupportedException cnse) {
            assert (false);
            return null;
        }
    }

    private Object _get(String key) {
        CapabilityKey key0 = null;
        Object value = null;
        key0 = CapabilityKey.getCapabilityKey(key);
        if (key0 != null) {
            value = this.getCapability(key0);
        }
        return value;
    }

    private synchronized void _createEntrySet() {
        if (this._entrySet == null) {
            HashSet<CEntry> hs = new HashSet<CEntry>();
            KeyIterator iter = new KeyIterator();
            while (iter.hasNext()) {
                CapabilityKey capKey = (CapabilityKey)iter.next();
                Object value = this.getCapability(capKey);
                CEntry ce = new CEntry(capKey.getCapabilityName(), value);
                hs.add(ce);
            }
            this._entrySet = Collections.unmodifiableSet(hs);
        }
    }

    private int _max(int value1, int value2) {
        return value1 > value2 ? value1 : value2;
    }

    private Object[] _getMapAsArray(Map<Object, Object> capabilities) {
        Object[] caps = new Object[capabilities.size() * 2];
        int i = 0;
        for (Map.Entry<Object, Object> entry : capabilities.entrySet()) {
            Object key = entry.getKey();
            CapabilityKey capKey = key instanceof CapabilityKey ? (CapabilityKey)key : CapabilityKey.getCapabilityKey((String)key);
            caps[i++] = capKey;
            caps[i++] = entry.getValue();
        }
        return caps;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CEntry
    implements Map.Entry<Object, Object> {
        private Object key;
        private Object value;

        CEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CEntry)) {
                return false;
            }
            CEntry ce = (CEntry)o;
            return (ce.key == this.key || ce.key.equals(this.key)) && (this.value == null ? ce.value == null : ce.value.equals(this.value));
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    implements Iterator<Object> {
        private int _current = 0;
        private CapabilityKey _next = null;

        public KeyIterator() {
            this._setNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        @Override
        public Object next() {
            if (this._next == null) {
                this._setNext();
            }
            if (this._next != null) {
                CapabilityKey next = this._next;
                this._setNext();
                return next;
            }
            throw new NoSuchElementException();
        }

        private void _setNext() {
            this._next = null;
            for (int i = this._current; i < CapabilityMap.this._indexedValues.length; ++i) {
                if (CapabilityMap.this._indexedValues[i] == null) continue;
                this._next = CapabilityKey.getKeyAt(i);
                this._current = ++i;
                break;
            }
        }
    }
}

