/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.application;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.render.ExtendedRenderKitService;
import org.apache.myfaces.trinidad.render.InternalView;
import org.apache.myfaces.trinidad.util.Service;
import org.apache.myfaces.trinidad.util.URLUtils;
import org.apache.myfaces.trinidadinternal.context.TrinidadPhaseListener;

public class ViewHandlerImpl
extends ViewHandlerWrapper {
    public static final String ALTERNATE_VIEW_HANDLER = "org.apache.myfaces.trinidad.ALTERNATE_VIEW_HANDLER";
    private Boolean _checkTimestamp;
    private ViewHandler _delegate;
    private final Map<String, Long> _timestamps;
    private boolean _inited;
    private Map<String, InternalView> _internalViews;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ViewHandlerImpl.class);
    private static final Long _NOT_FOUND = 0L;
    private static final String _RENDER_VIEW_MARKER = "__trRenderViewEntry";

    public ViewHandlerImpl(ViewHandler delegate) {
        this._delegate = delegate;
        this._timestamps = new HashMap<String, Long>();
        this._loadInternalViews();
    }

    protected ViewHandler getWrapped() {
        return this._delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot createView(FacesContext context, String viewId) {
        this._initIfNeeded(context);
        InternalView internal = this._getInternalView(context, viewId);
        if (internal != null) {
            UIViewRoot root = internal.createView(context, viewId);
            if (root != null) {
                return root;
            }
        } else if (this._checkTimestamp(context)) {
            try {
                String path = ViewHandlerImpl._getPath(viewId);
                Map<String, Long> map = this._timestamps;
                synchronized (map) {
                    Long ts = this._timestamps.get(path);
                    if (ts != _NOT_FOUND) {
                        URL url = context.getExternalContext().getResource(path);
                        Long modified = this._getLastModified(url);
                        this._timestamps.put(path, modified);
                    }
                }
            }
            catch (IOException e) {
                _LOG.severe((Throwable)e);
            }
        }
        return super.createView(context, viewId);
    }

    public String getActionURL(FacesContext context, String viewId) {
        String actionURL = super.getActionURL(context, viewId);
        RequestContext afContext = RequestContext.getCurrentInstance();
        if (afContext != null) {
            actionURL = afContext.getPageResolver().encodeActionURI(actionURL);
            actionURL = afContext.getPageFlowScopeProvider().encodeCurrentPageFlowScopeURL(context, actionURL);
        }
        return actionURL;
    }

    public String getResourceURL(FacesContext context, String path) {
        return super.getResourceURL(context, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        this._initIfNeeded(context);
        Map reqMap = context.getExternalContext().getRequestMap();
        if (reqMap.get(_RENDER_VIEW_MARKER) != null) {
            _LOG.warning("DUPLICATE_VIEWHANDLER_REGISTRATION");
        } else {
            reqMap.put(_RENDER_VIEW_MARKER, Boolean.TRUE);
        }
        ExtendedRenderKitService service = this._getExtendedRenderKitService(context);
        if (service == null || !service.shortCircuitRenderView(context)) {
            try {
                InternalView internal;
                if (service != null) {
                    service.encodeBegin(context);
                }
                if ((internal = this._getInternalView(context, viewToRender.getViewId())) != null) {
                    internal.renderView(context, viewToRender);
                } else {
                    super.renderView(context, viewToRender);
                }
                if (service != null) {
                    service.encodeEnd(context);
                }
            }
            finally {
                if (service != null) {
                    service.encodeFinally(context);
                }
            }
        }
        reqMap.remove(_RENDER_VIEW_MARKER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot restoreView(FacesContext context, String viewId) {
        if (context.getExternalContext().getRequestMap().get("org.apache.myfaces.trinidad.PageFlowSourceView") != null) {
            return super.restoreView(context, viewId);
        }
        InternalView internal = this._getInternalView(context, viewId);
        if (internal != null) {
            return internal.restoreView(context, viewId);
        }
        boolean uptodate = true;
        if (this._checkTimestamp(context)) {
            try {
                String path = ViewHandlerImpl._getPath(viewId);
                Map<String, Long> map = this._timestamps;
                synchronized (map) {
                    Long ts = this._timestamps.get(path);
                    if (ts != _NOT_FOUND) {
                        URL url = context.getExternalContext().getResource(path);
                        Long modified = this._getLastModified(url);
                        if (modified == _NOT_FOUND) {
                            this._timestamps.put(path, _NOT_FOUND);
                        } else if (ts == null || modified > ts) {
                            this._timestamps.put(path, modified);
                            if (ts != null) {
                                _LOG.fine("View document \"" + path + "\" has been modified, " + "ignoring postback for view \"" + viewId + "\"");
                            }
                            uptodate = false;
                        }
                    }
                }
            }
            catch (IOException e) {
                _LOG.severe((Throwable)e);
            }
        }
        if (!uptodate) {
            return null;
        }
        UIViewRoot result = super.restoreView(context, viewId);
        if (result != null) {
            TrinidadPhaseListener.markPostback(context);
        }
        return result;
    }

    public void writeState(FacesContext context) throws IOException {
        String viewId = context.getViewRoot().getViewId();
        InternalView internal = this._getInternalView(context, viewId);
        if (internal != null && internal.isStateless(context, viewId)) {
            return;
        }
        ExtendedRenderKitService service = this._getExtendedRenderKitService(context);
        if (service != null && service.isStateless(context)) {
            return;
        }
        super.writeState(context);
    }

    private synchronized void _initIfNeeded(FacesContext context) {
        if (!this._inited) {
            this._inited = true;
            String alternateViewHandler = context.getExternalContext().getInitParameter(ALTERNATE_VIEW_HANDLER);
            if (alternateViewHandler != null) {
                ViewHandler viewHandlerInstance = null;
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    Class<?> c = loader.loadClass(alternateViewHandler);
                    try {
                        Constructor<?> constructor = c.getConstructor(ViewHandler.class);
                        viewHandlerInstance = (ViewHandler)constructor.newInstance(this._delegate);
                    }
                    catch (NoSuchMethodException nsme) {
                        viewHandlerInstance = (ViewHandler)c.newInstance();
                    }
                }
                catch (Exception e) {
                    _LOG.warning("CANNOT_LOAD_VIEWHANDLER", (Object)alternateViewHandler);
                    _LOG.warning((Throwable)e);
                }
                if (viewHandlerInstance != null) {
                    this._delegate = viewHandlerInstance;
                }
            }
        }
    }

    private ExtendedRenderKitService _getExtendedRenderKitService(FacesContext context) {
        return (ExtendedRenderKitService)Service.getService((Object)context.getRenderKit(), ExtendedRenderKitService.class);
    }

    private boolean _checkTimestamp(FacesContext context) {
        if (this._checkTimestamp == null) {
            String checkTimestamp = context.getExternalContext().getInitParameter("org.apache.myfaces.trinidad.CHECK_FILE_MODIFICATION");
            boolean performCheck = "true".equals(checkTimestamp) || "development".equals(System.getProperty("oracle.application.environment"));
            this._checkTimestamp = performCheck;
            if ("true".equals(checkTimestamp)) {
                _LOG.info("TIMESTAMP_CHECKING_ENABLED_SHOULDNOT_IN_PRODUCTION", (Object)"org.apache.myfaces.trinidad.CHECK_FILE_MODIFICATION");
            }
        }
        return this._checkTimestamp;
    }

    private static String _getPath(String uri) {
        RequestContext afc = RequestContext.getCurrentInstance();
        if (afc != null) {
            return afc.getPageResolver().getPhysicalURI(uri);
        }
        return uri;
    }

    private Long _getLastModified(URL url) throws IOException {
        if (url == null) {
            return _NOT_FOUND;
        }
        return URLUtils.getLastModified((URL)url);
    }

    private InternalView _getInternalView(FacesContext context, String viewId) {
        ExternalContext external;
        InternalView internal = this._internalViews.get(viewId);
        if (internal == null && (external = context.getExternalContext()).getRequestPathInfo() == null) {
            String suffix = external.getInitParameter("javax.faces.DEFAULT_SUFFIX");
            if (suffix == null) {
                suffix = ".jspx";
            }
            if (viewId.endsWith(suffix)) {
                String viewIdWithoutSuffix = viewId.substring(0, viewId.length() - suffix.length());
                internal = this._internalViews.get(viewIdWithoutSuffix);
            }
        }
        return internal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _loadInternalViews() {
        this._internalViews = new HashMap<String, InternalView>();
        ArrayList<URL> list = new ArrayList<URL>();
        ClassLoader loader = ViewHandlerImpl._getClassLoader();
        try {
            Enumeration<URL> en = loader.getResources("META-INF/org.apache.myfaces.trinidad.render.InternalView.properties");
            while (en.hasMoreElements()) {
                list.add(en.nextElement());
            }
            en = loader.getResources("META-INF/org.apache.myfaces.trinidad.InternalView.properties");
            while (en.hasMoreElements()) {
                list.add(en.nextElement());
            }
            Collections.reverse(list);
        }
        catch (IOException ioe) {
            _LOG.severe((Throwable)ioe);
        }
        for (URL url : list) {
            try {
                Properties properties = new Properties();
                _LOG.fine("Loading internal views from {0}", (Object)url);
                InputStream is = url.openStream();
                try {
                    properties.load(is);
                }
                finally {
                    is.close();
                }
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String name = (String)entry.getKey();
                    String className = (String)entry.getValue();
                    Class<?> clazz = loader.loadClass(className);
                    InternalView view = (InternalView)clazz.newInstance();
                    this._internalViews.put(name, view);
                }
            }
            catch (IllegalAccessException iae) {
                _LOG.severe("CANNOT_LOAD_URL", (Object)url);
                _LOG.severe((Throwable)iae);
            }
            catch (InstantiationException ie) {
                _LOG.severe("CANNOT_LOAD_URL", (Object)url);
                _LOG.severe((Throwable)ie);
            }
            catch (ClassNotFoundException cnfe) {
                _LOG.severe("CANNOT_LOAD_URL", (Object)url);
                _LOG.severe((Throwable)cnfe);
            }
            catch (IOException ioe) {
                _LOG.severe("CANNOT_LOAD_URL", (Object)url);
                _LOG.severe((Throwable)ioe);
            }
        }
    }

    private static ClassLoader _getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ViewHandlerImpl.class.getClassLoader();
        }
        return loader;
    }
}

