/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config.upload;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.config.upload.UploadedFiles;
import org.apache.myfaces.trinidadinternal.share.util.CaboHttpUtils;
import org.apache.myfaces.trinidadinternal.webapp.wrappers.ActionRequestWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionUploadRequestWrapper
extends ActionRequestWrapper {
    private Map<String, String[]> _extractedAndDecodedParams;
    private Map<String, String[]> _extractedParams;
    private ActionResponse _response;
    private String _encoding;
    private static final String _WWW_FORM_URLENCODED_TYPE = "application/x-www-form-urlencoded";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ActionUploadRequestWrapper.class);

    public ActionUploadRequestWrapper(ExternalContext ec, Map<String, String[]> params) {
        super((ActionRequest)ec.getRequest());
        this._response = (ActionResponse)ec.getResponse();
        Map origionalMap = super.getParameterMap();
        this._extractedParams = new HashMap<String, String[]>(origionalMap);
        this._extractedParams.putAll(params);
        this._encoding = super.getCharacterEncoding();
    }

    @Override
    public String getContentType() {
        return _WWW_FORM_URLENCODED_TYPE;
    }

    @Override
    public String getCharacterEncoding() {
        return this._encoding;
    }

    @Override
    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (encoding.equals(this._encoding)) {
            return;
        }
        this._encoding = encoding;
        if (_LOG.isFine()) {
            _LOG.fine("Switching encoding of wrapper to " + encoding);
        }
        this._extractedAndDecodedParams = new HashMap<String, String[]>(this._extractedParams.size());
        byte[] buffer = new byte[256];
        for (Map.Entry<String, String[]> entry : this._extractedParams.entrySet()) {
            String key = entry.getKey();
            key = CaboHttpUtils.decodeRequestParameter(key, encoding, buffer);
            String[] oldValue = entry.getValue();
            int length = oldValue.length;
            String[] newValue = new String[length];
            for (int i = 0; i < length; ++i) {
                newValue[i] = CaboHttpUtils.decodeRequestParameter(oldValue[i], encoding, buffer);
                if (!_LOG.isFinest()) continue;
                _LOG.finest("Parameter " + key + ":" + newValue[i]);
            }
            this._extractedAndDecodedParams.put(key, newValue);
            this._response.setRenderParameters(this._extractedAndDecodedParams);
        }
        UploadedFiles.setCharacterEncoding(this, encoding);
    }

    @Override
    public String getParameter(String param) {
        String[] value = this._getParameterValues(param);
        if (value == null) {
            return null;
        }
        return value[0];
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        Map<String, String[]> map = this._getMap();
        return Collections.unmodifiableMap(map);
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this._getMap().keySet());
    }

    @Override
    public String[] getParameterValues(String param) {
        String[] value = this._getParameterValues(param);
        if (value == null) {
            return null;
        }
        return (String[])value.clone();
    }

    private String[] _getParameterValues(String param) {
        return this._getMap().get(param);
    }

    private Map<String, String[]> _getMap() {
        if (this._extractedAndDecodedParams != null) {
            return this._extractedAndDecodedParams;
        }
        return this._extractedParams;
    }
}

