/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.context;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.apache.myfaces.trinidad.component.visit.VisitCallback;
import org.apache.myfaces.trinidad.component.visit.VisitContext;
import org.apache.myfaces.trinidad.component.visit.VisitHint;
import org.apache.myfaces.trinidad.component.visit.VisitResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FullVisitContext
extends VisitContext {
    private final FacesContext _facesContext;
    private final Set<VisitHint> _hints;
    private final PhaseId _phaseId;

    public FullVisitContext(FacesContext facesContext) {
        this(facesContext, null, null);
    }

    public FullVisitContext(FacesContext facesContext, Set<VisitHint> hints, PhaseId phaseId) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!(phaseId == null || hints != null && hints.contains(VisitHint.EXECUTE_LIFECYCLE))) {
            throw new IllegalArgumentException();
        }
        this._facesContext = facesContext;
        this._phaseId = phaseId;
        EnumSet<VisitHint> hintsEnumSet = hints == null || hints.isEmpty() ? EnumSet.noneOf(VisitHint.class) : EnumSet.copyOf(hints);
        this._hints = Collections.unmodifiableSet(hintsEnumSet);
    }

    public FacesContext getFacesContext() {
        return this._facesContext;
    }

    public PhaseId getPhaseId() {
        return this._phaseId;
    }

    public Collection<String> getIdsToVisit() {
        return ALL_IDS;
    }

    public Collection<String> getSubtreeIdsToVisit(UIComponent component) {
        if (!(component instanceof NamingContainer)) {
            throw new IllegalArgumentException("Component is not a NamingContainer: " + component);
        }
        return ALL_IDS;
    }

    public Set<VisitHint> getHints() {
        return this._hints;
    }

    public VisitResult invokeVisitCallback(UIComponent component, VisitCallback callback) {
        return callback.visit((VisitContext)this, component);
    }
}

