/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.context;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.myfaces.trinidadinternal.config.xmlHttp.XmlHttpConfigurator;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderKit;

public class TrinidadPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = -1249678874100309402L;
    public static final String INITIAL_VIEW_ROOT_KEY = "org.apache.myfaces.trinidadinternal.InitialViewRoot";
    private static final String _POSTBACK_KEY = "org.apache.myfaces.trinidadinternal.context.AdfFacesPhaseListener.POSTBACK";

    public static boolean isPostback(FacesContext context) {
        return !Boolean.FALSE.equals(context.getExternalContext().getRequestMap().get(_POSTBACK_KEY));
    }

    public static void markPostback(FacesContext context) {
        context.getExternalContext().getRequestMap().remove(_POSTBACK_KEY);
    }

    public void afterPhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            context.getExternalContext().getRequestMap().put(INITIAL_VIEW_ROOT_KEY, context.getViewRoot());
        }
    }

    public void beforePhase(PhaseEvent event) {
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            FacesContext context = event.getFacesContext();
            ExternalContext ec = context.getExternalContext();
            ec.getRequestMap().put(_POSTBACK_KEY, Boolean.FALSE);
            if (CoreRenderKit.isPartialRequest(ec)) {
                XmlHttpConfigurator.beginRequest(ec);
            }
        } else if (event.getPhaseId() == PhaseId.APPLY_REQUEST_VALUES) {
            FacesContext context = event.getFacesContext();
            TrinidadPhaseListener.markPostback(context);
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

