/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.menu;

import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.apache.myfaces.trinidad.util.ContainerUtils;
import org.apache.myfaces.trinidadinternal.menu.MenuNode;
import org.apache.myfaces.trinidadinternal.menu.MenuUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemNode
extends MenuNode {
    private Map<String, String> _customPropList = null;
    private String _destination = null;
    private String _targetFrame = null;
    private String _action = null;
    private String _actionListener = null;
    private String _launchListener = null;
    private String _returnListener = null;
    private String _immediateStr = null;
    private String _useWindowStr = null;
    private String _windowHeightStr = null;
    private String _windowWidthStr = null;

    public void setAction(String action) {
        this._action = action;
    }

    @Override
    public String doAction() {
        String value = this._action;
        if (value != null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExpressionFactory expressionFactory = facesContext.getApplication().getExpressionFactory();
            ELContext context = facesContext.getELContext();
            MethodExpression methodExpression = expressionFactory.createMethodExpression(context, value, String.class, new Class[0]);
            value = (String)methodExpression.invoke(context, null);
        }
        this.postSelectedNode(this);
        return value;
    }

    public void setActionListener(String actionListener) {
        this._actionListener = actionListener;
    }

    public String getActionListener() {
        String value = this._actionListener;
        if (value != null && ContainerUtils.isValueReference((String)value)) {
            value = MenuUtils.getBoundValue(value, String.class);
            this.setActionListener(value);
        }
        return value;
    }

    public void actionListener(ActionEvent event) {
        String value = this._actionListener;
        if (value != null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExpressionFactory expressionFactory = facesContext.getApplication().getExpressionFactory();
            ELContext context = facesContext.getELContext();
            MethodExpression methodExpression = expressionFactory.createMethodExpression(context, value, Void.TYPE, new Class[]{ActionEvent.class});
            methodExpression.invoke(context, new Object[]{event});
        }
    }

    public void setLaunchListener(String launchListener) {
        this._launchListener = launchListener;
    }

    public String getLaunchListener() {
        String value = this._launchListener;
        if (value != null && ContainerUtils.isValueReference((String)value)) {
            value = MenuUtils.getBoundValue(value, String.class);
            this.setLaunchListener(value);
        }
        return value;
    }

    public void setReturnListener(String returnListener) {
        this._returnListener = returnListener;
    }

    public String getReturnListener() {
        String value = this._returnListener;
        if (value != null && ContainerUtils.isValueReference((String)value)) {
            value = MenuUtils.getBoundValue(value, String.class);
            this.setReturnListener(value);
        }
        return value;
    }

    public void setImmediate(boolean immediate) {
        this._immediateStr = immediate ? "true" : "false";
    }

    public void setImmediate(String immediateStr) {
        this._immediateStr = immediateStr;
    }

    public boolean getImmediate() {
        boolean immediate = MenuUtils.evalBoolean(this._immediateStr, false);
        return immediate;
    }

    public void setUseWindow(boolean useWindow) {
        this._useWindowStr = useWindow ? "true" : "false";
    }

    public void setUseWindow(String useWindowStr) {
        this._useWindowStr = useWindowStr;
    }

    public boolean getUseWindow() {
        boolean useWindow = MenuUtils.evalBoolean(this._useWindowStr, false);
        return useWindow;
    }

    public void setWindowHeight(int windowHeight) {
        this._windowHeightStr = Integer.toString(windowHeight);
    }

    public void setWindowHeight(String windowHeightStr) {
        this._windowHeightStr = windowHeightStr;
    }

    public int getWindowHeight() {
        int windowHeight = MenuUtils.evalInt(this._windowHeightStr);
        return windowHeight;
    }

    public void setWindowWidth(int windowWidth) {
        this._windowWidthStr = Integer.toString(windowWidth);
    }

    public void setWindowWidth(String windowWidthStr) {
        this._windowWidthStr = windowWidthStr;
    }

    public int getWindowWidth() {
        int windowWidth = MenuUtils.evalInt(this._windowWidthStr);
        return windowWidth;
    }

    public void setDestination(String destination) {
        this._destination = destination;
    }

    @Override
    public String getDestination() {
        String value = this._destination;
        if (value != null && ContainerUtils.isValueReference((String)value)) {
            value = MenuUtils.getBoundValue(value, String.class);
        }
        return value != null ? value + "?nodeId=" + this.getUniqueId() : value;
    }

    public void setTargetFrame(String targetFrame) {
        this._targetFrame = targetFrame;
    }

    public String getTargetFrame() {
        String value = this._targetFrame;
        if (value != null && ContainerUtils.isValueReference((String)value)) {
            value = MenuUtils.getBoundValue(value, String.class);
            this.setTargetFrame(value);
        }
        return value;
    }

    public Map<String, String> getCustomPropList() {
        return this._customPropList;
    }

    protected void setCustomPropList(Map<String, String> attrMap) {
        this._customPropList = attrMap;
    }
}

