/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.pda;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.CollectionComponent;
import org.apache.myfaces.trinidad.component.UIXColumn;
import org.apache.myfaces.trinidad.component.UIXTable;
import org.apache.myfaces.trinidad.component.core.data.CoreColumn;
import org.apache.myfaces.trinidad.component.core.data.CoreTable;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.TableRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlConstants;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.BandingData;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.ColumnData;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.RenderStage;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.RowData;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableUtils;

public class PdaTableRenderer
extends TableRenderer {
    public PdaTableRenderer() {
        super(CoreTable.TYPE);
    }

    protected void renderTableAttributes(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, Object cellPadding, Object border) throws IOException {
        Object width = this.getWidth(bean);
        if (width == null || width == "") {
            width = "100%";
        }
        OutputUtils.renderLayoutTableAttributes(context, arc, cellPadding, "0", border, width);
    }

    protected final void renderControlBar(FacesContext context, RenderingContext arc, TableRenderingContext tContext, UIComponent component) throws IOException {
        boolean hasNav;
        UIComponent action = PdaTableRenderer.getFacet((UIComponent)component, (String)"actions");
        boolean tableNotEmpty = !tContext.getRowData().isEmptyTable();
        boolean bl = hasNav = tContext.hasNavigation() && tableNotEmpty;
        if (hasNav || action != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("tr", null);
            writer.startElement("td", null);
            writer.startElement("div", null);
            PdaTableRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|table::control-bar-top");
            if (action != null) {
                writer.startElement("td", null);
                this.encodeChild(context, action);
                writer.endElement("td");
            }
            if (hasNav) {
                writer.startElement("div", null);
                writer.writeAttribute("valign", (Object)"middle", null);
                this.delegateRenderer(context, arc, component, this.getFacesBean(component), this.getSharedNavBarRenderer());
                writer.endElement("div");
            }
            writer.endElement("div");
            writer.endElement("td");
            writer.endElement("tr");
        }
    }

    protected void renderSubControlBar(FacesContext context, RenderingContext arc, TableRenderingContext tContext, UIComponent component, boolean isUpper) throws IOException {
    }

    private void _renderEmptyCell(FacesContext context, RenderingContext arc, TableRenderingContext tContext, boolean isSelect, Object emptyText) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        String cellClass = this._getCellFormat(tContext, isSelect);
        PdaTableRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)cellClass);
        if (emptyText == null) {
            emptyText = XhtmlConstants.NBSP_STRING;
        }
        writer.writeText(emptyText, null);
        writer.endElement("td");
    }

    protected void renderTableContent(FacesContext context, final RenderingContext arc, final TableRenderingContext tContext, final UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        FacesBean bean = this.getFacesBean(component);
        writer.endElement("table");
        writer.startElement("table", component);
        this.renderTableAttributes(context, arc, component, bean, "2", "1");
        PdaTableRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|table::content");
        final RowData rowData = tContext.getRowData();
        boolean isEmptyTable = rowData.isEmptyTable();
        final UIComponent detail = tContext.getDetail();
        this._renderTableHeader(context, arc, tContext, component);
        if (tContext.hasColumnHeaders()) {
            this._renderColumnHeader(context, arc, tContext, component);
        }
        ColumnData colData = tContext.getColumnData();
        final RenderStage renderStage = tContext.getRenderStage();
        renderStage.setStage(30);
        int physicalCol = 0;
        if (isEmptyTable) {
            int objectNameColumnIndex;
            writer.startElement("tr", null);
            if (tContext.hasSelection()) {
                colData.setColumnIndex(physicalCol++, -1);
                this._renderEmptyCell(context, arc, tContext, true, null);
            }
            if (detail != null) {
                colData.setColumnIndex(physicalCol++, -1);
                this._renderEmptyCell(context, arc, tContext, true, null);
            }
            if ((objectNameColumnIndex = colData.getObjectNameColumnIndex()) < physicalCol) {
                objectNameColumnIndex = physicalCol;
            }
            int columns = colData.getColumnCount();
            while (physicalCol < columns) {
                colData.setColumnIndex(physicalCol, -1);
                String emptyText = objectNameColumnIndex == physicalCol ? this.getEmptyText(bean) : null;
                this._renderEmptyCell(context, arc, tContext, false, emptyText);
                ++physicalCol;
            }
            writer.endElement("tr");
        } else {
            TableUtils.RowLoop loop = new TableUtils.RowLoop(){

                protected void processRowImpl(FacesContext fc, CollectionComponent tableBase) throws IOException {
                    ResponseWriter rw = fc.getResponseWriter();
                    rowData.setCurrentRowSpan(-1);
                    renderStage.setStage(35);
                    PdaTableRenderer.this.renderSingleRow(fc, arc, tContext, component);
                    renderStage.setStage(30);
                    int sz = rowData.getCurrentRowSpan();
                    for (int i = 0; i < sz; ++i) {
                        rw.startElement("tr", null);
                        PdaTableRenderer.this.renderSingleRow(fc, arc, tContext, component);
                        rowData.incCurrentSubRow();
                        rw.endElement("tr");
                    }
                    if (detail != null && ((UIXTable)tableBase).getDisclosedRowKeys().isContained()) {
                        renderStage.setStage(45);
                        rw.startElement("tr", null);
                        rw.startElement("td", null);
                        rw.writeAttribute("colspan", (Object)IntegerUtils.getString((int)tContext.getActualColumnCount()), null);
                        PdaTableRenderer.this.encodeChild(fc, detail);
                        rw.endElement("td");
                        rw.endElement("tr");
                        renderStage.setStage(30);
                    }
                }
            };
            loop.run(context, tContext.getCollectionComponent());
        }
        this._renderColumnFooter(context, arc, tContext, component);
    }

    private void _renderColumnFooter(FacesContext context, RenderingContext arc, TableRenderingContext tContext, UIComponent component) throws IOException {
        tContext.getRenderStage().setStage(60);
        ColumnData colData = tContext.getColumnData();
        UIComponent footer = PdaTableRenderer.getFacet((UIComponent)component, (String)"footer");
        if (footer != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("tr", null);
            writer.startElement("th", null);
            int firstFooterPhysicalIndex = colData.getPhysicalIndexOfFirstFooter();
            int colSpan = firstFooterPhysicalIndex > 0 ? firstFooterPhysicalIndex : tContext.getActualColumnCount();
            writer.writeAttribute("colspan", (Object)IntegerUtils.getString((int)colSpan), null);
            PdaTableRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|table::column-footer");
            this.encodeChild(context, footer);
            writer.endElement("th");
            if (firstFooterPhysicalIndex > 0) {
                colData.setColumnIndex(tContext.getSpecialColumnCount(), 0);
                for (UIComponent child : component.getChildren()) {
                    if (!child.isRendered()) continue;
                    this.encodeChild(context, child);
                }
            }
            writer.endElement("tr");
        }
    }

    protected final void renderSingleRow(FacesContext context, RenderingContext arc, TableRenderingContext tContext, UIComponent component) throws IOException {
        int stage = tContext.getRenderStage().getStage();
        switch (stage) {
            case 20: {
                return;
            }
            case 0: 
            case 30: 
            case 35: 
            case 100: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Bad renderStage:" + stage));
            }
        }
        ColumnData colData = tContext.getColumnData();
        int[] hidden = tContext.getHiddenColumns();
        int columns = tContext.getColumnCount();
        int physicalColumn = this.renderSpecialColumns(context, arc, tContext, component, 0);
        for (int currCol = 0; currCol < columns; ++currCol) {
            UIXColumn column;
            boolean isRowHeader;
            UIComponent child;
            if (hidden[currCol] != 0 || !((child = (UIComponent)component.getChildren().get(currCol)) instanceof UIXColumn) || (isRowHeader = Boolean.TRUE.equals((column = (UIXColumn)child).getAttributes().get(CoreColumn.ROW_HEADER_KEY.getName())))) continue;
            colData.setColumnIndex(physicalColumn, currCol);
            this.encodeChild(context, (UIComponent)column);
            physicalColumn = colData.getPhysicalColumnIndex();
        }
    }

    private void _renderColumnHeader(FacesContext context, RenderingContext arc, TableRenderingContext tContext, UIComponent component) throws IOException {
        tContext.getRenderStage().setStage(20);
        ResponseWriter writer = context.getResponseWriter();
        ColumnData colData = tContext.getColumnData();
        colData.setRowIndex(0);
        writer.startElement("tr", null);
        int physicalCol = this.renderSpecialColumns(context, arc, tContext, component, 0);
        int[] hidden = tContext.getHiddenColumns();
        int colCount = component.getChildCount();
        for (int j = 0; j < colCount; ++j) {
            UIXColumn column;
            boolean isRowHeader;
            UIComponent child;
            if (hidden[j] != 0 || !((child = (UIComponent)component.getChildren().get(j)) instanceof UIXColumn) || (isRowHeader = Boolean.TRUE.equals((column = (UIXColumn)child).getAttributes().get(CoreColumn.ROW_HEADER_KEY.getName())))) continue;
            colData.setColumnIndex(physicalCol, j);
            this.encodeChild(context, (UIComponent)column);
            physicalCol = colData.getPhysicalColumnIndex();
        }
        colData.setRowIndex(-1);
        writer.endElement("tr");
    }

    private String _getCellFormat(TableRenderingContext tContext, boolean isSelect) throws IOException {
        ColumnData colData = tContext.getColumnData();
        RowData rowData = tContext.getRowData();
        int row = rowData.getRangeIndex();
        int physicalColumn = colData.getPhysicalColumnIndex();
        int logicalColumn = colData.getLogicalColumnIndex();
        BandingData bandingData = tContext.getBanding();
        boolean band = bandingData.getBand(tContext, row, physicalColumn, logicalColumn);
        String cellClass = band ? (isSelect ? "OraTableCellSelectBand" : ColumnData.selectFormat(tContext, "af|column::cell-text-band", "af|column::cell-number-band", "af|column::cell-icon-format-band")) : (isSelect ? "OraTableCellSelect" : ColumnData.selectFormat(tContext, "af|column::cell-text", "af|column::cell-number", "af|column::cell-icon-format"));
        return cellClass;
    }

    private void _renderTableHeader(FacesContext context, RenderingContext arc, TableRenderingContext tContext, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent header = PdaTableRenderer.getFacet((UIComponent)component, (String)"header");
        if (header != null) {
            writer.startElement("thead", null);
            writer.startElement("tr", null);
            writer.startElement("td", null);
            writer.writeAttribute("colspan", (Object)tContext.getActualColumnCount(), null);
            PdaTableRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|column::sortable-header-icon-format");
            this.encodeChild(context, header);
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("thead");
        }
    }
}

