/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DateTimeConverter;
import javax.faces.validator.Validator;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.input.CoreInputDate;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.ReturnEvent;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.render.RenderUtils;
import org.apache.myfaces.trinidad.validator.DateTimeRangeValidator;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.convert.GenericConverterFactory;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderKit;
import org.apache.myfaces.trinidadinternal.renderkit.core.pages.GenericEntry;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SimpleInputListOfValuesRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs.ConfigurationScriptlet;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs.DialogStyleScriptlet;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs.Scriptlet;

public class SimpleInputDateRenderer
extends SimpleInputListOfValuesRenderer {
    private PropertyKey _chooseIdKey;
    private static final Integer _DEFAULT_COLUMNS = 10;
    private static final String _BLUR_PREFIX = "_dfb(this";
    private static final String _FOCUS_PREFIX = "_dff(this";
    private static final Object _ACTIVE_DATE_FIELDS_KEY = new Object();
    private static final String _LAUNCH_PICKER_TIP_KEY = "af_inputDate.LAUNCH_PICKER_TIP";
    private static final Object _CACHED_CHOOSE_ID = new Object();
    private static final String _DATE_TIME_ZONE_OFFSET_KEY = "dateTimeZoneOffset";
    private static boolean _dateScriptletsRegistered = false;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SimpleInputDateRenderer.class);

    public SimpleInputDateRenderer() {
        this(CoreInputDate.TYPE);
    }

    public SimpleInputDateRenderer(FacesBean.Type type) {
        super(type);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._chooseIdKey = type.findKey("chooseId");
    }

    protected void queueActionEvent(FacesContext context, UIComponent component) {
        FacesBean bean = this.getFacesBean(component);
        if (this.getActionExpression(bean) != null) {
            super.queueActionEvent(context, component);
        } else {
            Object submittedValue = this.getSubmittedValue(bean);
            Date date = null;
            try {
                Object converted = this.getConvertedValue(context, component, submittedValue);
                if (converted instanceof Date) {
                    date = (Date)converted;
                } else {
                    GenericConverterFactory fac = GenericConverterFactory.getCurrentInstance();
                    if (fac.isConvertible(converted, Date.class)) {
                        date = (Date)fac.convert(converted, Date.class);
                    }
                }
            }
            catch (ConverterException ce) {
                _LOG.fine((Throwable)ce);
            }
            RequestContext afContext = RequestContext.getCurrentInstance();
            DateTimeRangeValidator dtrv = this._findDateTimeRangeValidator(bean);
            if (date == null) {
                date = new Date();
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("value", SimpleInputDateRenderer._getDateAsString(date));
            parameters.put("minValue", dtrv == null ? null : SimpleInputDateRenderer._getDateAsString(dtrv.getMinimum()));
            parameters.put("maxValue", dtrv == null ? null : SimpleInputDateRenderer._getDateAsString(dtrv.getMaximum()));
            parameters.put(GenericEntry.getEntryKeyParam(), "cd");
            afContext.launchDialog(GenericEntry.getGenericEntryViewRoot(context), parameters, component, true, null);
        }
    }

    protected void queueReturnEvent(FacesContext context, UIComponent component, ReturnEvent event) {
        Object returnValue = event.getReturnValue();
        GenericConverterFactory fac = GenericConverterFactory.getCurrentInstance();
        if (returnValue instanceof Date || fac.isConvertible(returnValue, Date.class)) {
            FacesBean bean = this.getFacesBean(component);
            Converter converter = this.getConverter(bean);
            if (converter == null) {
                converter = this.getDefaultConverter(context, bean);
            }
            returnValue = converter != null ? converter.getAsString(context, component, returnValue) : returnValue.toString();
            event = new ReturnEvent(component, returnValue, event.getReturnParameters());
        }
        event.queue();
    }

    protected void encodeAllAsElement(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        if (!_dateScriptletsRegistered) {
            DateTimeZoneOffsetScriptlet.sharedInstance().registerSelf();
            _dateScriptletsRegistered = true;
        }
        String chooseId = this._computeChooseId(context, component, bean);
        arc.getProperties().put(_CACHED_CHOOSE_ID, chooseId);
        XhtmlUtils.addLib(context, arc, "_dfsv()");
        XhtmlUtils.addLib(context, arc, "_fixDFF()");
        XhtmlUtils.addLib(context, arc, _DATE_TIME_ZONE_OFFSET_KEY);
        super.encodeAllAsElement(context, arc, component, bean);
        if (!this.getDisabled(bean)) {
            this._checkIfActive(context, arc, component, this._getChooseId(arc));
        }
    }

    protected void renderIcon(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        XhtmlUtils.addLib(context, arc, ConfigurationScriptlet.sharedInstance().getScriptletKey());
        if (CoreRenderKit.usePopupForDialog(context, RequestContext.getCurrentInstance())) {
            XhtmlUtils.addLib(context, arc, DialogStyleScriptlet.sharedInstance().getScriptletKey());
        }
        super.renderIcon(context, arc, component, bean);
    }

    protected void renderAfterTextField(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        if (this._getChooseId(arc) == null) {
            super.renderAfterTextField(context, arc, component, bean);
        }
    }

    protected Converter getDefaultConverter(FacesContext context, FacesBean bean) {
        Converter converter = context.getApplication().createConverter("javax.faces.DateTime");
        if (converter instanceof DateTimeConverter) {
            DateTimeConverter dtc = (DateTimeConverter)converter;
            boolean trinidadDTC = SimpleInputDateRenderer._isTrinidadDateTimeConverter(converter);
            if (!trinidadDTC) {
                dtc.setDateStyle("short");
            }
            if (!trinidadDTC || dtc.getTimeZone() == null) {
                TimeZone tz = null;
                RequestContext requestContext = RequestContext.getCurrentInstance();
                tz = requestContext.getTimeZone();
                if (tz == null) {
                    tz = TimeZone.getDefault();
                }
                dtc.setTimeZone(tz);
            }
        }
        return converter;
    }

    protected String getOnblur(FacesBean bean) {
        String onblur = super.getOnblur(bean);
        RenderingContext arc = RenderingContext.getCurrentInstance();
        String chooseId = this._getChooseId(arc);
        int length = _BLUR_PREFIX.length() + 4;
        if (chooseId != null) {
            length += chooseId.length();
        }
        StringBuilder buffer = new StringBuilder(length);
        buffer.append(_BLUR_PREFIX);
        if (chooseId != null) {
            buffer.append(",'");
            buffer.append(chooseId);
            buffer.append("'");
        }
        buffer.append(")");
        return XhtmlUtils.getChainedJS(buffer.toString(), onblur, false);
    }

    protected String getOnfocus(FacesBean bean) {
        String onfocus = super.getOnfocus(bean);
        RenderingContext arc = RenderingContext.getCurrentInstance();
        String chooseId = this._getChooseId(arc);
        if (chooseId != null) {
            int length = _FOCUS_PREFIX.length() + 4;
            StringBuilder buffer = new StringBuilder(length += chooseId.length());
            buffer.append(_FOCUS_PREFIX);
            buffer.append(",'");
            buffer.append(chooseId);
            buffer.append("'");
            buffer.append(")");
            return XhtmlUtils.getChainedJS(buffer.toString(), onfocus, false);
        }
        return onfocus;
    }

    protected String getLaunchOnclick(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        if (this.getActionExpression(bean) != null || !Boolean.TRUE.equals(arc.getAgent().getCapabilities().get(TrinidadAgent.CAP_MULTIPLE_WINDOWS))) {
            return super.getLaunchOnclick(context, arc, component, bean);
        }
        String id = arc.getCurrentClientId();
        if (id == null || arc.getFormData() == null) {
            return null;
        }
        StringBuilder onClickBuffer = new StringBuilder(100);
        onClickBuffer.append("_ldp('");
        onClickBuffer.append(arc.getFormData().getName());
        onClickBuffer.append("','");
        onClickBuffer.append(id);
        onClickBuffer.append('\'');
        onClickBuffer.append(',');
        onClickBuffer.append(CoreRenderKit.usePopupForDialog(context, RequestContext.getCurrentInstance()));
        DateTimeRangeValidator dtrv = this._findDateTimeRangeValidator(bean);
        if (dtrv != null) {
            String minTime = SimpleInputDateRenderer._getDateAsString(dtrv.getMinimum());
            String maxTime = SimpleInputDateRenderer._getDateAsString(dtrv.getMaximum());
            if (minTime != null || maxTime != null) {
                onClickBuffer.append(',');
                if (minTime != null) {
                    onClickBuffer.append(minTime);
                } else {
                    onClickBuffer.append("(void 0)");
                }
            }
            if (maxTime != null) {
                onClickBuffer.append(',');
                onClickBuffer.append(maxTime);
            }
        }
        onClickBuffer.append("); return false");
        return onClickBuffer.toString();
    }

    protected Integer getDefaultColumns(RenderingContext arc, FacesBean bean) {
        Integer columnsInteger = null;
        Converter converter = this.getConverter(bean);
        if (converter instanceof org.apache.myfaces.trinidadinternal.convert.DateTimeConverter) {
            int columns = ((org.apache.myfaces.trinidadinternal.convert.DateTimeConverter)converter).getColumns();
            columnsInteger = columns;
        } else {
            columnsInteger = _DEFAULT_COLUMNS;
        }
        return columnsInteger;
    }

    protected String getButtonIconName() {
        return "af|inputDate::launch-icon";
    }

    protected String getChooseId(FacesBean bean) {
        return SimpleInputDateRenderer.toString((Object)bean.getProperty(this._chooseIdKey));
    }

    protected String getSearchDesc(FacesBean bean) {
        RenderingContext arc = RenderingContext.getCurrentInstance();
        if (SimpleInputDateRenderer.isInaccessibleMode((RenderingContext)arc)) {
            return null;
        }
        return arc.getTranslatedString(_LAUNCH_PICKER_TIP_KEY);
    }

    protected String getRootStyleClass(FacesBean bean) {
        return "af|inputDate";
    }

    protected String getContentStyleClass(FacesBean bean) {
        return "af|inputDate::content";
    }

    private String _getChooseId(RenderingContext arc) {
        return (String)arc.getProperties().get(_CACHED_CHOOSE_ID);
    }

    private String _computeChooseId(FacesContext context, UIComponent component, FacesBean bean) {
        return RenderUtils.getRelativeId((FacesContext)context, (UIComponent)component, (String)this.getChooseId(bean));
    }

    private void _checkIfActive(FacesContext context, RenderingContext arc, UIComponent component, String chooseId) throws IOException {
        if (chooseId == null) {
            return;
        }
        String id = this.getClientId(context, component);
        HashMap<String, Boolean> activeDateFields = (HashMap<String, Boolean>)arc.getProperties().get(_ACTIVE_DATE_FIELDS_KEY);
        if (activeDateFields == null) {
            activeDateFields = new HashMap<String, Boolean>();
            arc.getProperties().put(_ACTIVE_DATE_FIELDS_KEY, activeDateFields);
        }
        if (activeDateFields.get(chooseId) == null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("script", component);
            SimpleInputDateRenderer.renderScriptTypeAttribute(context, arc);
            SimpleInputDateRenderer.renderScriptDeferAttribute(context, arc);
            writer.writeText((Object)"_dfa('", null);
            writer.writeText((Object)id, null);
            writer.writeText((Object)"','", null);
            writer.writeText((Object)chooseId, null);
            writer.writeText((Object)"');", null);
            writer.endElement("script");
            activeDateFields.put(chooseId, Boolean.TRUE);
        }
    }

    private DateTimeRangeValidator _findDateTimeRangeValidator(FacesBean bean) {
        Iterator<Validator> validators = this.getValidators(bean);
        while (validators.hasNext()) {
            Validator validator = validators.next();
            if (!(validator instanceof DateTimeRangeValidator)) continue;
            return (DateTimeRangeValidator)validator;
        }
        return null;
    }

    private static boolean _isTrinidadDateTimeConverter(Converter converter) {
        return converter instanceof org.apache.myfaces.trinidad.convert.DateTimeConverter;
    }

    private static String _getDateAsString(Date date) {
        if (date == null) {
            return null;
        }
        return String.valueOf(SimpleInputDateRenderer._adjustTimeZone(date));
    }

    private static long _adjustTimeZone(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        long dateValueInMs = calendar.getTimeInMillis();
        long tzOffset = calendar.get(15) + calendar.get(16);
        TimeZone timeZone = RequestContext.getCurrentInstance().getTimeZone();
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        tzOffset = (tzOffset -= (long)timeZone.getOffset(dateValueInMs)) < 0L ? (long)Math.max((float)tzOffset, -9.223372E18f - (float)dateValueInMs) : (long)Math.min((float)tzOffset, 9.223372E18f - (float)dateValueInMs);
        long adjusted = dateValueInMs + tzOffset;
        return adjusted;
    }

    private static class DateTimeZoneOffsetScriptlet
    extends Scriptlet {
        private static final Scriptlet _sInstance = new DateTimeZoneOffsetScriptlet();

        public static Scriptlet sharedInstance() {
            return _sInstance;
        }

        private DateTimeZoneOffsetScriptlet() {
        }

        public Object getScriptletKey() {
            return SimpleInputDateRenderer._DATE_TIME_ZONE_OFFSET_KEY;
        }

        protected void outputScriptletContent(FacesContext context, RenderingContext arc) throws IOException {
            TimeZone tz = arc.getLocaleContext().getTimeZone();
            int tzOffsetMinutes = tz.getOffset(System.currentTimeMillis()) / 60000;
            ResponseWriter writer = context.getResponseWriter();
            writer.writeText((Object)"var _uixLocaleTZ=", null);
            writer.writeText((Object)String.valueOf(tzOffsetMinutes), null);
            writer.writeText((Object)";", null);
        }
    }
}

