/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.html.layout;

import java.io.IOException;
import java.util.ListIterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.component.UIXShowDetail;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.render.CoreRenderer;
import org.apache.myfaces.trinidad.render.RenderUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.renderkit.html.layout.ShowOneListRendererBase;
import org.apache.myfaces.trinidadinternal.ui.UIConstants;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.laf.base.BaseLafUtils;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLafRenderer;

public class CorePanelRadioRenderer
extends ShowOneListRendererBase {
    private static final String _RADIO_TABLE_SUFFIX_ID_CONST = "_sor_tbl";
    private static final String _RADIO_SPAN_SUFFIX_ID_CONST = "_sor_tbl_span";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(CorePanelRadioRenderer.class);

    protected void renderListDisplay(FacesContext context, UIComponent component, String disclosedChildId) throws IOException {
        _LOG.finest("CorePanelRadioRenderer.renderRadioFacet: disclosedChildId: {0}", (Object)disclosedChildId);
        UIXRenderingContext rCtx = CorePanelRadioRenderer.getRenderingContext(context, component);
        String compId = component.getClientId(context);
        ResponseWriter out = context.getResponseWriter();
        out.startElement("table", component);
        out.writeAttribute("id", (Object)(compId + _RADIO_TABLE_SUFFIX_ID_CONST), null);
        out.writeAttribute("border", (Object)"0", null);
        out.writeAttribute("cellspacing", (Object)"0", null);
        out.writeAttribute("cellpadding", (Object)"0", null);
        if (!XhtmlLafRenderer.isInaccessibleMode(rCtx)) {
            out.writeAttribute("summary", (Object)"", null);
        }
        out.startElement("tr", component);
        String label = (String)component.getAttributes().get("label");
        out.startElement("td", component);
        out.writeAttribute("align", (Object)"left", null);
        out.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
        out.startElement("span", component);
        XhtmlLafRenderer.renderStyleClassAttribute(rCtx, "AFLabelText");
        if (label != null) {
            out.writeText((Object)label, null);
        }
        out.endElement("span");
        out.endElement("td");
        this.renderSpacerTD(out, component, this.getLabelControlSeparatorSize());
        this._renderRadioItemsInTD(context, component, out, rCtx, compId, disclosedChildId);
        out.endElement("tr");
        out.endElement("table");
    }

    private void _renderRadioItemsInTD(FacesContext context, UIComponent component, ResponseWriter out, UIXRenderingContext rCtx, String compId, String disclosedChildId) throws IOException {
        out.startElement("td", component);
        out.writeAttribute("valign", (Object)"top", null);
        out.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
        String formName = RenderUtils.getFormId((FacesContext)context, (UIComponent)component);
        out.startElement("table", component);
        out.writeAttribute("id", (Object)(compId + disclosedChildId), null);
        out.writeAttribute("summary", (Object)"", null);
        out.writeAttribute("border", (Object)"0", null);
        out.writeAttribute("cellspacing", (Object)"0", null);
        out.writeAttribute("cellpadding", (Object)"0", null);
        ListIterator children = component.getChildren().listIterator();
        while (children.hasNext()) {
            String submitJS;
            boolean isImmediate;
            UIComponent child = (UIComponent)children.next();
            if (!(child instanceof UIXShowDetail)) continue;
            UIXShowDetail detailItem = (UIXShowDetail)child;
            String childClientId = child.getClientId(context);
            out.startElement("tr", component);
            out.startElement("td", component);
            boolean isRTL = BaseLafUtils.isRightToLeft(rCtx);
            if (isRTL) {
                out.writeAttribute("align", (Object)"right", null);
            } else {
                out.writeAttribute("align", (Object)"left", null);
            }
            out.writeAttribute("valign", (Object)"top", null);
            out.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
            out.startElement("span", component);
            out.writeAttribute("id", (Object)(childClientId + _RADIO_SPAN_SUFFIX_ID_CONST), null);
            Boolean disabledObj = (Boolean)detailItem.getAttributes().get(UIConstants.DISABLED_ATTR.getAttributeName());
            boolean disabled = false;
            if (disabledObj != null) {
                disabled = disabledObj;
            }
            if (!disclosedChildId.equals(childClientId) && !disabled) {
                isImmediate = detailItem.isImmediate();
                submitJS = this._getRadioSubmitJS(component, rCtx, formName, compId, childClientId, isImmediate);
                if (!CoreRenderer.isPDA((RenderingContext)RenderingContext.getCurrentInstance())) {
                    out.writeAttribute("onclick", (Object)submitJS, null);
                }
            }
            out.startElement("input", component);
            out.writeAttribute("id", (Object)childClientId, null);
            out.writeAttribute("value", (Object)childClientId, null);
            out.writeAttribute("name", (Object)compId, null);
            if (CoreRenderer.isPDA((RenderingContext)RenderingContext.getCurrentInstance())) {
                isImmediate = detailItem.isImmediate();
                submitJS = this._getRadioSubmitJS(component, rCtx, formName, compId, childClientId, isImmediate);
                out.writeAttribute("onclick", (Object)submitJS, null);
            }
            if (disabled) {
                out.writeAttribute("disabled", (Object)Boolean.TRUE, null);
            }
            out.writeAttribute("type", (Object)"radio", null);
            if (disclosedChildId.equals(childClientId)) {
                out.writeAttribute("checked", (Object)Boolean.TRUE, null);
            }
            out.endElement("input");
            out.startElement("label", component);
            out.writeAttribute("for", (Object)childClientId, null);
            Character accessChar = (Character)detailItem.getAttributes().get("accessKey");
            if (accessChar != null) {
                out.writeAttribute("accessKey", (Object)accessChar.toString(), null);
            }
            out.startElement("span", component);
            String radioSpanClass = this.getFieldTextClass();
            if (disabled) {
                radioSpanClass = "AFFieldTextDisabled";
            }
            XhtmlLafRenderer.renderStyleClassAttribute(rCtx, radioSpanClass);
            this.writeLabel(out, (UIComponent)detailItem, (String)detailItem.getAttributes().get("text"));
            out.endElement("span");
            out.endElement("label");
            out.endElement("span");
            out.endElement("td");
            out.endElement("tr");
        }
        if (!XhtmlRenderer.supportsScripting(RenderingContext.getCurrentInstance())) {
            out.startElement("tr", component);
            out.startElement("td", component);
            if (BaseLafUtils.isRightToLeft(rCtx)) {
                out.writeAttribute("align", (Object)"right", null);
            } else {
                out.writeAttribute("align", (Object)"left", null);
            }
            out.writeAttribute("valign", (Object)"top", null);
            out.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
            String nameAttri = XhtmlUtils.getEncodedParameter("multipleValueParam") + XhtmlUtils.getEncodedParameter(compId) + XhtmlUtils.getEncodedParameter("event") + "show";
            out.startElement("span", null);
            out.startElement("input", null);
            out.writeAttribute("value", (Object)"go", null);
            out.writeAttribute("type", (Object)"submit", null);
            out.writeAttribute("name", (Object)nameAttri, null);
            out.endElement("input");
            out.endElement("span");
            out.endElement("td");
            out.endElement("tr");
        }
        out.endElement("table");
        out.endElement("td");
    }

    private String _getRadioSubmitJS(UIComponent component, UIXRenderingContext rCtx, String formName, String compId, String detailChildId, boolean isImmediate) {
        if (formName == null) {
            _LOG.warning("PAGE_NOT_CONTAIN_FORM_ELEMENT");
            return null;
        }
        String validate = "1";
        if (isImmediate) {
            validate = "0";
        }
        String onClickHandler = "";
        boolean pprEnabled = this.elementSupportsPartial(rCtx, compId);
        if (pprEnabled) {
            if (CoreRenderer.isPDA((RenderingContext)RenderingContext.getCurrentInstance())) {
                StringBuilder jsBuff = new StringBuilder(135);
                jsBuff.append("submitForm('").append(formName).append("',").append(validate).append(",{event:'show',source:'").append(detailChildId).append("'});return true;");
                onClickHandler = jsBuff.toString();
            } else {
                StringBuilder jsBuff = new StringBuilder(220);
                jsBuff.append("_submitPartialChange('").append(formName).append("',").append(validate).append(", {event:'show',source:'").append(detailChildId).append("'});return true;");
                onClickHandler = jsBuff.toString();
            }
        } else {
            StringBuilder jsBuff = new StringBuilder(135);
            jsBuff.append("submitForm('").append(formName).append("',").append(validate).append(",{event:'show',source:'").append(detailChildId).append("'});return true;");
            onClickHandler = jsBuff.toString();
        }
        return onClickHandler;
    }
}

