/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidad.util.URLUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SkinProperties;
import org.apache.myfaces.trinidadinternal.share.expl.Coercions;
import org.apache.myfaces.trinidadinternal.share.io.InputStreamProvider;
import org.apache.myfaces.trinidadinternal.share.io.NameResolver;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.apache.myfaces.trinidadinternal.share.xml.XMLUtils;
import org.apache.myfaces.trinidadinternal.skin.SkinCSSDocumentHandler;
import org.apache.myfaces.trinidadinternal.skin.SkinCSSParser;
import org.apache.myfaces.trinidadinternal.skin.SkinSelectorPropertiesNode;
import org.apache.myfaces.trinidadinternal.skin.SkinStyleSheetNode;
import org.apache.myfaces.trinidadinternal.skin.StyleSheetEntry;
import org.apache.myfaces.trinidadinternal.skin.icon.ContextImageIcon;
import org.apache.myfaces.trinidadinternal.skin.icon.NullIcon;
import org.apache.myfaces.trinidadinternal.skin.icon.TextIcon;
import org.apache.myfaces.trinidadinternal.skin.icon.URIImageIcon;
import org.apache.myfaces.trinidadinternal.style.CSSStyle;
import org.apache.myfaces.trinidadinternal.style.util.CSSUtils;
import org.apache.myfaces.trinidadinternal.style.xml.parse.IconNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.IncludeStyleNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.PropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.SkinPropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetDocument;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SkinStyleSheetParserUtils {
    private static final String _TR_PROPERTY_PREFIX = "-tr-";
    private static final String _ORA_PROPERTY_PREFIX = "-ora-";
    private static final String _PROPERTY_RULE_REF = "rule-ref";
    private static final String _PROPERTY_INHIBIT = "inhibit";
    private static final String _PROPERTY_TEXT_ANTIALIAS = "text-antialias";
    private static final Pattern _SPACE_PATTERN = Pattern.compile("\\s");
    private static final Pattern _SELECTOR_PATTERN = Pattern.compile("selector\\(");
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SkinStyleSheetParserUtils.class);

    SkinStyleSheetParserUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parseCSSSource(ParseContext context, NameResolver resolver, String sourceName, Class<?> expectedType) throws IOException {
        if (expectedType == null) {
            throw new NullPointerException();
        }
        if (resolver == null) {
            throw new NullPointerException();
        }
        if (sourceName == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        InputStreamProvider provider = resolver.getProvider(sourceName);
        Object cached = provider.getCachedResult();
        if (cached != null && expectedType.isInstance(cached)) {
            return cached;
        }
        InputStream stream = provider.openInputStream();
        try {
            XMLUtils.setResolver(context, resolver.getResolver(sourceName));
            XMLUtils.setInputStreamProvider(context, provider);
            BufferedReader in = new BufferedReader(new InputStreamReader(stream));
            List<SkinStyleSheetNode> skinSSNodeList = SkinStyleSheetParserUtils._parseCSSStyleSheet(in);
            in.close();
            StyleSheetEntry styleSheetEntry = SkinStyleSheetParserUtils._createStyleSheetEntry(context, sourceName, skinSSNodeList);
            provider.setCachedResult(styleSheetEntry);
            StyleSheetEntry styleSheetEntry2 = styleSheetEntry;
            return styleSheetEntry2;
        }
        finally {
            stream.close();
        }
    }

    public static String trimQuotes(String in) {
        char lastChar;
        int length = in.length();
        if (length <= 1) {
            return in;
        }
        char firstChar = in.charAt(0);
        int firstCharIndex = 0;
        if (firstChar == '\'' || firstChar == '\"') {
            firstCharIndex = 1;
        }
        if ((lastChar = in.charAt(length - 1)) == '\'' || lastChar == '\"') {
            --length;
        }
        return in.substring(firstCharIndex, length);
    }

    private static StyleSheetEntry _createStyleSheetEntry(ParseContext context, String sourceName, List<SkinStyleSheetNode> skinSSNodeList) {
        ArrayList<StyleSheetNode> ssNodeList = new ArrayList<StyleSheetNode>();
        String baseSourceURI = CSSUtils.getBaseSkinStyleSheetURI(sourceName);
        for (SkinStyleSheetNode skinSSNode : skinSSNodeList) {
            List<SkinSelectorPropertiesNode> selectorNodeList = skinSSNode.getSelectorNodeList();
            ArrayList<StyleNode> styleNodeList = new ArrayList<StyleNode>();
            ArrayList<IconNode> iconNodeList = new ArrayList<IconNode>();
            ArrayList<SkinPropertyNode> trSkinPropertyNodeList = new ArrayList<SkinPropertyNode>();
            for (SkinSelectorPropertiesNode cssSelector : selectorNodeList) {
                String selectorName = cssSelector.getSelectorName();
                List<PropertyNode> propertyList = cssSelector.getPropertyNodes();
                int direction = skinSSNode.getDirection();
                ResolvedSkinProperties resolvedProperties = SkinStyleSheetParserUtils._resolveProperties(selectorName, propertyList);
                trSkinPropertyNodeList.addAll(resolvedProperties.getSkinPropertyNodeList());
                List<PropertyNode> noTrPropertyList = resolvedProperties.getNoTrPropertyList();
                if (SkinStyleSheetParserUtils._isIcon(selectorName)) {
                    boolean addStyleNode;
                    if (selectorName.charAt(0) == '.') {
                        selectorName = selectorName.substring(1);
                    }
                    selectorName = selectorName.replaceFirst(":alias", "");
                    if (direction == 2) {
                        selectorName = selectorName.concat(":rtl");
                    }
                    if (!(addStyleNode = SkinStyleSheetParserUtils._addIconNode(sourceName, baseSourceURI, selectorName, noTrPropertyList, iconNodeList))) continue;
                    SkinStyleSheetParserUtils._addStyleNode(selectorName, noTrPropertyList, resolvedProperties.getTrRuleRefList(), resolvedProperties.getInhibitedProperties(), resolvedProperties.isTrTextAntialias(), styleNodeList);
                    continue;
                }
                SkinStyleSheetParserUtils._addStyleNode(selectorName, noTrPropertyList, resolvedProperties.getTrRuleRefList(), resolvedProperties.getInhibitedProperties(), resolvedProperties.isTrTextAntialias(), styleNodeList);
            }
            if (styleNodeList.size() <= 0 && iconNodeList.size() <= 0 && trSkinPropertyNodeList.size() <= 0) continue;
            StyleNode[] styleNodeArray = styleNodeList.toArray(new StyleNode[0]);
            StyleSheetNode ssNode = new StyleSheetNode(styleNodeArray, iconNodeList, trSkinPropertyNodeList, null, skinSSNode.getDirection(), skinSSNode.getAgentVersions(), skinSSNode.getPlatforms(), 0, skinSSNode.getAcessibilityProperties());
            ssNodeList.add(ssNode);
        }
        StyleSheetDocument ssDocument = SkinStyleSheetParserUtils._createStyleSheetDocument(context, ssNodeList);
        return new StyleSheetEntry(sourceName, ssDocument);
    }

    private static ResolvedSkinProperties _resolveProperties(String selectorName, List<PropertyNode> propertyNodeList) {
        ArrayList<PropertyNode> noTrPropertyList = new ArrayList<PropertyNode>();
        ArrayList<String> trRuleRefList = new ArrayList<String>();
        TreeSet<String> inhibitedPropertySet = new TreeSet<String>();
        ArrayList<SkinPropertyNode> skinPropertyNodeList = new ArrayList<SkinPropertyNode>();
        boolean trTextAntialias = false;
        for (PropertyNode propertyNode : propertyNodeList) {
            String propertyName = propertyNode.getName();
            String propertyValue = propertyNode.getValue();
            if (propertyName == null || propertyValue == null) continue;
            boolean oraProperty = propertyName.startsWith(_ORA_PROPERTY_PREFIX);
            boolean trProperty = propertyName.startsWith(_TR_PROPERTY_PREFIX);
            if (oraProperty || trProperty) {
                int suffixIndex = oraProperty ? _ORA_PROPERTY_PREFIX.length() : _TR_PROPERTY_PREFIX.length();
                String propertyNameSuffix = propertyName.substring(suffixIndex);
                if (propertyNameSuffix.equals(_PROPERTY_RULE_REF)) {
                    trRuleRefList.add(propertyValue);
                    continue;
                }
                if (propertyNameSuffix.equals(_PROPERTY_TEXT_ANTIALIAS)) {
                    if (!"true".equals(propertyValue)) continue;
                    trTextAntialias = true;
                    continue;
                }
                if (propertyNameSuffix.equals(_PROPERTY_INHIBIT)) {
                    for (String value : _SPACE_PATTERN.split(propertyValue)) {
                        inhibitedPropertySet.add(value);
                    }
                    continue;
                }
                SkinPropertyNode node = SkinStyleSheetParserUtils._createSkinPropertyNode(selectorName, propertyName, propertyValue);
                skinPropertyNodeList.add(node);
                continue;
            }
            noTrPropertyList.add(propertyNode);
        }
        return new ResolvedSkinProperties(noTrPropertyList, trRuleRefList, inhibitedPropertySet, skinPropertyNodeList, trTextAntialias);
    }

    private static boolean _addIconNode(String sourceName, String baseSourceURI, String selectorName, List<PropertyNode> noTrPropertyNodeList, List<IconNode> iconNodeList) {
        Integer width = null;
        String widthValue = null;
        Integer height = null;
        String heightValue = null;
        String uri = null;
        String text = null;
        boolean isNullIcon = false;
        boolean createStyleNode = false;
        CSSStyle inlineStyle = null;
        for (PropertyNode propertyNode : noTrPropertyNodeList) {
            String propertyName = propertyNode.getName();
            String propertyValue = propertyNode.getValue();
            if (propertyName.equals("width")) {
                widthValue = propertyValue;
                width = SkinStyleSheetParserUtils._convertPxDimensionStringToInteger(widthValue);
                continue;
            }
            if (propertyName.equals("height")) {
                heightValue = propertyValue;
                height = SkinStyleSheetParserUtils._convertPxDimensionStringToInteger(heightValue);
                continue;
            }
            if (propertyName.equals("content")) {
                if (SkinStyleSheetParserUtils._isURLValue(propertyValue)) {
                    uri = SkinStyleSheetParserUtils._getURIString(propertyValue);
                    continue;
                }
                if (propertyValue.startsWith(_PROPERTY_INHIBIT)) {
                    isNullIcon = true;
                    continue;
                }
                text = SkinStyleSheetParserUtils.trimQuotes(propertyValue);
                continue;
            }
            if (inlineStyle == null) {
                inlineStyle = new CSSStyle();
            }
            inlineStyle.setProperty(propertyName, propertyValue);
        }
        Icon icon = null;
        if (!isNullIcon) {
            if (text != null) {
                if ((heightValue != null || widthValue != null) && inlineStyle == null) {
                    inlineStyle = new CSSStyle();
                }
                if (heightValue != null) {
                    inlineStyle.setProperty("height", heightValue);
                }
                if (widthValue != null) {
                    inlineStyle.setProperty("width", widthValue);
                }
                icon = new TextIcon(text, text, null, inlineStyle);
            } else if (uri != null) {
                boolean startsWithTwoSlashes = uri.startsWith("//");
                if (!startsWithTwoSlashes && uri.startsWith("/")) {
                    uri = uri.substring(1);
                    icon = new ContextImageIcon(uri, uri, width, height, null, inlineStyle);
                } else {
                    if (startsWithTwoSlashes) {
                        uri = uri.substring(1);
                    } else if (!uri.startsWith("http:")) {
                        uri = CSSUtils.getAbsoluteURIValue(sourceName, baseSourceURI, uri);
                    }
                    icon = new URIImageIcon(uri, uri, width, height, null, inlineStyle);
                }
            } else if (inlineStyle != null) {
                createStyleNode = true;
            }
        } else {
            icon = NullIcon.sharedInstance();
        }
        if (icon != null) {
            iconNodeList.add(new IconNode(selectorName, icon));
        }
        return createStyleNode;
    }

    private static void _addStyleNode(String selectorName, List<PropertyNode> propertyNodeList, List<String> trRuleRefList, Set<String> inhibitedProperties, boolean trTextAntialias, List<StyleNode> styleNodeList) {
        String name = null;
        String selector = null;
        int aliasIndex = selectorName.indexOf(":alias");
        if (aliasIndex > -1) {
            name = selectorName.substring(1, aliasIndex);
        } else {
            selector = selectorName;
        }
        if (trTextAntialias) {
            propertyNodeList.add(new PropertyNode(_PROPERTY_TEXT_ANTIALIAS, "true"));
        }
        PropertyNode[] propertyArray = propertyNodeList.toArray(new PropertyNode[propertyNodeList.size()]);
        int length = trRuleRefList.size();
        ArrayList<IncludeStyleNode> includeStyleNodes = new ArrayList<IncludeStyleNode>();
        if (length > 0) {
            for (String value : trRuleRefList) {
                SkinStyleSheetParserUtils._addIncludeStyleNodes(value, includeStyleNodes);
            }
        }
        StyleNode styleNode = new StyleNode(name, selector, propertyArray, includeStyleNodes.toArray(new IncludeStyleNode[0]), null, inhibitedProperties);
        styleNodeList.add(styleNode);
    }

    private static SkinPropertyNode _createSkinPropertyNode(String selector, String name, String value) {
        Object propValueObj;
        String key;
        block3: {
            StringBuilder keyBuilder = new StringBuilder(selector.length() + name.length());
            keyBuilder.append(selector);
            keyBuilder.append(name);
            key = keyBuilder.toString();
            Class<?> type = SkinProperties.PROPERTY_CLASS_TYPE_MAP.get(key);
            propValueObj = null;
            if (type != null) {
                try {
                    propValueObj = Coercions.coerce(null, value, type);
                }
                catch (IllegalArgumentException ex) {
                    if (!_LOG.isWarning()) break block3;
                    _LOG.warning((Throwable)ex);
                }
            }
        }
        SkinPropertyNode node = new SkinPropertyNode(key, propValueObj != null ? propValueObj : value);
        return node;
    }

    private static void _addIncludeStyleNodes(String value, List<IncludeStyleNode> includeStyleNodes) {
        if (value != null) {
            ArrayList<String> selectors = new ArrayList<String>();
            String[] test = _SELECTOR_PATTERN.split(value);
            for (int i = 0; i < test.length; ++i) {
                int endIndex = test[i].indexOf(")");
                if (endIndex <= -1) continue;
                String selectorValue = test[i].substring(0, endIndex);
                selectorValue = SkinStyleSheetParserUtils.trimQuotes(selectorValue);
                selectors.add(selectorValue);
            }
            int size = selectors.size();
            for (int i = 0; i < size; ++i) {
                String includeStyle = (String)selectors.get(i);
                if (includeStyle.endsWith(":alias")) {
                    int endIndex = includeStyle.indexOf(":alias");
                    int startIndex = 0;
                    if (includeStyle.charAt(0) == '.') {
                        startIndex = 1;
                    }
                    includeStyleNodes.add(new IncludeStyleNode(includeStyle.substring(startIndex, endIndex), null));
                    continue;
                }
                includeStyleNodes.add(new IncludeStyleNode(null, includeStyle));
            }
        }
    }

    private static StyleSheetDocument _createStyleSheetDocument(ParseContext context, List<StyleSheetNode> ssNodeList) {
        long timestamp = SkinStyleSheetParserUtils._getDocumentTimestamp(context);
        return new StyleSheetDocument(ssNodeList.toArray(new StyleSheetNode[0]), null, timestamp);
    }

    private static long _getDocumentTimestamp(ParseContext parseContext) {
        long timestamp = -1L;
        InputStreamProvider provider = XMLUtils.getInputStreamProvider(parseContext);
        if (provider != null) {
            Object identifier = provider.getIdentifier();
            if (identifier instanceof File) {
                timestamp = ((File)identifier).lastModified();
            } else if (identifier instanceof URL) {
                try {
                    timestamp = URLUtils.getLastModified((URL)((URL)identifier));
                }
                catch (IOException io) {
                    _LOG.warning("CANNOT_GET_STYLESHEET_DOCUMENT_TIMESTAMP");
                }
            }
        }
        return timestamp;
    }

    private static List<SkinStyleSheetNode> _parseCSSStyleSheet(Reader reader) {
        SkinCSSParser parser = new SkinCSSParser();
        SkinCSSDocumentHandler documentHandler = new SkinCSSDocumentHandler();
        parser.parseCSSDocument(reader, documentHandler);
        return documentHandler.getSkinStyleSheetNodes();
    }

    private static boolean _isURLValue(String propertyValue) {
        return propertyValue.startsWith("url(");
    }

    private static String _getURIString(String propertyValue) {
        assert (SkinStyleSheetParserUtils._isURLValue(propertyValue));
        int uriEnd = propertyValue.indexOf(41);
        String uri = propertyValue.substring(4, uriEnd);
        return SkinStyleSheetParserUtils.trimQuotes(uri);
    }

    private static boolean _isIcon(String selectorName) {
        return selectorName.endsWith("-icon") || selectorName.indexOf("-icon:") > -1 || selectorName.indexOf("Icon:alias") > -1;
    }

    private static Integer _convertPxDimensionStringToInteger(String propertyValue) {
        int pxPosition = propertyValue.indexOf("px");
        if (pxPosition > -1) {
            propertyValue = propertyValue.substring(0, pxPosition);
        }
        return Integer.valueOf(propertyValue);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResolvedSkinProperties {
        private Set<String> _inhibitedPropertySet;
        private List<PropertyNode> _noTrPropertyList;
        private List<String> _trRuleRefList;
        private List<SkinPropertyNode> _skinPropertyNodeList;
        private boolean _trTextAntialias;

        ResolvedSkinProperties(List<PropertyNode> noTrPropertyList, List<String> trRuleRefList, Set<String> inhibitedPropertySet, List<SkinPropertyNode> skinPropertyNodeList, boolean trTextAntialias) {
            this._noTrPropertyList = noTrPropertyList;
            this._trRuleRefList = trRuleRefList;
            this._inhibitedPropertySet = inhibitedPropertySet;
            this._skinPropertyNodeList = skinPropertyNodeList;
            this._trTextAntialias = trTextAntialias;
        }

        public List<PropertyNode> getNoTrPropertyList() {
            return this._noTrPropertyList;
        }

        public List<String> getTrRuleRefList() {
            return this._trRuleRefList;
        }

        public List<SkinPropertyNode> getSkinPropertyNodeList() {
            return this._skinPropertyNodeList;
        }

        public Set<String> getInhibitedProperties() {
            return this._inhibitedPropertySet;
        }

        public boolean isTrTextAntialias() {
            return this._trTextAntialias;
        }
    }
}

