/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.util;

import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.render.RenderUtils;
import org.apache.myfaces.trinidad.util.FastMessageFormat;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.laf.base.BaseLafRenderer;

public class MessageUtils {
    private static final String _GLOBAL_FORMAT_KEY = "af_messages.GLOBAL_MESSAGE_FORMAT";
    private static final String _MESSAGE_BOX_LIST_FORMAT_KEY = "af_messages.LIST_FORMAT_private";

    private MessageUtils() {
    }

    public static FacesMessage getFacesMessage(FacesContext context, String clientId) {
        Iterator messages;
        if (clientId != null && (messages = context.getMessages(clientId)).hasNext()) {
            return (FacesMessage)messages.next();
        }
        return null;
    }

    public static String getMessageTypeFromSeverity(FacesMessage.Severity severity) {
        if (severity == FacesMessage.SEVERITY_INFO) {
            return "info";
        }
        if (severity == FacesMessage.SEVERITY_WARN) {
            return "warning";
        }
        return "error";
    }

    public static String getClientIdFor(FacesContext context, UIComponent from, String forParam) {
        return RenderUtils.getRelativeId((FacesContext)context, (UIComponent)from, (String)forParam);
    }

    public static boolean multipleMessagesQueued(FacesContext context, boolean globalOnly) {
        Iterator msgIter = null;
        msgIter = globalOnly ? context.getMessages(null) : context.getMessages();
        if (msgIter.hasNext()) {
            msgIter.next();
            if (msgIter.hasNext()) {
                return true;
            }
        }
        return false;
    }

    public static String getAnchor(String clientID) {
        if (clientID == null) {
            return null;
        }
        return "_msgAnc_" + clientID;
    }

    @Deprecated
    public static String getGlobalMessage(UIXRenderingContext context, String summary, String detail) {
        if (summary != null && summary.equals(detail)) {
            return summary;
        }
        Object[] parameters = new String[]{summary, detail};
        String pattern = BaseLafRenderer.getTranslatedString(context, _GLOBAL_FORMAT_KEY);
        return new FastMessageFormat(pattern).format(parameters);
    }

    public static String getGlobalMessage(RenderingContext arc, String summary, String detail) {
        if (summary != null && summary.equals(detail)) {
            return summary;
        }
        Object[] parameters = new String[]{summary, detail};
        String pattern = arc.getTranslatedString(_GLOBAL_FORMAT_KEY);
        return new FastMessageFormat(pattern).format(parameters);
    }

    public static String getClientMessage(RenderingContext arc, String summary, String detail) {
        Object[] parameters = new String[]{summary};
        String pattern = arc.getTranslatedString(_MESSAGE_BOX_LIST_FORMAT_KEY);
        return new FastMessageFormat(pattern).format(parameters);
    }
}

