/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.collection;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.myfaces.trinidad.util.ArrayMap;
import org.apache.myfaces.trinidadinternal.ui.AttributeKey;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.collection.AttributeMap;

@Deprecated
public class ArrayAttributeMap
implements AttributeMap {
    private static final Object[] _EMPTY_KEY_VALUES = new Object[0];
    private Object[] _keyValues;
    private int _size;
    private int _increment;

    public ArrayAttributeMap() {
        this(0);
    }

    public ArrayAttributeMap(int size) {
        this(size, 5);
    }

    public ArrayAttributeMap(int size, int increment) {
        if (increment < 1 || size < 0) {
            throw new IllegalArgumentException();
        }
        this._keyValues = size > 0 ? new Object[2 * size] : _EMPTY_KEY_VALUES;
        this._increment = increment;
    }

    @Override
    public Object getAttribute(UIXRenderingContext context, AttributeKey key) {
        return ArrayMap.getByIdentity((Object[])this._keyValues, (Object)key);
    }

    @Override
    public void setAttribute(AttributeKey key, Object value) {
        if (value != null) {
            this.putAttribute(key, value);
        } else {
            this.removeAttribute(key);
        }
    }

    @Override
    public Iterator<AttributeKey> attributeKeys(UIXRenderingContext context) {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        ArrayList<AttributeKey> keyValuesList = new ArrayList<AttributeKey>();
        for (int i = (size - 1) * 2; i >= 0; i -= 2) {
            keyValuesList.add((AttributeKey)this._keyValues[i]);
        }
        return keyValuesList.iterator();
    }

    public int size() {
        return this._size;
    }

    public Object clone() {
        try {
            ArrayAttributeMap am = (ArrayAttributeMap)super.clone();
            if (this._keyValues != _EMPTY_KEY_VALUES) {
                am._keyValues = (Object[])this._keyValues.clone();
            }
            return am;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public String toString() {
        int entryCount = this.size() * 2;
        Object[] keyValues = this._keyValues;
        StringBuffer keyValuesBuffer = new StringBuffer(10 * entryCount);
        keyValuesBuffer.append(super.toString());
        keyValuesBuffer.append('[');
        for (int i = 0; i < entryCount; i += 2) {
            keyValuesBuffer.append(keyValues[i]);
            keyValuesBuffer.append('=');
            keyValuesBuffer.append(keyValues[i + 1]);
            keyValuesBuffer.append(',');
        }
        keyValuesBuffer.append(']');
        return keyValuesBuffer.toString();
    }

    protected void putAttribute(AttributeKey key, Object value) {
        int size = this.size();
        int entryCount = size * 2;
        Object[] keyValues = this._keyValues;
        for (int i = 0; i < entryCount; i += 2) {
            if (keyValues[i] != key) continue;
            keyValues[i + 1] = value;
            return;
        }
        Object[] newKeyValues = keyValues;
        if (entryCount >= keyValues.length) {
            newKeyValues = new Object[entryCount + 2 * this._increment];
            if (entryCount != 0) {
                System.arraycopy(keyValues, 0, newKeyValues, 2, entryCount);
            }
            newKeyValues[0] = key;
            newKeyValues[1] = value;
            this._keyValues = newKeyValues;
        } else {
            newKeyValues[entryCount] = key;
            newKeyValues[entryCount + 1] = value;
        }
        ++this._size;
    }

    protected void removeAttribute(AttributeKey key) {
        int size = this.size();
        if (size > 0) {
            int entryCount = size * 2;
            Object[] keyValues = this._keyValues;
            for (int i = 0; i < entryCount; i += 2) {
                if (keyValues[i] != key) continue;
                System.arraycopy(keyValues, i + 2, keyValues, i, entryCount - i - 2);
                keyValues[entryCount - 1] = null;
                keyValues[entryCount - 2] = null;
                --this._size;
                return;
            }
        }
    }
}

