/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.util;

import java.util.HashMap;
import java.util.TimeZone;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

public final class DateUtils {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(DateUtils.class);
    private static HashMap<String, String> _supportedTimeZoneIdsMap;

    private DateUtils() {
    }

    public static TimeZone getSupportedTimeZone(String id) {
        String officialId = _supportedTimeZoneIdsMap.get(id.toLowerCase());
        if (officialId != null) {
            return TimeZone.getTimeZone(officialId);
        }
        _LOG.warning("CANNOT_FIND_TIMEZONE", (Object)id);
        return null;
    }

    static {
        String[] supportedIds = TimeZone.getAvailableIDs();
        _supportedTimeZoneIdsMap = new HashMap(supportedIds.length);
        for (int i = 0; i < supportedIds.length; ++i) {
            String id = supportedIds[i];
            _supportedTimeZoneIdsMap.put(id.toLowerCase(), id);
        }
    }
}

