/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.digester.AbstractObjectCreationFactory;
import org.apache.commons.digester.Digester;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.GeneratorHelper;
import org.apache.myfaces.trinidadbuild.plugin.faces.io.PrettyWriter;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.AttributeBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ComponentBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ConverterBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.FacesConfigBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.FacesConfigParser;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ValidatorBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.AttributeFilter;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.ComponentFilter;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.ConverterFilter;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.Util;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.ValidatorFilter;
import org.codehaus.plexus.util.FileUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AbstractFacesMojo
extends AbstractMojo {
    private File licenseHeaderFile;
    private boolean skipApiOrBaseClasses;
    private File localResource;
    private FacesConfigBean _facesConfig;
    private String _licenseHeader;
    private static final String _AUTO_GENERATE_WARNING = "// WARNING: This file was automatically generated. Do not edit it directly,\n//          or you will lose your changes.\n\n";
    private static final String _DEFAULT_LICENSE_HEADER = "/*\n * Licensed to the Apache Software Foundation (ASF) under one\n * or more contributor license agreements.  See the NOTICE file\n * distributed with this work for additional information\n * regarding copyright ownership.  The ASF licenses this file\n * to you under the Apache License, Version 2.0 (the\n * \"License\"); you may not use this file except in compliance\n * with the License.  You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing,\n * software distributed under the License is distributed on an\n * \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\n * KIND, either express or implied.  See the License for the\n * specific language governing permissions and limitations\n * under the License.\n*/\n";
    static /* synthetic */ Class class$org$apache$myfaces$trinidadbuild$plugin$faces$AbstractFacesMojo$URLCreationFactory;

    protected List getCompileDependencyResources(MavenProject project, String resourcePath) throws MojoExecutionException {
        try {
            ClassLoader cl = this.createCompileClassLoader(project);
            Enumeration<URL> e = cl.getResources(resourcePath);
            ArrayList<URL> urls = new ArrayList<URL>();
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                urls.add(url);
            }
            return Collections.unmodifiableList(urls);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to get resources for path \"" + resourcePath + "\"", (Exception)e);
        }
    }

    protected void addResourceRoot(MavenProject project, String resourceRoot) {
        List resources = project.getBuild().getResources();
        Resource resource = new Resource();
        resource.setDirectory(resourceRoot);
        resources.add(resource);
    }

    protected URL[] readIndex(MavenProject project, String resourcePath) throws MojoExecutionException {
        return this.readIndex(project);
    }

    protected List getMasterConfigs(MavenProject project) throws MojoExecutionException {
        if (this.localResource != null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            try {
                urls.add(this.localResource.toURL());
            }
            catch (MalformedURLException e) {
                this.getLog().error((CharSequence)"", (Throwable)e);
            }
            return urls;
        }
        String resourcePath = "META-INF/maven-faces-plugin/faces-config.xml";
        return this.getCompileDependencyResources(project, resourcePath);
    }

    protected URL[] readIndex(MavenProject project) throws MojoExecutionException {
        try {
            List masters = this.getMasterConfigs(project);
            if (masters.isEmpty()) {
                this.getLog().warn((CharSequence)"Master faces-config.xml not found");
                return new URL[0];
            }
            LinkedList entries = new LinkedList();
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            Iterator i = masters.iterator();
            while (i.hasNext()) {
                URL url = (URL)i.next();
                Digester digester = new Digester(spf.newSAXParser());
                digester.setNamespaceAware(true);
                digester.setRuleNamespaceURI("http://www.w3.org/2001/XInclude");
                digester.addCallMethod("faces-config/include", "add", 1);
                digester.addFactoryCreate("faces-config/include", class$org$apache$myfaces$trinidadbuild$plugin$faces$AbstractFacesMojo$URLCreationFactory == null ? AbstractFacesMojo.class$("org.apache.myfaces.trinidadbuild.plugin.faces.AbstractFacesMojo$URLCreationFactory") : class$org$apache$myfaces$trinidadbuild$plugin$faces$AbstractFacesMojo$URLCreationFactory);
                digester.addCallParam("faces-config/include", 0, 0);
                digester.push((Object)url);
                digester.push(entries);
                digester.parse(url.openStream());
            }
            return entries.toArray(new URL[0]);
        }
        catch (ParserConfigurationException e) {
            throw new MojoExecutionException("Failed to parse master config", (Exception)e);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Failed to parse master config", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to parse master config", (Exception)e);
        }
    }

    protected boolean isModifiedSince(URL[] urls, long lastModified) throws IOException {
        for (int i = 0; i < urls.length; ++i) {
            URLConnection conn = urls[i].openConnection();
            if (conn.getLastModified() <= lastModified) continue;
            return true;
        }
        return false;
    }

    protected String convertStringToLiteral(String value) {
        return Util.convertStringToLiteral("String", value);
    }

    protected String convertStringToLiteral(String className, String value) {
        return Util.convertStringToLiteral(className, value);
    }

    protected String readLicenseHeader() throws MojoExecutionException {
        if (this.licenseHeaderFile == null) {
            return _DEFAULT_LICENSE_HEADER;
        }
        if (!this.licenseHeaderFile.exists()) {
            throw new MojoExecutionException("License header file not found: " + this.licenseHeaderFile.getName());
        }
        if (this.licenseHeaderFile.isDirectory()) {
            throw new MojoExecutionException("Expecting a file and found a directory: " + this.licenseHeaderFile.getName());
        }
        StringBuffer sb = new StringBuffer();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(this.licenseHeaderFile));
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception reading license header file", (Exception)e);
        }
        return sb.toString();
    }

    protected String getLicenseHeader() throws MojoExecutionException {
        if (this._licenseHeader == null) {
            this._licenseHeader = this.readLicenseHeader();
        }
        return this._licenseHeader;
    }

    protected void processIndex(MavenProject project, String resourcePath) throws MojoExecutionException {
        this._facesConfig = new FacesConfigBean();
        URL[] index = this.readIndex(project, resourcePath);
        for (int i = 0; i < index.length; ++i) {
            this.processIndexEntry(index[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processIndexEntry(URL entry) throws MojoExecutionException {
        URL old = this._facesConfig.setCurrentResource(entry);
        try {
            new FacesConfigParser().merge(this._facesConfig, entry);
        }
        finally {
            this._facesConfig.setCurrentResource(old);
        }
    }

    protected FacesConfigBean getFacesConfig() {
        return this._facesConfig;
    }

    protected void writePreamble(PrettyWriter out) throws MojoExecutionException {
        out.write(_AUTO_GENERATE_WARNING);
        out.write(this.getLicenseHeader());
    }

    protected void copyFile(File sourceDirectory, String sourcePath, File targetDirectory) throws MojoExecutionException {
        try {
            File sourceFile = new File(sourceDirectory, sourcePath);
            File targetFile = new File(targetDirectory, sourcePath);
            if (sourceFile.exists() && sourceFile.lastModified() > targetFile.lastModified()) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Copying file \"" + sourcePath + "\""));
                }
                FileUtils.copyFile((File)sourceFile, (File)targetFile);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying file \"" + sourcePath + "\"", (Exception)e);
        }
    }

    protected void writeImports(PrettyWriter out, String packageName, Set imports) {
        GeneratorHelper.writeImports(out, packageName, imports);
    }

    private ClassLoader createCompileClassLoader(MavenProject project) throws MojoExecutionException {
        Thread current = Thread.currentThread();
        ClassLoader cl = current.getContextClassLoader();
        try {
            List classpathElements = project.getCompileClasspathElements();
            if (!classpathElements.isEmpty()) {
                String[] entries = classpathElements.toArray(new String[0]);
                URL[] urls = new URL[entries.length];
                for (int i = 0; i < urls.length; ++i) {
                    urls[i] = new File(entries[i]).toURL();
                }
                cl = new URLClassLoader(urls, cl);
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error calculating scope classpath", (Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error calculating scope classpath", (Exception)e);
        }
        return cl;
    }

    protected static class VirtualAttributeFilter
    extends AttributeFilter {
        protected VirtualAttributeFilter() {
        }

        protected boolean accept(AttributeBean attribute) {
            return !attribute.isVirtual();
        }
    }

    protected static final class ConverterTagLibraryFilter
    extends ConverterFilter {
        private final String _namespaceURI;
        private final boolean _requireTagClass;

        public ConverterTagLibraryFilter(String namespaceURI) {
            this(namespaceURI, true);
        }

        public ConverterTagLibraryFilter(String namespaceURI, boolean requireTagClass) {
            this._namespaceURI = namespaceURI;
            this._requireTagClass = requireTagClass;
        }

        protected boolean accept(ConverterBean converter) {
            QName tagName = converter.getTagName();
            String tagClass = converter.getTagClass();
            return (!this._requireTagClass || tagClass != null) && tagName != null && this._namespaceURI.equals(tagName.getNamespaceURI());
        }
    }

    protected static final class ValidatorTagLibraryFilter
    extends ValidatorFilter {
        private final String _namespaceURI;
        private final boolean _requireTagClass;

        public ValidatorTagLibraryFilter(String namespaceURI) {
            this(namespaceURI, true);
        }

        public ValidatorTagLibraryFilter(String namespaceURI, boolean requireTagClass) {
            this._namespaceURI = namespaceURI;
            this._requireTagClass = requireTagClass;
        }

        protected boolean accept(ValidatorBean validator) {
            QName tagName = validator.getTagName();
            String tagClass = validator.getTagClass();
            return (!this._requireTagClass || tagClass != null) && tagName != null && this._namespaceURI.equals(tagName.getNamespaceURI());
        }
    }

    protected static final class ComponentTagLibraryFilter
    extends ComponentFilter {
        private final String _namespaceURI;
        private final boolean _requireTagClass;

        public ComponentTagLibraryFilter(String namespaceURI) {
            this(namespaceURI, true);
        }

        public ComponentTagLibraryFilter(String namespaceURI, boolean requireTagClass) {
            this._namespaceURI = namespaceURI;
            this._requireTagClass = requireTagClass;
        }

        protected boolean accept(ComponentBean component) {
            QName tagName = component.getTagName();
            String tagClass = component.getTagClass();
            return (!this._requireTagClass || tagClass != null) && tagName != null && this._namespaceURI.equals(tagName.getNamespaceURI());
        }
    }

    protected static final class ValidatorTagFilter
    extends ValidatorFilter {
        protected ValidatorTagFilter() {
        }

        protected boolean accept(ValidatorBean validator) {
            return validator.getTagClass() != null;
        }
    }

    protected static final class ConverterTagFilter
    extends ConverterFilter {
        protected ConverterTagFilter() {
        }

        protected boolean accept(ConverterBean converter) {
            return converter.getTagClass() != null;
        }
    }

    protected static final class ComponentTagFilter
    extends ComponentFilter {
        protected ComponentTagFilter() {
        }

        protected boolean accept(ComponentBean component) {
            return component.getTagClass() != null;
        }
    }

    protected static final class ValidatorTagClassFilter
    extends ValidatorFilter {
        private final String _packageContains;

        public ValidatorTagClassFilter(String packageContains) {
            this._packageContains = packageContains;
        }

        protected boolean accept(ValidatorBean validator) {
            String tagClass = validator.getTagClass();
            String packageName = Util.getPackageFromFullClass(tagClass);
            return packageName.contains(this._packageContains);
        }
    }

    protected static final class ConverterTagClassFilter
    extends ConverterFilter {
        private final String _packageContains;

        public ConverterTagClassFilter(String packageContains) {
            this._packageContains = packageContains;
        }

        protected boolean accept(ConverterBean converter) {
            String tagClass = converter.getTagClass();
            String packageName = Util.getPackageFromFullClass(tagClass);
            return packageName.contains(this._packageContains);
        }
    }

    protected static final class ComponentTagClassFilter
    extends ComponentFilter {
        private final String _packageContains;

        public ComponentTagClassFilter(String packageContains) {
            this._packageContains = packageContains;
        }

        protected boolean accept(ComponentBean component) {
            String tagClass = component.getTagClass();
            String packageName = Util.getPackageFromFullClass(tagClass);
            return packageName.contains(this._packageContains);
        }
    }

    protected static final class ComponentClassFilter
    extends ComponentFilter {
        private final String _packageContains;

        public ComponentClassFilter(String packageContains) {
            this._packageContains = packageContains;
        }

        protected boolean accept(ComponentBean component) {
            String componentClass = component.getComponentClass();
            String packageName = Util.getPackageFromFullClass(componentClass);
            return packageName.contains(this._packageContains);
        }
    }

    protected static final class ComponentTypeFilter
    extends ComponentFilter {
        private final String _typePrefix;

        public ComponentTypeFilter(String typePrefix) {
            this._typePrefix = typePrefix;
        }

        protected boolean accept(ComponentBean component) {
            String componentType = component.getComponentType();
            return componentType.startsWith(this._typePrefix);
        }
    }

    protected class SkipFilter
    extends ComponentFilter {
        protected SkipFilter() {
        }

        protected boolean accept(ComponentBean component) {
            String componentType = component.getComponentType();
            return !AbstractFacesMojo.this.skipApiOrBaseClasses || !componentType.startsWith("javax") && !componentType.endsWith("Base");
        }
    }

    public static class URLCreationFactory
    extends AbstractObjectCreationFactory {
        public Object createObject(Attributes attributes) throws MalformedURLException {
            String href = attributes.getValue("href");
            if (href == null) {
                throw new IllegalStateException("Missing href attribute");
            }
            URL master = (URL)this.digester.getRoot();
            return new URL(master, href);
        }
    }
}

