/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.myfaces.trinidadbuild.plugin.faces.AbstractFacesMojo;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.component.AbstractComponentGenerator;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.component.MyFacesComponentGenerator;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.component.TrinidadComponentGenerator;
import org.apache.myfaces.trinidadbuild.plugin.faces.io.PrettyWriter;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ComponentBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.FacesConfigBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.ComponentFilter;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.FilteredIterator;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.SourceTemplate;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.Util;

public class GenerateComponentsMojo
extends AbstractFacesMojo {
    private MavenProject project;
    private String resourcePath = "META-INF/maven-faces-plugin/index.lst";
    private File templateSourceDirectory;
    private File generatedSourceDirectory;
    private String packageContains;
    private String typePrefix;
    private boolean force;
    private boolean suppressListenerMethods;
    private String jsfVersion;

    public void execute() throws MojoExecutionException {
        try {
            this.processIndex(this.project, this.resourcePath);
            this._generateComponents();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error generating components", (Exception)e);
        }
    }

    private void _generateComponents() throws IOException, MojoExecutionException {
        this.project.addCompileSourceRoot(this.generatedSourceDirectory.getCanonicalPath());
        FacesConfigBean facesConfig = this.getFacesConfig();
        if (!facesConfig.hasComponents()) {
            this.getLog().info((CharSequence)"Nothing to generate - no components found");
        } else {
            if (this.suppressListenerMethods) {
                this.getLog().warn((CharSequence)"Event listener methods will not be generated");
            }
            Iterator components = facesConfig.components();
            components = new FilteredIterator(components, new AbstractFacesMojo.SkipFilter());
            components = new FilteredIterator(components, new AbstractFacesMojo.ComponentTypeFilter(this.typePrefix));
            if (!this.force) {
                components = new FilteredIterator(components, new IfModifiedFilter());
            }
            if (!components.hasNext()) {
                this.getLog().info((CharSequence)"Nothing to generate - all components are up to date");
            } else {
                int count = 0;
                while (components.hasNext()) {
                    this._generateComponent((ComponentBean)components.next());
                    ++count;
                }
                this.getLog().info((CharSequence)("Generated " + count + " component(s)"));
            }
        }
    }

    private void _generateComponent(ComponentBean component) throws MojoExecutionException {
        String fullClassName = component.getComponentClass();
        AbstractComponentGenerator generator = component.isTrinidadComponent() ? new TrinidadComponentGenerator(this.getLog(), this._is12()) : new MyFacesComponentGenerator(this.getLog(), this._is12());
        try {
            this.getLog().debug((CharSequence)("Generating " + fullClassName + ", with generator: " + generator.getClass().getName()));
            String sourcePath = Util.convertClassToSourcePath(fullClassName, ".java");
            File targetFile = new File(this.generatedSourceDirectory, sourcePath);
            StringWriter sw = new StringWriter();
            PrettyWriter out = new PrettyWriter(sw);
            String className = Util.getClassFromFullClass(fullClassName);
            String componentFamily = component.findComponentFamily();
            if (componentFamily == null) {
                this.getLog().warn((CharSequence)("Missing <component-family> for \"" + fullClassName + "\", generation of this Component is skipped"));
            } else {
                String packageName = Util.getPackageFromFullClass(fullClassName);
                String fullSuperclassName = component.findComponentSuperclass();
                String superclassName = Util.getClassFromFullClass(fullSuperclassName);
                if (superclassName.equals(className)) {
                    superclassName = fullSuperclassName;
                }
                if (superclassName.equals("UIXMenuHierarchy") || superclassName.equals("UIXTable") || superclassName.equals("UIXHierarchy") || superclassName.equals("UIXMenuTree") || className.equals("CoreTree")) {
                    superclassName = fullSuperclassName;
                }
                String componentType = component.getComponentType();
                String templatePath = Util.convertClassToSourcePath(fullClassName, "Template.java");
                File templateFile = new File(this.templateSourceDirectory, templatePath);
                SourceTemplate template = null;
                if (templateFile.exists()) {
                    this.getLog().debug((CharSequence)("Using template " + templatePath));
                    template = new SourceTemplate(templateFile);
                    template.substitute(className + "Template", className);
                    template.readPreface();
                }
                this.writePreamble(out);
                out.println("package " + packageName + ";");
                out.println();
                generator.writeImports(out, template, packageName, fullSuperclassName, superclassName, component);
                generator.writeClassBegin(out, className, superclassName, component, template);
                generator.writePropertyValueConstants(out, component);
                generator.writePropertyConstants(out, superclassName, component);
                generator.writeFacetConstants(out, component);
                generator.writeGenericConstants(out, componentFamily, componentType);
                generator.writeConstructor(out, component, 1);
                if (template != null) {
                    template.writeContent(out);
                    template.close();
                }
                generator.writeFacetMethods(out, component);
                if (template == null) {
                    generator.writePropertyMethods(out, component);
                } else {
                    generator.writePropertyMethods(out, component, template.getIgnoreMethods());
                }
                if (!this.suppressListenerMethods) {
                    generator.writeListenerMethods(out, component);
                }
                generator.writeStateManagementMethods(out, component);
                generator.writeGetFamily(out);
                generator.writeOther(out, component);
                generator.writeClassEnd(out);
                out.close();
                targetFile.getParentFile().mkdirs();
                targetFile.delete();
                FileWriter fw = new FileWriter(targetFile);
                StringBuffer buf = sw.getBuffer();
                fw.write(buf.toString());
                fw.close();
                targetFile.setReadOnly();
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Error generating " + fullClassName), (Throwable)e);
        }
    }

    private boolean _is12() {
        return "1.2".equals(this.jsfVersion) || "12".equals(this.jsfVersion);
    }

    private class IfModifiedFilter
    extends ComponentFilter {
        private IfModifiedFilter() {
        }

        protected boolean accept(ComponentBean component) {
            String componentClass = component.getComponentClass();
            String sourcePath = Util.convertClassToSourcePath(componentClass, ".java");
            String templatePath = Util.convertClassToSourcePath(componentClass, "Template.java");
            File targetFile = new File(GenerateComponentsMojo.this.generatedSourceDirectory, sourcePath);
            File templateFile = new File(GenerateComponentsMojo.this.templateSourceDirectory, templatePath);
            return templateFile.lastModified() > targetFile.lastModified() || component.isModifiedSince(targetFile.lastModified());
        }
    }
}

