/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.myfaces.trinidadbuild.plugin.faces.AbstractFacesMojo;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ComponentBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ConverterBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.FacesConfigBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ValidatorBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.FilteredIterator;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.XIncludeFilter;
import org.codehaus.plexus.util.FileUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class GenerateFaceletsTaglibsMojo
extends AbstractFacesMojo {
    private MavenProject project;
    private String resourcePath;
    private Map taglibs;
    private String faceletHandlerClass;
    private File configSourceDirectory;
    private File generatedResourcesDirectory;
    private boolean force;
    private static final String _FACELETS_NAMESPACE_URI = "http://java.sun.com/JSF/Facelet";
    private static final String _FACELETS_TAG_LIBRARY_DOCTYPE_PUBLIC = "-//Sun Microsystems, Inc.//DTD Facelet Taglib 1.0//EN";
    private static final String _FACELETS_TAG_LIBRARY_DOCTYPE_SYSTEM = "http://java.sun.com/dtd/facelet-taglib_1_0.dtd";
    private static final String _FACELETS_TAG_LIBRARY_DTD = "<!DOCTYPE facelet-taglib PUBLIC \n  \"-//Sun Microsystems, Inc.//DTD Facelet Taglib 1.0//EN\"\n  \"http://java.sun.com/dtd/facelet-taglib_1_0.dtd\" >\n";
    private static final String _XINCLUDE_FACELETS_TAG_LIBRARY_DTD = "<!DOCTYPE taglib PUBLIC\n  \"-//Sun Microsystems, Inc.//DTD Facelet Taglib 1.0//EN\"\n  \"http://java.sun.com/dtd/facelet-taglib_1_0.dtd\" [\n      <!ELEMENT xi:include EMPTY>\n      <!ATTLIST xi:include\n          xmlns:xi CDATA #FIXED  \"http://www.w3.org/2001/XInclude\"\n          href     CDATA #IMPLIED\n          xpointer CDATA #IMPLIED>\n]>\n";

    public void execute() throws MojoExecutionException {
        try {
            this.addResourceRoot(this.project, this.generatedResourcesDirectory.getCanonicalPath());
            this.processIndex(this.project, this.resourcePath);
            Iterator i = this.taglibs.entrySet().iterator();
            while (i.hasNext()) {
                XMLStreamWriter stream;
                XMLOutputFactory outputFactory;
                OutputStream out;
                Map.Entry entry = i.next();
                String shortName = (String)entry.getKey();
                String namespaceURI = (String)entry.getValue();
                FacesConfigBean facesConfig = this.getFacesConfig();
                Iterator components = facesConfig.components();
                components = new FilteredIterator(components, new AbstractFacesMojo.SkipFilter());
                components = new FilteredIterator(components, new AbstractFacesMojo.ComponentTagLibraryFilter(namespaceURI, false));
                Iterator validators = facesConfig.validators();
                validators = new FilteredIterator(validators, new AbstractFacesMojo.ValidatorTagLibraryFilter(namespaceURI, false));
                Iterator converters = facesConfig.converters();
                converters = new FilteredIterator(converters, new AbstractFacesMojo.ConverterTagLibraryFilter(namespaceURI, false));
                String targetPath = "META-INF/" + shortName + ".taglib.xml";
                File targetFile = new File(this.generatedResourcesDirectory, targetPath);
                String configPath = "META-INF/" + shortName + "-base.taglib.xml";
                File configFile = new File(this.configSourceDirectory, configPath);
                targetFile.delete();
                if ((components.hasNext() || validators.hasNext() || converters.hasNext()) && configFile.exists()) {
                    out = new ByteArrayOutputStream();
                    outputFactory = XMLOutputFactory.newInstance();
                    stream = outputFactory.createXMLStreamWriter(out);
                    this._writeStartTagLibrary(stream, _XINCLUDE_FACELETS_TAG_LIBRARY_DTD);
                    stream.writeStartElement("xi", "include", "http://www.w3.org/2001/XInclude");
                    stream.writeNamespace("xi", "http://www.w3.org/2001/XInclude");
                    stream.writeAttribute("href", configFile.toURL().toExternalForm());
                    stream.writeAttribute("xpointer", "/facelet-taglib/*");
                    stream.writeEndElement();
                    this._writeTags(components, validators, converters, stream);
                    this._writeEndTagLibrary(stream);
                    stream.close();
                    ByteArrayInputStream mergedStream = new ByteArrayInputStream(((ByteArrayOutputStream)out).toByteArray());
                    SAXParserFactory saxFactory = SAXParserFactory.newInstance();
                    saxFactory.setNamespaceAware(true);
                    saxFactory.setValidating(false);
                    SAXParser saxParser = saxFactory.newSAXParser();
                    XMLReader mergedReader = saxParser.getXMLReader();
                    mergedReader = new XIncludeFilter(mergedReader, configFile.toURL());
                    mergedReader.setEntityResolver(new EntityResolver(){

                        public InputSource resolveEntity(String publicId, String systemId) {
                            return new InputSource(new ByteArrayInputStream(new byte[0]));
                        }
                    });
                    InputSource mergedInput = new InputSource(mergedStream);
                    SAXSource mergedSource = new SAXSource(mergedReader, mergedInput);
                    targetFile.delete();
                    targetFile.getParentFile().mkdirs();
                    StreamResult mergedResult = new StreamResult(targetFile);
                    TransformerFactory transFactory = TransformerFactory.newInstance();
                    Transformer identity = transFactory.newTransformer();
                    identity.setOutputProperty("doctype-public", _FACELETS_TAG_LIBRARY_DOCTYPE_PUBLIC);
                    identity.setOutputProperty("doctype-system", _FACELETS_TAG_LIBRARY_DOCTYPE_SYSTEM);
                    identity.transform(mergedSource, mergedResult);
                    targetFile.setReadOnly();
                } else if (components.hasNext() || validators.hasNext() || converters.hasNext()) {
                    targetFile.getParentFile().mkdirs();
                    out = new FileOutputStream(targetFile);
                    outputFactory = XMLOutputFactory.newInstance();
                    stream = outputFactory.createXMLStreamWriter(out);
                    this._writeStartTagLibrary(stream, _FACELETS_TAG_LIBRARY_DTD);
                    stream.writeCharacters("\n  ");
                    stream.writeStartElement("namespace");
                    stream.writeCharacters(namespaceURI);
                    stream.writeEndElement();
                    this._writeTags(components, validators, converters, stream);
                    this._writeEndTagLibrary(stream);
                    stream.close();
                } else if (configFile.exists() && configFile.lastModified() > targetFile.lastModified()) {
                    targetFile.delete();
                    targetFile.getParentFile().mkdirs();
                    FileUtils.copyFile((File)configFile, (File)targetFile);
                    targetFile.setReadOnly();
                }
                this.getLog().info((CharSequence)("Generated " + targetPath));
            }
        }
        catch (XMLStreamException e) {
            throw new MojoExecutionException("Error during generation", (Exception)e);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Error during generation", (Exception)e);
        }
        catch (TransformerException e) {
            throw new MojoExecutionException("Error during generation", (Exception)e);
        }
        catch (ParserConfigurationException e) {
            throw new MojoExecutionException("Error during generation", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error during generation", (Exception)e);
        }
    }

    private void _writeTags(Iterator components, Iterator validators, Iterator converters, XMLStreamWriter stream) throws XMLStreamException {
        while (components.hasNext()) {
            ComponentBean component = (ComponentBean)components.next();
            this._writeTag(stream, component);
        }
        while (validators.hasNext()) {
            this._writeValidatorTag(stream, (ValidatorBean)validators.next());
        }
        while (converters.hasNext()) {
            this._writeConverterTag(stream, (ConverterBean)converters.next());
        }
    }

    private void _writeStartTagLibrary(XMLStreamWriter stream, String dtd) throws XMLStreamException {
        stream.writeStartDocument("1.0");
        stream.writeCharacters("\n");
        stream.writeDTD(dtd);
        stream.writeCharacters("\n");
        stream.writeStartElement("facelet-taglib");
        stream.writeDefaultNamespace(_FACELETS_NAMESPACE_URI);
        stream.writeCharacters("\n  ");
    }

    private void _writeEndTagLibrary(XMLStreamWriter stream) throws XMLStreamException {
        stream.writeCharacters("\n");
        stream.writeEndElement();
        stream.writeEndDocument();
    }

    private void _writeTag(XMLStreamWriter stream, ComponentBean component) throws XMLStreamException {
        String tagHandler;
        stream.writeCharacters("\n  ");
        stream.writeStartElement("tag");
        stream.writeCharacters("\n    ");
        stream.writeStartElement("tag-name");
        stream.writeCharacters(component.getTagName().getLocalPart());
        stream.writeEndElement();
        stream.writeCharacters("\n    ");
        stream.writeStartElement("component");
        stream.writeCharacters("\n      ");
        stream.writeStartElement("component-type");
        stream.writeCharacters(component.getComponentType());
        stream.writeEndElement();
        if (component.getRendererType() != null) {
            stream.writeCharacters("\n      ");
            stream.writeStartElement("renderer-type");
            stream.writeCharacters(component.getRendererType());
            stream.writeEndElement();
        }
        if ((tagHandler = component.getTagHandler()) == null) {
            tagHandler = this.faceletHandlerClass;
        }
        if (tagHandler != null) {
            stream.writeCharacters("\n      ");
            stream.writeStartElement("handler-class");
            stream.writeCharacters(tagHandler);
            stream.writeEndElement();
        }
        stream.writeCharacters("\n    ");
        stream.writeEndElement();
        stream.writeCharacters("\n  ");
        stream.writeEndElement();
    }

    private void _writeValidatorTag(XMLStreamWriter stream, ValidatorBean validator) throws XMLStreamException {
        stream.writeCharacters("\n  ");
        stream.writeStartElement("tag");
        stream.writeCharacters("\n    ");
        stream.writeStartElement("tag-name");
        stream.writeCharacters(validator.getTagName().getLocalPart());
        stream.writeEndElement();
        stream.writeCharacters("\n    ");
        stream.writeStartElement("validator");
        stream.writeCharacters("\n      ");
        stream.writeStartElement("validator-id");
        stream.writeCharacters(validator.getValidatorId());
        stream.writeEndElement();
        stream.writeCharacters("\n    ");
        stream.writeEndElement();
        stream.writeCharacters("\n  ");
        stream.writeEndElement();
    }

    private void _writeConverterTag(XMLStreamWriter stream, ConverterBean converter) throws XMLStreamException {
        stream.writeCharacters("\n  ");
        stream.writeStartElement("tag");
        stream.writeCharacters("\n    ");
        stream.writeStartElement("tag-name");
        stream.writeCharacters(converter.getTagName().getLocalPart());
        stream.writeEndElement();
        stream.writeCharacters("\n    ");
        stream.writeStartElement("converter");
        stream.writeCharacters("\n      ");
        stream.writeStartElement("converter-id");
        stream.writeCharacters(converter.getConverterId());
        stream.writeEndElement();
        stream.writeCharacters("\n    ");
        stream.writeEndElement();
        stream.writeCharacters("\n  ");
        stream.writeEndElement();
    }
}

