/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.myfaces.trinidadbuild.plugin.faces.AbstractFacesMojo;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.XIncludeFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class GenerateFacesConfigMojo
extends AbstractFacesMojo {
    private MavenProject project;
    private File configDirectory;
    private String configPath = "META-INF/faces-config-base.xml";
    private String packageContains = "";
    private String converterPackageContains = "";
    private String validatorPackageContains = "";
    private File targetDirectory;
    private String targetPath = "META-INF/faces-config.xml";
    private boolean force;
    private String typePrefix = "";
    private String transformStylesheet;
    private boolean removeRenderers;
    private String jsfVersion;

    public void execute() throws MojoExecutionException {
        try {
            this.addResourceRoot(this.project, this.targetDirectory.getCanonicalPath());
            File targetFile = new File(this.targetDirectory, this.targetPath);
            URL[] index = this.readIndex(this.project);
            if (!this.force && !this.isModifiedSince(index, targetFile.lastModified())) {
                this.getLog().info((CharSequence)("Nothing to generate - " + this.targetPath + " is up to date"));
            } else {
                LinkedList<URL> configURLs = this.getMasterConfigs(this.project);
                File configFile = new File(this.configDirectory, this.configPath);
                if (configFile.exists()) {
                    configURLs = new LinkedList<URL>(configURLs);
                    configURLs.add(0, configFile.toURL());
                }
                if (!configURLs.isEmpty()) {
                    FileOutputStream resultStream;
                    URL baseURL = GenerateFacesConfigMojo.class.getResource("resources/faces-config.xml");
                    DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                    Document document = docBuilder.parse(baseURL.openStream());
                    Element root = document.getDocumentElement();
                    Iterator i = configURLs.iterator();
                    while (i.hasNext()) {
                        URL url = (URL)i.next();
                        Element include = document.createElementNS("http://www.w3.org/2001/XInclude", "xi:include");
                        include.setAttribute("href", url.toExternalForm());
                        include.setAttribute("xpointer", "/faces-config/*");
                        root.insertBefore(include, root.getFirstChild());
                    }
                    TransformerFactory transFactory = TransformerFactory.newInstance();
                    Transformer identity = transFactory.newTransformer();
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    identity.transform(new DOMSource(document), new StreamResult(out));
                    ByteArrayInputStream mergedStream = new ByteArrayInputStream(out.toByteArray());
                    SAXParserFactory saxFactory = SAXParserFactory.newInstance();
                    saxFactory.setNamespaceAware(true);
                    saxFactory.setValidating(false);
                    SAXParser saxParser = saxFactory.newSAXParser();
                    XMLReader mergedReader = saxParser.getXMLReader();
                    mergedReader = new XIncludeFilter(mergedReader, baseURL);
                    mergedReader.setEntityResolver(new EntityResolver(){

                        public InputSource resolveEntity(String publicId, String systemId) {
                            return new InputSource(new ByteArrayInputStream(new byte[0]));
                        }
                    });
                    InputSource mergedInput = new InputSource(mergedStream);
                    SAXSource mergedSource = new SAXSource(mergedReader, mergedInput);
                    targetFile.delete();
                    targetFile.getParentFile().mkdirs();
                    File tmpFile = null;
                    if (this.transformStylesheet != null) {
                        tmpFile = File.createTempFile("generate-faces-config", null);
                        resultStream = new FileOutputStream(tmpFile);
                    } else {
                        resultStream = new FileOutputStream(targetFile);
                    }
                    StreamResult mergedResult = new StreamResult(resultStream);
                    URL xslURL = this._is12() ? ((Object)((Object)this)).getClass().getResource("resources/transform12.xsl") : ((Object)((Object)this)).getClass().getResource("resources/transform.xsl");
                    InputStream xsl = xslURL.openStream();
                    StreamSource xslSource = new StreamSource(xsl);
                    Transformer transformer = transFactory.newTransformer(xslSource);
                    transformer.setParameter("packageContains", this.packageContains);
                    transformer.setParameter("typePrefix", this.typePrefix);
                    transformer.setParameter("removeRenderers", this.removeRenderers ? "true" : "false");
                    transformer.setParameter("converterPackageContains", this.getParameter(this.converterPackageContains, this.packageContains));
                    transformer.setParameter("validatorPackageContains", this.getParameter(this.validatorPackageContains, this.packageContains));
                    transformer.transform(mergedSource, mergedResult);
                    ((OutputStream)resultStream).close();
                    if (this.transformStylesheet != null) {
                        StreamSource tmpSource = new StreamSource(tmpFile);
                        StreamSource transformSource = new StreamSource(new File(this.configDirectory, this.transformStylesheet));
                        Transformer finalTransform = transFactory.newTransformer(transformSource);
                        FileOutputStream finalOut = new FileOutputStream(targetFile);
                        StreamResult finalResult = new StreamResult(finalOut);
                        finalTransform.transform(tmpSource, finalResult);
                        finalOut.close();
                        tmpFile.delete();
                    }
                    targetFile.setReadOnly();
                    this.getLog().info((CharSequence)("Generated " + this.targetPath));
                }
            }
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Error during generation", (Exception)e);
        }
        catch (TransformerException e) {
            throw new MojoExecutionException("Error during generation", (Exception)e);
        }
        catch (ParserConfigurationException e) {
            throw new MojoExecutionException("Error during generation", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error during generation", (Exception)e);
        }
    }

    private boolean _is12() {
        return "1.2".equals(this.jsfVersion) || "12".equals(this.jsfVersion);
    }

    private String getParameter(String paramName, String defaultValue) {
        String param = paramName.length() > 0 ? paramName : defaultValue;
        return param;
    }
}

