/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.myfaces.trinidadbuild.plugin.faces.AbstractFacesMojo;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib.AbstractComponentTagGenerator;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib.AbstractConverterTagGenerator;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib.AbstractValidatorTagGenerator;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib.MyFacesComponentTagGenerator;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib.MyFacesConverterTagGenerator;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib.MyFacesValidatorTagGenerator;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib.TagAttributeFilter;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib.TrinidadComponentTagGenerator;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib.TrinidadConverterTagGenerator;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.taglib.TrinidadValidatorTagGenerator;
import org.apache.myfaces.trinidadbuild.plugin.faces.io.PrettyWriter;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ComponentBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ConverterBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.FacesConfigBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.MethodSignatureBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.PropertyBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ValidatorBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.ComponentFilter;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.ConverterFilter;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.FilteredIterator;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.Util;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.ValidatorFilter;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.XIncludeFilter;
import org.codehaus.plexus.util.FileUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class GenerateJspTaglibsMojo
extends AbstractFacesMojo {
    protected MavenProject project;
    protected Map taglibs;
    protected String resourcePath;
    protected File configSourceDirectory;
    protected File templateSourceDirectory;
    protected File generatedSourceDirectory;
    protected File generatedResourcesDirectory;
    protected String packageContains = "";
    protected boolean force;
    protected boolean disableIdExpressions;
    protected boolean coerceStrings;
    private String jsfVersion;
    private String type;
    private static final String _JSP_TAG_LIBRARY_DOCTYPE_PUBLIC = "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN";
    private static final String _JSP_TAG_LIBRARY_DOCTYPE_SYSTEM = "http://java.sun.com/dtd/web-jsptaglibrary_1_2.dtd";
    private static final String _JSP_TAG_LIBRARY_DTD = "<!DOCTYPE taglib PUBLIC \n  \"-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN\"\n  \"http://java.sun.com/dtd/web-jsptaglibrary_1_2.dtd\" >\n";
    private static final String _XINCLUDE_JSP_TAG_LIBRARY_DTD = "<!DOCTYPE taglib PUBLIC\n  \"-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN\"\n  \"http://java.sun.com/dtd/web-jsptaglibrary_1_2.dtd\" [\n      <!ELEMENT xi:include EMPTY>\n      <!ATTLIST xi:include\n          xmlns:xi CDATA #FIXED  \"http://www.w3.org/2001/XInclude\"\n          href     CDATA #IMPLIED\n          xpointer CDATA #IMPLIED>\n]>\n";
    private static final Set _CAN_COERCE = new HashSet();

    public void execute() throws MojoExecutionException {
        try {
            this.processIndex(this.project, this.resourcePath);
            this._generateTagHandlers();
            this._generateTagLibraryDescriptors();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error generating components", (Exception)e);
        }
    }

    protected void writeCustomComponentTagHandlerContent(PrettyWriter out, ComponentBean component) throws IOException {
    }

    protected void addCustomComponentTagHandlerImports(Set imports, ComponentBean component) {
    }

    protected void writeCustomComponentTagDescriptorContent(XMLStreamWriter stream, ComponentBean component) throws XMLStreamException {
    }

    private void _generateTagLibraryDescriptors() throws MojoExecutionException {
        try {
            this.addResourceRoot(this.project, this.generatedResourcesDirectory.getCanonicalPath());
            Iterator i = this.taglibs.entrySet().iterator();
            while (i.hasNext()) {
                ValidatorBean validator;
                ConverterBean converter;
                ComponentBean component;
                XMLStreamWriter stream;
                XMLOutputFactory outputFactory;
                OutputStream out;
                boolean hasGeneratedTags;
                Map.Entry entry = i.next();
                String shortName = (String)entry.getKey();
                String namespaceURI = (String)entry.getValue();
                FacesConfigBean facesConfig = this.getFacesConfig();
                Iterator components = facesConfig.components();
                components = new FilteredIterator(components, new AbstractFacesMojo.SkipFilter());
                components = new FilteredIterator(components, new AbstractFacesMojo.ComponentTagLibraryFilter(namespaceURI));
                Iterator validators = facesConfig.validators();
                validators = new FilteredIterator(validators, new AbstractFacesMojo.ValidatorTagLibraryFilter(namespaceURI));
                Iterator converters = facesConfig.converters();
                converters = new FilteredIterator(converters, new AbstractFacesMojo.ConverterTagLibraryFilter(namespaceURI));
                String targetPath = "META-INF/" + shortName + ".tld";
                File targetFile = new File(this.generatedResourcesDirectory, targetPath);
                String configPath = "META-INF/" + shortName + "-base.tld";
                File configFile = new File(this.configSourceDirectory, configPath);
                targetFile.delete();
                boolean bl = hasGeneratedTags = components.hasNext() || converters.hasNext() || validators.hasNext();
                if (hasGeneratedTags && configFile.exists()) {
                    out = new ByteArrayOutputStream();
                    outputFactory = XMLOutputFactory.newInstance();
                    stream = outputFactory.createXMLStreamWriter(out);
                    this._writeStartTagLibrary(stream, _XINCLUDE_JSP_TAG_LIBRARY_DTD);
                    stream.writeStartElement("xi", "include", "http://www.w3.org/2001/XInclude");
                    stream.writeNamespace("xi", "http://www.w3.org/2001/XInclude");
                    stream.writeAttribute("href", configFile.toURL().toExternalForm());
                    stream.writeAttribute("xpointer", "/taglib/*");
                    stream.writeEndElement();
                    while (components.hasNext()) {
                        component = (ComponentBean)components.next();
                        this._writeTag(stream, component);
                    }
                    while (converters.hasNext()) {
                        converter = (ConverterBean)converters.next();
                        this._writeTag(stream, converter);
                    }
                    while (validators.hasNext()) {
                        validator = (ValidatorBean)validators.next();
                        this._writeTag(stream, validator);
                    }
                    this._writeEndTagLibrary(stream);
                    stream.close();
                    ByteArrayInputStream mergedStream = new ByteArrayInputStream(((ByteArrayOutputStream)out).toByteArray());
                    SAXParserFactory saxFactory = SAXParserFactory.newInstance();
                    saxFactory.setNamespaceAware(true);
                    saxFactory.setValidating(false);
                    SAXParser saxParser = saxFactory.newSAXParser();
                    XMLReader mergedReader = saxParser.getXMLReader();
                    mergedReader = new XIncludeFilter(mergedReader, configFile.toURL());
                    mergedReader.setEntityResolver(new EntityResolver(){

                        public InputSource resolveEntity(String publicId, String systemId) {
                            return new InputSource(new ByteArrayInputStream(new byte[0]));
                        }
                    });
                    InputSource mergedInput = new InputSource(mergedStream);
                    SAXSource mergedSource = new SAXSource(mergedReader, mergedInput);
                    targetFile.delete();
                    targetFile.getParentFile().mkdirs();
                    StreamResult mergedResult = new StreamResult(new FileOutputStream(targetFile));
                    TransformerFactory transFactory = TransformerFactory.newInstance();
                    Transformer identity = transFactory.newTransformer();
                    if (!this._is12()) {
                        identity.setOutputProperty("doctype-public", _JSP_TAG_LIBRARY_DOCTYPE_PUBLIC);
                        identity.setOutputProperty("doctype-system", _JSP_TAG_LIBRARY_DOCTYPE_SYSTEM);
                    }
                    identity.transform(mergedSource, mergedResult);
                    targetFile.setReadOnly();
                    continue;
                }
                if (hasGeneratedTags) {
                    targetFile.getParentFile().mkdirs();
                    out = new FileOutputStream(targetFile);
                    outputFactory = XMLOutputFactory.newInstance();
                    stream = outputFactory.createXMLStreamWriter(out);
                    this._writeStartTagLibrary(stream, this._is12() ? "2.1" : "1.2", shortName, namespaceURI);
                    while (components.hasNext()) {
                        component = (ComponentBean)components.next();
                        this._writeTag(stream, component);
                    }
                    while (converters.hasNext()) {
                        converter = (ConverterBean)converters.next();
                        this._writeTag(stream, converter);
                    }
                    while (validators.hasNext()) {
                        validator = (ValidatorBean)validators.next();
                        this._writeTag(stream, validator);
                    }
                    this._writeEndTagLibrary(stream);
                    stream.close();
                    continue;
                }
                if (!configFile.exists() || configFile.lastModified() <= targetFile.lastModified()) continue;
                targetFile.delete();
                targetFile.getParentFile().mkdirs();
                FileUtils.copyFile((File)configFile, (File)targetFile);
                targetFile.setReadOnly();
            }
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Error generating tag library", (Exception)e);
        }
        catch (ParserConfigurationException e) {
            throw new MojoExecutionException("Error generating tag library", (Exception)e);
        }
        catch (TransformerException e) {
            throw new MojoExecutionException("Error generating tag library", (Exception)e);
        }
        catch (XMLStreamException e) {
            throw new MojoExecutionException("Error generating tag library", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error generating tag libraries", (Exception)e);
        }
    }

    private void _writeStartTagLibrary(XMLStreamWriter stream, String dtd) throws XMLStreamException {
        stream.writeStartDocument("1.0");
        stream.writeCharacters("\n");
        if (!this._is12()) {
            stream.writeDTD(dtd);
        }
        stream.writeCharacters("\n");
        stream.writeStartElement("taglib");
        if (this._is12()) {
            stream.writeNamespace("", "http://java.sun.com/xml/ns/javaee");
            stream.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            stream.writeAttribute("xsi:schemaLocation", "http://java.sun.com/xml/ns/javaee/web-jsptaglibrary_2_1.xsd");
            stream.writeAttribute("version", "2.1");
        }
        stream.writeCharacters("\n  ");
    }

    private void _writeStartTagLibrary(XMLStreamWriter stream, String version, String shortName, String namespaceURI) throws XMLStreamException {
        this._writeStartTagLibrary(stream, _JSP_TAG_LIBRARY_DTD);
        stream.writeStartElement("tlib-version");
        String tlibVersion = this.project.getVersion();
        tlibVersion = tlibVersion.replaceAll("[^.0-9]", "");
        while (tlibVersion.startsWith(".")) {
            tlibVersion = tlibVersion.substring(1);
        }
        while (tlibVersion.endsWith(".")) {
            tlibVersion = tlibVersion.substring(0, tlibVersion.length() - 1);
        }
        stream.writeCharacters(tlibVersion);
        stream.writeEndElement();
        if (!this._is12()) {
            stream.writeCharacters("\n  ");
            stream.writeStartElement("jsp-version");
            stream.writeCharacters(version);
            stream.writeEndElement();
        }
        stream.writeCharacters("\n  ");
        stream.writeStartElement("short-name");
        stream.writeCharacters(shortName);
        stream.writeEndElement();
        stream.writeCharacters("\n  ");
        stream.writeStartElement("uri");
        stream.writeCharacters(namespaceURI);
        stream.writeEndElement();
    }

    private void _writeEndTagLibrary(XMLStreamWriter stream) throws XMLStreamException {
        stream.writeCharacters("\n");
        stream.writeEndElement();
        stream.writeEndDocument();
    }

    private void _writeTag(XMLStreamWriter stream, ComponentBean component) throws XMLStreamException {
        stream.writeCharacters("\n  ");
        stream.writeStartElement("tag");
        stream.writeCharacters("\n    ");
        if (this._is12() && component.getDescription() != null) {
            stream.writeCharacters("\n    ");
            stream.writeStartElement("description");
            stream.writeCData(component.getDescription());
            stream.writeEndElement();
        }
        stream.writeStartElement("name");
        stream.writeCharacters(component.getTagName().getLocalPart());
        stream.writeEndElement();
        stream.writeCharacters("\n    ");
        stream.writeStartElement("tag-class");
        stream.writeCharacters(component.getTagClass());
        stream.writeEndElement();
        if (this._is12()) {
            stream.writeCharacters("\n    ");
            stream.writeStartElement("body-content");
            stream.writeCharacters("JSP");
            stream.writeEndElement();
        }
        this.writeCustomComponentTagDescriptorContent(stream, component);
        if (!this._is12() && component.getDescription() != null) {
            stream.writeCharacters("\n    ");
            stream.writeStartElement("description");
            stream.writeCData(component.getDescription());
            stream.writeEndElement();
        }
        Iterator properties = component.properties(true);
        properties = new FilteredIterator(properties, new TagAttributeFilter());
        while (properties.hasNext()) {
            PropertyBean property = (PropertyBean)properties.next();
            this.writeTagAttribute(stream, property.getPropertyName(), property.getDescription(), property.getUnsupportedAgents(), property);
        }
        stream.writeCharacters("\n  ");
        stream.writeEndElement();
    }

    private void _writeTag(XMLStreamWriter stream, ConverterBean converter) throws XMLStreamException {
        stream.writeCharacters("\n  ");
        stream.writeStartElement("tag");
        stream.writeCharacters("\n    ");
        if (this._is12() && converter.getDescription() != null) {
            stream.writeCharacters("\n    ");
            stream.writeStartElement("description");
            stream.writeCData(converter.getDescription());
            stream.writeEndElement();
        }
        stream.writeStartElement("name");
        stream.writeCharacters(converter.getTagName().getLocalPart());
        stream.writeEndElement();
        stream.writeCharacters("\n    ");
        stream.writeStartElement("tag-class");
        stream.writeCharacters(converter.getTagClass());
        stream.writeEndElement();
        if (this._is12()) {
            stream.writeCharacters("\n    ");
            stream.writeStartElement("body-content");
            stream.writeCharacters("empty");
            stream.writeEndElement();
        }
        if (!this._is12() && converter.getDescription() != null) {
            stream.writeCharacters("\n    ");
            stream.writeStartElement("description");
            stream.writeCData(converter.getDescription());
            stream.writeEndElement();
        }
        this.writeTagAttribute(stream, "id", "the identifier for the converter", null, null);
        Iterator properties = converter.properties();
        properties = new FilteredIterator(properties, new TagAttributeFilter());
        while (properties.hasNext()) {
            PropertyBean property = (PropertyBean)properties.next();
            this.writeTagAttribute(stream, property.getPropertyName(), property.getDescription(), property.getUnsupportedAgents(), property);
        }
        stream.writeCharacters("\n  ");
        stream.writeEndElement();
    }

    private void _writeTagAttributeDescription(XMLStreamWriter stream, String description, String[] unsupportedAgents) throws XMLStreamException {
        if (description != null || unsupportedAgents.length > 0) {
            stream.writeCharacters("\n      ");
            stream.writeStartElement("description");
            if (unsupportedAgents != null && unsupportedAgents.length > 0) {
                if (description == null) {
                    description = "";
                }
                description = description + "\n\n    This attribute is not supported on the following agent types:\n";
                for (int i = 0; i < unsupportedAgents.length; ++i) {
                    description = description + " " + unsupportedAgents[i];
                    description = description + (i < unsupportedAgents.length - 1 ? "," : ".");
                }
            }
            stream.writeCData(description);
            stream.writeEndElement();
        }
    }

    protected void writeTagAttribute(XMLStreamWriter stream, String propertyName, String description, String[] unsupportedAgents, PropertyBean property) throws XMLStreamException {
        stream.writeCharacters("\n    ");
        stream.writeStartElement("attribute");
        if (this._is12()) {
            this._writeTagAttributeDescription(stream, description, unsupportedAgents);
        }
        stream.writeCharacters("\n      ");
        stream.writeStartElement("name");
        if (property != null) {
            stream.writeCharacters(property.getJspPropertyName());
        } else {
            stream.writeCharacters(propertyName);
        }
        stream.writeEndElement();
        if (!this._is12()) {
            stream.writeCharacters("\n      ");
            stream.writeStartElement("rtexprvalue");
            stream.writeCharacters("false");
            stream.writeEndElement();
            this._writeTagAttributeDescription(stream, description, unsupportedAgents);
        } else if (property != null) {
            if (property.isRequired()) {
                stream.writeCharacters("\n    ");
                stream.writeStartElement("required");
                stream.writeCharacters("true");
                stream.writeEndElement();
            }
            if (property.isMethodExpression() || property.isMethodBinding()) {
                stream.writeCharacters("\n    ");
                stream.writeStartElement("deferred-method");
                stream.writeCharacters("\n      ");
                MethodSignatureBean sig = property.getMethodBindingSignature();
                if (sig != null) {
                    stream.writeStartElement("method-signature");
                    stream.writeCharacters(sig.getReturnType());
                    stream.writeCharacters(" myMethod(");
                    String[] params = sig.getParameterTypes();
                    for (int i = 0; i < params.length; ++i) {
                        if (i > 0) {
                            stream.writeCharacters(", ");
                        }
                        stream.writeCharacters(params[i]);
                    }
                    stream.writeCharacters(")");
                    stream.writeEndElement();
                }
                stream.writeEndElement();
            } else if (!property.isLiteralOnly() || "binding".equals(propertyName)) {
                stream.writeCharacters("\n      ");
                stream.writeStartElement("deferred-value");
                String propertyClass = property.getPropertyClass();
                if ("java.lang.String".equals(propertyClass) && this.coerceStrings || _CAN_COERCE.contains(property.getPropertyClass())) {
                    stream.writeCharacters("\n        ");
                    stream.writeStartElement("type");
                    int genericIndex = propertyClass.indexOf(60);
                    if (genericIndex > 0) {
                        propertyClass = propertyClass.substring(0, genericIndex);
                    }
                    stream.writeCharacters(propertyClass);
                    stream.writeEndElement();
                    stream.writeCharacters("\n      ");
                }
                stream.writeEndElement();
            } else {
                stream.writeCharacters("\n      ");
                stream.writeStartElement("rtexprvalue");
                if (property.isRtexprvalue() || "id".equals(propertyName) && !this.disableIdExpressions) {
                    stream.writeCharacters("true");
                } else {
                    stream.writeCharacters("false");
                }
                stream.writeEndElement();
            }
        }
        stream.writeCharacters("\n    ");
        stream.writeEndElement();
    }

    private void _writeTag(XMLStreamWriter stream, ValidatorBean validator) throws XMLStreamException {
        stream.writeCharacters("\n  ");
        stream.writeStartElement("tag");
        if (this._is12() && validator.getDescription() != null) {
            stream.writeCharacters("\n    ");
            stream.writeStartElement("description");
            stream.writeCData(validator.getDescription());
            stream.writeEndElement();
        }
        stream.writeCharacters("\n    ");
        stream.writeStartElement("name");
        stream.writeCharacters(validator.getTagName().getLocalPart());
        stream.writeEndElement();
        stream.writeCharacters("\n    ");
        stream.writeStartElement("tag-class");
        stream.writeCharacters(validator.getTagClass());
        stream.writeEndElement();
        if (this._is12()) {
            stream.writeCharacters("\n    ");
            stream.writeStartElement("body-content");
            stream.writeCharacters("empty");
            stream.writeEndElement();
        }
        if (!this._is12() && validator.getDescription() != null) {
            stream.writeCharacters("\n    ");
            stream.writeStartElement("description");
            stream.writeCData(validator.getDescription());
            stream.writeEndElement();
        }
        this.writeTagAttribute(stream, "id", "the identifier for the validator", null, null);
        Iterator properties = validator.properties();
        properties = new FilteredIterator(properties, new TagAttributeFilter());
        while (properties.hasNext()) {
            PropertyBean property = (PropertyBean)properties.next();
            this.writeTagAttribute(stream, property.getPropertyName(), property.getDescription(), property.getUnsupportedAgents(), property);
        }
        stream.writeCharacters("\n  ");
        stream.writeEndElement();
    }

    private void _generateTagHandlers() throws IOException, MojoExecutionException {
        this.project.addCompileSourceRoot(this.generatedSourceDirectory.getCanonicalPath());
        FacesConfigBean facesConfig = this.getFacesConfig();
        if (!(facesConfig.hasComponents() || facesConfig.hasConverters() || facesConfig.hasValidators())) {
            this.getLog().info((CharSequence)"Nothing to generate - no components found");
        } else {
            Iterator components = facesConfig.components();
            components = new FilteredIterator(components, new AbstractFacesMojo.SkipFilter());
            components = new FilteredIterator(components, new AbstractFacesMojo.ComponentTagFilter());
            components = new FilteredIterator(components, new AbstractFacesMojo.ComponentTagClassFilter(this.packageContains));
            Iterator validators = facesConfig.validators();
            validators = new FilteredIterator(validators, new AbstractFacesMojo.ValidatorTagFilter());
            validators = new FilteredIterator(validators, new AbstractFacesMojo.ValidatorTagClassFilter(this.packageContains));
            Iterator converters = facesConfig.converters();
            converters = new FilteredIterator(converters, new AbstractFacesMojo.ConverterTagFilter());
            converters = new FilteredIterator(converters, new AbstractFacesMojo.ConverterTagClassFilter(this.packageContains));
            if (!this.force) {
                components = new FilteredIterator(components, new IfComponentModifiedFilter());
                converters = new FilteredIterator(converters, new IfConverterModifiedFilter());
                validators = new FilteredIterator(validators, new IfValidatorModifiedFilter());
            }
            if (!(components.hasNext() || converters.hasNext() || validators.hasNext())) {
                this.getLog().info((CharSequence)"Nothing to generate - all JSP tags are up to date");
            } else {
                ComponentTagHandlerGenerator componentGen = new ComponentTagHandlerGenerator();
                AbstractConverterTagGenerator converterGen = null;
                AbstractValidatorTagGenerator validatorGen = null;
                if (this.type == null || "trinidad".equals(this.type)) {
                    converterGen = new TrinidadConverterTagGenerator(this.is12(), this.getLicenseHeader(), this.getLog());
                    validatorGen = new TrinidadValidatorTagGenerator(this.is12(), this.getLicenseHeader(), this.getLog());
                } else {
                    converterGen = new MyFacesConverterTagGenerator(this.is12(), this.getLicenseHeader(), this.getLog());
                    validatorGen = new MyFacesValidatorTagGenerator(this.is12(), this.getLicenseHeader(), this.getLog());
                }
                int count = 0;
                while (components.hasNext()) {
                    componentGen.generateTagHandler((ComponentBean)components.next());
                    ++count;
                }
                while (converters.hasNext()) {
                    converterGen.generateTagHandler((ConverterBean)converters.next(), this.generatedSourceDirectory);
                    ++count;
                }
                while (validators.hasNext()) {
                    validatorGen.generateTagHandler((ValidatorBean)validators.next(), this.generatedSourceDirectory);
                    ++count;
                }
                this.getLog().info((CharSequence)("Generated " + count + " JSP tag(s)"));
            }
        }
    }

    protected boolean is12() {
        return "1.2".equals(this.jsfVersion) || "12".equals(this.jsfVersion);
    }

    private boolean _is12() {
        return this.is12();
    }

    static {
        _CAN_COERCE.add("java.lang.Integer");
        _CAN_COERCE.add("java.lang.Long");
        _CAN_COERCE.add("java.lang.Boolean");
        _CAN_COERCE.add("java.lang.Double");
        _CAN_COERCE.add("java.lang.Float");
        _CAN_COERCE.add("java.lang.Short");
        _CAN_COERCE.add("java.lang.Character");
        _CAN_COERCE.add("java.lang.Byte");
        _CAN_COERCE.add("int");
        _CAN_COERCE.add("long");
        _CAN_COERCE.add("boolean");
        _CAN_COERCE.add("double");
        _CAN_COERCE.add("float");
        _CAN_COERCE.add("short");
        _CAN_COERCE.add("char");
        _CAN_COERCE.add("byte");
        _CAN_COERCE.add("javax.faces.component.UIComponent");
        _CAN_COERCE.add("javax.faces.convert.Converter");
    }

    private class IfValidatorModifiedFilter
    extends ValidatorFilter {
        private IfValidatorModifiedFilter() {
        }

        protected boolean accept(ValidatorBean validator) {
            String tagClass = validator.getTagClass();
            String sourcePath = Util.convertClassToSourcePath(tagClass, ".java");
            String templatePath = Util.convertClassToSourcePath(tagClass, "Template.java");
            File targetFile = new File(GenerateJspTaglibsMojo.this.generatedSourceDirectory, sourcePath);
            File templateFile = new File(GenerateJspTaglibsMojo.this.templateSourceDirectory, templatePath);
            return templateFile.lastModified() > targetFile.lastModified() || validator.isModifiedSince(targetFile.lastModified());
        }
    }

    private class IfConverterModifiedFilter
    extends ConverterFilter {
        private IfConverterModifiedFilter() {
        }

        protected boolean accept(ConverterBean converter) {
            String tagClass = converter.getTagClass();
            String sourcePath = Util.convertClassToSourcePath(tagClass, ".java");
            String templatePath = Util.convertClassToSourcePath(tagClass, "Template.java");
            File targetFile = new File(GenerateJspTaglibsMojo.this.generatedSourceDirectory, sourcePath);
            File templateFile = new File(GenerateJspTaglibsMojo.this.templateSourceDirectory, templatePath);
            return templateFile.lastModified() > targetFile.lastModified() || converter.isModifiedSince(targetFile.lastModified());
        }
    }

    private class IfComponentModifiedFilter
    extends ComponentFilter {
        private IfComponentModifiedFilter() {
        }

        protected boolean accept(ComponentBean component) {
            String tagClass = component.getTagClass();
            String sourcePath = Util.convertClassToSourcePath(tagClass, ".java");
            String templatePath = Util.convertClassToSourcePath(tagClass, "Template.java");
            File targetFile = new File(GenerateJspTaglibsMojo.this.generatedSourceDirectory, sourcePath);
            File templateFile = new File(GenerateJspTaglibsMojo.this.templateSourceDirectory, templatePath);
            return templateFile.lastModified() > targetFile.lastModified() || component.isModifiedSince(targetFile.lastModified());
        }
    }

    class ComponentTagHandlerGenerator {
        ComponentTagHandlerGenerator() {
        }

        private Set initComponentList(ComponentBean component, String fullSuperclassName) {
            HashSet<ComponentBean> componentList = new HashSet<ComponentBean>();
            componentList.add(component);
            ComponentBean lBean = component;
            while ((lBean = lBean.resolveSupertype()) != null && !fullSuperclassName.equals(lBean.getTagClass())) {
                GenerateJspTaglibsMojo.this.getLog().debug((CharSequence)(component.getComponentType() + ": Add additional Tags from: " + lBean.getComponentType()));
                componentList.add(lBean);
            }
            return componentList;
        }

        public void generateTagHandler(ComponentBean component) {
            String fullSuperclassName = component.findJspTagSuperclass();
            if (fullSuperclassName == null) {
                GenerateJspTaglibsMojo.this.getLog().warn((CharSequence)("Missing JSP Tag superclass for component: " + component.getComponentClass() + ", generation of this Tag is skipped"));
                return;
            }
            Set componentList = this.initComponentList(component, fullSuperclassName);
            String fullClassName = component.getTagClass();
            try {
                GenerateJspTaglibsMojo.this.getLog().debug((CharSequence)("Generating " + fullClassName));
                String sourcePath = Util.convertClassToSourcePath(fullClassName, ".java");
                File targetFile = new File(GenerateJspTaglibsMojo.this.generatedSourceDirectory, sourcePath);
                targetFile.getParentFile().mkdirs();
                StringWriter sw = new StringWriter();
                PrettyWriter out = new PrettyWriter(sw);
                AbstractComponentTagGenerator generator = component.isTrinidadComponent() ? new TrinidadComponentTagGenerator(GenerateJspTaglibsMojo.this._is12()) : new MyFacesComponentTagGenerator(GenerateJspTaglibsMojo.this._is12());
                GenerateJspTaglibsMojo.this.getLog().debug((CharSequence)("Generating " + fullClassName + ", with generator: " + generator.getClass().getName()));
                String className = Util.getClassFromFullClass(fullClassName);
                String packageName = Util.getPackageFromFullClass(fullClassName);
                GenerateJspTaglibsMojo.this.writePreamble(out);
                out.println("package " + packageName + ";");
                out.println();
                String superclassName = Util.getClassFromFullClass(fullSuperclassName);
                if (superclassName.equals(className)) {
                    superclassName = fullSuperclassName;
                }
                String componentFullClass = component.getComponentClass();
                String componentClass = Util.getClassFromFullClass(componentFullClass);
                generator.writeImports(out, null, packageName, fullSuperclassName, superclassName, componentList);
                generator.writeClassBegin(out, className, superclassName, component, null);
                int modifiers = component.getTagClassModifiers();
                generator.writeConstructor(out, component, modifiers);
                if (!Modifier.isAbstract(modifiers)) {
                    generator.writeGetComponentType(out, component);
                    generator.writeGetRendererType(out, component);
                }
                GenerateJspTaglibsMojo.this.writeCustomComponentTagHandlerContent(out, component);
                generator.writePropertyMembers(out, componentList);
                generator.writeSetPropertiesMethod(out, componentClass, componentList);
                generator.writeReleaseMethod(out, componentList);
                generator.writeClassEnd(out);
                out.close();
                targetFile.delete();
                FileWriter fw = new FileWriter(targetFile);
                StringBuffer buf = sw.getBuffer();
                fw.write(buf.toString());
                fw.close();
                targetFile.setReadOnly();
            }
            catch (Throwable e) {
                GenerateJspTaglibsMojo.this.getLog().error((CharSequence)("Error generating " + fullClassName), e);
            }
        }
    }
}

