/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.myfaces.trinidadbuild.plugin.faces.AbstractFacesMojo;
import org.codehaus.plexus.util.DirectoryScanner;

public class GenerateMasterFacesConfigMojo
extends AbstractFacesMojo {
    private MavenProject project;
    private String[] excludes;
    private String sourcePath;
    private File sourceDirectory;
    private String targetPath = "META-INF/maven-faces-plugin/faces-config.xml";
    private File targetDirectory;
    private boolean force;

    public void execute() throws MojoExecutionException {
        try {
            this.addResourceRoot(this.project, this.targetDirectory.getCanonicalPath());
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(new File(this.sourceDirectory, this.sourcePath));
            scanner.addDefaultExcludes();
            scanner.setIncludes(new String[]{"**/*.xml"});
            if (this.excludes != null) {
                scanner.setExcludes(this.excludes);
            }
            scanner.scan();
            String[] xmlFiles = scanner.getIncludedFiles();
            long lastModified = 0L;
            for (int i = 0; i < xmlFiles.length; ++i) {
                lastModified = Math.max(lastModified, new File(xmlFiles[i]).lastModified());
            }
            File targetFile = new File(this.targetDirectory, this.targetPath);
            if (!this.force && targetFile.lastModified() > lastModified) {
                this.getLog().info((CharSequence)("Nothing to generate - " + this.targetPath + " is up to date"));
            } else {
                this.getLog().info((CharSequence)("Generating " + this.targetPath));
                targetFile.delete();
                targetFile.getParentFile().mkdirs();
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetFile));
                XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
                XMLStreamWriter writer = outputFactory.createXMLStreamWriter(out);
                writer.writeStartDocument("1.0");
                writer.writeCharacters("\n");
                writer.writeStartElement("faces-config");
                writer.writeDefaultNamespace("http://java.sun.com/xml/ns/javaee");
                writer.writeNamespace("xi", "http://www.w3.org/2001/XInclude");
                writer.writeCharacters("\n");
                for (int i = 0; i < xmlFiles.length; ++i) {
                    String xmlFile = xmlFiles[i];
                    if (File.separatorChar == '\\') {
                        xmlFile = xmlFile.replaceAll("\\\\", "/");
                    }
                    writer.writeCharacters("  ");
                    writer.writeStartElement("http://www.w3.org/2001/XInclude", "include");
                    writer.writeAttribute("href", xmlFile);
                    writer.writeAttribute("xpointer", "/faces-config/*");
                    writer.writeEndElement();
                    writer.writeCharacters("\n");
                }
                writer.writeEndDocument();
                writer.close();
                targetFile.setReadOnly();
            }
        }
        catch (XMLStreamException e) {
            throw new MojoExecutionException("Error during generation", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error during generation", (Exception)e);
        }
    }
}

