/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.myfaces.trinidadbuild.plugin.faces.AbstractFacesMojo;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.FacesConfigBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.RenderKitBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.RendererBean;

public class GenerateRendererMapMojo
extends AbstractFacesMojo {
    private MavenProject project;
    private String resourcePath = "META-INF/maven-faces-plugin/index.lst";
    private File generatedSourceDirectory;
    private String renderKitPrefix;

    public void execute() throws MojoExecutionException {
        try {
            this.processIndex(this.project, this.resourcePath);
            this._generateRendererMap();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error generating components", (Exception)e);
        }
    }

    private void _generateRendererMap() throws IOException {
        this.project.addCompileSourceRoot(this.generatedSourceDirectory.getCanonicalPath());
        FacesConfigBean facesConfig = this.getFacesConfig();
        if (!facesConfig.hasRenderKits()) {
            this.getLog().info((CharSequence)"Nothing to generate - no renderkits found");
        } else {
            Iterator renderkits = facesConfig.renderKits();
            while (renderkits.hasNext()) {
                RenderKitBean renderkit = (RenderKitBean)renderkits.next();
                String id = renderkit.getRenderKitId();
                if (!id.startsWith(this.renderKitPrefix)) continue;
                this._writeRenderKitMap(renderkit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeRenderKitMap(RenderKitBean rk) throws IOException {
        File outFile = new File(this.generatedSourceDirectory, "/META-INF/" + rk.getRenderKitId() + ".renderkit");
        FileWriter fw = new FileWriter(outFile);
        PrintWriter pw = new PrintWriter(fw);
        try {
            Iterator renderers = rk.renderers();
            while (renderers.hasNext()) {
                RendererBean r = (RendererBean)renderers.next();
                pw.print(r.getComponentFamily());
                pw.print('|');
                pw.print(r.getRendererType());
                pw.print('=');
                pw.println(r.getRendererClass());
            }
        }
        finally {
            pw.close();
        }
    }
}

