/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces.generator;

import java.util.Set;
import org.apache.myfaces.trinidadbuild.plugin.faces.io.PrettyWriter;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.PropertyBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.Filter;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.FilteredIterator;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.Util;

public class GeneratorHelper {
    private GeneratorHelper() {
    }

    public static boolean isConverter(String propClass) {
        return "javax.faces.convert.Converter".equals(propClass);
    }

    public static boolean isKeyStroke(String propClass) {
        return "javax.swing.KeyStroke".equals(propClass);
    }

    public static boolean isAWTKeyStroke(String propClass) {
        return "java.awt.AWTKeyStroke".equals(propClass);
    }

    public static boolean isNumber(String propClass) {
        return "java.lang.Number".equals(propClass);
    }

    public static boolean isColorList(String propClass, String[] propClassParams) {
        return "java.util.List".equals(propClass) && propClassParams.length == 1 && "java.awt.Color".equals(propClassParams[0]);
    }

    public static boolean isColor(String propClass) {
        return "java.awt.Color".equals(propClass);
    }

    public static boolean isAction(PropertyBean property) {
        return property.getClass().equals("javax.el.MethodExpression") && property.getJspPropertyName().equals("action");
    }

    public static boolean isActionListener(PropertyBean property, boolean is12) {
        return property.getJspPropertyName().equals("actionListener") && (property.isMethodExpression() || is12 && property.isMethodBinding());
    }

    public static boolean isValueChangeListener(PropertyBean property, boolean is12) {
        return property.getJspPropertyName().equals("valueChangeListener") && (property.isMethodExpression() || is12 && property.isMethodBinding());
    }

    public static boolean isValidator(PropertyBean property, boolean is12) {
        return property.getJspPropertyName().equals("validator") && (property.isMethodExpression() || is12 && property.isMethodBinding());
    }

    public static void writeImports(PrettyWriter out, String packageName, Set imports) {
        FilteredIterator iterator = imports.iterator();
        iterator = new FilteredIterator(iterator, new PackageImportsFilter(packageName));
        while (iterator.hasNext()) {
            String className = (String)iterator.next();
            out.println("import " + className + ";");
        }
        out.println();
    }

    public static String getJspPropertyType(PropertyBean property, boolean is12) {
        if (property.isMethodExpression()) {
            return "MethodExpression";
        }
        if (is12 && property.isMethodBinding()) {
            return "MethodExpression";
        }
        if (is12) {
            if (!property.isLiteralOnly()) {
                return "ValueExpression";
            }
            return property.getPropertyClass();
        }
        return "String";
    }

    public static class PackageImportsFilter
    implements Filter {
        private final String _packageName;

        public PackageImportsFilter(String packageName) {
            this._packageName = packageName;
        }

        public boolean accept(Object object) {
            String className = (String)object;
            String packageName = Util.getPackageFromFullClass(className);
            return !packageName.equals(this._packageName) && !packageName.equals("java.lang");
        }
    }
}

