/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.faces.generator.component;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.GeneratorHelper;
import org.apache.myfaces.trinidadbuild.plugin.faces.generator.component.ComponentGenerator;
import org.apache.myfaces.trinidadbuild.plugin.faces.io.PrettyWriter;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.ComponentBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.EventBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.EventRefBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.FacetBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.parse.PropertyBean;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.FilteredIterator;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.PropertyFilter;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.SourceTemplate;
import org.apache.myfaces.trinidadbuild.plugin.faces.util.Util;

public abstract class AbstractComponentGenerator
implements ComponentGenerator {
    private Log _log;
    boolean _is12;
    private static final Pattern _GENERIC_TYPE = Pattern.compile("([^<]+)<(.+)>");
    private static final Map _RESOLVABLE_TYPES = AbstractComponentGenerator._createResolvableTypes();

    public AbstractComponentGenerator(Log log, boolean is12) {
        this._log = log;
        this._is12 = is12;
    }

    protected Log getLog() {
        return this._log;
    }

    public void writeClassBegin(PrettyWriter out, String className, String superclassName, ComponentBean component, SourceTemplate template) {
        out.println("/**");
        String longDescription = component.getLongDescription();
        if (longDescription != null) {
            out.println(" *");
            out.println(" * " + this.convertMultilineComment(longDescription));
        }
        if (component.hasEvents(true)) {
            out.println(" *");
            out.println(" * <h4>Events:</h4>");
            out.println(" * <table border=\"1\" width=\"100%\" cellpadding=\"3\" summary=\"\">");
            out.println(" * <tr bgcolor=\"#CCCCFF\" class=\"TableHeadingColor\">");
            out.println(" * <th align=\"left\">Type</th>");
            out.println(" * <th align=\"left\">Phases</th>");
            out.println(" * <th align=\"left\">Description</th>");
            out.println(" * </tr>");
            Iterator events = component.events(true);
            while (events.hasNext()) {
                EventRefBean eventRef = (EventRefBean)events.next();
                EventBean event = eventRef.resolveEventType();
                if (event == null) continue;
                String eventClass = event.getEventClass();
                String[] eventPhases = eventRef.getEventDeliveryPhases();
                String eventDescription = event.getDescription();
                out.println(" * <tr class=\"TableRowColor\">");
                out.println(" * <td valign=\"top\"><code>" + eventClass + "</code></td>");
                out.print(" * <td valign=\"top\" nowrap>");
                if (eventPhases != null) {
                    for (int i = 0; i < eventPhases.length; ++i) {
                        if (i > 0) {
                            out.print("<br>");
                        }
                        out.print(eventPhases[i]);
                    }
                }
                out.println("</td>");
                out.println(" * <td valign=\"top\">" + eventDescription + "</td>");
                out.println(" * </tr>");
            }
            out.println(" * </table>");
        }
        if (!component.hasChildren()) {
            out.println(" * <p>");
            out.println(" * It does not support any children.");
        }
        out.println(" */");
        int modifiers = component.getComponentClassModifiers();
        String classStart = Modifier.toString(modifiers);
        classStart = classStart.replaceAll("public abstract", "abstract public");
        out.println(classStart + " class " + className + " extends " + superclassName);
        HashSet<String> interfaces = new HashSet<String>();
        if (template != null) {
            interfaces.addAll(template.getImplements());
        }
        if (component.isNamingContainer()) {
            interfaces.add("javax.faces.component.NamingContainer");
        }
        Iterator events = component.events();
        while (events.hasNext()) {
            String source;
            EventRefBean eventRef = (EventRefBean)events.next();
            EventBean event = eventRef.resolveEventType();
            if (event == null || eventRef.isIgnoreSourceInterface() || (source = event.getEventSourceInterface()) == null) continue;
            interfaces.add(Util.getClassFromFullClass(source));
        }
        if (!interfaces.isEmpty()) {
            HashSet<String> implementsSet = new HashSet<String>();
            Iterator iter = interfaces.iterator();
            while (iter.hasNext()) {
                String fcqn = (String)iter.next();
                implementsSet.add(Util.getClassFromFullClass(fcqn));
            }
            char[] indent = new char[classStart.length() + " class ".length() + className.length() + 1];
            Arrays.fill(indent, ' ');
            out.print(indent);
            out.print("implements ");
            Iterator iter2 = implementsSet.iterator();
            while (iter2.hasNext()) {
                out.print((String)iter2.next());
                if (!iter2.hasNext()) continue;
                out.println(",");
                out.print(indent);
                out.print("           ");
            }
            out.println();
        }
        out.println("{");
        out.indent();
    }

    public void writeClassEnd(PrettyWriter out) {
        out.unindent();
        out.println("}");
    }

    public void writeImports(PrettyWriter out, SourceTemplate template, String packageName, String fullSuperclassName, String superclassName, Collection components) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void writeImports(PrettyWriter out, SourceTemplate template, String packageName, String fullSuperclassName, String superclassName, ComponentBean component) {
        String superPackageName;
        Iterator facets;
        TreeSet<String> imports = new TreeSet<String>();
        if (template != null) {
            imports.addAll(template.getImports());
        }
        if (component.isNamingContainer()) {
            imports.add("javax.faces.component.NamingContainer");
        }
        Iterator properties = component.properties();
        if ((properties = new FilteredIterator(properties, new NonVirtualFilter())).hasNext()) {
            while (properties.hasNext()) {
                PropertyBean property = (PropertyBean)properties.next();
                String propertyClass = property.getPropertyClass();
                if (propertyClass == null) continue;
                imports.add(propertyClass);
                String[] types = property.getAttributeClassParameters();
                if (types == null) continue;
                for (int i = types.length - 1; i >= 0; --i) {
                    this.addGenericImports(imports, types[i]);
                }
            }
        }
        if ((facets = component.facets()).hasNext()) {
            imports.add("javax.faces.component.UIComponent");
        }
        Iterator events = component.events();
        while (events.hasNext()) {
            String sourceInterface;
            EventRefBean eventRef = (EventRefBean)events.next();
            EventBean event = eventRef.resolveEventType();
            if (event == null) {
                this.getLog().warn((CharSequence)("Unknown event type \"" + eventRef.getEventType() + "\"" + " in component:" + component.getComponentType()));
                continue;
            }
            String listenerClass = event.getEventListenerClass();
            if (listenerClass != null) {
                imports.add(listenerClass);
            }
            if (eventRef.isIgnoreSourceInterface() || (sourceInterface = event.getEventSourceInterface()) == null) continue;
            imports.add(sourceInterface);
        }
        if (!superclassName.equals(fullSuperclassName) && (superPackageName = Util.getPackageFromFullClass(fullSuperclassName)) != packageName) {
            imports.add(fullSuperclassName);
        }
        this.addSpecificImports(imports, component);
        imports.removeAll(Util.PRIMITIVE_TYPES);
        GeneratorHelper.writeImports(out, packageName, imports);
    }

    protected void addSpecificImports(Set imports, ComponentBean component) {
    }

    public void addGenericImports(Set imports, String type) {
        Matcher matcher = _GENERIC_TYPE.matcher(type);
        if (matcher.matches()) {
            imports.add(matcher.group(1));
            String[] types = matcher.group(2).split(",");
            for (int i = types.length - 1; i >= 0; --i) {
                this.addGenericImports(imports, types[i]);
            }
        } else {
            imports.add(type);
        }
    }

    public void writeGenericConstants(PrettyWriter out, String componentFamily, String componentType) throws IOException {
        out.println();
        out.println("static public final String COMPONENT_FAMILY =");
        out.println("  \"" + componentFamily + "\";");
        out.println("static public final String COMPONENT_TYPE =");
        out.println("  \"" + componentType + "\";");
    }

    public void writePropertyConstants(PrettyWriter out, String superclassName, ComponentBean component) throws IOException {
    }

    public void writePropertyValueConstants(PrettyWriter out, ComponentBean component) throws IOException {
        Iterator properties = component.properties();
        properties = new FilteredIterator(properties, new NonVirtualFilter());
        while (properties.hasNext()) {
            PropertyBean property = (PropertyBean)properties.next();
            String[] propertyValues = property.getPropertyValues();
            if (propertyValues == null) continue;
            String propName = property.getPropertyName();
            for (int i = 0; i < propertyValues.length; ++i) {
                String propValue = propertyValues[i];
                String propValueName = propName + Character.toUpperCase(propValue.charAt(0)) + propValue.substring(1);
                String propValueKey = Util.getConstantNameFromProperty(propValueName);
                out.println("static public final String " + propValueKey + " = \"" + propValue + "\";");
            }
        }
    }

    public void writeFacetConstants(PrettyWriter out, ComponentBean component) throws IOException {
        Iterator facets = component.facets();
        while (facets.hasNext()) {
            FacetBean facet = (FacetBean)facets.next();
            String facetName = facet.getFacetName();
            String facetKey = Util.getConstantNameFromProperty(facetName, "_FACET");
            out.println("static public final String " + facetKey + " = \"" + facetName + "\";");
        }
    }

    protected String convertStringToBoxedLiteral(String className, String value) {
        if (value == null) {
            return null;
        }
        if ("String".equals(className)) {
            return "\"" + value.replaceAll("'", "\\'") + "\"";
        }
        if ("boolean".equals(className)) {
            return "true".equals(value) ? "Boolean.TRUE" : "Boolean.FALSE";
        }
        if ("char".equals(className)) {
            return "Character.valueOf('" + value.replaceAll("'", "\\'") + "')";
        }
        if ("int".equals(className)) {
            return "Integer.valueOf(" + value + ")";
        }
        if ("double".equals(className)) {
            return "Double.valueOf(" + value + ")";
        }
        if ("float".equals(className)) {
            return "Float.valueOf(" + value + ")";
        }
        if ("Number".equals(className)) {
            if (value.indexOf(".") == -1) {
                return "Integer.valueOf(" + value + ")";
            }
            return "Double.valueOf(" + value + ")";
        }
        throw new IllegalStateException("property-class " + className + " not supported for auto-boxing");
    }

    protected String convertVariableToBoxedForm(String className, String varName) {
        if ("boolean".equals(className)) {
            return varName + " ? Boolean.TRUE : Boolean.FALSE";
        }
        if ("char".equals(className)) {
            return "Character.valueOf(" + varName + ")";
        }
        if ("int".equals(className)) {
            return "Integer.valueOf(" + varName + ")";
        }
        if ("short".equals(className)) {
            return "Short.valueOf(" + varName + ")";
        }
        if ("long".equals(className)) {
            return "Long.valueOf(" + varName + ")";
        }
        if ("double".equals(className)) {
            return "Double.valueOf(" + varName + ")";
        }
        if ("float".equals(className)) {
            return "Float.valueOf(" + varName + ")";
        }
        throw new IllegalStateException("property-class " + className + " not supported for auto-boxing");
    }

    public void writeConstructor(PrettyWriter out, ComponentBean component, int modifiers) throws IOException {
        String fullClassName = component.getComponentClass();
        String className = Util.getClassFromFullClass(fullClassName);
        if (Modifier.isPublic(modifiers)) {
            if (!Modifier.isAbstract(component.getComponentClassModifiers())) {
                String rendererType = component.getRendererType();
                if (rendererType != null) {
                    rendererType = this.convertStringToBoxedLiteral("String", rendererType);
                }
                out.println();
                out.println("/**");
                out.println(" * Construct an instance of the " + className + ".");
                out.println(" */");
                out.println("public " + className + "()");
                out.println("{");
                out.indent();
                this.writeConstructorContent(out, component, modifiers, rendererType);
                out.unindent();
                out.println("}");
            }
        } else if (Modifier.isProtected(modifiers)) {
            out.println();
            out.println("/**");
            out.println(" * Construct an instance of the " + className + ".");
            out.println(" */");
            out.println("protected " + className + "(");
            out.indent();
            out.println("String rendererType");
            out.println(")");
            out.unindent();
            out.println("{");
            out.indent();
            this.writeConstructorContent(out, component, modifiers, "rendererType");
            out.unindent();
            out.println("}");
            if (Modifier.isAbstract(component.getComponentClassModifiers())) {
                out.println();
                out.println("/**");
                out.println(" * Construct an instance of the " + className + ".");
                out.println(" */");
                out.println("protected " + className + "()");
                out.println("{");
                out.indent();
                out.println("this(null);");
                out.unindent();
                out.println("}");
            }
        }
    }

    protected abstract void writeConstructorContent(PrettyWriter var1, ComponentBean var2, int var3, String var4) throws IOException;

    public void writeGetFamily(PrettyWriter out) throws IOException {
        out.println();
        out.println("@Override");
        out.println("public String getFamily()");
        out.println("{");
        out.indent();
        out.println("return COMPONENT_FAMILY;");
        out.unindent();
        out.println("}");
    }

    public void writePropertyMethods(PrettyWriter out, ComponentBean component) throws IOException {
        this.writePropertyMethods(out, component, null);
    }

    public void writePropertyMethods(PrettyWriter out, ComponentBean component, Collection ignoreList) throws IOException {
        Iterator properties = component.properties();
        properties = new FilteredIterator(properties, new NonVirtualFilter());
        while (properties.hasNext()) {
            PropertyBean property = (PropertyBean)properties.next();
            if (property.isList()) {
                this.writePropertyListMethods(out, property, ignoreList);
                continue;
            }
            this.writePropertyDeclaration(out, property);
            this.writePropertyGet(out, property, ignoreList);
            this.writePropertySet(out, property, ignoreList);
            if (!GeneratorHelper.isValidator(property, this._is12)) continue;
            this.writePropertyListMethods(out, property, ignoreList);
        }
    }

    protected abstract void writePropertyListMethods(PrettyWriter var1, PropertyBean var2, Collection var3) throws IOException;

    protected abstract void writePropertyListMethods(PrettyWriter var1, PropertyBean var2) throws IOException;

    protected static String getSingular(String plural) {
        if (plural.endsWith("s")) {
            return plural.substring(0, plural.length() - 1);
        }
        return plural;
    }

    protected abstract void writePropertyDeclaration(PrettyWriter var1, PropertyBean var2) throws IOException;

    protected void writePropertySet(PrettyWriter out, PropertyBean property, Collection ignoreList) throws IOException {
        String propertyClass = Util.getPropertyClass(property);
        this.writePropertySet(out, property, propertyClass, ignoreList);
        if (property.getAlternateClass() != null) {
            String alternateClass = Util.getAlternatePropertyClass(property);
            this.writePropertySet(out, property, alternateClass, ignoreList);
        }
    }

    protected void writePropertySet(PrettyWriter out, PropertyBean property, String propertyClass, Collection ignoreList) throws IOException {
        String propName = property.getPropertyName();
        String propVar = Util.getVariableFromName(propName);
        String description = property.getDescription();
        String setMethod = Util.getPrefixedPropertyName("set", propName);
        if (ignoreList != null && ignoreList.contains(setMethod)) {
            return;
        }
        out.println();
        out.println("/**");
        if (description != null) {
            out.println(" * Sets " + this.convertMultilineComment(description));
        }
        if (property.isRequired()) {
            out.println(" * <p>");
            out.println(" * This is a required property on the component.");
        }
        out.println(" * ");
        out.println(" * @param " + Util.getVariableFromName(propName) + "  the new " + propName + " value");
        if (property.isMethodBinding() && this._is12) {
            out.println(" * @deprecated");
        }
        if (property.getDeprecated() != null) {
            out.print(" * @deprecated ");
            out.println(this.convertMultilineComment(property.getDeprecated()));
        }
        out.println(" */");
        if (property.getDeprecated() != null) {
            out.println("@Deprecated");
        }
        if (this.isAccessorMethodFinal()) {
            out.print("final ");
        }
        out.println("public void " + setMethod + "(" + propertyClass + " " + propVar + ")");
        out.println("{");
        out.indent();
        this.writePropertySetterMethodBody(out, property, propertyClass);
        out.unindent();
        out.println("}");
    }

    protected abstract void writePropertySetterMethodBody(PrettyWriter var1, PropertyBean var2, String var3) throws IOException;

    protected void writePropertyGet(PrettyWriter out, PropertyBean property, Collection ignoreList) throws IOException {
        String propName = property.getPropertyName();
        String propertyFullClass = property.getPropertyClass();
        String propertyClass = Util.getClassFromFullClass(propertyFullClass);
        String description = property.getDescription();
        String getMethod = Util.getMethodReaderFromProperty(propName, propertyClass);
        if (ignoreList != null && ignoreList.contains(getMethod)) {
            return;
        }
        boolean isUnchecked = false;
        String[] genericTypes = property.getPropertyClassParameters();
        if (genericTypes != null && genericTypes.length > 0) {
            isUnchecked = true;
            propertyClass = Util.getPropertyClass(property);
        }
        out.println();
        out.println("/**");
        if (description != null) {
            out.println(" * Gets " + this.convertMultilineComment(description));
        }
        if (property.isRequired()) {
            out.println(" * <p>");
            out.println(" * This is a required property on the component.");
            out.println(" * </p>");
        }
        out.println(" *");
        out.println(" * @return  the new " + propName + " value");
        if (property.isMethodBinding() && this._is12) {
            out.println(" * @deprecated");
        }
        if (property.getDeprecated() != null) {
            out.print(" * @deprecated ");
            out.println(this.convertMultilineComment(property.getDeprecated()));
        }
        out.println(" */");
        if (property.getDeprecated() != null) {
            out.println("@Deprecated");
        }
        if (isUnchecked) {
            out.println("@SuppressWarnings(\"unchecked\")");
        }
        if (this.isAccessorMethodFinal()) {
            out.print("final ");
        }
        out.println("public " + propertyClass + " " + getMethod + "()");
        out.println("{");
        out.indent();
        this.writePropertyGetterMethodBody(out, property);
        out.unindent();
        out.println("}");
    }

    protected boolean isAccessorMethodFinal() {
        return false;
    }

    protected abstract void writePropertyGetterMethodBody(PrettyWriter var1, PropertyBean var2) throws IOException;

    public void writeFacetMethods(PrettyWriter out, ComponentBean component) throws IOException {
        Iterator facets = component.facets();
        while (facets.hasNext()) {
            FacetBean facet = (FacetBean)facets.next();
            this.writeFacetGet(out, facet);
            this.writeFacetSet(out, facet);
        }
    }

    public void writeFacetSet(PrettyWriter out, FacetBean facet) throws IOException {
        String facetName = facet.getFacetName();
        String facetVar = facetName + "Facet";
        String facetKey = Util.getConstantNameFromProperty(facetName, "_FACET");
        String setMethod = Util.getPrefixedPropertyName("set", facetName);
        String description = facet.getDescription();
        out.println();
        out.println("/**");
        if (description != null) {
            out.println(" * " + this.convertMultilineComment(description));
        }
        if (facet.isRequired()) {
            out.println(" * <p>");
            out.println(" * This is a required facet on the component.");
        }
        out.println(" */");
        out.println("@SuppressWarnings(\"unchecked\")");
        out.println("final public void " + setMethod + "(UIComponent " + facetVar + ")");
        out.println("{");
        out.indent();
        out.println("getFacets().put(" + facetKey + ", " + facetVar + ");");
        out.unindent();
        out.println("}");
    }

    public void writeFacetGet(PrettyWriter out, FacetBean facet) throws IOException {
        String facetName = facet.getFacetName();
        String facetKey = Util.getConstantNameFromProperty(facetName, "_FACET");
        String getMethod = Util.getPrefixedPropertyName("get", facetName);
        String description = facet.getDescription();
        out.println();
        out.println("/**");
        if (description != null) {
            out.println(" * " + this.convertMultilineComment(description));
        }
        if (facet.isRequired()) {
            out.println(" * <p>");
            out.println(" * This is a required facet on the component.");
        }
        out.println(" */");
        out.println("final public UIComponent " + getMethod + "()");
        out.println("{");
        out.indent();
        out.println("return getFacet(" + facetKey + ");");
        out.unindent();
        out.println("}");
    }

    public void writeListenerMethods(PrettyWriter out, ComponentBean component) throws IOException {
        Iterator events = component.events();
        while (events.hasNext()) {
            EventRefBean eventRef = (EventRefBean)events.next();
            EventBean event = eventRef.resolveEventType();
            if (event == null) continue;
            this.writeListenerAdd(out, event);
            this.writeListenerRemove(out, event);
            this.writeListenersGet(out, event);
        }
    }

    public void writeListenerAdd(PrettyWriter out, EventBean event) throws IOException {
        String listenerFullClass = event.getEventListenerClass();
        String listenerClass = Util.getClassFromFullClass(listenerFullClass);
        String eventName = event.getEventName();
        String addMethod = Util.getMethodNameFromEvent("add", eventName, "Listener");
        out.println();
        out.println("/**");
        out.println(" * Adds a " + eventName + " listener.");
        out.println(" *");
        out.println(" * @param listener  the " + eventName + " listener to add");
        out.println(" */");
        if (this.isAccessorMethodFinal()) {
            out.print("final ");
        }
        out.println("public void " + addMethod + "(");
        out.indent();
        out.println(listenerClass + " listener)");
        out.unindent();
        out.println("{");
        out.indent();
        out.println("addFacesListener(listener);");
        out.unindent();
        out.println("}");
    }

    public void writeListenerRemove(PrettyWriter out, EventBean event) throws IOException {
        String listenerFullClass = event.getEventListenerClass();
        String listenerClass = Util.getClassFromFullClass(listenerFullClass);
        String eventName = event.getEventName();
        String removeMethod = Util.getMethodNameFromEvent("remove", eventName, "Listener");
        out.println();
        out.println("/**");
        out.println(" * Removes a " + eventName + " listener.");
        out.println(" *");
        out.println(" * @param listener  the " + eventName + " listener to remove");
        out.println(" */");
        if (this.isAccessorMethodFinal()) {
            out.print("final ");
        }
        out.println("public void " + removeMethod + "(");
        out.indent();
        out.println(listenerClass + " listener)");
        out.unindent();
        out.println("{");
        out.indent();
        out.println("removeFacesListener(listener);");
        out.unindent();
        out.println("}");
    }

    public void writeListenersGet(PrettyWriter out, EventBean event) throws IOException {
        String listenerFullClass = event.getEventListenerClass();
        String listenerClass = Util.getClassFromFullClass(listenerFullClass);
        String eventName = event.getEventName();
        String getMethod = Util.getMethodNameFromEvent("get", eventName, "Listeners");
        out.println();
        out.println("/**");
        out.println(" * Returns an array of attached " + eventName + " listeners.");
        out.println(" *");
        out.println(" * @return  an array of attached " + eventName + " listeners.");
        out.println(" */");
        if (this.isAccessorMethodFinal()) {
            out.print("final ");
        }
        out.println("public " + listenerClass + "[] " + getMethod + "()");
        out.println("{");
        out.indent();
        out.println("return (" + listenerClass + "[])" + "getFacesListeners(" + listenerClass + ".class);");
        out.unindent();
        out.println("}");
    }

    public abstract void writeStateManagementMethods(PrettyWriter var1, ComponentBean var2) throws IOException;

    public void writeOther(PrettyWriter out, ComponentBean component) throws IOException {
    }

    protected String convertMultilineComment(String commentBody) {
        StringBuilder buff = new StringBuilder(commentBody.replaceAll("\n", "\n * "));
        int s = 0;
        do {
            if ((s = buff.indexOf("<pre>", s)) <= 0) continue;
            int e = buff.indexOf("</pre>", s += "<pre>".length());
            String markup = buff.substring(s, e -= "</pre>".length());
            markup = markup.replaceAll("<", "&lt;");
            markup = markup.replaceAll(">", "&gt;");
            buff.delete(s, e);
            buff.insert(s, markup);
            s = buff.indexOf("<pre>", s + markup.length() + "</pre>".length());
        } while (s > 0);
        return buff.toString();
    }

    protected static String resolveType(String className) {
        return (String)_RESOLVABLE_TYPES.get(className);
    }

    private static Map _createResolvableTypes() {
        HashMap<String, String> resolvableTypes = new HashMap<String, String>();
        resolvableTypes.put("boolean", "Boolean");
        resolvableTypes.put("char", "Character");
        resolvableTypes.put("int", "Integer");
        resolvableTypes.put("float", "Float");
        resolvableTypes.put("double", "Double");
        resolvableTypes.put("java.util.Locale", "Locale");
        resolvableTypes.put("long", "Long");
        resolvableTypes.put("java.lang.String", "String");
        resolvableTypes.put("java.lang.Number", "Number");
        resolvableTypes.put("java.util.TimeZone", "TimeZone");
        return Collections.unmodifiableMap(resolvableTypes);
    }

    protected class NonVirtualFilter
    extends PropertyFilter {
        protected NonVirtualFilter() {
        }

        protected boolean accept(PropertyBean property) {
            return !property.isVirtual();
        }
    }

    protected class ResolvableTypeFilter
    extends PropertyFilter {
        protected ResolvableTypeFilter() {
        }

        protected boolean accept(PropertyBean property) {
            String propertyClass = property.getPropertyClass();
            String resolvableType = AbstractComponentGenerator.resolveType(propertyClass);
            return resolvableType != null;
        }
    }
}

